#!/usr/bin/env python
# -*- coding: utf-8 -*-

levels = {
    # Sernimir II
    "Of Pancakes and Spaceships": '''H4sIAMTllmEC/5WPQW7DIBBFr4JmXSTsVRQfIpW6S5TFCE9sVHtAMKh1LPfsxSTZddMN0nwejz
8rOA5Z9N0zJTiqFUw9a7oHlxVmP5HNE5UJTt/LQNydfkzbNc2hNV3bHIyBNwXWZ5bCNO123bYS
+Cx/qf+rM1UmS6gvIiXCaMcdYZwflpt6R7b4SUkh9+ojoKU0upB2qncJp8l/Ua8dJ4nZivNcd4
MaaPHDUPpcC4xZRh936Rkfn0RCK75AzwI0B1n0q4Z+XsP2C/fVcAJKAQAA''',
    "Slightly Different": '''H4sIAMTllmEC/5WPMQ6DMAxFr4I8NxIwlrUDe7dWDFEwECnEKDiqKKJnr0np1qUZLOX5+zlZwf
opsnqSxxnO2QpFqonu4L7CSA5NdCg3qJc2UI++ql95WRVy8qqUksMpA0PRs6SKcmu2TQBF/iX/
X5gnHS9Tmgk4ow5m2CNej4ldne0Hdkt2sV2HAWVOuq2dtXP0wFZZP3OIhi359C9IQDH1vbykkb
COPFDYZTf9kQfUhklCx2IcJ17Ud7062rC9AbSqKdFGAQAA''',
    "Crossover": '''H4sIAMTllmEC/5WQMWsDMQyF/0rQXIMvS9LcVDp0zZySwfhEzmBbhy2lJMf999omJEsI7WLQ03
tPH57BxUlYXSliht1qBt3eplbhe4ZAHq14LBN8kR/6D+m7bvOuNbytwJJELqtuvRyXMncv83tv
2EUJ/Z5rx/ZJRy0h4WdU/2jSD5Y/8ut2mS9TMybMaJIdlaUQJDq+KBwcO4pqXWPRhOb7TJQznT
FVcXDZeE8/OCgXMyexNdC+AZqgmE6nQnIsZiM8UqodB2PHGk9oLFMx3RgwTOXsneS2huUXk808
MrUBAAA=''',
    "An Introduction to Bonding": '''H4sIAHbolmEA/3WPwWrDMBBEf8XsqQULLBMotU/JwZBzby05qPbiCJTdIK8SWuN/79puLjW9CG
aYeTsawdM1iflmwgGqEYr5WTyVHyNcOGCbAkIFbz7cMNb7vrZ291IUkEPLiQQqW06nKQf7f7cJ
iaMnrBstv266WuYk2yGb69nT8TlbYR3qlGbZYou6/EMtZuYnU4fR/Hq7HOTrOrMiDuhie9Y8uc
vs7Ck7kkTuUiueKRPODlr21Gum84MLge/YGU+DxDUz/xEWbYT7XkeecnBJzhwV+O4WfETXCmti
PSxJhXfBPBaYR6CE6QcdaUvmjAEAAA==''',
    "A Brief History of SpaceChem": '''H4sIAMTllmEC/33QwWrEIBAG4FcRzxViKBSa0zaX3Htr2YPV2URInDCOlDTk3atu91C29CLMP+
PH6C59WBOrLwwQ5bPYZVPPmpbgfZcLzmDTDLmSw+YIRwjd0Gmtm0Y+CGkxBc5N3R7nI9f6X6Gf
ZiQfoOvnQjz9YRQEE//e66re7WIrZ8XJetcNV1M3XXsvN9X9wOCA1C19zBFva/UIIhiyU24uSw
qeNwXOs8eg2iIFs9S5k3ghDxcx+MhIm8CLeF2NhX6Cpcw5H8084yc45UNkSrYY9StkDRTjOOY3
nPOwSTwhFfbN2KlcJzA2u+q2liMzqsiGOO/905THN7KA9dS5AQAA''',
    "Removing Bonds": '''H4sIAMTllmEC/22Pv2rDMBDGX8VorkA2XVJvHfIAHRsyKNJhC6S7IJ1aUuM8e08iXUoWgb4/P7
7bVMBrZf1DCEW9DZsy/e1qE06bShTB1QjyU8dYKQeE+Xg30zyOh9HM03gwRr0MylFFltQ47ed9
F4EqP4M/BzbaP47plAuhh6z/1FeR+Hbt7QwFbHarmClVDHzT4AMHQj01EtrUcx+Q6CvgMrwLqz
THh2JjpG/wOmDhXF1r9YtVFzTTssjGs4Rt5ZVyA31at7Z6BuuYJPQY4rNddGGbWZY+TLX/AuSX
NT1eAQAA''',
    # Sernimir IV
    "Double Bonds": '''H4sIAMTllmEC/22PzQrCMAyAX2XkbKEbHsTdxLt3ZYfahTmojbQp/oz57KZVT3oJ5EvyJZlg9J
fE6kEeI6yrCXSJhWZwmOBMDm1yKBnsbvcBfbtr63qlNSwqsJQ8S6lu5m6eBVDif8Z/lqdusqjR
bfOj00V2JN9jUF+6FMT3S5EEjGiCPeUpb86FbSkdHVYbmYqZ92M0ztEVezX6yCFZHsmXv6AAxT
QMclQnzSbxiULW7M1bG9BYJmn6rOyDGVRkE1hu+hRhfgEdQoU6RAEAAA==''',
    "Best Left Unanswered": '''H4sIAMTllmEC/22PsWrEMAyGXyV4rsFJC4Vm61xuu6XlBtVWE0MiHbLMcQ3ps9c216m3GPz90s
evzUQ6Z7XfTJjMS7cZ195GK/jYzMoL+rxg+ZlDVOEJaTyMff/snHnojOdMWsJ+2E/7XgBnvee8
7/lxQ1U9unH4J3RN98kUUOwffSpIr+emEUwI4ucSrmumqFeLIWpkskM1Eaxt7hWTdm/4pd2RgN
IFBUPNQ0ywLHzBYCMllezrbrvbNGCVp6lUPpVhyDqzVN07+LmuC4JXLkO3OkFgsklBtPS9hWb/
BXMPW4BkAQAA''',
    "Multiple Outputs": '''H4sIAMTllmEC/22QTWvEIBCG/0rwXEFDKUs95rzkvmUPVodEME7QkW4a8t+rsr00vQi+H8+M7s
yFNRP/xgCJvXc7E+1sahU+dragB5M9lBsbdPzE0F0x4MNZUMOopHzrherlRQj20jGDOVCJyv64
H0cRMNN/E85UNVTWH4qoCHlqjI9tgqDq9MupUSuFZyHyX/W1SLStrRshgY5mLuay5OBo42AdOQ
y8r6Sgl5a7Zk9u9dCN7QWpetYl7T1+geUuJIrZ1F77KNYETjhNZcd7CetMM8aKumkz13oEbQhL
6LmKjXriiXSksuvTZMcPdLtx35UBAAA=''',
    "An Introduction to Pipelines": '''H4sIAMTllmEC/7WQQUsEMQyF/0rp2YGkAxXsSfeiF9mzt9KNbGGmHWoKuzuMv920iqx4FA99hN
f0e0lX/RpPdBhiWioPl5zoTd+pVYOofqB0oURu9w72UY4DQEAHaI2o6ToigMPuI1qU2liUuvum
+wYtGGeMbXXz9Y3S2ALuA3FOkUucJEUixt2z4BGvkaKmw9CO4Ea8FcAmhFz598yrnvNEoU70J7
7gQ66JBYKwfY37k/2fn3OV3cJnfxoK+cC5tE1BLD4vfYql5EMNHHNq75KfP/dO6inx95XirPZx
oSm2r5I+X/mYS+t88eGotw95OXeJBgIAAA==''',
    "There's Something in the Fishcake": '''H4sIAMTllmEC/22QsWpEIRBFf0Vs0kTQNIFYhYXw+k2VsIXo5ClR56Ej2c3y/j3qQqptLM69nt
G58mKywyRC3hqJX8xQ+Qu7cjnPSQf4PO37I+Nf4QzubpcvF1dwhawXrZSSkve6GsHBRywhgz7E
kTz3aKiw0b2JCSPYFuFfaed1y15tcHq5OZTUTzdTF1lsmXpdyfnEZM6igLGEZXhVR95UUckUgt
IJlQYd0mWbQ7aCrlkKmIcsmzTpu4cCD5UdMQH5kFcWMiMP7C1Ub803jLIL1cSIP3MltXunZq6L
TyAI17X/5dTLppHHMZ9/GOv5/gfKrZWpegEAAA==''',
    "Sleepless on Sernimir IV": '''H4sIAMTllmEC/22QT2vEIBDFv0rw3IB6WEo9Bsr2lMNCDy17sHGaCOoE/9CkS/rZO9oe9yLy88
17z7mxqINB39uwltx/Y4DEnrob4+1stIL363E8dOzTbmDuatl5NxFnCOqshBCcM5KL+jBue8Uj
4cc/LCsedPzAoAbCJ8LVHUu+V8Kjg6k4qFPPGL12BpbdgBrOP1yOikvKa+5SCXmiu5T/BSYsId
Oc4K2+11sfQU8ZYw2QhBad+pR1zBCJ5FiAYN7XlrZGNGXKFkM1C9o3enEAq4OUOgzdBWKw3sbu
5bVqjE3aOfxqW0pk16bbBlkDfcZ5pr9cSaxLXrDGsjc9Lez4BWMMNw6NAQAA''',
    # Danopth
    "Every Day is the First Day": '''H4sIAMTllmEC/32QwWrEIBCGX0U8V9Bs2UNzKumWPEPLHqwOiZDoomOLDemzd5QtFLr0oDj//P
P568adv2QUn8FD4g9s47LtTa3C68bXsIDJC1DFx2JjmMD3Y6+UkpLfMW5C9khN1e3nnWr1L2HQ
8S34fqD54435CggZb2X6TXk0gGUBD/3wJbuRVi9roEo9yL5TRzof/iSUjU/3W4jiR70nCculcS
Mk0NHM1FzX7B0WAdahC150leT12nynd4iFPenCXGI4A3t2MWEVqsu6pJclfIAVzieM2VRC+wze
BIFhmuglZzLrjHOIFfqizVzHI2iDgUzXUDbqSSTUESn1tcn3bwJtxZe7AQAA''',
    "It Takes Three": '''H4sIAMTllmEC/32PwWrEIBCGXyV4rqBuYaGeeksvOe2pZQ9Wh0Sa6KIjJQ3ps3e0W2hh6UWY/5
/5+NyYD5eC/CMGyOyh25hob0tr8LKxJc5gyww0sX51KY4QdK+llEKwu47ZWAJSKdV+3mmW/xIG
j9+EgQjHG4SKiAVvWf3mPC5LDN7oof8UBy0U2TQlqZUiMS3VUf6Fi4Z+jcFB4j/pPUW4XhoyQQ
aT7ETlspTgceXgPPoYuKqkYJa294TdybxB7k5TAqiN89nMc3wHx33ImIqtV+33rAUc4ziS+JmW
TcEppgp6Nnaq5wmMxUhLVxGXzMgzmoRkei3Z/gWh9pfGrAEAAA==''',
    "Split Before Bonding": '''H4sIAMTllmEC/32QQWvDMAyF/0rweQHb7FCWW0+9dbDbRg9erKWG1AqKTJuG7LdPdrrDIMwHgZ
6k7z08qxCHxPUdI4zqpZqVLrWoWfiY1QV7aFMP0qnD5Ak7iM3hW9vGyNONlaLVU6VaTJFly9jl
tEhv/kUdb1MGHVfQzmbQbgOUSZh4K+VWsuoVCG/BQ4m40q0EzB7GrB6N1UabP066+Hxi9ED1r/
osEk9D4ROM4Kg956voLkV7G/rA1R6+kKDay22IXZ77MLq+xyv4OsSRKbUcMJY/UEWoGbtOcp9k
2SU+I2Xcu1vxBK5llKWHtSfX1SM7Ysn2GKrlB3QimEe7AQAA''',
    "Settling into the Routine": '''H4sIAMTllmEC/22QMWvDMBCF/4rRXIPklAz1WApZsrRbSwbVvtoCWWekE40b3N/eOzlDIcFwiM
/vvXvSRUUbepxqF+ZM9Q8GSOqpuihdZqECPk7r+lCpL3eG/q5WHYFGG6B9Pvzqx1YbY3RrNH9t
w0c+N2WavTFKojDTvY0TeuiyB4k8LH3EAULLkQ1bJbKEKfZ3mAOxymhJMzfml2sdtrJ9v21mu8
z/7bZezTYL2d1ZITsme64j2I4wSuMdo9Gm2qYE06dfGFHMcKW9S7c/BHqP3+UNE8OOHIbyvqqA
mnAYuP+JxbTM5SJzxH4TSqdgp0LfgMi7MFQuEFY0QvXKL+oCiMhmGjGK7N12o1r/AEZCnk3mAQ
AA''',
    "Nothing Works": '''H4sIAMTllmEC/22RQWuEMBSE/4rkXCHRZRea41681GuhZQ+pSTVU8yR5oWsX97f3JeuhUBFymM
x8M+qNeeU0TKV1c8TyB5wJ7Lm4MZ7PrCbh/bKuTwX7tFejd73sxeCgnJHn5s4PkgshuBTiKIQU
nB5ZkUBKRScjkkiZ1qKH3jjZ3nlF7lPNyXciRyqDiHubJhhNF0eTAM2iM6A4L8pZbWRzbmWdCE
RLCypxrHNfB9EhRQRft/Z9kmweUx7hbeyfcEpP6lp6ozoEn4YdSBpUKFUIZvoYF5LQR7Op2ob/
F7jMuXX2oGOHFlyqcWrKags4WNcXr+C/QrpIjHGE7/ztAzFyJP8XloUSoe/pRS5kVhEH8Inzpr
qBrb8fGqXs4wEAAA==''',
    "Challenge: In-Place Swap": '''H4sIAMTllmEC/2WRzWrDMBCEX8XoXINklwSiU/ElPdQUemvpYWtvbYEsGf2QuMZ59q5ECg1BoM
No9tsZtLJvdca+VGaOofyxBj07FCvjdLNWBWcHNLK98EoKsa+5rMSec/ZQMJEcLxhGMCib44U/
Si6E4OTbCSEFp0NuwUmp6GYbDdkY7vesbLIau6gxIZ+myRoFsiVkLXmVkdU+gzMyw4jV2WgCTQ
i+XePcgo5Ln9MXzQJG9SiPTZsYIpXYUZX6r8o/UkJNcC4dQhesSyFrkkbwpQ/gAjpSgot4FcF7
nL70cqv2yt8/hGXOuWZn+9gFZU3abWDKajOC1mgGPBTPpnzV0GHxdoI5eRJOa3vK/+QJl6dTtg
+WhTLYYaDWn2SGGEabUrJ36Ea2/QIEsrTk4gEAAA==''',
    # Alkonost
    "An Introduction to Sensing": '''H4sIAMTllmEC/42QP2sDMQzFv4rRHIOPdijNlLFLlm4pGVxb3BkuUrDllva4717ZSYf+oXQx+O
n33hNaING5in1nwgL3ZgHX36424WmBE88Y6oz6gz0ybfe4HYbBOQcbA4EriY5u1o35yu7yqPAu
N/juO3xclQeu8lv7/xoH1yKGH44/etXSPM9MEbP9VG9VmnyxBalwVkFyRdXk7dwDMxb0OUwtif
zpUkLmgSRzrEESkxE2j2pPNDYqpuLnmV8x2kRF4zrU7wldsMLjqOseFfZVpl4LB38pyeiDsELX
BWL2o/XxxVPQxOsU1g+ytuTEvQEAAA==''',
    "Prelude to a Migraine": '''H4sIAMTllmEC/42QzU7EMAyEXyXyeSNlCwdEnwEtZ9AeTGK1kVJnlR+gVOXZcaLlxB64WPLnmc
koG3i+1KK/IlOGR7WB6bPTBl43WGIgWwPJBqfPdSIeT+Px+GAMHBTYWLnI6W4/qNvabzM0+WDG
4a/pvIsPYi23Wvzv5cH0jLfIjpL+pfeCZsw6E+eYBJRUSVhZLz0vUSZMdhbDslT2ZdXkfPGR9d
DSGZeue04UqiNVokL15KeEnqkJnM8YQvwgpz1nSbfN3P8MOtAlTpOUP4sYa5l7C3hBOzd7IrQl
iujaxyWcNLp3ZCuJ1yvsPztcJ8qhAQAA''',
    "Random Oxides": '''H4sIAMTllmEC/32RS2vEIBSF/0pwXcGYLkqz7T5QZpWShdVLIiTXwcd00iH97b3aKWUedKN47j
mfHjwxi/sU+adDCOy5OjFR1qJm4e3EFjeDTjPQiXXHdQRsu7aun4RgDxXTLmGkUS23YaNz/W++
t6jbHineiMt8Q+FL785GhTYt7c6SX8pr/7Dl+1yK9wrcA1Uv1h2tAQJ2X0LmDlK0ktC0NTeFxF
+d6wpVVzg9dqVJodzGc/7doQHPf9VHkiYVeAAMzpMQfQLS4rovcA8BlNcTBZYloY0rB2Ojdchl
pqNaiu9VoXHLzzNCHhgb1Dy7DzDcYiCqzqHyA6wIPLpxpAYDmVWKU7md9UpPOe5B6ejIdH6H8W
rkyhwUaiKep2z7Boa/kssvAgAA''',
    "No Ordinary Headache": '''H4sIAMTllmEC/22QwWrDMBBEf0XsOQbZgSatf6An+97QwyIttsDWGllq7Br32yspgZKSi2BHej
Oj3cCh1TwWxk7BF99saYY3sYHMZ1aTcNlg5IFUGChO0BjvuCNbNz+yqsvydJR1VZ6khIMAxcH6
+KraD+IRa5c1Qe0NOlcJOj9CL/tnnO6lZiIdtdc9OgEH/6zi/1pGiXYxmuqmTcWeZZQyG464FI
5QeXbJ8BilHucC9RdalYO9C3RXHalVDeT+VL9OOXRyrIPyhm3KsDjeqrBonTYW3SreCTWqntK9
NjMOA19Jx5XP0SqTecWQhcJz18XvpDVg8D2nSPiIPOy/GQYpFq4BAAA=''',
    "No Thanks Necessary": '''H4sIAMTllmEC/4WSS0/DMBCE/0rkcyPZKX0In1AvPaUHkJBAHCx71VgkduUHNFTht7N2KkFoBZ
dIHme+nZ3kRJwwynalNocYyg9rwJPb4kRofmY1Cc8n0tkWZGwBT6TWwdk9GF5/0ooztppTXrEV
pWRWEGmjCfhWNcyKqW137JNpN5rWVTKtp6bl8IKncygPoFBbIIiwPwM9igCObxG8QzJjI5nxqm
JT/s1FqHurdOyKTdNapxXwWmzazMiQy6Uu8y2HFNDGcK3C37VpWdxJrfi2xhrmnLI1Y5ymmJzR
HDlVkjqtJoN/lHAlfSJjBRj+jMXkSBnp/3ATuBPH0oGQwboUfoFSI3wp1JswMi8ZXISz6kD2sg
X3rYb+kNMcnFVRBm1NGmFEN65ti4dGmFdf1CDBe+H6dK20F21r30Hh3+eRlI3545IslMHu97hm
alzE0Ng0kTwJ2ZDhC0R15AG5AgAA''',
    "Challenge: Going Green": '''H4sIAMTllmEC/22RQU8DIRCF/wrh7CYM1mZTTqYm7c1DbxoPCLhLsss0LGhrs/52B9pDG70Q5g
Hfe8OceNTB4tj4sM+p+cbgJr5iJy7qWtUivJ74iIMzeXBU8bWO7xjYk8eDt06tn3+EVACtFErC
ktZ7aIXgd4wbzCHRk8V8x24Z26ON2LnAdnn4KJQtQXYKCACCYCBASQm3GDm/UXXJPDlnSQMxE5
xjTv+1cG1ZnHL0hj0ab89+lHxRzJYglYAWyLNEVyDa0pIse1FSKCko0XUW8qUK/ricP0etCbu8
TX9JOupDE502CWNJ+kBSr6dG208dTG0pxexITcd9Je4j2mySx1BoQY9nn14PgwudW7EN+tCxTX
Su3rB+oiP8cpbmOhGsvq1z5FVoEnYdpS2fqXPqMRbgizY9n38BQd1VOBMCAAA=''',
    # Sikutar
    "Ice to Meet You": '''H4sIAMTllmEC/32QQUvEMBCF/0rIScFAW0TFHheW7UH2rLKHbDK2gTazJBO0lv53J3GFPSxeAu
/NzPdmskjnT4nUN3qI8lkssipvcbPxvsgJRzBpBFZyN9uAPfh219Z1XVXyTkiDyRMX62Y9rKzr
fwldQC9uuu5W7L+chXYLe0Y1D03VNvXTFWJGYqJrW15yN3jUI12SN1jIj1fJVeEe0VsI6s+9Z2
vQUX2kCIE1hQRs0XwqEQEi6GAG7p+m5B3NCqwjh141Ge719HuiAUEoXgBIvGLKJeuiHkf8BKuc
j8w1eax8jyyGIux7vuTAzTrRgDlfvmkz5PEA2hBy03kTG3Sft8zR55pcfwBgD5f0zAEAAA==''',
    "Under the Ice": '''H4sIAMTllmEC/32QwU7DMAyGX6XKmUhJhzREX2BcuhMX0A4hMW2kNpkSR1Cq8uzYYVxg4hLJv3
9/v51V+HAuKD9igCzum1Wo+laVhedVzHECWyagShwWl+IAoTt0WmulxE0jbCwBqanb7bRRrf8l
9B6/CT0R9lcIjIgFr231h1Nyc3z3Drr+U7VHBu5U1+q9Vt1O3/2Cq4p+icFBkj/qLUmjyfK1ZE
hUYypAEi7nmpIgg0l2JP88l+BxkeA8+hhky/Bg5up7ZGiDIzQPFrjhfDbTFN/ASR8yUS0P1f8Q
VZAYh4FOOZHZFBwjp4snY0ceT2AsRjJd9nDJDLwjB196YvsCUcFlm70BAAA=''',
    "Unknown Sender": '''H4sIAMTllmEC/22PwWrDMAyGXyXoPENSelpeoKdexi4rPXi2mpglUrFlShry7pO9FjbYxaBPvz
7JKwS6ZjF3Jkzw2qzQ1rfSAk4rzDyhyxNqBYfFRx6Q+kPfdV3bwksDjjOJNrvddt42BZzlP+dv
zxGZ+iP+SP5a2ur4ZPIYzZPuFY02mUtOGLWWmFGRLNeqi5jQRjdqfp4zBVkM+iCByeyKnOxcc+
/0RXyj5g2LvXR8SHaa+IbeBEqqdWWq/hwqMMLDoEefNWyzjFzWw4d1YxmPaJ2whh6H+GiHcmTZ
/OjB9g0oP6LzZQEAAA==''',
    # Note: In the below two levels I used 'has-fusion' instead of 'has-nuclear' as a hack to get 'drag-fusion-reactor'
    "Falling": '''H4sIAMTllmEC/22RUUvDMBCA/8rIs4WkOlH7LsJgPsomPmRp1gbaXLledLXM3+5dHMiceQjku/
vuLsms9uHg6yLEIVHxCdGP6mExK827erHksXr60uVzZXjpqjR32lRlabRWVwtlJGuF00AQqxVy
0vUtR44cgkSXFWfVQ+dd6ryIGyIMqa824t3/VHSQInFweTyVP1e2AR1EkbbS7Ub/Y5UX1jrATp
z1Thzz1xGpt4cCvXUEKOMuGbV2LGz9bqPzNSPC5E90n8YA8Zyhd5PrPP5SmobcfUCokyMxmEbb
Z/pouy7ERlAdRj7AR/6Gke2cLGO8qgwKgqbhq7xxsk3UAua3sK5Vx29gLFTNwQEAAA==''',
    "Challenge: Applied Fusion": '''H4sIAMTllmEC/22QTWsDIRCG/8riuQuj/WDJnkKh9JbcCi05iJpdwXXEjzZt2Pz2jqbQSzyIPI
7PO86ZRek1Lr31oeT+B71JbNOdGbS90Qo+Dut617GjPRl9s5a9yWzi+HoBsRs5LRgFH4CPQnAA
Vh9jybcyFnRGFWeqZD9jCjNGq7qtsrrq7ve7CzxU5SPnI/CBzBwGEM1PZ1EJAK9Z170lUqDC4j
NpObTmF3nqo5EqY6z5T4RmmXqpP6VXRhPKsZg/eizJov9n+Tu0DkNEXVSud0S9XBp9nqVzxk9m
021DcNbo7uUqoCJtE93iV5tcIl973qbKGugzThMN4EDFsmT6f3W+SzWz9Rd9s/EboQEAAA==''',
    # Hephaestus IV
    "Like a Boss": '''H4sIAMTllmEC/32QwUrFMBBFf6VkbSAp4sLs7KYL/QHlLWIytME280gmSC31253EJ/hAJBCYe2
fO3GQXIZ4LyQ+MkMV9twvd7qZW4WUXKy7gygJcicGmV4xmMFrfKSVuOuGwRGJL98fp4Fr9Oz9u
PuEE0YxM0H8QKgILXWf6Zv7mPAHNNoIZxk91W8NobVQlGt0z1vQVbrTic7VCtQX8BA9J/qg9S7
SdGzhBBpvczOa6lhhok+ADBYyyr6Ro19b3GN6gs90D5lxlH7JdFnwHL0PMlIqrI+0DRBMk4TRx
9hM320Izpkp5tm6u4wmsI+SmSwqf7CQT+OIYeDHF8QVXIH4UrQEAAA==''',
    "Sacré Bleu!": '''H4sIAMTllmEC/32QTU/EIBCG/0rlLAl0N2uUk/ayF714U/eAMGlJWtjQIaY29bc7YP2IWYWEZN
6ZeecZZub8MSF/DR5GdlXNTJS3qFl4nNkQejCpB4rYfrIxtOCrZtLeWVD75k5JOkLVcrcRaiMv
hGDnFTMheaQWWS+HhWL5r+8tYKc9qGb/JrZKFEMpd1IqKeiSuRSk1PKEeXYPCU+tcQpd0Yj6i/
m3ofhm/dl8bQCDdxhd/wG5ob1XzAJY0Fbkv35CFNTn4C1E/qluScLpWKZEGEFH01FyGBKNmzhY
hy54Xmcnr4dSd69NfEpCwGV100M6yznrRt334QUsd37EmEzuK1/NisAxtC1tc6BinbALMVs9aN
Pl9gjaYKCiFcVG3fIRdURiXZNseQe+FKBdLwIAAA==''',
    "The Plot Thickens": '''H4sIAMTllmEC/32RPWvDMBCG/4rR1EINkr+GavTiMUOmlgyqfNimii5IMsU1zm+vdHFpKaHLA3
f36r0PrWyylznkn2jBs+dsZZxI2ZR4XdkZDejZQIxYq9wbWtlKIRrO2VPGNM42xJIottMWY/Hv
+27pHQ5gZRcdxB2HZIFzuDfTb58DmgXCuBiwIB/aKy+6K68ebZpLCCkKYkmsiDWxaQSXPLWWRe
oviyKRp0DyklgRa2JDyoaUNbEiln9n5zT5qHxulBsgv+0QK8HNECvxaj24/Ftf7WIP1qP7kYXl
Qvs58KCcHlMPq86UO46QHQyG7DhO+j0+TMV+8soY/IA+n6yPLjpMaOnyjBJ5wGGIRztFsZrDSN
3Yi7p5O1A6YBTtfXunhtsG+yfsArZ9AaRK4x8qAgAA''',
    "Danger Zone": '''H4sIAMTllmEC/5WQzU7EMAyEX6XyeSOlhRO9cthnWLQHk1htpNZe5QdUqvLsONFyAg5cLPnzzG
SUHQLfSjYfwpTgqdvBttloBS87rLKQKwvpBufNR5mIx/PY9721cOrASeGsx4fj1P2l/rRDNfR2
HH7aroc6QUr+rcm/8wbb4l6FPUXzTR8VzZhMIk4SFeRYSFnebi06UiKMblbDuhYOeTPkQw7CZq
jpjGvTPSNPFLuLtqzYh4TLIu/kTeCkma5a2sdBAybLNGn7q4qx5Lm9DRd0c7VHQpdFRfcWPuJk
0L8hO028X+H4AoJRmz+mAQAA''',
    "Molecular Foundry": '''H4sIAMTllmEC/22RQWvEIBCF/4p43lBH2FCa48JCD2XvLT1YHXYDiROMtpuG/PeObg4J9JKJT9
+8b3SWwXhHfdX6IcXqlzyO8kXMUpVvUbPwMcueOrSpQ17J10BeXO6tw+aM4klcGgBdg2q01rXi
As8K5EFIS8lHdtTLQexbnEz4It+cGlC1AnZkHwA32fr08smrlXFEdKzBceFuklL8D3mXgT362M
aV8tQoxZTAkaXokqwg/ytd+GEt8DjAJbPlmbZUoApBb+5VQGMjhUxwZOlmxsq4b+NtQY0h4aqO
acA8scOw3whoJ9tt1TgNBX8I5JKNLfkc7k1f1LfHgCaIM+O4MOVN146m6+gHHb/kyH2KrbycLE
IV6XrlW8nXaVK8Uc6T78be5PIHtSfrGQUCAAA=''',
    "Gas Works Park": '''H4sIAMTllmEC/5WSzU7DMBCEXyXyuZFsh1YVPhYJLqjcKoE4LIlpoiZ25B8oVOXZ2d1WokA5cL
Hssefb2U12IoBr/FB2bsypfPfORnFZ7ITklVUSHnZi8L2tc2/xJBYQnrwzC6PUTEmj1UxKo+RM
KjEpRO2zS/hM7yfFHz6t8a3RFfnIjft/uCt2VAeGpgQVkb67H/F0bC5a26Cmpntkiudua5uzDY
sVJBvMzYfUS2xNcWtzLqIQT2af07lBnca8takFZ80CORc8IWUkw5RUBMMt7hl5klhJ4qtfuEPX
xVXnt12D1CWmQ+pc8+RwrTDiTxKhBtiWwUKdfKCoU5RaiCU0L+BqHkgK2R7VmEdLdRobvi7S28
gRxuCbXKfOOyrjYGD1GmKx8mETizsIG7ppugh97195vBEh7OH/R7BQJr9eY1v0bSCn1lMxcQ91
K/afpCn7hosCAAA=''',
    "Challenge: KOHCTPYKTOP": '''H4sIAMTllmEC/42SUU/CMBSF/8rSJ40uth0khD4BxpjwAAm8qPGhdnVrsrVL1ypI+O/edqAsGM
PLbnpOd89377ZD72oj81Tpxrv0y2jZonGyQxieaKUqJYxO7pXZqFyylUrukgXDZEQww5gMCGGE
hgMlI0wYpWSAMSM4HAgJPrpNEAm9JraVWgk2acHJMoyDQ4MzNdZoNgV5COoeZOPdOc0O1aaSwl
fyFO3B8qKW2gEbcEWiI1hXKJRfNEriqWMDdigwSSyBRxivHbQneH/g/j81ubq57rYy7cXin1hy
mt7LO+LC2N2a+uH0gvD0EA47/XvoS9Kz7Cw+5Nd8k1rJhTM2fIMhSCVvU55/cC1kDpKzXh7U1j
fSvhmdS9s3rBRbUZ2qbtvEaRprci+cMjqEa15HdVbyqpK6kONkvnicrZdP8/ViGW7kqgXLfMZ/
tYVm8d2A9oKikDpTFLCpV7jMvStNCEXPXJRo/w3o9fQV5gIAAA==''',
    # Atropos Station
    "The Blue Danube": '''H4sIAMTllmEC/5WOsQoCMQyGX6VkttA7xMHbxMEHcFIcYhs84UwlbQU9zme3V3VSB5dAvj//R3
o48jlFffNMAeaqB1NmoSPY9nDyHdnUUd5gdXXiD8TNqqmqyhiYKLA+cczhbJioX9d3U4+FyjT1
Z2035Cb4FL998revNkW39+xI9JtOM2ox6EAcvGQQJVFm8XouaqFAKLYdTYynwtYtqUWXSC2R05
7GCFNsSx02+DwWQhu96LfICR40uguyJadfKQwPnbCFx2kBAAA=''',
    "No Stomach for Lunch": '''H4sIAMTllmEC/22PwUoDMRCGX2XJ2cBMlB7MUYQeihdvioeYjF1hN1OmyWFdts9uknYRrQRC8k
3m/yaz+oyHnPQXRzqq+25W0PZGK3id1cgD+TxQuanH1LtI9uEEZnuCjQVEBIu4QbQIZVk0CGBN
O5vGTSO35SGom055zjGVLDTL27IUwDn9N8If7TTQj/iuKk0TwCq+KJusDfFLBtWEV8HbKQjvKd
oSakpo/Y3B6+ba/c4xkOiVmoLSdGgxQkdy4vvaFd3Y2BN3z4lH5/vug6Xb5Xiuu5x6lvrixZ2J
kPOJRa9pQdxeC4XsKehLUS3fSmo/zasBAAA=''',
    "No Employment Record Found": '''H4sIAMTllmEC/4WPTUsDMRCG/0rIuYFNVQRz2oqyJw/2pniIydgNJJklH8K69L+bxCq2il4Cee
adZ2YWavyUE3tDD5FekYV27W20gseFOrSgsoXyoxsM6MVGcH7RdXRFqMLsU6ms9ytyHO1tdsZn
J3pb4vzsv/zWWKOKfGtq/Pw0/lQaKP9zuWHWAXfgxVANxwJeDVWBOf128A+PGi0Go0ivjBbDdb
uBd2LN+eXJal3zPqPXENgXLWiUkUXwEUMBKWQ4sJcc4RtK89TGBogggxqr3EvX2B2SGzdZnB34
RO5BYdDktszQNSVzGpucPsiPvgBSJQzs06mD3DGpX6VXoMtcg54dMnT/DosfNzz9AQAA''',
    "Right All Along": '''H4sIAMTllmEC/32RwWrDMAyGX6X4tMECspO6dD6NQM5jx40dvFRLAq5dFPvQlfbZZ6stG6Ps4A
9b+v1Lsg9i8rsUq6/gcRaPi4MAJkdL4O0gtsFhnxzmk2gtfQRvWiOlBhAPC9GH5GNOSXV8P+az
/Pd+51KgyaPpssP6hkOxCCne6um3z3Nw+4iR7GcxDBjHvUNv7toTqO4Ezb03ErSUBmAtwSjItY
wqFUvnOS4Vs2Y2TM1c6ayXy7JXquhBFgdQzJrZMJdMzVxxlRVX0cyGuWTWfycFnnO0c+UsDVid
J86ZSAlzJr/xBqm66puLeEY/B/qRxf2OX4NwRkv9WGp4u+XYyzSMcfHkXF7BDyVlUxz5uni1Zz
Gh7WOg6mq0ITucW7r8wUUgjt8J8pogKQIAAA==''',
    "Accidents Happen": '''H4sIAMTllmEC/32PT2vDMAzFv0rwuQY7zS7zabccC7lt7ODZojGkcvCfQRe6zz7ZXSjNyjAI/K
T3k97CHM458S+PENlzszBRa1WL8Lawk5/A5Anoxw6jj/PoQ47qoKSUT0KwXcOMz5iov7/smnvD
4CZnPKrBlfFuO/5OBib/XdmfbfBHQNV/i7ZApFAtlTuSbAlVWD6nR3n+ZnAI6kDIvRI3ZI0kpZ
Ltli9uh27iaQINjkhdTUjuK1AKeiv2Aa8APzxaCHxVO5JGHXkEjD6QkEIG0tJ5rtsCRNDBjIWE
+lS1F2OcBUyx6fU8A5aezmmsfvaqr9MBtEk+8JVkgz5ybT81GrD8t8suPx8tDWIPAgAA''',
    # Flidais
    "Special Assignment": '''H4sIAMTllmEC/32QQUvEMBCF/0rJ2UKS1aWY07IIvS3oTfEQk2FbSJOSJmAt3d/uJLa6aJHAQN
5MvjcvE2ltH0P54SwM5L6YCM01q0l4mUjnDKhoAG/kITSjAQvieKG8vtBbwSgewTijVDC250xw
tkeFZ50nndwURLloAxIYn19nvLN/bepRe/c+muJR6lZJI041whmjCK82gInoYthK8mt7aZ1Zl7
9DKs3U6xBXi6dALAfCukNnrH8C0Z84114HBUEaDc2o8bfQbXesT99/U1G+wDcW2LBIHm/OavDl
qlYohbHPZh4GkF416ZWVXdaeelCtNMVhGNqz7QAfYVfG0Dif+s/ya96DVMH5cmVpL8/lEHvwi+
EyQOZPnj517C0CAAA=''',
    "Suspicious Behavior": '''H4sIAMTllmEC/31RyWrEMAz9lcGnFhrwkoXWt04PPRZ663JwM2ISyNjBSyEdpt9eWc5QKEMPeZ
H0nvSEfGSjnVOsvpyFwO42R8YJqZoLr0d2cBP0aQLM2Nb4D2f1VgvRcs5uNqx3yUakhDy9nzAX
//a/Ja5u6+phHJadd3uwulQev7nEmZIrIbSQgnMthbjgkC1cipd2vuDzFCDt3OymBeKwTGBBXx
UK/bb4oW99bTXnaKYFb4XUkuctuFY8b1F2yttkTkhSKIprihuKW4q7Nitl6RBq7azXvFnzds27
8kfrjJJQEdaEDWFL2GXMJCJdRynCmrAhbAm7v1fjdLPBhGoyfg9VuR4y0SdABt9zB7466+tVHM
AG539lcZnpsh4CGN8P2cOaA9WeU5jHfnQpbO5hMJ8jNiJtUhxoBHsxpcGD6aPz1XnYzpt9WWt9
01XATj+XYwjtmQIAAA==''',
    "I Told You So": '''H4sIAMTllmEC/31PQWrDMBD8itC5hl0VROne6otzbi5p6UG1l6TgaI0sHRLjvr2SkkALoQcN7M
zO7GjRX35KsTmL51k/q0VDxcoW4n3RRxm5TyPnSbcufIqnlhAtgH5QupfkY5bQrB9rnvFff3ca
guzZU5cT8E5CiZAU73X6nfPC/syeqf0G2+VHgNYgASAg4QXRIpDJPQ2ZysBjvkimIlYEU1xoLC
IZYwH/9IHaJv934NDc2KdMxdNUWwSe2YX+UFzeHSu3UVsZB7WTpF6lCC7Fg4QivbnLamDXRwnN
LWYIbt/MaeJwvXVd0OsP9NO0u58BAAA=''',
    "Ω-Pseudoethyne": '''H4sIAMTllmEC/6WSQU/jMBCF/0rkM9baDtsFcmwPPXBAlXpZdg8mHtpIiR0l9kKEym/fGceUJi
oSgqiK63Hy5r1v8sI6bY1reGXb4HnpmtZZsL5nN9n9C2tcDWWoYbbFHVvq7sE1sNPFnyByfZ39
yJaFlAuhCiHiXSr6FVLhKgS7yFjpgvX4sjpcZJ9Tw/dztRCiUEktp1Wor6mhKxW9yfyoiSvqob
ZKTmfaf3GXGPUABmsCK23nTCh95Sw3UOsBy5LqLnji2FbtyIxtVhu8GKn4oY3uTKd3XNuyQs4j
d+r4jEc5riT1a5LoDPz1YDq3A1usXykNXpRmRll+3/z2C+aliG2T2PyLSmWvux2QyWmucVz8ro
dgHPj9YCGNEIPmyzWOPw5M0V3E2BJHJhEBji6XCGEhJxAuxWHuvm90XfMTCMlMyqGOQUZ+7wn4
U+X3fEwwSTMhRjpnkJl/SA0M70CX3nVv3aSczPyM4HZ7O16r1SqKb/BP2n2+zVVq8zNmQgDu6f
0pThqxHx02+vntgGqKSsHrhxqOvh513cNJ7xOYiKsJtvIDB1NRhSxY3Xw0XzrWwe/RKz7wW5d7
dvgP3e11y5YEAAA=''',
    "Σ-Ethylene": '''H4sIAMTllmEC/61SS4uDMBD+K5JzAxq3Lrse14UeenLxso9D0GwbMInYhFZK97fvTNTWllJ6aA
RDvgnzPSZ70nJdGUWlbpylpVGN0ULbDXkNvvZEmVqUrhYXRziRRVe1ZiV0uvgLWRrBClMGv5DM
AlIapy3citjhB44Dx0aICsAQkKY1lSutNJpWouYd3kXcOIs6Gtn0nCTP8jwn2MR2jSeuWr6iXJ
cSZPaykXEHpTnsfafDLLgpPpPcGiXL4EOuFE+/XRjzuPfBQuadwP5wL8X9XpLRy4tnHXpdzmeA
LW9XAjWeu+xt0Xe77mqhxckmjOwpjcAnGPX/KISvNx9Hg3nYEZ1GwDDYc/EbxeuaTiIYtAw2GB
t8PPuR3NZ7FPp2S2PCUGHyIH3xmPPc53wKmG6lXdNe8FnYk3nmeVHATLFZnmVLv7IsuzLjX7dB
8lbw0pp2ZI/Y+Yu98mKK5bCQyRMhaX4/xdFg4g1CGmYrqvEaxRaeC4uK78YCYmxCMUkQMlJOS9
tRUUlEkEtzde3NYYk7uwZBUPzk5Zoc/gEy9f0kdAQAAA==''',
    # Australia!
    "Moustachium 602": '''H4sIAMTllmEC/62PQYrDMAxFrxK0rsExZRbNqgfoBVq6UB2TGByrOHKHacicvbKnA7PIcjYCfU
nvfy3g4z2zelJ0MxyaBXStVS3CZYGJgrM5OOngmGdOGHyeuuOja1uj91rDrgFLObJstGa9rtK3
/4ApHMq8le8v7ERCQzsKrfnQRojfUivU6M5swHVF3yj2LqlfdS8Sf90rMrnZYbJjuYo4bdmUUe
9nDIE+Xa98lI+yZU+x/gtVUEzDICmvsoyZR0qFdMYfcnJomWTp7donHJR4JJZY7yGsL19W8dSj
AQAA''',
    "Moustachium 604": '''H4sIAMTllmEC/62PMW7DMAxFr2JwjgDZNTo0Uw6QCyTIwMiCLUAWA5lqkBju2UspLtDBYxYS/C
TfJ2dw4ZZYPSnYCb6qGXSJRc3CeYaRvDXJW6ngkCaO6F0a94fvfV03utUadhUYSoFlom6WyyJ1
/QZM5lDirfv+w44kNDSD0KpP3QrxR6LO0Ea/4JKbNX9smOlidaXQ2aj+1FYkftyKRbSTxWiGvB
Vw3LLNrc5N6D3dbadckA+TYUeh/A9FUEx9L1dfZBgTDxQz6YQvcrRomGRode0i9ko8IstZaxOW
X2Z8VvqzAQAA''',
    "Moustachium 608": '''H4sIAMTllmEC/62QQWoEIRBFr9K4jqDOEEJczQFygQmzqNjSLdjWYJcJSdM5e0pjIJBZZlPyv+
Wrb20ipGsh+YHJr+Jx2IRqtbnVeN7EgtG7Ej0rcSorZYihLPb0arU26qiUuBuEw5KIO7TZLztr
/Q+YysFCt/L9hj0h08DNTBvu1QMTP7mqCjWmw7U1TWt7aNpYZapWVvfT9PNg/oZRLcoLptFn+e
Me2aL3a4uQ/eohu7m+SrDcilWvxrBCjPjmRxkSb6A4CpjafkQzJOE08a8u3AyFZsyVdIZvcvbg
CLmpTx0zTJJnZOJY/VLsX3fq+vjTAQAA''',
    # 63 Corvi
    "QT-1": '''H4sIAMTllmEC/42QTWrEMAyFr2K8tiBOOy10LjDbQlcdsjCOSAz+ydgyM2nI3WubhtJdNwI9PT
49aePGL5ngK3hM/I1tvGu1qVW4btwFizpbLB2/oDXZnS94lrLvOi4Y1yF7KjPZ78O+FyFk+ouU
rf4X0zXIrBIQWlxCJIxFp5ix6LesPGUHd2VtgrWRTzVnJ5gUrBfsSbBnwU6CvQj2OlQWrUvbGj
GhinoGHZzL3tAKOBoywUNfI3jlmu/9A2Ttf/fDka7w+WhSWR7uOILxqeTSFdGexZsAFKapHDoU
s8o0h5qffyo9V2pEpSkU00+qMaoJjrOO4YPv3+lys8GbAQAA''',
    "QT-2": '''H4sIAMTllmEC/52QwWrEIBCGX0U8K2ja7UL3uE+w0FNLDjYZEsFoqiNLGtJn72g3tHvtZWQ+h/
//Z1Zu/ZxRfgYPiT+zlataKy3gbeVTcNBlB9Tx8+hCtB5OZ/elmpPW+qjVqaFHKS4Y70L2SIO6
2dptIxAy3uvrWv+lqarie/A9RLnThtBokkzgU4gEMGa4MQQHc4gIf/hHNh7zJK/GuSSXmuZQFl
WCaVHkHgR7FOwg2JNgx7ZY4jLXpBESmNiNZD5N2VtcJPQWbfCyKUm9merc5eWn//W/i9vbRObh
Cr20PlGurkjUa/MKJIZhoOO0NGwyjnUv/mq6sahGMB0GGrql6qMZ5L7W/pn49g1Lw0oq3AEAAA
==''',
    "Teleporters": '''H4sIAMTllmEC/22Q0U7DMAxFf6XKE0hEJOkEE/0HeJk0iYmHqDU0ok2y1BEdVf8du9sYCF5s57
r3XKuTeHUjNNL5mFF+Bg+DeCgmoaiKTfZvA4IvNsmF0TVQbYvb4qlSeq1VpdVa6cportqwYsq1
UlVpuGp9v9K0NtzEfFOIkPFvxiT60EGdO/gV+Gh9GKJ7h+pqe+0XmCop8dhKapRg+CWIXIfskf
xazfPy7COFeBzkh8NWHoNpv5vOR0QXlyN2QryQAw9xyW+SfZN7XrKJ0SNjDQ0HGlYzfxywhSQv
IUfwPwjnzwRzdyLokoYGBnTeogtefvN/ipes3o4yga0xJM5hd2sHuc/WY+5JwZThJCaoD3UH6a
Keb4opNLlmNB/kbX/82dBBDAmB0CTbjG1gs3i2dSvmL9Myar4aAgAA''',
    "QT-3": '''H4sIAMTllmEC/4WRQWvEIBCF/4p4VtCkm0JzKnvptdBTSw7WDJtAoqmOLOmS/vaOdpfu0kMPDv
g5vvdGT3x0S0L56R1E/sBOXJVaaAZvJz77CWyagHb80QKuEzho91+qeqLVat3Uqq10o1WrtKZa
U1FcMG59ckjXdLV120bAJ7x106X+4/Cjeu3z10EV/XfvegjyQitCg4kygos+EMCQ4MwQJlh8QL
jiH8k4TLM8mmmKci3ZdvkRlGBaZLlasDvBdoI1gt132RLXpeQOEMEEO5D5PCc34iqhH3H0TlY5
qTNz6Xt+kXXe//rfxO3HSOb+CL0cXaRcNkuUn+AFSPSHAz1VR80m4VDm4q/GDlk1gLHoqemcqg
/mIC9jXQ4j374Bt/dm+fgBAAA=''',
    "QT-4": '''H4sIAMTllmEC/32QQWvDMAyF/4rx2QYrazuYj730ssNgp40evEQ0gcTObJnSle63T3ZbtsI2Ai
Z6lt/7pKMc/JxJfwSPST6IozT1rGoRXo9yCiO2eUSu5CNS7zza9ebTLCwY/izACsAaADAWGjDG
NvxrpBKyDdkTv4PmtD1xDf+ar118C96ui+Mv74tByHSLe3b8G/GCVRHPuBXuDHoTYWoAA3QY9V
VtWOpd0gl9CpEFihkvGuGIc4iEP/T37DzlSe/dOCZ9qHDLMqlRAlSxu1NiocRSiZUS93UpdJgr
eMSELrY9h09T9gMdNHYDDcHrppB6N9W+p2e9KPV3/g1uNyQOD3vs9OATc7XFoq5bVkFT2O14V1
tudpn6Opd8cW1fXCO6lgI3Xai66Hb6Otb1MsnTF207MBw6AgAA''',
    "Precursor Compounds": '''H4sIAMTllmEC/52RzWrDMBCEX0XoHFNJLoZWp+JLjqHH/hxUe5sYIq0rS5A0JM/eXcWUkuZQao
wWjaVvZ8cHGV3o0VdDGHOqPjHAJO/FQaqyFpWF54P0uIUub4F2snXxDT2snX3JqnZ34ka0VutG
GatUWbXh12pDVSm5ELLDHBJdNseF+BuN7temUcqamVZzVeZ/NHJlijddfzOpEo/YZnZ6wX6l3R
zQBNCTptWROsr3YQf91dDkct9HXEOwyxM3o4ebcQh8EXO6FvTPAc62q4cO0n4LAeY5iFaIqhA1
26/nMTRHcxEzGaWd/kUv8QTxOIS1bU+qoQAaHv8cUFm14ejPYRn+ARdcBnu3qyK4LmHkOW5J2r
ip+sgupOxJSTEDiWk/lrZjxD53acDAsOB8UVeRfMUJo2jRj9Shn/izy2mDkQ88uW4jj1/TZywY
pgIAAA==''',
    "Collapsar": """H4sIAJuwpGEC/21QTU/DMAz9K1XORCTpqICe0HbYASS0Ix8Hr/XWSm1S0kTbmMpvx+nHNsQi1b
Ff6uf3fGSbco85L3XjHf82Glv2GB2ZoMg+vIjhgT9l6A4VakwH4EeoJX2plErIWKQq3FKkFCjG
FAS7iZgMFHOwa6OjVam36fxHJNSUhFaRKJUqEXKlEiFSqRIVqAhhHXXvEBqjz2KOrDYVZr7CQP
tqjSPaF5OjBWfsqCy6jeY9tyRuEiXkIDLUaqzjUA+TZD+V3uJkkJwZrx3xz0Q3Gvg7dnnIrdmi
Tkf/wa+a/E7Nouv6qib9qF3Ld6UruPGONkzP70c25Lwpm37b72zVn8Xz6SwWC/ZJLO7Q9INzC1
v+FRoCUZi2J1hJSg6U3NHEK7Thvys0HrTzNbcIGa3uH9l9F1qMK9Dys4tB+RU9pZ4Y5GxkiOnO
sXWlBlcazU/0l+CgO4yqYT+Jacfu2jtYV3jysoGqRcILaCf9hDrr8dIdblC3GORoqHtobqoKmh
Z6l+BdQX4JfoOsYN0vVZiC4PwCAAA=""",
    # ResearchNet
    # Volume 1 Issue 1
    "Tunnels I": '''H4sIAMQCKWAC/22OMQrDMAxFrxI0N2CnQ6A5QZdMnRo6mFRpDI4cbHlIg3v22u5Wsgj0+P9JO2
haA9dvS+jhUu0gyiw0g2GHxRocg8G0Qa/Z2RdS139E00nZnkXXyFYIOFUw2kCcUrKJjxgTsIGP
5MfCbPvziGKZla8ZDa7WMbrE2QVMnLe1KBx6VG6cc5XUUtgtEKHx1TVDFXi2uQh39Ys99TTp9A
Jv+Uz8AkGNriAGAQAA''',
    "Tunnels II": '''H4sIAMQCKWAC/2WOsa7CMAxFf6XKDJJdoTeQsUsZ2Jh4ekMohlYqTpU6Q19Vvh0nLKAq0pVy5H
Pt2XQ8RNn+e6bR7IvZQM5ME/idzcP31MSe9GeOJK1jslX9hJ0FRASLoM8i/qBmiQC2VAxmU5jG
Rxb1sFz+lkWBj/K9DnN+rqina/B3YltbXPVAKoGVU7lw8WyrdMXKSErrxq1QT4MPQkG5hEjKZR
pyQaCRXGjapLJ7ZHaKzNSPxeGQqIvS+mSas3vPXbvbrdMLZFJaLi/LnT7jSwEAAA==''',
    "Tunnels III": '''H4sIAMQCKWAC/32QP0/DMBDFv4rlCSQifAkTnrogZS4TFYNJr8SSY0f+M7RRvjtnuwgBVZY8vZ
+du/e8cG3nFJuLsxj4M1s4lG+hGRwWPjmDQzJIju98QKsHuQsSoOuE4A+MDy7ZSKfQru8rebE5
Yq+NHpxlL159Tmij3GsJAp4ApKjSkggSqNKSCFpXr5ADIUV1UNy/DDmES/FWsRtJSoC86/cg8V
NlKz67a+5pAntk9CbXArDV41qgSn7E3KrU+bM+7/9w9oi++aYtoVGFJqLB2fmInmD0CYnH81wC
egyo/DDmaVZNhb0ma9EE1vd9xirF0eVf+ZuqF4/6dNJUMZ6JdusXWGgEvRcCAAA=''',
    # Volume 1 Issue 2
    "Fission I": '''H4sIAMQCKWAC/22OMQ7CMAxFr1J5plLSke6oXAHEELUutZQmVeIMpcrdccIEYrHkZ/9nH0BuS9
y+vMMI5+YAVWulBdwPWL3FMVmUDga0lNZ+wF7rTik4NTD65FhmusuPnAX4xP+UX5p9Cv6Jrh/E
o388qloWE9u4WWLGIJRDQqG8b1UQMKIJ41KCzqyVXShG8q65FmgSL74E4WY+axPNM8kDvJcj+Q
3K8y+4+gAAAA==''',
    "Fission II": '''H4sIAMQCKWAC/2WOPQvCMBBA/0rJrJCqKNrJRehSCm6KQ2hPG0iTkFwELfnv5uLix3KQl7x3mZ
jUNuD8aTR4tismxvPMlMB5YqNR0AUF6cQasBi0DGPV2Kost0vO2axgnQka0325iJcYEzABv7Nl
np+po1R3cNX+ljqrzU+HU4T/Oa1QSvS0vu1JW/9p5A3Cz71VEhFcougCJIoPmxsOPAjXDSRqMW
Z2kN5Lo4u6JioCDoZMdhLvd728XmX6BD5oS3wBz9/3jjYBAAA=''',
    "Fission III": '''H4sIAMQCKWAC/23OsQrCMBCA4VcpN1tIdBG7Szu5Kw6hvdpAm5TkAsaSd/cSFxGXQL7L/WQDbd
ZA9csa9HCqNhDlLJrhtsFiZ+zDjHyDyzM+0DSXRsqjELCroLfBEI/kPt1TYrCB/hW/K20cnM2d
ljvypyNKZVK+9uusidCxkgvISnEtAYceleunvGjUUuysvdfWVF3XZVaBJptX4ao+Dwc9jpq/QJ
H1kN5DXTJX+wAAAA==''',
    # Volume 1 Issue 3
    "Chloroform": '''H4sIAMQCKWAC/32PwUrFMBBFf+WRtYWZCgpm2U1X/oC4iO3UFtLMY5Isaqnf7iQqWBE3SeaEnH
uzmyVcc2reOFA0D5fdYF0rLeBpNyt7GrInnUzn5IWD7SziHYC5uZiBc0h6he3xfOgM/77vt1H4
lYLt1YB/GIqCczp3+nSeesyehSeW1XZ959/htjRCtAh4D2hb1A0stnWDknWKghqkXxlJmm/aKp
pdbCKFyKIgSaYvNuVIP1DarrWHUCQnw1zkwa2/uhXqcpqrzDzSyrIMORY8LtOkZ5+2Enx8ACKK
8ZKIAQAA''',
    "Cycloaddition": '''H4sIAMQCKWAC/22OwYrCMBCGX0VyVshMiyz2KMKe9gUWDzGNNJAmkk4O3VKf3ZmI7MJK4Cf5hs
z/LcrHW6HdT4puUofNonTNSgV8L2pMwdkSHL/UiYY5uOi6413j5123HWg+HcAeORG07rAShL2k
ELXdKJtKJN4AuJ7XlUEq9K74b9lxtiFdCplnX8t9H9IEdbskSsIza6sGgJdBA2IDTXWqqVGmzT
8nXY0uKfYu7160ZUTzrZpkNzmT7SC/ohl/7Uzfe/IpysAUGlKW0ZcbU/a2TIJ7f73yPdDMI1wf
GRwic3IBAAA=''',
    "KOHCTPYKTOP++": '''H4sIAMQCKWAC/32R30vDMBDH/5WQJ6Ur5tIpYp5WQYSBG2wvIj7ULrOBNhn58TDL/ncvzYZU51
56zffuvp+7pKdK74LPv4yWjj6QnsLwHdQovPW0M62sQyvxRGfWSa1qMXMCoCgYoxNCaxO0x+zd
YULG5aWxRosSa29/l75jMWUXYSvVqhr7VwoNYDp2AI4W0cMEf26DM0bkyVafndSeXOXX6EpuCO
7BGEwBBIMUOAYmIAXOI1bwSAfB2RAgNcT9AUYjsZ+dLuOzI778h84SPfFO9DTLcTK80T/wSP8w
eiNtflLvUWoql+OrOWNR8DZI1Px+N4xmpZOVrZvopKtu0OaL58f18nW+XiyzLCaq4Juhmb7Izl
hVBxfljdpu8b/1e0wVh2/2cFgMSwIAAA==''',
    # Volume 1 Issue 4
    "Quantum Decomposition": '''H4sIAMQCKWAC/2WPQUvEMBCF/8qSs4VM1KWY4yrsrQieFA+xO2sLbVLSCVhL97c7k7qiK4UH/U
je+zKr1g+Jis/gcVR3m1npnJkKeJlVHzqsU4f8px6ocT50dnfSZn/St9XeAmwBrDGlBqsBQFvQ
/FkwwrURIsF5LQmS6mqj6pA8cSmY5XVZGIREf10g5+/96mN6R28rnufh0kh1eVGnpUv/u5rV8W
y+/fZeLVfj1XV9gzE/rqv9xYRsvAV/wFic6Q2jxo0FYYdDiISRIcWEzGkaskTEEV2sG2nzrs/s
MTlPqd/cYx36IYwttcHLAZeoCVKinnbhWcihPR5bfhBNTM3yBTOWUuO+AQAA''',
    "Propane Accessories": '''H4sIAMQCKWAC/32QT2vDMAzFv0rweQHLSUupTyM75Lh76cFz1CaQ2sF/DmlIP/tkd2MtjF4M+j
3p6ckLG8wUQ3m1Bj3bFwuD/GaawGFhFzuijiNSxRrlvqyRjQTYcs7eCqZtNIEkEOtxpZq/nG/n
ztkzGtmSA/zjkCxsDM+Z7p6PPp/OTsqgbG68am98J0FsASRU6RU1OUsuaEHeQkQkIqrMq8R5nd
VNIlDT1FMSnnP0ypejcmcs74lICS4iKfQHHbryt3/30+zReOv+2sI85bQOPSqn+7TDqMvjBcW7
1uhpaqBbSVYx9NmCfVifB7rhdBro7jATFes3a0JTtrIBAAA=''',
    "Benzoic Acid": '''H4sIAMQCKWAC/6WQwWrDMBBEf8Xo3MCulBpTnVJfAqXkA0oPqqRg00QKjnxIjPPt3ZXbpiRpL8
WwSLNY82YG0YZdn2bHGPxePBSDwDyzysLLILZx422/8XQTC+tTa4uFbZ2ulydQ9Wq11ICIoBHo
04gl0pQIoCVUILUkBbTCiraKdXFXCBv7kOhFlOPrSHf40/bRh6MPXtcnKMm11JC9AEtJU+ap2P
HMQGeZSdREwjqRMI8s+axukTBK7NOtSn7yPPvUGOYhmPnv8fHSAs5RL+PF71qnjPdTs//LSVvK
+dm+pPY5uVLVFRZzvcXgfDf7UuckpcMuA3Z+701nG/4rmO0VNOumT03sePNkgnPmnUXXrtctxU
wHWqjxA31hwUVvAgAA''',
    # Volume 1 Issue 5
    "Electrophilic Addition": '''H4sIAMQCKWAC/32PwWrDMAyGXyX43IDldj0sp3Ub7B3GDq6jYrPEDo58yEL67JOdFjoCwyCj3/
L/6Z+F80Oi+id4HMVzNQsotahZ+JxFHzo0qUPuxCmG3nlsTvEqVQOwfwLZKL6kFLtKmJA88Ryo
5WvhXv5r9k526pDdXtns4yoPDUg+bHtUXBVI9i6KgmOuWdlgMick+ptiBT/CYKfqN3fm/QOS1Q
/UW5Y7GjZouKEbuebdb/PKssY5+BZjfVcPLNE0FHzEEXU0Nv/yul/z83YUw2Bd50z10raOXPB5
QieyIeaZcXBe03cyFstL6y4Xx5loytjlFy+ecSfAAQAA''',
    "Diethyl Ether": '''H4sIAMQCKWAC/32QzWrDMBCEX8Xo1EINK/mHUJ1KWsgtxx5KD6q9iQy2FWT54Brn2btap5A2EA
Qra2atb1azaPrTGNJv1+MgnpNZSK6sRuFjFp1rsRpbpJN4C9b0qLdnULszlBqklKAl0NJSlpKq
kgBasaJYUaxk1AjiKRGVG/tAd0m1fC50hrvAlwqDaWu0U01YYmbb3f4OdgMqYuGCvQFGohvD35
nXCNfY1waDndqE5kWvHy7zFo+077XMNpGrmJvHCirmWQdd81wnjCZoyLkn5++C3YKfp+C/yv9p
gbNaM6St8UdM19TkBD8iOV+ur9Gnv/05SWE6cXqPAxpf2Xhfb7rbiaJhxmCdj9a7aw/edFGsm8
OhoUcIExlq+QFomBPAHwIAAA==''',
    "2-Hexene": '''H4sIAMQCKWAC/32QT0vEMBDFv8qSs4WZ9I9gjnvpZUG8iofYzm6L3aSkCVhL+9lNZhUtiAR+JG
9e3kyyiN6MwWcf1tAkHg6LQCarSXhexNUO1ISB4knUc+vshYyqFSICiLuDaGwwPhZRri9rPMO/
CSfyXW/o8KTbvtGDOqakCkHJP/NSoA1+P+Otw+9UmdX0TobUcYOq3gA3kJyLCmWFcZ/zvmCWzC
oRIkDhfeytojGxTIQy6VAkyoJ1ycyZyB7kuxDXbm7gqTs9ZYN2F8pu88eKd4Fi5dWallz27S++
zBOZybofm59HfpujibRrutTD6OvuvUnTwXd8Tzxa50dr3uYkt/353Mf/8XMs5esn4L5QS+oBAA
A=''',
    # Volume 1 Issue 6
    "Mazeite'": '''H4sIAMQCKWAC/23PvQrCMBQF4FcpWVwU772BCmZ01tFFHGqNGGiTUpOhLX13c1OFFrockpO/L4
Mwtgl+1zurP+KYDQJSppaL2yBqV+kyVDrOxLnotfFanbJ9dnIxrgowB1JAnAg5gaKUElIveYyS
JC/IHGJSTqQk8RgJAZVEOvDeeI7ENhOlC9bH55DG+zjGwgW/plyRbea0iTMHTrQJtdAk7M80YX
8oQkRYoUGCPZx96nb3bylWvmsSqNUfXbTlm0/Zol4guSuCf7uW24spuXia18vE7/iObxq/W9b7
FZsBAAA=''',
    "Silica": '''H4sIAMQCKWAC/32PwW7CMAyGX6XKGTS72aEij8Chhx4Rh9AGiFaSqk0kStV3n+1p0hBol8T+HP
/6sigfhpy2jxjcpHbFolBOoQwOi7rF3rW5d9Spxve+jcE03iDiJ4DaFKqNOSSaYrkeV+rh34j6
Pl9cMDUFVG/2OSDm9Cz1k/giYsmj+ChqA1ghiBGiQU0XGK3Zz2jWJAgVnaW801LrUoiWTamB6y
chEJ1TDJ0bt7+0IpTmQTRGNzk7tlfeCvb2R42JzekaR2Z7G7rOfjHs/Pns6RtppoFevwEY38e0
ggEAAA==''',
    "Galvanization": '''H4sIAMQCKWAC/32QQWuEMBCF/4rkXOlMAj0093b3L7T0kGqsgpssMSm44n/vOONCpdCLH+9NJn
nPRQ3hWnJ9i8FP6rlaFPKX3c14X9Qljr4poyelTnOb4pcP9mQREUA9VKqJJWQaol4/VtLw7w3n
FIN98RZAPyFaFBgCoNWiNAq0wBDAGgIQNJ80yEA5CTtkAXfIHjD+BN2SxpKP5SX677ivbvx2Yb
j5ttqTV4/VW6D4BvhhAlALAxyfTSPK0IwDizKstJEFUSAKNO/tZfb49/ZsHuIDh/+MofWpvrua
rN5NdVcmn0jnVDxZeb5yj+Qn71LTbxcFdzl0c3mIYRu4kvu4LSsX2nlz2qHrBvoXeSbXrD8qkD
slLwIAAA==''',
    # Volume 1 Issue 7
    "Industrial Methanol": '''H4sIAMQCKWAC/32OQWvDMAyF/0rweQXbK2PMx1zSQ+nuYwcvVhezVCqODc1C9tsneRS2MWaDQE
/Se9+iIp5L3rwTwqQemkWZWqsqwtOiTjRCX0bgTnVzSPQK6LoPbZ3hp53lotVNo3oqmHnL2PV5
5V7/a9X69ELY7AnpEgO49sB+d1b87v/wE0Mq+SfsV8J31z3kwSONrmXC20MnnsY4o/k7XXmNZd
6aYpy1v9l1TWKyAGlzVbcs5flcExJM4FM/yBX6U9V2GMqUU/RjcwWQsS95oCQLj56n/ZuIIR6P
kXHzLHHrJ4LYO1mCAQAA''',
    "Glyoxylic Acid": '''H4sIAMQCKWAC/22OwWrDMAyGXyX4vIKkjRLm0yh0gR1y3GHs4DkuNSR2cG1oGrJnn+xSSLddhP
0J/f83C+vGFDcX78xJPFezgDILzeBjFoPvjU694Z/Y+zBYXb1o28lm17aNRNwSSsIaQCLUgBIA
kd+EAOKhEtonF/kWaflcFgY+xftKLHNd866iCbL5BmqvQVyQJ2KNeBcKORH+BLz2kz9P/U213a
1lkbasuZa96gPVxB2Pv8WhaH9515mwudEnRnEaS1swJ6OCPuYrp4Z/DPJGpXj0Ie/eOjUGn1ln
DwfL0nFiTssPaQfaqo8BAAA=''',
    "Bioplastic": '''H4sIAMQCKWAC/32QQUvEMBCF/0rJScHCJG2XYk7ai5dlBY/iIbZZG+gmJU3AWtrf7kyKoCISeJ
BvJm/mZWHGjjHkH87qid1mC+NJEyXwvLCLG3QbB403dtShV1bL5mGDUgLnHCQHPJLzA0cVHEAK
xMBuMta6aAO+42J9WfEO/5o3yr86mx2dde+mwyEnchXkV//hR4Yuhp/r7xO+uz66YR5UG0yb3b
Wmk1fNBgWtf9pAXFtcv97XJxUpRJFImUh1wIjAa1wDSlKReigil8UetyAFQhIqUlFRT1Glakmd
+OhXBEgBejXlg/JvOt+jYCX4qLGCX9Fpn3/114jCPKZIXk9a+bYnP6suid0bNw5qwphEVQy988
SfrBl1V6XZnTmfDf5LmLFSrJ/VMGFp/QEAAA==''',
    # Volume 1 Issue 8
    "Chlorination": '''H4sIAMQCKWAC/32QwWrEIBCGXyV47sJoKYV66qaHvEPpwRpDBNcJOh7SkH32jiGwYbcUQZ1f/f
x0ET5OhU4/GF0Wb80i5NZvaQ0+F3HB4GwJjivRjgGTj0634QpKKylfAbTkQYJ4aoTFEok3SrV+
rVzDv7QzJsOsc3eFZ4a8gNQSuGlgImOVhEdqxWKhv6yP7G7uE9pN1zbv1ve6a8NB+M4XbrYP78
Xvm6diyG6qNtSuWrXvgJU4mnwaSnaJI0rF7VGegic6pjRP24XJZWeSHSsrmsvx0w15jDU3hUas
Z8WHz5anbFfz3g+DZ3OaeU2tv7PAw4PcAQAA''',
    "Sulfuric Acid": [
        # 1-8-2
        '''H4sIAMQCKWAC/32OvU7EMBCEXyVyTaRdczpFuKJLdRQp0RXB2RBLiR35pwhR7tlZG1HAIRqv9x
vtzOzC2DXF+sNZCuKp2gWWt9AMXnexuJl0mok30W6Dd+9kVasQEUA8VEK7ZCOLKI/rwTv869Cl
eUxedfn+/IdBdnAp/iz1ZXlvY3T1rM2g2hvI7uUGJwXYICqQ3E0hNCBLDvKQDSMJCKgkNr+Soe
S+OTuQr7/pidHUhzqss4mRPKPoEzGN21paeArUez1lL9sv982y0Kc4uXwsLrQ4VlLIeDDjyP85
biw9Hp+/AXmTigEAAA==''',
        # 3-7-1 of the same name
        '''H4sIAMQCKWAC/2WQMW+EMAyF/wrKXCQ7OiHUTN06lYHhhqpDBKEXCRIUEgmKuN9eOyytYCD4OX
7vM7sI2vV+Kq2bUyx/vDOLeC12AfmdVRY+dzH50XRpNFSJu44mqPcnyEYhPaAk1oBKSgQQL4Xo
fHKRbqI8vo6DhMGupr+kIJu1aRxSUO0TagWAFaICSQcoQKzIFc+KzCvgpCxKOHs8kCOZWDTr9m
2caoiMwGp5goFgBJ/iNf3/XieK7Yq3zvZ5v5asbgRSn1SUj1Bnc8qlQ9aMBMhEOenv8pBXp18V
tHUkSKomvZbB6C76wBQ3kh56KZeoA10kJYZkeGqbM9IcfJ+6aL1ja6enKyg3dIoPz+Piw0yeOm
lhubfDQN9j3Dj++AX+so/R7wEAAA=='''],
    "Bad Times": '''H4sIAMQCKWAC/32PzUrFMBBGX6VkbSGTqqjZWbkURHThTlzEZmqKbVLys4il99mdVAQviIRMmB
Pm48zKRrukWH86i4HdVCuDve60gJeVzW7CPk1IHeuy9u4drewkAHDOzirWu2QjfYLYXjfq+b8J
rfJvzsqW5i//mC8BLsVTp+/E3ykPGE2eFuMCXZun6u4g2+7Im6fHw5GLEg4gBcAFPcDpSF6EJQ
iylkJcU22gVMGvuDjx4LsFWWr09Q89J2RUqIcU0FMffUJCMS+7kMeAyvemBFk17+xW6ep5nGkJ
gipF48ogu1dWa/VRoB6HYaSdYqaPZvsCKkh2EY4BAAA=''',
    # Volume 1 Issue 9
    "Friedel-Crafts": '''H4sIAMQCKWAC/32R3WqEMBCFX0VyXWFmbLPQXHWFIn2F0gs3xiq4yZLVC1fss3cyZftnKZIhOZ
nMnG9cVO9P05hfgndndZ8tCiWKmoTnRR3D4Ow0OD6pam5isN0QYm+zB9s3pioHQ4gABhF3COom
UzZMfuR0pPVl5TP8W3Pv/MV5Z8o30BUvLqQJuahGLkqyJ41oCtRApiANaBD4MyQRi9SeJBaiFG
m/cZKshGn8i3fD+Oq8YTOUqFIL+l0QvsC+Py7TbMLhJ9IdzwjEGAgaCBSI4Q8QvMLiJw7gDmQK
bIKEmYqtieTiEHzjYn5Vb1ka55PYie7s6mi79MrXR9EeY+8aN+RlrFv+H3xTT2MXYrp74nRJbv
q27RlqnFOf9R2LIA9yKAIAAA==''',
    "Wöhler Synthesis": '''H4sIAL50QmEA/3WOwUrEMBCGX0XmpNCFmbBsl+YkexGE9SDiQT3ENqXBJlnS5FBLfXYnwYNFJG
Qgf4bv+xcw7pLi7tM7PUGzAOVRMn6+LGD9qNs0amjgNCunopbn04MkOhBKpJqnoCMiVND65CI0
JNa3tQL8H3RrrXcmWXm++8K9JOTDxJqIicREEoSZS3+4DPYpbhoX0S/6U9BKXme0uOG7KcuCIs
MiIDyiYE3NiSi5EFslZuG7d50Ou59sX0GcL1kU9KRVaAfed8rm5Pk1IfaHYdTh6nF2cdCTmfhb
pTj4wAv3ynWd+uCoM31vuHGcoRHrN38hRmGHAQAA''',
    "Diels-Alder": '''H4sIAMQCKWAC/32QQW6DMBBFrxJ5XaQZg1iUVdtUinqFKAsKk4JE7AjsBUHk7J2ZpCltowpphD
+2339MpnXHGJKTdzSYx9VkUKemEmwnc/AdVbEjXpnX0IwdOSpezmA3Z8gKBH4KxNzytAhQWE0s
5jIlMQ8rU/noAt+Adt7NvIZ/Mc8xlHV75WTMyW8EmXw3MsfmyEmqTJ2XLhd+ipKkd/lSwMdwT3
zZYjPWvf8gV3ABywVQoPj7QvjW+aFA7nQVyFUAtBaoBqgGLEqjKuFS6fYbrajKe/qXLfB372rq
k6804yiMR23R00BlXzVyypUHzdYtdUPy1PEZicsYGt/Lhzfeqzvrdr9vWSSMHNv5Ey0Vq6olAg
AA''',
    # Volume 1 Issue 10
    "Bad Times, Part II": '''H4sIAMQCKWAC/31QTUsDMRD9KyEnhS7MxO0WDHhwFe1BEOpNPMTd1A2mm5JNDrW0v93JFMEPkJ
C3k/ey781kL924zan6CKOd5KXYS2RkthDPe7kJ3nbZWzrJVfbrHMWN6wYfouutXrX+CEorxAZQ
K4ULAI2ICwQ5E7ILeUz0J6rDy4HO8K/9bRp23o5Wt+R5f4RaI9Aiv0YRKiRvxYz6ioO/MSUn5P
RzrlPw97CHPCUTe3FnJn3W+qqlQMVwTnul8YIzUDVIWDMi45wRaFT6NDwx0MhQXqHUimvuFupS
w5yZmvuf/+4ZuOPBTJU38c1Wp95JSTFbUl7D2NtYfd2viUq7Lc8Q7WRN7IbiN5oNc9emF09uY6
eZeDQxieWyqCanIcSid+bdXm2dLWzv1mtHD5J2pKjDJwWEGlMPAgAA''',
    "Freon": '''H4sIAMQCKWAC/42PTQrCMBBGr1KyVphJxFKzFIorLyAu+hNpoU1Kmiy01LM7CRQVVFxkYF6Sed
9MrNWDd+ub0Wpku2RiEGukAZwm1ptOVb5T1LHcKqMTFKKQ+zvwA519l99BSI5bRMkBgSpHAAmY
IUiBmFKDPAsVMrrG8JStElYZrx2N3c6r5Iun/OwRmEUDpqR4lcbZiyc43z3nmVTMePdp6f8Wxd
+L8l8BEKK/NLpWdr3QDSF3HaLXqlEVtmrCL130zywBFN41xgZ0bKsA6vZyaSmyuxLk8wPaVUxB
zgEAAA==''',
    "Benzene Derivatives": '''H4sIAMQCKWAC/5WRPWvDMBCG/4rR1EICOqkVoZradMiWDoUOpYPqXGqDLQVZCnVC+tt7Ur+cYA
oZfMjP+Y7Hr/astpsYpjtnsWM3xZ5Brpkm8LxnrWuwjA3SG7stMfQNWtTzDy4W9GgOAFwDKMm1
AEVnSYCzScFKF22gMXWYFMd7lu/9G1q9TAsAZiKNzk6HXmiM8X997tDuvm0U2SjNOXAgJyWoil
wl2WjIHLIfCAV0zpyMSUEIRV3xRdKXQxEQZJJUXAxjWQ19Hl0TBz7XF/OU0eXZWjLzFOexnIR0
luIkYOB/UQ11Hiq0rvm1WS7OF6FrGRUZUUgOr86u0E9/6BWhynTTDm3nPIHgIxIL/SYLeuzQ+L
JKm6xph3da3KOvtybUW0qb2iaGKq9gT65Ze9MmuKrX65r+NvTUkIdPFHad4s8CAAA=''',
    # Volume 1 Issue 11
    "Portland Cement": '''H4sIAMQCKWAC/32RsU7DMBCGX6XyTKW7S5AsPEFXpCJ1RAwmcamlxK5SZyhReHZ+OwIqqFjs3H
/x952TSflwHNP6PQZ3UnerSXFZS5qD50n1sXPN2DlUauc731iz89sPEiPMtZBh1lgr1kTqZqWa
OIaEl1nmlxk1/Ut89L0zG7sFRQgYuYrJnDima6Newh5c51PGYboyY22YNLEhoJnh4BobsebFhE
jKswj90tLP7JeK+29DVQy3MAAq+SsQQaSzYIEWteBexYMJ0F8qEf1Hl32vMbRuWH+lGlE6H4t4
cCdnh+aQTwXbl+wpDqmzoV1tXO9wAi07pkMcyr9q/JtNJWz9fu9xg3RGo5o/AS92IQT2AQAA''',
    "Solder Coarsening": '''H4sIAMQCKWAC/21Qy27DIBD8FcS5URdQpajc2nxApRyrHgghNZIDFo9Davnfu7BO5Va9MMzM2s
zszH2Yatl9xeAyf2Yzh352tQnvM7/G0dk6OmT8GMezS/rtxB7ZMWiAJxBCC9FBElPIAEWFDLRC
ANBSdg8IhNzLNomAk1IhAw0riO5JAgV9REBj/IFxG2soGEXI5WNZUIi1/Ndgm/rFT4PJ3rI/8e
mv2IJehO2LSlA2iiEI1mw/Lag2gZK99r0vtV+XAB1+xYce/hQDBtrd1T1K5Tb10MllZ5Id2lfB
XDfrZ6/RpOyCD5/NNLUMMTX74LPFazKh6Wd/uXhcQbmhp5ZvixcZnesBAAA=''',
    "Graphene": '''H4sIAMQCKWAC/22QzU7DMBCEX6XymUj2OnUROfbQB+CIOJh0SyK1duTYSCXKu7OegqASl5Hz7e
xPZlFjmEpuPmPgWT1tFqWhoBW8LOoSz9yXM8uX2vv0FkO374xxWquHjepjCVlKhtbXdRUQS/5v
4t8ph+SngQPLHK2dNp02zhjMFNX1rQncghPUgrTwtPBswbfgDrpzRnfGge/kwo5ALN4WHropei
16CTMtlLDRYhfhBgslXGhxIeFmW/UuAY3/H/zcnH165+aWhFRyKiwVSe7IqfnxP36bZw5zTL+2
fJ2QUuKZfeqHuiP4y11ylfmSB/Sp58wf3FKFx/F0GiXnfJWCXb8AEhCUYOABAAA=''',
    # Volume 1 Issue 12
    "The Big Cleanup": '''H4sIAMQCKWAC/53Qu27DIBQG4FdBzLUEqENTtnbx1Cy1MlQZqH0SkGywuAyO5T57DyS9uLehCx
I/Oh/wz9TYMcXq5CwEektmysta0hw8zXRwPbSpB9zReuq8O4KVtRSCM0avCG1dshEPuVj2C+7Z
n8JORfCyfmFiK7ngnMm8cORu1tw1WuvRR2VshI6ciWZbvwMb8S+hPOIyzcVGZOs7sl/yr1yKPx
X1WW+8siYNskEFzXU57KOa3+ood1/qKD/7AmTh2dkOfPWWCoy0ClUAG5zHIPoEmMVpLLyHAMq3
OktWDecSNJA7cyT3PSibxnykUtRlnD64oI2HHHbmcDD4zjjli5ZXwHV/QysCAAA=''',
    "Going Green Part II": '''H4sIAMQCKWAC/32OwUrEMBCGXyXkbCETRYp5gO1edoUVPIiH2E63gTQpkwSspfvsJl0EFfEyzH
w/fP8s3LgpxerDOwz8gS0ctrnRAl4WPnqLbbKYL97MHfkzOtUoABCC3zDe+uRiDkGur2u+xb+G
U7J9IvZExr+bDtXpeBG3RXYvhQJRC6kE1HmXUP/hLwU+xZ8/Xxu/tzzriKSai5DH4oarDpSUv5
8Wm/LNuw6p+qJ3GQ06VGGyJmZTRpESZhrnaSsgDKipHYrL6XFjO2/cme0I0bFHTZHt9yXWKQ6+
KPgBR0+mTaHgzvR93m2ccyTXTztSEXuKAQAA''',
    "Waste Treatment": '''H4sIAMQCKWAC/42QTUvEMBCG/0rJeQszYXGLAS9ePNmL4kE8xO7UFrdJyQdYS/3tTrIVtujBHg
J5kveZN51Fb8YYyk9ryIvrYhaQ10wTeJ7FYE/UxBPxTjzpQE7dfYGsFfIHSmIFqKREALErRGOj
CXwTcdkV2+yjI61uObu/X/NXnAdAzgMeEBVCBZKNh2Q88+T9w768LOwXNoZte8zr5dT6Y3ojo2
oeyRMreW68tUFywa/o/x8Luc2rNUdy5Q/dM+q0Lz0Zbx2D4CKtrI2eLlCYxjzRkSftmi7JjR7W
Fj5Q8cA/LwzEYj7SMXTZKBr9TjdjT4ke+7btuXuY+EQu30h7JsrbAQAA''',
    # Volume 2 Issue 1
    "Pyridine": [
        # 2-1-1
        '''H4sIAMQCKWAC/6WPwWrDMAyGXyX4vILkUnfMtwVKTmH3sUOWqKuhtYtrH9KQPvskj7GOll12sJ
A/bOn/JuX8MafFOXg6qadqUlhqoQJeJ3UIe+rznvimWpdi+CBv2wtoi7hegtW4BlAPlepD9olf
oZ7fZr7Dn6OeyZ/Jk60vYBo+FgABLaDRXHWpSwSwWDiiQe61Qe4L14VrNJxEayO98JskEiXkdE
/zOk8zDkWtqsfOu4FsU7ecBmUrmrue8GN5PelljG5wX2orVlu1/3S73SuL34MfKC6+6SOjNB5L
gkgn6mK/k1++O/xKJazLaRei0I2LnZDBbbeOBdIoC+ZPhzf3JRgCAAA=''',
        # 2-8-3 of the same name
        '''H4sIAMQCKWAC/5WRQU+EMBCF/wrpeUk6xWWjPa1cOBFvHowHhFlpAu2mtAeW7P52p9VVMGrigc
nwhXnz3jAzpY/epSejcWR3ycwg1kgDeJrZYHpsfI/0xirlrHlFLasLFxJgl3EpYMc52ySsMV47
+ur2vEnWY+XUxrGkmGqtWpRlUdF0fp2WHABWGtn5mVQY/9PNPeoTapTFheclPZJz4EBiuaAqYs
2A5CFyWgjUixyoj1xELiCnMELkoQ98aQQEOQlWjHc/XWrpZ9+gm/oPR6IMJ4rBPqOG/Rl838C/
ki7VHiarWvUutiWxbfX/fHTc35PxmOvF6BZteqU3hLp6TEfUo7EEnPVIzE3H6MriiLVtuqCk62
HlNLDauy7OsUfTH2w9BNiqw0FRLjfFX/sGTLIt1nYCAAA='''],
    "Breakdown": [
        # 2-1-2
        '''H4sIAMQCKWAC/22Q3UrEMBBGX2XJtYWZqeTCXqks+A6yF7GdpcVuUvLD0i312Z2MCiJeZPhyIP
MdspnJLyU3t+A5mYfDZkCn0gpeN3MJM/dlZrmZJ/Y39tw9f4B9kdMBIGAHaEkm6WwRoEPliBYl
k0XJykk5oQXqiGzNlZu7g+lD8VlKkPbTvgsIJf/n9tvnsee8zt9GJEYkLlg70bZQeyS3+LcBdP
9b8APH5ofeCxpdahL7FKKAHAsLy+uiXZETu9iPdZN3l6//iOzeh3D1FbqSR31ojssaFA3T+TyJ
bF4F0/4JWvJNvm8BAAA=''',
        # 5-3-2 of the same name
        '''H4sIALbnL2AC/22SzU7DMBCEX6XyCaRG8m6qSJBDJSokDhy4AwfjuGrUxI5cW5BW7bOz66TQv4
udnXF2Pm+yE17ZyrVZbbsYsq2zZiMeJzsh05pUFt53onWN0bExVIknY7fGmnm5OMj8I8r8YUYP
LwdZlFKChFICyhxpx4LXHKQsITnADlCFBVCVHEwOsiOxRCy4YkdMJ0K7aAOFFvvp5JzizTW90i
b0TWK5G0AWhIH3hHNsO7Q7Nh9QoABkOBhRyQHkHUbM8RrD6WuUzz3RCBfDramdMj6HlWK445Bw
GBIAnA+EdrwYBTA7a/R0ng+S0+FW2DiL/1HM/mL4S1yFyDHkoj33D8Z7VVsSZlS16ifzRungPN
+1IGmlNpmNujHKkxJ8NKO4iZ3xX85W5sLwRvd0/kQNfZfQO++qqEPtLJNY1Q7/GSWuK/edRBXD
yvGr4lXZdc9SVS+XNd0+9CTj/hf+Paf9zgIAAA=='''],
    "Vitamin B3": [
        # 2-1-3
        '''H4sIAMQCKWAC/32QwWrDMAyGXyX4vIKlsKzMsEO7w07dbZexg5cqxLSxi2PD2pA++ySPjo7CDh
HSF/zrsyfl/CGnxSl4GtVjNSkotVAB75Mawp7avCee1NrGz+CrZxe+3JbM+vWs0QA0iAZhqbUB
5KruKtWG7BMfAZw/Zp71v7kr8ifyHHjWzQt/RmvQYDQnc8VSa5D8wnkjyK4GuC8cC0do2AexkV
74jYmohJz+3vnH7dpn42zr/EXnflPu+esEKE5w44Ti9MCVPfjvlYepQfpaLzmn5jfi/sZPFzt+
3y3FxYUio96Oiy6PFHlOMROjdDwU0Ugj2dj2EuTtUNibS3ZwvlrVQm1OfZCTqrU7ejo4Erp1Xe
f4tukoO+ZvSGW97ggCAAA=''',
        # 4-6-3 of the same name
        '''H4sIAMQCKWAC/2WPwWrDMAyGXyX4vIBk07Qsp3aXnbLbdvYclRoSOzg2NCvds09KO9jowUL+jD
/9uqijP1Nf+zCVXH/FQLN6ri4KuKq9o7wMFKh9+Qb9yqcFRIQWsTHQamy4NwxAXZ8qFUv+L8G1
jnEgVwYSY+et80F0Des23Zs4UW8123QDuDpR/EyAe81+4aCFG73j3sCOfxnDc1sAZIJr1TciVX
EcF0vIPBRBwumHLPtxjMHbtuMk5nexmw63KOs9isSUKSXrA4MN30Z7rhNZl2Oa7+hk5zoUN5BN
THIqdIdzmSh9xtDTn4e8TGucKcW+uOxjkJnBjit999mOPlQHI9SWfIryV32wyPbCen88et4pL8
z19QcmRzV/0QEAAA=='''],
    # Volume 2 Issue 2
    "PVC": '''H4sIAMQCKWAC/32QwWrDMAyGXyX4tMECstMmoz6V7NDjTruMHTJHbQKuHRxnkJXu2ScrHesoLJ
DP0S/ll6yT6N0wxfzTOxzFJjsJyWQ1Ca8ncfQWzWSRIrGb2+BNZ33oTbY1fat3tdWSHtBKygpA
PGTC+MlFKpfq/HamGP713BqMs0WHuv4CtaNXAxtKWRbJtqTvgoRb72Tup/j3Bku36w7P3s4fvZ
ttVvPoLeq7S6+itvdOSyilTP0SFbNgrphrZsms0jQAab5lSlDMgrlirpkls7qsBogFc82smJBW
ppVajtVylDd7BL5p14y5bcIB8+XOlIlhQsq8e9diyH/qHy/FI7rRh9+ypEW0OPgQ8UqP88B7Cj
hiE0yXervmuOzupU5hM8WOrcSTP3TYWPqf5Lbf73tac5wppc7fb0PmA08CAAA=''',
    "PVA": '''H4sIAMQCKWAC/32QwWrDMAyGX6X4tMECspM4YT6VbbBbd9pl7JBlahNw7eI4Y1lpn32ysrKWwT
B8SL9k/Uh70bvdGLMv73AQt4u9kExWk/CyF1tvsR0tUiZWn9MGnVkdQRkpawVGyRpA3CxE60cX
qUeqw+uBcvh30EPsJosOzR2NejxCYSTQo6FaEZUEGs2KkjoxKX9sko8f4+UGs/G52ZO300fvJr
tY2tZ33pqrk+3q2pGzluycqJg5s2CWTM2stAQDIBMlUzFzZsEsmRVTJ6Y9wKQWmPcwec5xwXHJ
sea44ljW6VfOrJgl8WJ74N27ZshsEzaYzVegSgwjUuXNu3cM2am//mke0A0+/LYlLaLFnQ8Rz/
Q47fhyAQdsQtslb9ds52s+L1PajLHjUeLebzpsLP0n+b1fr3s6fJyopA7fFd2Z4mECAAA=''',
    "Naphthalene": '''H4sIAMQCKWAC/32QQWvEIBCF/8riuYEZk8hSj7kEFvoHSg82upvQrAajhzQkv72jodAupZcPfW
98zHNlg51iKD6dNTN7Pq0MM7OahNeV3d1oujgaurF20d7djJWtREQA9nRinYs2kIl8e9voDv8m
NMq/Oysbei/+eJ8CXAy/dzoSf6a8qKkPvRqNNbLZAXeAdodzCuUoIe0mgWdWmXUicgFcYpVZCk
SJtSCdH6wEcslLASg5z2dMMyWnorLEzCqzfqwOefFezcWo/M0URwVygo+GHKqsjS++588khWXK
VbyZjfJdn/Ksuj/WS7KKoXc+GRdltVYfSdTD9TrQf4SFjHL7AqSaxF/KAQAA''',
    # Volume 2 Issue 3
    "Anthraquinone": '''H4sIAMQCKWAC/32Q3WoCMRCFX0Vy7cJMshukuSoWWgrFByi9iG7sLmhiYwJV0WfvzEihrdCbA/
M/3zmpMe5qaY4phr26m5wUikqWE68ntU2bsKqbQJHCads8jH0YDn1OyxCPIQY3v4B9ukDrAK1G
B1rUIIDTgIAO0SI41Kxa8iB5jRa009oCqulErVKNha6gPr+dKYZ/X5n7vExx8pJi+qSP3HzBdz
RdwBnAzT5emGr5DXu98HPrfSxD9h91jOlKhgRGcLPFhV4FRAYBi5qPMZrACgLjIKlUCZA6DTCs
QbHCcCcamWplqpWpTrZ1bAVasUjUdDJrxS7L26ATNTOCNOYvJAji4PfNxuf30FxhqVJyDVQhs/
qQm+/+llLlsBPoHPbB59XA+6Lf3hrBBV/LkDKXnh857sf1eiTbyoFy+vwFfUldLkoCAAA=''',
    "Soap": '''H4sIAMQCKWAC/32QTUvDQBCG/0rZk4KB2cmHwT2VIAYvOXgUDzHdmkC6G5LNIZb2tzszpdaiSO
CBeWfZZ9/sVeeGOUSf3tlJPaz2Sgsl5eB1r3a+t83cW5rUurGha1brptuYojxCXFRVaUBrDUYD
fUbrTBNRAxiEHNAgJWBindM25lzdrVTjZxfoRo2HtwPN8K/2MbRLb501xRGQtMlFhhcZJyRj/q
lhj5/Ddd+T+KfsxdeDKW+4Ht66io1XDVGz7txTGAsTYSrMMgQD9/KwLCdCllMOMd8DKEyEKRNT
OZkIY+GvCiAF2nqK+nr8sNGpCm3COFvavHu3sWN0Pp9QFJZBKo12svXYtHyfq3ffNXmu59D6kZ
PnJ5433Xbb0b8IC2V4+AJVMx+HIgIAAA==''',
    "Glucose": '''H4sIAMQCKWAC/21QwU7DMAz9lSlnKtlOW03kiDQ4IPEBiENoMzqpTaY0OZSq+3YcM8SQuDw57z
37xV7VyZ9zqj6Dd7O6360KBIUtxOuqpjC6Lo+OX+oQ4mTH3g1L78zD0wXoxRAhgEHcExjCFtAQ
IKC626kuZJ+4D2l72zYmQk7/xd1GPI65CzNPv0DLAVgyuDQaSgxRi2gQJAxKzZGMGq+fQDCA/D
DUiNpKl5a6ll4SDxUPaMFasCmIuqhYCzYFtS4TtCypa8GG8c96IMsNdq5GGz9c9b0mKylmx8p7
8L2L1Y9/fzXPzs8h/trScpYTRDc7G7uhZHg73Z6lUDanQdrUc452sr6Q/el4PPEN08KC3r4Ak9
esedkBAAA=''',
    # Volume 2 Issue 4
    "PZA": '''H4sIAMQCKWAC/32QTU/DMAyG/0qVE5OoZCdbO1EJaeyy08aBE4hDaDMW0aVT2hy6afvt2AmIL4
lDLfu1Uz9+T8K6QxjyY+dML26yk8AYo8rC00nsu9bUoTVUiasHb7t2ki1H7YK3dbaobVNdLdeb
1eQCqkIsECrAUmKFsuRcFpRLybrEEmQFgJSjQoBKUUqTMKcIak66knMAcZ2JugtuoJ0oz89nqu
FfsDvjjsaZanmBYkUfb+F/Im9PDBA3JkIkHqKKMxILoiJCztNM1CPhHxJG6cLw07TE9p3nfvT6
aJ3e2yZCzQhqtiaLNnRh2hF9AeZQEJVpyUzRI0xRMVPyKzmYuMkpSfmMX8npb0qIjDvd5632ry
ZPtNQZfDDUeelcY3z+OT//GN6G3vivqWE8xEO86Y329Y5X0DnpuMcFlzoMu46fiFq/mduDNaw2
dru1ZMMwUked3wH7XAW5YgIAAA==''',
    "INH": '''H4sIAMQCKWAC/32Qz27CMAzGXwXlvEp2AmVaJQ7jwi7sAaYdQjFrtZKgNjkAgmefnVCxP9Iulv
PZ8fezz6p1hxiKk3c0qKfJWWGKSRXh7az2vqM6dsQvtTzWnd/EQI6q5RWmqyuUFeoSsUIsUVc6
5RoQWDEIUBmUiEkxWnKddM39qB4mqvbRBR6O+vJ+4Tf8S/BM7nRzL5M7pMmApeaoUzR3R6GCkT
D7Jp3dIdFKLvofEkHxMfy8Tmb7zvMyeNfaU7sdiebrK5hXMRYDmIuBThBGzDIKzPgqgo75ENw5
FTgWpBPyGo+a8+kcx8PhTKbdDlr+hoaE3Nih6Gz/QUWG50roI3Fl492W+mLs17fmXRyov3eF4y
Ht1dNAtq8bsXB2n3ddr+RpY2i8fFG1/aTFoSVRt+1u1/JVwpEr5vIFk8z3T1oCAAA=''',
    "PAS": '''H4sIAMQCKWAC/32QTWvDMAyG/0rxeQHJTtOwwCDrpad2sOPYwUvc1SxxSj4OaWl/+yQlZR+MHS
Jev1asR+9Z+XAc+ujUBNep+8VZoVRx2Xg5q7qpXDFUjk4qL9qxsrUvXbbeXEGvN+vdlkUGmGjM
QCNAhpggZpoqZAZXQBpS7gEkjdJjRBvW6m6himYIPU1AfXm90Bn+xXh04eQCMVwhoenJ/PKNQa
oRkmmikKBmKhRfi0+ERKV1wtr8RcIozdD/jGhi+84TR3ntQ9PZyhcjfYu88CXTrYhutd1dwQiE
llComkSCkMEzVqIZd0WalsEJkePjSrGSAybFObIMYlkjlteWKXfGKQe6/L0GyBIH20WVbd9dNK
1DN307OLp5a0Lp2ujWn87N+6Fz7VdXPx5l09Z1zrbFgUcEW4v3lD/z0Q79oeFfVGE/3MPRO3ZL
v997yqkf6cZcPgGsG+RUcQIAAA==''',
    # Volume 2 Issue 5
    "Fusion - Germane": '''H4sIAMQCKWAC/22OTYvCMBCG/0rI2UKm60HMUdDehL0uHmI7pYE2I/mAraX+didxFzxIYGCemT
zvLNK6W4rVnRwGuReLVKUWmsHPIicasU0jciebufP0O4/i23S2NaM+NxpgB0rXAErJjZAtJRd5
F+r1sq4MKMVPEe/aE/rJONQnbB5qy8Yv1mlQ/LQCNmuoWf8hRJWIK7kOffVPt4wGE6o+BfTcR5
+QUZxvJc1jQOPbIYucmQo7pmDJiUr8nZJnJsWB8n95oGBfrLN9b/nsOOf09QmgRMtAQAEAAA==''',
    "Fusion - Silane": '''H4sIAMQCKWAC/32Pu4rDMBBFf8WojkEyIUVUGhY3qVKGFFp7vBY4M0GPwjHOt+9IzoIXQhAMzB
k492oWFu8xlA9C8OJYzELlmWkCl1ncaIQ2jsCbaKbO0Q+gbrRSSkqxK0RLEQMfVbVcF97lR8MJ
wmAQdN085V7LZNFK8mPhQfGsWKurt/Jkpxj+F17jthFnO6aEs30TofYfMmRO+CbswJV/tGI0GF
96QE+OQXARXqyPHjYoTPdcwIEH49ohydHcMvuK3hIWZbG2SycTw5CNoiZvV9bZvrf8kTClQssv
WxoLTKABAAA=''',
    "Fermentation": '''H4sIAMQCKWAC/32P0UrDMBSGX6XkSsHBOSmOYq5GpvTKCl6KF7HNbKBNRpaKtXTP7knG2JSxm0
PypT3f/0/M2O0QFj/O6h17yCaGaSYawdvEetfpeug03Vg5Nt59apvdPK/W5a0oBSICsLuM1W6w
gb5BPr/PdIeri15GP3yZOlvVphGy3EMuK1lVtA+WiAJ5mrjkKICTQnBOHgFQcDpDQSSHSDgWND
G/lCLGcEO4VPA8i1T+w9lsbdy3abSQ1R54cpMPky86/myHU8PzTY+hVdZ1QtIG6nQf++CpzyEr
p9zHVik3WdI58dTznyvKKGGj/eJIC0Jh3Car1zutfN3Gv6zqE3vSvtc2qGCcjVwNoXU+vrya/o
Aas9kYSh7GaJl/AS9ljD8LAgAA''',
    # Volume 2 Issue 6
    "Hydrazine": '''H4sIAMQCKWAC/32OzwrCMAyHX2X07CCtomCPu+zkC4iHumVusLXSP4c5tmc3rXiYihRC84X88k
2s0/fg84fR6NgxmxhPNdEIzhMbTI9V6JE6Vo61NTfUspSccwC2yVhlgvY05GK+zNTD34RC2avR
sqD9/Y/9GGCCXzu9Ej891KPTKE8LiHKBHeUdOEiIWpIDPSmIUBXkKbdftpBukUuNNn/THaFWub
wJDi313gYk5Md7OmvRobJVG4O0GtYqEargWxMX2QkHY7squIjrrmno3/uRRmJ+AttYaq92AQAA''',
    "Organometallics": '''H4sIAMQCKWAC/22NTWvEIBCG/0rw3ICTQA/12EsPu9sfUPZg3dko+BF0PGRD+ts7Cj20FGHQ5x
2fdxcurpXGR4pYxMuwC9lnpw187CIkj6Z65Jc464UXXQ3qvCgAmKQUT4MwqUbiHKbjehwMUqX/
tL9USHbzw8mRbb7Xty85nxxLnwGUZLdUIPkomEBKNcH8p0v2ps8Ub5jHHzoxsrqMZfWOCDMjyh
WZ0rb23owFdTa2uaIOnb3nRccUkLT3zpQW6Uo2te/igiFlZ2rHN3e/893TxtF8fAPe9MhgQAEA
AA==''',
    "Nonsense!": '''H4sIAMQCKWAC/42QQQrCMBBFr1KztpBEN5oLdCFeQFzEdmoDbaakyaKWenYnARGxSCEE5oX5by
YTM7YPPn+ghYEds4mJdCcawWViHbZQhhaoYsVYObyDVYUSQnDOthkrMVhPj0LO15lq/j8BWhM6
VQAFyO+AHXWv1x3IFnUY/NIGK52Cf0ZeNj+5jHLBlfzZmKcJbmgrcPmb7gn5sU8xDgbQrmxil9
VdYme0A9DZRKiDb9BFfApOd9pGWJm6NjSJH9OvvAB7+Ui6pQEAAA==''',
    # Volume 2 Issue 7
    "Iron and Ozone": '''H4sIAMQCKWAC/32Py2rDMBBFf0VolUINkgrFVPuAV84+dKHak9rgSEYegV3jfntnVEJI+tgI5k
g6d+4qez8mLD6Ch0m+iFXqfGbK4LjKcxigSQPQJOt5eQdv609lrNalUdboUin5KGQTkkd6o832
utGs/hVVMXixq6oHUc99C3YPNQnN859GVoaEvy177yVZdt1Z1HWrm0qs40ZP3Eh/52trTPnjPw
vegm8hFhdqCHVuKhAGGENEiAQxJiCOy5gTIkzgYtOxzbvztb/zrcjxfOMSdoF/ywOwhlDbn049
7YkL529f25ZRI60BAAA=''',
    "Normalization": '''H4sIAMQCKWAC/62Oy2rDMBBFf8VoHYPGLiWtlt1kk/oDQhaqM6kF9kzQA+IY99s7EnTRpnRVBB
d0xD26i3J0SbG+MWFQz9WidMlCMzgsauIR+zSi3NQe42AJzcvuQz8YDQDagJZjAB5BsgGtTSNY
q02lek4Updeum+o3EY/F1Ha7P1xb4e1P49N6XEWqOMXv+6HkP2wGnf36Ttdd53ck00l7e9fIlT
emE/r6izaCBhvqgBTYC4g+obA4X4rPY0Dr+yGbyE6FvbKf7OhuNjqm/GBTHEpZ7e2V2GPyGZ/c
+exkWJzz9+snpmrGuc4BAAA=''',
    "Decomposition": '''H4sIAMQCKWAC/22PwUrEMBCGXyXkpODCTFyka47dyx6kwnoTD7VNaaDNhDSBraU+u0kWoYtehu
Qb8n9/Fq6NDX73RUZN/JktHPLMNIH3hY80qCYMKt54SdYqx+5Op3t2DoPta69kGc7VN+wlCHFA
kIj4JFACFogSRQERQQFCCoxn/sB4Q8H4GIdi/VjXCCj42xaY59YcbV1w7M1puuhWyaR8vLrENv
9qvLFAUsCfxO1fqpxZhiomioOAf7pCbvpJplVu90v3EfnZ5jynJlW7pk+vTD1mdlQNjZYm7TWZ
tKiD78ml1Ut9Ya80DGpOvNVdp2MzPyfX+gMIean3mAEAAA==''',
    # Volume 2 Issue 8
    "Phenol": '''H4sIAMQCKWAC/32PwU7DMAyGX2XKmUm2A1FFbnBg4tLdEYfSebRSl0xdKq2rumfHMQwNkDjkl/
0piT9Ppg37IS1PMfDB3C8mg5pKM3iZzC52XA8dS2fK4/jOwZdnII9YEHjCAsDcLEwdh5DkDtL8
OksP/370wOHEgf3jGdxKjgdAQA/oSJI0LQJ4VI7oUGpyKLVyUk7oxITI5TrzPyZZJQ7p55Kfbt
c+64ZD7C46d+XqW6jIg60jHf+lIiNtFiIVIiVAKESkJa0qWtLE31qgUm8xbLhfXuitoDTuVabn
A1d93eRXodpdCWZSDamJfWbPT7nftNttK3ukURjNHzRnG9TTAQAA''',
    "Uracil": '''H4sIAMQCKWAC/32PwWrDMAxAf6X4vIClBrfMt+0SGGynncYOXqwsYaldHPuQhvTbJ3sMutHtIC
E9IfG0iMEdU6xO3tEkbjeLgJILzeBlEQc/UptG4k40sw3+nZxuNABIKW42ovXJRR4Crq8r9/Lf
C3fkTuRI35+laji0lCBBS1DIGUve8mUNhQMo4BoVcF04Fo6gJGpElevtNZOs4lP8+d2X26XPcz
DtMGadmnXqx7PEJ45fWjv4SwtZa1+09lkIihDurmrJIvXmnaVQfdOaUW+mqksTBe5jSMQozsfi
F2giE9o+H3LmcOGciUmx93lLPBhnrfnI0A5dN/B/ceYBrp8ZfSbW5AEAAA==''',
    # 2-8-3 stored with the same-named 2-1-1
    # Volume 2 Issue 9
    "Phosgene": '''H4sIAMQCKWAC/22OywrCMBBFf0WytjAJ0opdFkFwoXtxEdqpKbZJyWNRS/vtTrJSkcAlc8Lck5
l1egw+exmNjh02M4OUiUZwm9lgeqxDjzSxo1dTjxrLagVxWmFXcqBTcp4LSsEBSpGI4HnMSNh2
w2oTtKcGLpb7shAwwf8Tf8quyrhHkl2qnnzUn3Mg157uIHhBAwmKHwOkfiVd1gaHlpC3AQn5aU
y9Fh1KW6u4peXw5YpMBq9M3GNnqZtGPiNsurbt6Gd+ogexvAGZ+ENgOQEAAA==''',
    "Ignoble": '''H4sIAMQCKWAC/22PwWrDMAxAf6X43ICVlR3mYy/toWX3soObKktoIgVbPmQh+/bJZoNShkCgJ/
QkLaanKUn1xYTRvG0WY0suNIPLYkYesEkDamXOyOTO6ADAWmu2G9NwItEW1OvHuirgJP8ZHy0n
lM4Tuv3h2+7U9QrgbFY6sBquznYHNTytsGXBlemGofqjtaLOx6pNEYPWEhL+ojgNvcgjlXkqFw
SM6EPTZT35sbDjJ/FVD1Tkk3Scx8w7B5mY7nPGt75te31CZm29rD8b6At1PQEAAA==''',
    "Alchemy": '''H4sIAMQCKWAC/23OPQvDIBCA4b9SnBsw6dCPTJm6lNK9dLDmgoLRoHdDGvzvVekQQhfhnoP3XJ
i2E2H1cRYCu+wWxstbNMNzYaMzIMlAmtgNRN8+3m1TnxrO2X7HpCOLaVU38RVjAkf4r7iuXJ3p
245S5XjeVHhpKBGqADY4nww9wc8GCrChMBmNuFacp3LFQwDhpcp9K8ZinZEKxjmTIFSlz+5aZu
j1MOj0RZwTHuIXC97vvhsBAAA=''',
    # Volume 2 Issue 10
    "Bosch-Meiser": '''H4sIAMQCKWAC/32Q0UvDMBDG/5WSJwcW7qJsxTxp9yCI7kl8EB9ie6PBNRlpCs7S/e3edYiTDQ
k5ku+4X74vg3J+26f8K3jq1E02KJzqpIrwOqg2bKjqN8Q3ddu2wTtrnu73cGUAEcEgLrhqPvIZ
eKnLTFWh94knUI9vI9/hX2xp43vw2dKFT1eTKVd70Myda+EWzAUsNJxwBRz6dC7AMf3FJoqGHe
sVQxEPUDRas+U/UPi1egx4jmTNhWTWM96lYOaSHAr2CZyfYbhgJEh+AwI+4I0++RGYfHPemmL+
o16zlHbb6blIHdlYNTLlbTtpd6GrmvyRXEdRdNunJkTpPFhf1/ZDxNqt145Npx039PgNn6nM6d
0BAAA=''',
    "Beckmann Rearrangement": '''H4sIAMQCKWAC/22P30vDMBCA/5WSZwt3V+2GeZq++LIJPio+xPa6FptkZClYS/e3e40bOJDAkf
vuR75MqnOHIebf3vFR3WeTghQTXcDbpKzvuRp6lkxtKo6mr/1XZ1k/noCeTnC3e9aAiKAR5GjE
EiUSAmiCFZImLIVTIgWs5V5IO6ibTFV+cFE2I83v8yzAD/E/ob8Su3zLsR37xgdrbFdfmRCu8L
z/7PBrVdB68aGSLoZULNVkfmUCyePDu5pDfqG3guJ4SO8HPrIJVbtMOWMTe+Dq0xrnshcpBeP2
bFkGpcMMsfVh6XndbhZQd03TyV/iKJDmH7w1bqWDAQAA''',
    "Stock-Pohland": '''H4sIAMQCKWAC/32QPWvDMBCG/0rQlEINOoWQUk3x5MkUOnQoHVT7Uqu1paCPwTHub+9J7mcIRX
BCr04Pz2li2hxjKE7WoGe3q4lBrjlNwePEBttjE3ukE9sPgzVaybp65xsJsAOQwGlJAcC5BEGV
Xa9YY6MJ9ALE/DTTmf+LLa1TBmX5Sd3CNy+zL1MT1sZwSf83uxpbZ1/QSIILghN3gf8B8h/Jc7
GTJrV1WV2R3LrOm+SL1zJ5rnyTfEWukCvPc4BYptmmHpH/i36NOsWOw5lCcni2pkVXfKU3FHXK
Fx6Nt46C4CJSFsZjFnToUbmmSySjhpzdB9u8FXe265Vp04WKocuP2T7YQTe1Nq/qAZXHPl23+n
DQNHEYqUXMHzwkdiUUAgAA''',
    # Volume 2 Issue 11
    "Swapite": '''H4sIAMQCKWAC/22PwUrEMBCGX2XJxYuFmalWMce9i9Cj7KG2szSw25Q0QdbSfXYnMVUrXhLmy5
/k+2dlhjH44sMOPKmn3awwrYlG8HpYbncK/sBZne2J23BimVT93ozGs66vgFeAl+d9bTQAVkQa
sULUJWEFpEkmkgnTBAIJNJVpQ0hnKBAlCXgfI5imUiIgScI7eQzLBwIlVq0NgxcBpOWwRE0b/L
bMl/c/rjc/srXZr7L5u6yS/bJR+nX1ys7bPrnkt2wsjhiVN7KQVN/s0LErVvooqG+mwvOJR+s8
O4HeBRbuL2NSdzxx49o+vjY05991ImqC7228piYfRtOliPDOHI9G6vuLnNHyCfCDiTryAQAA''',
    "Hardening": '''H4sIAMQCKWAC/32QvW6EMBCEXwW5Dsp6oUlc5a5JlReIriDgy1kyNvLZBUG8+61/SKILSsNoh7
U93yxMmSn4+ssaeWXP1cJ4+iY3Gu8LG62WfdCSJnaQbtZahVEcpEDeArCHivU2GE+/Oa6nlWb4
946jnSbpxDEIaPCJgwAk4QJ4FkjC88TLlFd4PoBFsol5E/NmQwIkPAttAogG4/Qnasxqg98rYD
9wfOoOGX6Ad4uq8+nqRWs70x3VY0XVFeQCWXrYhczRN5Bv5PYXYyTGxI+wFVZazJ3eBY6JP6wZ
pKs3tyXLz1OK7uRVdq6/xFOmG5P32rlBGmU+o9kFf7Eu2m+qj8agzmdF5H4mE9cbHuPT7VUCAA
A=''',
    "Keying In": '''H4sIAMQCKWAC/6WSwWrEIBRFfyW4bkCfgaR1281Q6CJdlTILJ3E6QqLB6CIN+fc+lYEJQwulm4
hXOMf7zEq0mYIvv6xRM3kqVsLSN6Ux+FjJaAfVhUHhjrTBX5TRYRRtEMCqilLyUJDOBuPxnMF2
3HBPf4U8h754lcZ20sthmT2yyvb05t4FQyJAAgMTPPK5AOA1pYIBb3DhwB/30gqNfxKwLOBZAJ
FcZ3IUwL8EkBskMss6Hsl1Jje5yJ3guMWx2eD3j5HneGv+wUpzkZt2cB0f28nvx8docp+s6ZUr
r2mD0UXOpVeDmqzzymHoXVCY+2VKd3FqVtJ1l0gzckzZi1q0+SwOJoYS/xbr0rV1F4Nen88aq/
gFQ759Az+IEJJ+AgAA''',
    # Volume 2 Issue 12
    "Ethane": '''H4sIAMQCKWAC/32PwQqDMAyGX0V6npB2w8N6lIHvMHbotE5BW6ntwYk++9LIwLExCoF8JX++zK
w1Q/Dp0xo9snMyM06VaATXmfW202XoNHasmCpnH9rIQnLOAdghYaUNxuMnF8ttwR7+JuTK3a2R
Oc5nP+ZjgA3+02lL3KdcfKOMlvkKolghkxBtJAd8MZhjFagnBRFBRBA5fmkDLUWpSrv0TU+I/D
TQMqdHrVzZxCmj+p1AJCr4xjo6zY7txqq2rlt09RNysbwAR3wyMmYBAAA=''',
    "Cyclobutane": '''H4sIAMQCKWAC/32Pz2rDMAzGX6X4vICllDLmYy657AnGDm6iLqGuXfznkIX02Se57NAyhuFD+s
n6+LSq2V9Lbr6Dp6TedquCqpUK+FjVJTgaiiPuVL+MMXyRN70BAK3Vy04NofjMQ8Dtc+Ne/+vQ
2XgM3nS8f/hjXwxCyY+Z7o4PLsvgwrFk68l0N73vb/rVYMuJDMIBQNxFUVRLVIP3GqWG+hM0P4
NVW7nGtPh8k66JOPFIsfmle0aTTU0in0JkkGMhZnm51nSREtk4TOLk7eU5sWBb8lRX1Xtwbj6f
rdBxPp1mvjEvPMHtB93RELOeAQAA''',
    "Styrene": '''H4sIAMQCKWAC/22QQWvEIBCF/0rw3IAz7kqp9JRLDu1leyw92GS2CWR1McqShuxv7+hS2EIjjP
q94c0zqxjdOcX62zuaxVO1CllqoRm8r+LkJ+rSRHwTrxSH0VF1sP3Y2ck0rUHQUhrgT4qHSnQ+
ucitgNvHtjHwKf434d71LS6BHJnmKnV7lfumfW54R3bVgHkCSqN4DhhADWAQNYJRWIjkZbBUda
sKOBGWCkqzj1SczsAu98tdOe9Z/ZNXlrSDnevJhi+qb7lZiSERK5/e9RTq3/5HRnE5l/yBZrKh
G7Kfs6f7N2VkUxx8yPDFXygsbJNxPx6PI/+CuLCkth87gYU5iwEAAA==''',
    # Volume 3 Issue 1
    "Thinner Line": '''H4sIAMQCKWAC/22QQUsDMRCF/0rJScGFSaqlmJP0oAelF6EH8RCzUzewO1nSRLot6293klqotQ
QG8k3mzXvZi2Co9l3lqE+x2nnCjbif7AWUWmgGb3vR+RZtapFvYrkdPpH0Uks5BxA3E2F9osgt
qcb3cWSwdlus/8nKPP2CsTGEevH0DbcapJSgJfBhuZnkqiSAVoyLdLYiViZi0DyglscJOZfHV3
mhT/FShFPbDxYjt/VV3jy9ZrFFjjBTvBMOm3MFVfSnxUXxApCJgoOv88hQArO/YBwxuONbZ7ZV
QGOjD9mNYtSYTWXqL0MWa0YxJPyllGyLJvyFm9Rj+PBU41kjoB34/QmNQ1/y9cHXyUbnKfsj0x
X62jgiDJNnR5i5SbHxeVo8Gk7QYly5XW7Ubr12/FdxyI7HHywANY4cAgAA''',
    "Decomposition of Ethanolamine": '''H4sIAMQCKWAC/5WSUW/CIBCA/0rDs0046qYZj26JyRL9AcseGMVJ0nINwmJn9LePoy7auT3s5Q
IfvfvuoAfmlauxLa3rYig/0ZkdeygOjOeYKYGXA2uxMTo2Ju3YU9gqh41qrTNyceJieeKz1VoC
3ANIEDnyeYqCA+cSqhlwyStIUVREONCai0wEEVpyNimYxuhCskyPk+JX7bfxbr380zhUHiyQjf
+x9D9HG3vyNOc5qotncELyw+AZnGPb6zEJGcYwvm/I8bqNlQ0e342TJJ+NywCnIvwmZ6H8Gzq5
oHZ/yxA3Get9Tw56uvlNBqUE472yLoEq7Vq1L71ROqCnvqcJbdWuVPWHctrUCQUfzZl6o3vdGH
+hoe+ytfNYRx0sOjI61Wb6aDS2He4sHRS4Ka5/M/pQxbBFKseea5VqEKvtZmPTNKFPXBy/AEPf
/LbRAgAA''',
    "Anesthetics": '''H4sIAMQCKWAC/22RX2vDIBTFv0rxuQE1/UMWGKyF0pe97W3sQYwhMqPB6mhW0s++e01G12YEDJ
7knN89eiFe2Mq1mbZdDNm3s+pEnhYXQtOaVBTeL6R1RsloFOzIwUTntVXl4Up5yVjBaMlZQSlZ
Loh00Qb4azUsF/e2fWNG296gjzO2pRTsbMvunJuZc+ddi8adH435Ohnz9b2RDx8DeEmtz6qadW
KY9KpCI3CE45WuSgpwCKLwQNyGwcoZxTKwEoxyMcxT/qnlaudbSMVqOaZsx5ixISbT1HOE/R2a
UeTQWexRGDfNCqWPO783h5Sd0jiFaHiNG54OJMepgVMkTIGd+MOljDA+g715LVMNOJ7eqF/o1G
ZkTaWAzxOY3qbAQ3vAICco74W2eDOwa8U580rI4Dwe5QakRpwyUX0JK1UFUvBRTapXspdG+Zsa
+i6N2nlXRRm0s0i0ok3qC9xPaFTQ8oSyiKFxaCZSfKrnTitUK13XGiqHHr7kww+/GRAN/gIAAA
==''',
    # Volume 3 Issue 2
    "Fertigprodukt": '''H4sIAMQCKWAC/21QQWrDMBD8itGphZhqpRBKfUshTU4+Flp6EJaSiNpSkKUSJzhv70oKJSa9SM
zs7OzOnokTRtqu1OYQfHmyRvXkpTgTmt7ERuLzTDrbqia0ChHZOGuKh83msaiPWqpqpeoKgC0Y
rRg8U0pmBWlsMB7Fi3FW/N99036hrL5Qnk0gm1TAkyOwZ4oUv/P9GtGabPVRybv9IQ5aKje0rQ
5dtVRoPc8GMRpZD9LZnTLVGkdjDSCuDqiInjb4e7tpiDfR/gijT0oWMQ9mKJ6KD5MSAFRAOcWt
KX6IKOAXB6QaY1mSP5YlPDdwVGJ0zjLiCTGe2iEjmhFlse/2IkDHa7zpqu/CK5eC1n9J00kZTE
+KBtEB1U5og8QcUSeOpVOi8dbFWyyQ2ou+7L1wKETGu6CupJB4k0bJKWtC0ypxI/XDIS12cFaG
xmtr4hZGdIldKef1LtW+fSyI4Pc2tpPXvdO91yLppd5uNWb0A5bY+At50c/hywIAAA==''',
    "Novel Semiconductor": '''H4sIAMQCKWAC/4VRTW8CIRD9K4Szm/JhPJT7Gi+9eGx6wN1RSRbYIBit8b93gNVqYtMLL/OGgf
feXGjQrve2MW5Msfn2Dg70nVwoK2dhM/F5odYP0KUBsKKr4J1qQXEuFpIpgcAYnRHa+eQi3phf
Z+R5ZAnBameSVcs8JwXPc1L8N9dCCL7Z3adbIG9kWb8Wr5/4uuIrdGtO0L/0RddmMJ13pA16Z8
FFtTaKMT7nXPEKooJEYAi8gOD1SgU2gahkBbRVbkqsUNxEYsWYYpXkBWiW6FN8VsfL+Wj/wx9h
IGuwWXCfuugDqi0R4JFXUJWyV4KlwL3c1Uz/3wRLscgVxlj8FpiUCoE+eMm2+K1QyMekOStBR9
yQNi4TWFl9agLoLDR7miO114dG90ftOuiRiiHBxB7SCGGDxiD8NuJ5LNbH4LNh413+1Gn7VyC5
rVPc+/wI3QwJ9G2qN9utwSzjGVvi+gPTTNir7wIAAA==''',
    "Passivation": '''H4sIAMQCKWAC/5WS3W4CIRCFX8VwXZMZsIkpVz6B3je92LoYSXdhs0BTNfrsHX7ailFjL+CEEx
i+OXBg2gzBT/fWKMdeJgeGaU5uNF4PrLedWodO0Yot40a5PIGQCHNAiZhmPgdgTxO2tsF42oj8
+HakNdyv9qVbvVftZNGFXpvQy0V3AjwBX0pAFBjrJ6Eh6B5eTJ4EsvAsgqctkLBAkAcSs/Asgq
TGfCbGh5Fo/FCVmwtHYSxwNU4Bv8NTiHmcz9lm/2MTF4nxOjh+JbiCiOeJ8Qq0ECY2KS4JBb1x
fGQbfP2H8qufo68a5/Rn42/Az27AVxle7SGHh38RZsxHPwBC6uDdmlaN09/oydo2buqUcXYkw4
9Bked3Q+pmVE4143obK5mmrzrU1kS7CX6bjrKPYVS6jV6rNxtNifhdCu8bM4xCPnwDAAA=''',
    # Volume 3 Issue 3
    "Life: Prep Work": '''H4sIAMQCKWAC/2WOsU7EMAyGX6XKTKUkA8NlvKUDSGwMiCHXujSiF1euM/Sq8uzYkZCAWyz5+/
V/9m5SXgq3N8ywmlOzG1tnpQrednPFGfoyg2ym2wbCD8ihC845a81DY3osmSV0/ng/DgFY+K/T
1fnb8ww8bTNkCN2X9WeRPToXvCqD8//FVq32TnKOdMEcavuuoRVJB6D2h3pBU1zbsaxAsjMVEM
TbUnUEK0TqJxXleK3sKY1wal4IluYV6VOjWHhCrZvEQJETZq98SOOY5DXe9NTxDbhYuWNaAQAA''',
    "Life: Cytosine": '''H4sIAMQCKWAC/32Qz0rEMBCHX6XkbGEm0XbZHHvpQfQBxENtpzawmyz5c6ilfXYn1QVXxMuQ+Y
Z8+U0WYewlxfLDWQriWCwC97rTDF4WcXYn6tOJuBPtPHj3Tla3GhEBxF0hepds5CHK9XXlHv41
NJ1/c1Y3Wsrqj/tZ4FK8zfRlvLHM0QVjSTcb3LcbPDxtoJ41qgpBI5sl56skaok1cFU1c36RiZ
IHAK0Up9egeAkNMleEGlED5LOE37vBnoyTD+TLKz0wmrpQBrLBeQbRJ/pmYwr0A8X5sgf3FKjz
/ZTltjvv7NGMdCyuK+VJl+K0C4WJ5LtonJWZD2YcDf9BnHmm1k9tRTTzvgEAAA==''',
    "Life: Thymine": '''H4sIAMQCKWAC/32QMW/CQAyF/wq6uZFsHwmIG1kY2rJ0qzqk4DQnhTuUXIYUwW+vHYIKUtXhLP
nZeu/znYwPxz5l3zFwZ1azk8GxjqoK7ydziA3v+oalMy+c6qHhwG5zAVo7xALRESKAQ5JqnmZm
F/uQZBvp/HGWHv61XA8pdl4c1xeYi2v+egG7VWdCh7AQfwAJcASaQrgASSSdkl2IjrbQSgWQA0
VxYLVaq/uWln9QKVbs0+PpV857trd6OExouaAVgkZbeXf5qMlISiFcOFeF5spC+fKWP7FgrvVK
9/BzcplcidI8kMLIWZdd1pTtF2dXYpmktmeZfMaw5za77S+n5Y5DF9vfNdWqvuM7KQ3H8cCWOy
7bXa2xoTyM2rOveDWbTtdB2ad69DM+cVsmHwOpvvdV5eWr0iAze/4B+QABOEwCAAA=''',
    # Volume 3 Issue 4
    "Cyanamide": '''H4sIAMQCKWAC/22PwWrDMAyGX6X4tMECUsIaWI45LOzQFyg9eLayGhI7ODY0K9mzTwobY7Q+CP
uz/l+/ripqb8NYOD/lVHwGT7N62V0VbHWjAo6ndX3aqd5dyN70IlfVLTaGD/JN9wVlUyICNMgH
FOvETbWL9lvHQ3t4lCbAupKmPQIL9nyvsAZQMinkdC/QGAYyeaBfPz06S017YLvuxhIQkI1rqS
XnkSQmZJ9YjbAtlChG7TyDZ36N+lJE0iaFKEMrRmc9F3qeaXwfFkYpZvqh1s33PyKZxQwU/2ha
pi3xFIPNJrngJQqH/7+HQJ3TOYhUvb3K27q+d7xxkiG4fgMc4epxsAEAAA==''',
    "Acetic Acid": '''H4sIAMQCKWAC/22PwWrEIBCGXyV4bkBNKUs9LTk09JIHKHtw1XSF6ASjkGxIn70z6aVsiyDMJ/
8/nxtLOloItY9TyfUdopvZa7UxftwHJfCxsQCjM2V0OLFutQk+XVSdEkJwzp4qZqDEjI9C7pd9
RzD4xdk/xYLy/bJSusf06SdN+1ir0xWiahG/IKYSKPk/sd8yZ+OyN9XZeKva7os3bd93ipOYEh
wP1Qm8JZoqyU9cKomEqwa3C9XIxx/wwz+7lLSPCJ5xCnqpk9MmQyIRieim51rPswvXcUWUU3EU
W6dDa0pgi8keInVHHR5lCeuSb5Do4f2NZuuHwePHMhXK/RtnysQHnwEAAA==''',
    "Combustion Engine": '''H4sIAMQCKWAC/4WQwWrDMBBEf8XoHIMkmxCqW9OUXkKOPZQeFEuJBbFkZKnYDcm3d7U2TdwWim
GRdr1vZnQmXlrlmtzYNob801ndkYfsTChW7KbG25k07qSreNJwI1sdamm1WL9caSkYWzImKGOM
CkbhExyOcOZQySIjlYs2wF55WWRz0GbiXCkH1HJCMY4VUSN2BFKOZ47w4l/4eqhObh/DpFCCwm
pS4GPlN7VRZ1RAtuBYC1QrUJ+jI/Q1V36/gDg5mF6rP1+S7PrhqK3YQU5wsOIp0Qr8pzUXw3yD
YZ0lkX7vbPZkXG8UhJk4S+DQO9qdJ0YTmv4ivcqgvYCX4Dtcgjjs+1F/ABIB/vbSWGhwuDWyz7
2WVXA+WS2hVcsul+pD2koraAUf9dTtYquTbaX9bRCGFn203qlYBeNsErWyGXO6Zh+71M029mis
TkMZQ+0SgjzKrh6ybfWsQ+zSSJnDwUC0MCSDly/IYml3zgIAAA==''',
    # Volume 3 Issue 5
    "Smelting Iron": '''H4sIAMQCKWAC/22RUUvDMBSF/0rJk8IGuekYw4AvFWEg+LBH8SG2mQbbpKQpTMf22z03q6DWl9
Cc9H7nnnuPIhrfhG7pfD+m5WfwdhA3xVHIfGaVhaej6EJr67G1uIltDP5qu91eF+HgGqvv7Vmq
x7MstSS1JqWl2kipSaq1Iq1kvhBOsShEHUafQFmfFsW/2MUfcgnySsuSKeqCpMxXjNTlhIcxwZ
j9f9qUM5uda11t9M6Bq1BIKxQSKCinDYFVQgIYL9BU1sr8zr7ErbCSv0v8y62w9Nv2+QRnsXcH
28zGS9zHg+vskKDpylR5ekR5XjkWt/IdFKnkBc97EVV4Rw3/jYmySRjTnP87dGXiS/DFnbvMtZ
qyr5Wa/LLTzwQkT5PhfEvYS574fxVqVrFrzSsywjHPHLuUyIOgiJVXN9+A4pMboz8G7JBsjMZ5
CCvcOnNYRmvqFOIwSW9mWA5jbzlyYyPUFEfLlR997qiPoRnr5IJnvDfdpc/Otsn514Ij8oMZ01
vgclGbd3vbO8tq4/Z7h2zpAy/q9AVKjlmcRAMAAA==''',
    "Neodymium Magnet": '''H4sIAMQCKWAC/5VQTU+EMBT8K6RniX3F9SA3DibGuH/AeKjwELLQkn4ckPDffW0XXTfExEuHN8
O0M29hvZq8yz+1QssesoVBPCMbiNeFjXrA2g9IE6u00aqsSoAD5+wmY7X2ypECYn1baeZ/2p+C
+xFLzsU9QAkJRIKCgEPJIWkJRIICoiZEnHgCSFCI5Cto4iUkEAkKgp2gIan2bq/5XtyQ5eoW/l
P20nFE3cxj78fsRX4odOTObrNjQ0f1qzUFBUr9Xffcc1tFqrttJBUEcQh/hG/+39I8Vn7XqkGT
b+wdUZ20uUVltSHCGY9nrvUWryiHA07auEvezVPsbdCiNHUXHlVy3N1F0KR3XXyKPUvVNPIUyK
Zv25426GYSivULKWXCuZQCAAA=''',
    "Carbide Swap": '''H4sIAMQCKWAC/42QwWrDMBBEf8Xo3MCuFOxSHXPsMYUcSg+KrTSijmRkiZIa/3tX6zaFNJRevM
wbr5jZSTg/5LT6CN6O4qGaBPKXaQHPkziF3ra5t6TEU/avY7Je7zRiswYQd5VoQ/aJXJTzy0wa
/nxi63rXBl9tTNy7zuqt22iAGlEj4LoMLAIkI1UjaMm2whpQS+ZK1QAakBcU7RVnUSh5gKJBq8
tQsvzyK2xJG3K6dYEbkSkqhcPr1vDT+dapLkV3l57/LojQcBdslmaLUg1XIo9bM1RyUexdxSv5
9sF3Nq6+6T2hoxlXyfZ2CDHZSDDFbImn88AFoh2tie2xvObNidlXl2r7bobCTU7HUHbFo/FdZ9
4K7Nzh4OgM6UyGmj8BYB81u2QCAAA=''',
    # Volume 3 Issue 6
    "Fuel Production": '''H4sIAMQCKWAC/2WQQWvDMAyF/0rwuQHZocQspzHYsd197OAl6mpI7ODao13JfvsklUGzgXngT3
7Sk68quTDEqfZhLrn+igFP6qG6KhAVyuD1qqY4Yl9GpJva+ZziB4Zu9w2m07ptoDO6BVCbSvWx
hEyvtsumWtv25wub9jeTNWyya1O7vC3kU7HkdSAtet/tKeGpx5B9mTiHptOBbjV1bShK1xhRik
XcMNekutMgKm8MiN44v7zPooGTwL/Bj5iPmHgNLZuAJbcBC9yD9qEUTMBYmSm8sZLLyjSuNsZK
Oq7SL2j4M5lHZ0zJ+UDA0G1y5zqh63NM/CVbQkd3qt3w6UKPA6GcCrLtMkvOOcWh9NnHwL2Dm4
Q+Fxyrl1XJlXyMiYvvY0H3iwd/OHhaOl+o1Cw/n+jFriwCAAA=''',
    "Siliconheart Piece": '''H4sIAMQCKWAC/3WPwUrEMBCGX6XkbCGTChVz9C4LexQPMZ2lgTYp6QRcS312Z7IURRTCB/knM/
NlU9nFIc1tiEuh9iNFXNVjsyldWVMJXjY1pwl9mZBv6inj6jFSKLN9/tTAx4LuAazRvdZWQw9M
IwToudrdaKRqOiHcaGqXUN01yqcSiTeA2V/3nYNU6C+xnzLnMAWf4oguU3MK6NGeA1s9WF2Vvs
WYVcOYY/UhKcL8EuD+l4euFoQ5uxA5MHyb3Xub0XlKWZw6jka3trH4iR04oVxQuq5LFVxyGoqn
kKKMjm7+R1uqrtCYZIZ6mwq6o2kIl0vgD9NVFu5fakT7W7cBAAA=''',
    "Raygun Mechanism": '''H4sIAMQCKWAC/21Qy07DMBD8lchnInkdUCxy4sCRh+gRcXCdLbGU2JFjSy1V+u3suhSB4DKKZz
c7j6OIxvdhqp2fc6o/gsdF3FZHIQsWlonXo5jCiDaPSC+xcaOzwQ9oYqqeHVrsNu7xJHUHANcA
nZQtIxRULcgOCirVSkJoJXRKMgJviqtK2JB9ouOg1rd1JWLn9tj/a0zcYRowdk8nCSepSFTTVZ
Aa+KqWrKyLsmZNYGyA+UbxpmrKfqOLL+YVbYJg1ZDTf038TP9iDtV9zHMKsePQZENt3DlJScVq
bVFri05J3vD3dyPMn6s62ys2ftUgSwkJYzTOE6HoNZl9HdFYUmZzN0QNZqnNsuC0HQ9EpZjxi+
3d8neQDnPJMMfQZ5tc8CzqzXRJ9p599YB2MN4tE89MTkOIPN2OGc3ll97tdo4aSXy8WT8BFIlA
XEkCAAA=''',
    # Volume 3 Issue 7
    # 3-7-1 stored with the same-named 1-8-2
    "Fuming Nitric Acid": '''H4sIAMQCKWAC/22PwWrEIBRFfyW4bkCdQkJdFcqQVeYDSheizowQNRiFpCH99r5nZlEm3Ui815
x33kqi9Dq42voxp/o7eDORt2oltJwlxeBzJS4MRuXBwI30NsVwM170P5QLxpoTFZw1lJKXiqiQ
fYJXjG9f2wbB1c5GHyYwBHWL3kHdDmIMQWwHoQO5zAv2l71vOfYt9AgOOR2ZR1Orqndlteh6oJ
wELRSQhlmMtpQVIpycPS1At4fF/9tXHzbMVhvRP+waoDAOdvuMJxbCkolRWg8Bh5uTcx2NVClE
9H+F6C6nekoywkNIUswG/1rGMniMQWeVbPCI9tKV9Jyd9bfqz6bYypzuIRZd4wI0ecJY2+sVvo
e0oMP2C0op4xoAAgAA''',
    "Rocket Fuel": '''H4sIAMQCKWAC/21STWsCMRD9K0vOLmRiqdK9FhEKCqW30kNIxhrcTSQmZVexv70zWUur7eWRPP
K+ICcRtbehq53f51Qfg8eDeKhOQhYsLBOvJ9GFFk1ukW5i5VIM7+ib1adUDcBsKhsFMynFpBIm
ZJ/o1f15Ul3L1v3AovUomisWzW9Fb2fSiY3r0f7bSiwHO4YvRx8A9gHyYWHI6VoDBX/XeHT+0r
96QTr0zmJZQsXueA2osoZQzjlCUckGylmpm8IgOVX+CeGW+uj86Lz8dobiTCiBEAoqBezPeOPM
1glj1M4ToejW6b6OqE0KkedNidrqQ63th/YGLVEpZrywEc1gWow/bBr2pd0+BptNcsFzotddYZ
+D2WGqFhlbpnVO28Bi8USfxOodk9ZtNo5GpoEbnb8AA7zpTkECAAA=''',
    # Volume 3 Issue 8
    "Hydroxides": '''H4sIAMQCKWAC/4WQy2rDMBBFf8VoHYOkQkmrHzAE4kIXXZQuBktuBLFk9Ch2jfvtHcmhTeI+vD
DoztXxGU/EgZG2K7XpYyjfrVGe3BcTofmd0xQ8T6SzR9XEo8ITebRSx07sQTB8KCWbgjQ2moDD
23lTXLYfbADv04Vd6t9d919mvEJaPSi58mAJUA/jqzKi/qAcAVtOBWfbhZI8yRME5USF43oRyn
MmOE9uCW5jWHN/sSyqUTo7aKnErq6y8RXxzJ7R+WTx0x86Q+1hYbH/WHzF+nu9S0AiYNuBNhhQ
PHUwlE5BE6xLq99gdABf+gAOi5gEF9UpBPkGplHyOw1jnx16Z2VsgrYmfdBAl9Ov9XxKIYaDdY
uxcyo3pW5bjYuEEXM+fwI1yC2QcAIAAA==''',
    "Nobility": '''H4sIAMQCKWAC/42QQU/DMAyF/0qV8yolW0GInnbapImdJyEOpvVYpCSuUgdRqv53nMKBUSS4WP
Lz++yXjCpCaMmXNnSJy3cK2Kv7YlR6rrOahcdReXLYJIfSqT06m3y9x9qYtdZqVaiGUmCZVdOq
uDYfkUJ9zFaj//Ie4tCx2A9R7Jvbn/anSQhFia/Dmrn+e4/ReYteQNv4Isg2I+buN2S9QE4YBD
nlx91UCyQzjDGCDSJspPPwVkaEhinm6JVIF+jLniGKURSOCb/EkBqH8E3koZuPdpHa1LClkO8F
8J/fTM/WWR6yBokvlEm1S/AKD+RRMsmgteezlfBik0DTB6EkK5j/AQAA''',
    "Sortite": '''H4sIAMQCKWAC/42S307CMBTGX4X0miX9wwZziY+AJkQJES/K6GRxrEvXmiDx3T3nVOIQI970S0
+b3/n6nR5Z3XbBJ++2NT27GR2ZoJWqWHg6sr1tTBkaAzu2DG997U2yDpyX1TpILnSxeHhcFlyI
TPBCiFyCSCEViBLTCedsPGKlDa0HQvYxHl1DyiwiFSA5IoklgQXCqcEQqf6BVPyElIojhFgiep
a/IJ8ByvifWcxtdzg1MbhutsX87n6FdILPiC1SCkLl50GkF64veVXkQYrkeRYtp4RV+bUUhjwK
QZeRJwf+ojGcXnrOm0AEmIEN/vyDxFCGjRbWeYgb4RjyqhB8ygU2wFWKFEXBLEEmuURJYQwgGX
wPkOnPcASn3jvdJ412LyaJLuDEu2DgZGPbrXHJ6f7s63Jv2t6672tY86YxHTg0g7o/dOTcmd5o
V+6wd6v3w9dgSQe/Ixwr9au57WqqbuuqquHt/kCxfwKiN2IxQwMAAA==''',
    # Volume 3 Issue 9
    "Radiation Treatment": '''H4sIAMQCKWAC/1WPwWrDMBBEf8XoXINWKgnUx1DIpT20hZ5Ve40FtmTkFcQNzrd3Vy4NRTCgET
NvdFW9v2BX+zBnqr9jwEU9VVcFrOqZhnXEgM3pps35ph8b0HwagINhNaB1Y4pj4CAqjnqolJb0
C9LgJFySGgD0PQ9/eZDMxqGY6f8GXXSKI7Z5RKk8rQuhm/x90vH1nYukzhQFODJAmwKzAtjBts
B2vLHM38nQWPu7uY05EENAb7KGMCXnAxuab5O71AldSzHJNsvW4JY65HZEl9ihlFFS61yGzil2
uSUfg1QHNxX3zXXeiVl9cBlNyEB+dpmGKCXqE9OX68TrfN97/jat7JvtB4OziJOnAQAA''',
    "Boron Compounds": '''H4sIAMQCKWAC/22SMU/DMBCF/0rkCSQinR2gFZ5Il0pIZIANMZjYVS0SO3IcKaVKfjt3pqiFdr
mcn5Xvvbtkz4Jy2re5dd0Q8y/vTM8esj2DVJNKwtuetb4x9dAYPLHSBzXKZzWDKGe4rWZYSIA7
ziUIqgIrSJEUDkvsgS8Be0G9SD0USwBZAPWFSJVzTlJBD3aTsdoPLqIfF9P7NKGwsaPRF7Oy9U
4HX28bH2ydPdZWy/WqkZyQaMgXSCSCH+Lfl3mq/4bzLntFTqJpI8tVM0OBMJqKA8IwPjKP6NOw
QD5wCfubrLyq1tdHIu7mZ0+IPewGKDYIWocQ/JKBODN48doObVaNFDl9myrNzxMjoQj+D0WsaE
JQ1pGAp1aNeTCqjj7Qiu5R2qo+V31v2o9mh1IMgzmo2vbnF3HXpURd8Hqoo/WOTJ1qT/a78m2H
KXRPV2qIWx/o8gl/R60+SdR2s7E4XCRyMX0Da11oP6sCAAA=''',
    "Photovoltaic Cells": '''H4sIAMQCKWAC/31RTW8CIRT8KxtOmtTkwarR7tGLnmyit6ZpKGAk3YUNC0Zr1t/eB7tp/Wh6Yc
I8mBmGM3HcSFuNtKmDH31ZoxrynJ0JpDWxkXg9k8qWSoRS4Y4sbF0rl21VWQanpSoW4QJsqwpK
JwzygjI2BygoIOTkKSPCBuPxJmXtW9sisdNHJR9caRRfC8+bUO6CKzYXmBUAdEopiiFAwRCAFo
x2wBDQiKUZ9JBm0RZSWC4rHapseZLOHlNaOVgvh5gY845n6UZcGZ2hJNp1wgAkJrXBP4a8q6N3
2GDqTn+DkkmZ0j78eJZSJ8jzPnU6wvIEOeuOxDfQm86g7Z/yt+vVL0j8gh/jCYvGvUdnfG/VHY
E+FH4dPBqzR+Pu9wer1fC61PBbKpv/U+qtQ7TwyjmuTSRwV/HjyCkuvHWx8ClSe96MuDxwI5RE
yrugerYJGOXDGqnc7cApcRLlNetPdYpfOyuD8NqaGMXwKrEve+vtwZaea5EtsNImTnnwexs1CC
+1UO+fkZR6t9NYhj/hIG+/Ad1CkZhEAwAA''',
    # Volume 3 Issue 10
    "Elementary": '''H4sIAMQCKWAC/22PsU7DMBCGXyXyTKSzI0GFJwhImejAwGxsV7EU+yLHlhKq8uyc3Q6UkiFKTv
//3XdHdnCrNa0Lc07tFwa7sMfmyDi92bCZiHqcMDrdPGln5NBPktMDUnD+AMDuGgYl+o7GZd88
O63iJwaVrHxTQ7//hk5yODdgB5x691zIjtdvsQOQneAEOhEJc7q1ODKPk9V5sr/29FXKlCUXoy
sljTkkinM4XQSvKX2VbF4crgVSNEUxE1DNgIg78Q9J3JA+6NIoB+rvCXA+ilcAGf0BFAKlo3KB
BkB/Xq1ttEonjOXgjkajWtolqUhBmqSYbWltc902RzRZJ4ehoIPydfo6WW8DdbYyVTmNWLpspF
YMNhqvat64w8GReNqKz+kHvpUguvsBAAA=''',
    "Mixed Acids": '''H4sIAMQCKWAC/4WSX0vDMBTFv0rJs4Ukm66YJ/FlILLCHsWHkKQ22CYlTWR1zM/uvRlo90fsQ0
tOe3/nnKR7EqTTvi+tG1IsP70zI7kv9oTme1ZReNmT3ndGpc7AiqwnHbxqOx+sKh6U1WL92AkG
FxWcsRWl5KYgyicX4fPl4aa4Mv9mXLFNXWO1EesvyrcIoEwwzu6Qw9l/mLr149BaZ0QNgIWgOQ
DDQWTdMoZpzimvBwCRxu6MvlqbbHYTZBMbyASYimOnCig45lM8nWD5Pk+FndLvxmAzQC0hXQWB
6DEdrTIcmsKDA11wiuWPTrO8jKItvXCpTTg/gL9dVvzH5TqfX/Lz3vp5j0V9dMhB0WfmgHsNDu
ykx+UZghvaRROCtA4EDqte7spgpIo+4J4uQGrlWEr9IZ0yGqQYksGxacjZhuB1UtF6h2wn+6w+
44nmsCPKMkWIjy+e4BfX8h1FbZvGQsU4offhG2Nv+r7/AgAA''',
    "Squaric Acid": '''H4sIAMQCKWAC/2VPTUvEMBD9KyUnBQszySLFnGQvBQ978Cgesm1qi91kTZNDLd3f7mRWwaUEHj
NvyPtYxODOKZbf3tlJPBWLAEZmM/G2iJMfbZNGS5vYz83ojykaZ/X+Arv6ApVGfETUKDNKniXP
CPS0ZAREBA0yIyoE0JJRIaMkFA+FaHxykYxQru/rSoRP8TYfMv7PVM9t8B/WaQojKUy2yD63gp
DVYPP59SuZMDTFczO03OhAIneH+v6q9VtMcjHgYlypoiuoa5mKy1R5Zl6prXc2P3rX2lD+sTui
ejOVXZpsoD2GZImK85mDBTtZE5o+Czlz2oTNvEmx9/mveDGubc1nJtuh6waqF2c6qPUHQ0wsQ+
IBAAA=''',
    # Volume 3 Issue 11
    "Misproportioned": '''H4sIAMQCKWAC/22PzUrEMBDHX6XkvIUkuFDsA7gXqbhH8RCSWTfQZso0kdZSn91JKsjKXgLzm/
w/ZhVkgsOh9mFMsf7CAJN4rFYhy1toBm+rGLAHm3rgSXTz8gGh7b6lbpVqtGy1aqQUh0pYTCHy
H7UdqlvRaXGEWXbaZUplmfonU9v7xlKBKd5rdM+wegHC2Tsoznsp3bC73DM0Z+SaUt0kyZITgc
j4wODI02DmmsDYiJRTHxhdzVQb92mCBccoUoJfGpLtwdAfjMtYio2ELtnoMeTAYIZCn/3EixEp
L9iLVybFK2YD8XrunjJx/nLxfGBcmOrtB8zEf5ygAQAA''',
    "Narkotikum": '''H4sIAMQCKWAC/3WQ0WqDMBSGX0VyXSGxpcJyNcqgN9sLjF2EJM5QzZFjMtoV++w7SWVFpAgBP4
/f/59cGSpvoC+dH2Iof8Hbkb0UV8bzmWkCn1fWQ2d17Cy9sXcbWuWtPBxvfCe5EIJLwemRQuwF
nZXgXFaEOdsUTEP0gf7bT5tiKXqbPTdekWr/XJVJlUmVyXYt/5rIzxp3tma1j0hpx4tB+LZeUl
ZF/pT1XzJtzA5tB+hSo24eqe8zNQ0lO8SwFi93yik6i3Txqp2Rx0P3SKuXtQWf5vClJTeBBrCn
W05ttuly6vXt1PyJNnmDRVTOE+D01qtziVbpAJjK7wi1aizHoJAGiQSMdobK/CivrXnQcBlysw
HBRB0c+BToVZ/ph8ITBHeKfaIqhhbwvge6MTiVh41rGkcbhgt9qqY/PRCHSX4CAAA=''',
    "Vereinheitlichung": '''H4sIAMQCKWAC/8WSwW7DIAyGX6Xi3EhAqqhabutlT7DLtAMFd0FKTETMtLbqnn3gpqpymrTDeo
hlfoO/H5OziAZdGCqPY6LqFBAm8bQ6C8mR1SK8ncUQerCph7wSu6Ptwz6RcR6w3X3LzUv+Wqka
rVoplVStUk2J11xzXispW6l5T8nFeiVsSEi55eayXi0Zz4AnQCjdm9y9mfvOjHuXG0M1ShaSup
E06zr70K1mB/p3Kt8sWDIEFM3M32b+9u98LQtfz/y2Zi81z6e+KmXn0tf7JVsTIdHyWRTH/x6T
ksWMfCBbP4pd4AQxGo9Z0Hk1mK8qgrEUYnmTJkudmSrjPg1acFmimGBWpzRC3Ad0EO8FOo58hT
EGlyz5gAWKZmD1FSJ47MBT722X8KMUTaIuRP5Bu+gn8obPOH84+DwROuZSffkBOwir/s4DAAA=''',
    # Volume 3 Issue 12
    "Haber-Bosch": '''H4sIAMQCKWAC/22QQUsDMRCF/8qSswtJWtpqQNB66MX26EE8TDdTN9hNljSRrWX7253ZKrRWAo
G8zPvezBxEBG9DUzrf5lR+BY87cVcchBzuQWXh9SCasMUqb5FeYulSDO/ozfIotVFqOpJGq6mU
4qYQVcg+UdVtf1Nc2lbdnk2rk2mm2TS7NI36t558YuM6tFddKaY8Y6rBo5kvjnJspFJKGiXpEH
Oi6NZKMlmdyDyJeIGE0ZBBr6iKHZysjOZawYEhp/82cN7+Q9ME78AsiTP6EzxVZ5G/wyjJZH0F
mkNcB188udA5S4P8LGSi9WkhNMLsisQoGiKC8yRoejXQlRGhSiFyy2OSatiVYD/BV2hJSjEj2/
btkNvGYHOVXPDM9tAM6gLWGMvHsKtqliGnOkT+qOAD71uHrFq32TjqP+05vP8GzgC5dDgCAAA=''',
    "Mustard Oil": '''H4sIAMQCKWAC/22QT0sDMRDFv8qSswuZrLTUnGQvlWIVKnhON1k2kE1K/kDXUj+7mU0Va70k5D
eZmffeifT6qGSt7SHF+sNZFchDdSKQT/JozGSqdjDOa6l4u/6kTbvGi7WGAywY5QwWFDhjCwBO
AYByoICknA3QTBjyhsGSUnJXEYrDX10UIeg0Vm+Ddt0krIiKb3btFv+vsA03wLwh76FLysg5d7
sUb7WeyOiM6pJR17N/xG9mxbAClPwtpHPJxtwA9HyRdT2nBPAUXPwlsfgvMWzb3T85FL8lgZJG
k6ssJ7BEJ3MmJauGYuGPFNQSlfdCWwT5NYpj7ZXoovNo+T6jQYQ6e1Tj3kwZRZ/UhUodbgtxOs
yODt7J1EXtLC61YpzpcwpReFm9aINYpDg4j4V35fdCIpO673XOJeJQdv4Cvm47UTgCAAA=''',
    "Nano Electric Motor": '''H4sIAMQCKWAC/32QQU/DMAyF/0qVM5WcdCuIShxAk7iMy7ghDqHzSESXVFlyKFP323FcNqiQUK
XX5NnK++yjsK5Psfz0Dg/itjgKycpuNl6OYu87bFOHdBOraLTD5uEE6vEEdQNSSmgk0NdIWUtS
JQEaxY5iR7FTUSOIq0K0PrlIb0k1vo50h38Dn43F+B1Z5cjNJYffPifUcMaYkEAxWHWJnpD+AG
QCn+J8BxPSb4z7FIeuWGM09Nukrjd2y0xLYpK0jTmWrFgXrHXW2aKuMw/UzLlgrX6Y1UQ7rZH5
1YK1ziqXNOp8DOAhjD6UnQ7vWE7jUCWGhFR5826LoTz335AVh57HCnhAHVqT33N6z96Tdr5Y0e
gx2LZY++hDLusUDZ2oodUfeNdbzO7W7naWlhQHqlTjFx7FO/RPAgAA''',
    # Volume 4 Issue 1
    "Count": '''H4sIAMQCKWAC/32QzUrEMBRGX2XISsFCbjrMgFkWoQuZFxAXsb21wTYZ8rPIlM6ze5MqjCgScu
CekI8vWZg25xiqizXo2eNuYVBYbBYvC5vthF2ckCbWpt7ZdzSylQDAOXvYsc5GE+gQxPq60sz/
TWiUe7NGNnT/8Mf9HGBj+NlpS7xNeQpjmtBgr9WsDcrmykV75fu7E1Hc05YgDgBSbIQjEeDIQX
JBxSXU1F6Kwlpkciie05KisP71Ql76Uf8eXfVt96RG5SuPxltHIriIX26IHm9USOdS36FH5box
hxs1bx9T4kioGMaSw56V+UhZ9XoYNL09JNL1+gmJIeVltgEAAA==''',
    "Sharing Is Caring": '''H4sIAMQCKWAC/3WQzU7DMBCEXyXyuZFip5QKn1CEFCSgBw4cEAdjbxuLxI4cGzVU5dlZuzk0UG
TJP5+1szN7IE4YZbtcmz74/MsaGMhNdiBF2hON4PVAOtuCDC3gizyCb4QBXtXfxZJTuqKU0wIX
p4wWBWc07gXFgywyIm0wHutWx0U2F3oRHhxHFbZBmTWdCcxL345YTbZ6D+qiW1KPytkdmKwahd
EKeF09RW/l5ARFr1E0qtjgL8U9d3YXE9qWV+gN/V1t6kllynnKfDKbCEuEJVLSNZKS/QpBi9ic
/el1K8Fbo73T7WmmJTr/t1tKVKYsc+0ojuN0QhsES3x1Yp87ENJbN0yoEUMu1KcwEhQi7wJMdA
g9uHdrFLj5hwM5yvac+rFPxntnVZBeWxOtGNEl+twIp80uux+yKt3ipwi+sVGCPAjzMUak9Har
cQZ+RFwefwCmpIKejAIAAA==''',
    "Reassembly": '''H4sIAMQCKWAC/22RwWrDMBBEfyXo3MDuCkyo6SGY0hwKLb2WHhRZIaayZGQZ6gbn26uVk5I0vS
zWyN55Mz6IoFzt22XjuiEuv70zvbhfHATkmVUW3g+i9dbowZp0EmsdRtvoxVo3dVltqpcj0KYk
WAGVhAVCiXkCIaSJBWEpcQVYAmCaMuvIz+JuIbQfXEx7kaaPaUrCrvky9Q0TsvVj3I/WOLN4sq
P2tqzY+ggFI2TX5IHIBNmDskKzK86uzEG0Yj7gNzMNc8CczcTscF5N54VYSDjFy6sEo/oh3lJe
t1UFH71Ttjb7sU5r005ZbR5Sb5uXf5BzLewDZ3CiHELyraQC5jKplPIE/lsgTKcY1wSvwXfNLU
LKxghzR3jVVDafcS6gZsz570nu8Y85u0cTgmpcEiidWvW1DEbp6APXI5O0V/2yHzoTtt7VJiQ1
hsGcLoLRo7aXahy7nKELvh50TDHY1Kk2q29G9b1pt3ZkVQ1x7/lb8azcZ5bqZrdrUg9xZPvpB3
+0DtDxAgAA''',
    # Volume 4 Issue 2
    "Cyanogen": '''H4sIAMQCKWAC/2WOwUrEMBCGX2XJScFCJoVdMCfpZUHwBcRDbKa22J0saXKIpT67kxHBpYcMmQ
/+759VTXTNqfkKhIt6PKxKyxRaweuqLmHGPs/Im3rqMZUZCW33rc2Zn9UAoC3AsdXWwJH/LQOt
Hg6qD5kSx8Bsb9vGIOR02wYy/zeci4/hA8mKHERudkJdbXoX7oojCd91L/e/x51aOU4s9cQWTj
tXlb0H8hibP2oYjW5phrxg5D3FjIxSuUpRxAVd7McqIne5Ka/M5TSGmlPPjrx3nxX6aRgmPjWV
WrD9AFe/3XJ8AQAA''',
    "Chloromethylsilane": '''H4sIAMQCKWAC/4WPTUvEMBCG/8qSs4WZVNZijkUQPOzBo3iIbUqCabLk41BL+9udRIRVUSkMzN
PhfZ+szLhzTs2bdyqy28PKsM5KC3ha2eytGrJVtLFTORSnHVqB2CEIjh2g4LwDYFcHNvjsEh0i
35432uHPtLukJcX1O/D7HY4CECkSgT6KPyJNjkAllfBKeCUtHf4sLI0+p68P+lC4rO219cHPKu
nFRmOrAvW3j4Ym7+2/Hnh9KXLzzQSqx4t3owrNJ+WEtIzNlKMKtKeQFaG0nKtSUFHJMOgS5OT8
i2b5K3PSviSwB+nGUb4WOJppMvS8tJSq7R0d1wUS1gEAAA==''',
    "Glyceraldehyde": '''H4sIAMQCKWAC/22PwUoDMRCGX6XkpNDCzEQWMceCLnjwAcRD3EzZxd2kpMlhXbbP3kmKItLLz+
SbhO/PogZ/zGn3HTyf1NNmUVCz0gLeFzWFkbs8spzUc4iTHR33s2Ozb89AbwYIEQziI5BBamQm
QgC13aguZJ/kHdL6sa4CQk63dH8VL+PccfyVtHdXzb3EvhUbVlsxiLNBNLrOBAhoqBKAckdjI0
RD7SUpW6qp/7eD2u0zeMdx90MfBKX5WDtFPrGNXV9eeTvd6Fk2Nqc+xLJ7td45+1WgGw6HQf6W
Zlno9QIpPlaccQEAAA==''',
    # Volume 4 Issue 3
    "Ethandiamin": '''H4sIAMQCKWAC/12QwWrDMAyGX6X4PIPklAXmYxj0sl76BCZxiFljB0eGdiV99krOLhuGD/u39O
u3H2oMNz/oEJdC+idFv6qPw0MhU10o9N8rpXG05ycYi9g2YA22AOrtoEBqvjxNLtru9ISjBUQE
i8CLi9+RaRCkhak27kmF/g6CyjldfV+uXhw/xXAIbg7RntnW6I4h/roef51NJWDLbDgS7/e5la
ay2blnqNzzgFCe0KcSiYcibJKOfM4uRBH4NLubzt71lLJkPbI0uVWv5DIXskK5eOm6LzX4ktNQ
egopinV08//niOwKTUmaVTflsFJwVR7COAb+Abrzldleuns5upcBAAA=''',
    "Radikal": '''H4sIAMQCKWAC/31Qy2rDMBD8FaNzDJJTklKdii++tIVeeig9LJaMRWzJSKuS1KTf3pXyaBNCdV
jY2Z3RzM7Mg1VuLI2dIpZfzurAHoqZ8VwzmoD3mY1u0G0cNHXsDULQPqDruvIVlNnAIF8aKehx
WYl7ztmiYK2LFmn9br8oLvlPGntjz9S6IdKK84PA/9TH0Vh3Zj4337wi8vpElhUXXFxKfOxJhX
Vmq9XNnH/jyCx4CiIoSOK6iLfOcx0JrBuA/B1s1anQVapKZHdrIVJMqst0IblMTqXI0+xa8uv4
gmfrqL0HY1MY6kbYll5Di84nMyuCeghlQPC0SAj6qI8gqE+wrVa/KO6m7HfyTsUWjbPpQwtjRo
93TRBE7F2SY3XvTUADeVOZrjMUGnc0qvY/RfuaxkECAAA=''',
    "Kreisalkanol": '''H4sIAMQCKWAC/21QsWoDMQz9leCphR7IvlBCPWYJZMjYoXRQ73ycqc8OtgxJQ/LtlXxjuzzLT9
J7km4qYxzT0vl4rtT9pOiKetvcFDRsrBAfn/f7y0ZN/uLGP7WaUR3THFwslKbJ7q3WrwCKO0RH
vWMpLtvDA8yJU1qDNXoH2hqjuUyUU6X/BlhScEMNTlT21yGkr0oYyVHGFOz+AVsW3T6dDs/8iK
tm0RWNoF4RxAxAjGG1B81Mz0OA7ddYRrGm33G27yXWDcHsWAEkln2GVCPxNBraQcjljD4y0fNv
wUuXHQ6UsixhmJqxdIUwcyEzlKuTruu5bXTOaawD+RRFOuLS2GN2vmD4xpiC8FhpTrldYM6+kM
dWPvpp8nwbuorV/RdKwakkygEAAA==''',
    # Volume 4 Issue 4
    "Inorganic Pigments": '''H4sIAMQCKWAC/3WSQUsDMRCF/0rISaELSXaRxYCXngrCFg+CiIe4mbbB3WRJE91a2t/uJFpobX
sJ5IX3vTdDttQrq11fGDvEUHw7C2t6T7aU5TOrSXjd0t510MYO8EanK+96E3tyM5vdkmY0GuTU
N5JzUQkmBa8ZoxNCWxdtQMPdbkJOCY+g9LF7/p7ctbjsftshgC7MCPpiU9qMmyVY2eyZyJgDJd
lcDKcOns/jNs/GG22UxSGQgJQS/TgKl1yIigspBNJkmZiSl//6cZZi2Bk1bwnIC3Sd+8IJcUN7
ViGyFhwLsvq3LOeHsKOUc7444z+BJmmPiMbGJ2xcAWJLhpvgKQkvf0lXI1JGAO+VsUnAW6/Gwo
Nqg/NpcRVKK7UulP5UtgWNUvARkm0z5EKDdzq2wTib2Fb1WZ1Z55fKmpbMzbIHix8KX1UMK+fT
e6s+4GEwkFRtFguD84UNvojdD9hTgWSfAgAA''',
    "Miller-Urey": '''H4sIAMQCKWAC/42SXUvDMBSG/8rItYWT7MNhQZCJ7sbtSrwQL2Jz5oJtUrJUVsf87Z6Tzsk+QF
sIzUnO8+Z9m40I2hlfZdbVTcw+vcOVuOptBKQxVbnwvBGVL7FoSqSZeNIRQz79AjXPJT2QKzkG
mSslAcRFTxS+cZF2DrYXvcPWm6ryzup8Rt39HFKzBHoJdJlAfyIeMC61w3xCiMERYiRp5FOcA7
1siSUWdo3mxLBk8kSHV+96t9avrSGBOTlkqKJRjaGzmaCcj5i2Jvg3dCmJfRAsyzq+iacSh07u
fKh0aXDZms4O5Qkq+SEhFh0x8jhVCdvdEQ5x92VbWA6GQAQbzn7OT6EoOaJvoIxlDiksSDF1wa
nOHYz38fXhrKg6Ef33XSAAE2h30NZRAWhW6XUWUBfRBw5pSKWlXmXafGhXoKFSDA3uqqumRv5B
BsPvQmzrdI46eNMU0XrHok5X3V2xZYkhewzYclk3cem5WRT6Ha9ri1w1drGw5Ce2tKK239t5So
8VAwAA''',
    "Getting Pumped": '''H4sIAMQCKWAC/32QT0/DMAzFv8qUM5XspH8GkZDQQHBh2x1xKJu3VrRJ1aaHMW2fHTsFMYSEWl
nJ83N+eTmq2nVjSD68o0HdzI4KY42qCC9H1fqGNmNDvFPPFKpDQ47qtnZkF09nMEursQC0iLlG
qzUCWJwq8KeuZmrjRxd4HvXp9cR7+BfywAznG7s4g2aAXllARLAG5xPG8DoCNOYIfwBC8GP4nW
tCXmLuV+s7YVwzA/lfrs6QWgBBIQhKjtcC5CpwxkoiTpdLV+fIaxNTG76IBR2vOV0tjS+QRk8W
a56DtpCKh0fFkxWsQxanjCgmkwr5XPyFEKFg5VdEiAGrckiast9TMkXlTuhH4s6bd1vqk2///M
s8kBt8/2MTLVBDne8DXejh0MXn6Wmgst9UwnZlG7VHCqF2+9l6bDvaSqccQxVPVZvynW67mkTd
1rtdze8cDtwxp0/YYmWMZgIAAA==''',
    # Volume 4 Issue 5
    "Lewisite": '''H4sIAMQCKWAC/32PT2vDMAzFv0rweQXJgRTmU+lhY+y429ghc1RicO3iP4wspJ99UkrZSmEHy9
IDvd/TrFw41bL5joGyemxmhWtdVRHeZ3WMnmz1xJPaWSqTp0Bmfwb9zM8AIoJB7FowGjvuWxZA
PTTKxhoKr6FePhae4X/vlCk427wlZ0cfkxvI7PLen6Fl+5ZdhbUVmMYtCE2+O5CQYi23Z13Qf3
Gv9OWyK7+XXFmAnWYUsDl/mm+R67hHQKl6jaIvGbC9ywBrgs8YBkqbq6pZKtNpJSfK1Cc7ylbo
jzdpROtrGWMS9eVJ5sEdDo5jl0mMlh/QuDjitAEAAA==''',
    "Novichok": '''H4sIAMQCKWAC/1WQzU7DMBCEX6XKmUi7tugPOaEiQBxKXyEkrmKReCPHRi1V++zMRj3Qyyo7tr
+Zybk4+KNrSx/GnMpfCW4qnhbngjGLF990vURZPDcuSfAp+t5V2yuZbY/xuquIecVUMS+ZK6YN
cWUgESSzJFuxxXfxsChIeftOprGT6BsQfVu9A7L/vOIeEeMp8VphtCYDJD9iMfOB4TUwF3Akp/
ugNM9Betfk3qnLTn6QW77/BVWjnRrtAVS6UToSz4bGgA5z7XALYhiK5c1cZMWIY5e4SXauayzf
ajWSQ4Ip00XTJRdj7QMEwjbUxzK6ukkSNauF1NVTOeXRxS8JrYtQU8xOX57GOfwYpc1N8hIUH+
rhrpJqdU74hap+vOne+sPBo3s6QTOXPyzAGHDRAQAA''',
    "Ribulose": '''H4sIAMQCKWAC/22QQUvEMBCF/8qSs4WZpC3FHIVVvCx4FQ/ZNmsLbbOkyaGW7m93ZkRQkUB4+f
KSl5dNDfM1p+IjzH5R94dNgcxCGbxuagqjb/PoaaWOIU5u7Hy/dt4+PN1AnyxoRLCIDWiLuiat
NQKou4NqQ54TnUO9v+07gZDTf3E/I16Gcx7DQtffoKIEvAGcSFJCjWgRaFhAztTY0GxIAidrpO
SGtWEnGPEY8RjxlMx1KaRkAqW8vRJ/JbpmrivxVH97gLTo3VKMLr774qsP7aSYPe2cw9z5WHz7
G0JpvUqv6BfvYtvzfbObfnVl5nLqQ2T6/MjrbrhcBvqUtBIz+yee3UDPqgEAAA==''',
    # Volume 4 Issue 6
    "Knockout Drops": '''H4sIAMQCKWAC/22SUUvDMBSF/0rJs4UkZW6YJ6lCwYc9+iA+xDSjYWlS0gQ2R/3t3nvnwDlbCO
T09jvnpD2xpEMfx9qFqeT6MwY7s4fqxDitpKLwdmJj9NYUb2HHXnW2SXVfXG6VgIsrKTZcKCkF
5+yuYiaWkGFSyOV9WUDYuYPtb1wEwp7zoEP0qgUcIFfbTnFiCg438O8FrEhWkhRJCnmphnybiy
/GZu3gY3LBqtYDEgOuKaFYwxCGiSXf5rhu2B37FA2BTPVoXK+61v9C/anJlx/zawol0b5CGhzZ
pWKDwZotheOQ6lKSn/HQdY1lSWs41TzXlxt05xvU/8mAIeDDJO0CCA3sRn2ok9Umx4RNVyANeq
7nrBMMgpJTsfjWcaLAU4p9MdnFgOigR1JfQjR7OLTqKcVpxie65CEm+hVs+tA9ar3b7Rw0z0fQ
5fINbzhPulsCAAA=''',
    "Strong Acids": '''H4sIAMQCKWAC/2WPT0sDMRDFv0rJ2YWZrJWue9KC7EU8VPCcZrNtYDcp0wRaS/vZnUlVlBLIn0
fem987qcEfXF/5sMup+ozB7dXj7KSQd/Xq0tYE1y67C9y3gIjQIvBqER+Qd40ArWYZ1N1MgXhW
eRwyeTt7sr5v2ahXb1f3gh1QHAgL0JzBIXzohYSUWI18V2fOijndAp3UFEdn8+hkUnfsKa4pTr
/DnolD6zn+YbIxh8S/Ec7fhP9D3skP40/A8uUCteDWHfM2pW0jbXUj1KWzvlLrUqFmXpZKg1rf
jpSZyREZH0Tg12QOFTljUyTpNWdpa/ZVyHZ0hlhJlJ24jrvCt6PYZ5t8DBIdzFTUVaIYNgV6L7
rJaRvFrT4crU0vWu+HwXPNdGRdn78A/fGiTukBAAA=''',
    # 4-6-3 stored with the same-named 2-1-3
    # Volume 4 Issue 7
    "1,2,3-Triphenol": '''H4sIAMQCKWAC/31RsWrDMBD9laDZhrtTIko1eumWpdChdFBtpTY4kpGlITX2t/ckU2hL6HLo3j
u993RaxOCmFOtP7+wsHg+LwFILmoHXRVz9aNs0Wu5EY8K7d7rRiApAVAfR+uQiU0jr28o9/Hv/
xUQb9NMGdGYJRNCED4CaCO/IZT2f4u+Au8FPUayokvVzGKbeOj/qZgPFFuq8gdQgFaFGqZBdpG
IvYFvM7tm3VKAyQyrnIQWk4VhSlYr7+cQJNZYKp79poWTtzVyPJnzYek/NTAzJMsNL62yov+eP
DMXbVNIHO1sT2j7rOXO996JMmRR7H8ofhMF0PmPdcLkMvIV4Y1yuX0mbgNDNAQAA''',
    "1,3-Dimetoxibencene": '''H4sIAMQCKWAC/31QTU/DMAz9K1NOIK1S7HYB0RsDiRs/AHHoOo9WapMpTSW2afx2bG/TNgQc+u
q8WHkfO9P69ZiybfA0mIfJzoCiskK87UwfOqrHjvhkHslvyVM5/7Luhb/SWrBQWnDIiIo5WFuC
8gAOeEYHPCuPyiM4iyWik1l4M52YOow+sQjg/n3PZ/uvk+fUbLqjFWQrxVmSTQBeizHibzKiE8
Z0XcFB+FIMpnn21PaUwme7IF9fVFBkN3P+5a+37IPDawWFesglPOYatRAPUGgReC+V4akgxpkw
4GRG5e1M/R8QBC0AnGq1TmZuVYq++5nLaqqmGrKuih+UHfLxTYoj8c0i+CXF7LRfHJdX40DxvJ
U2a40eaaAq1o1I+Kr/qw65rsbUBHnCzGNbLYNwy3a1arnGtGE+338DvO3LM3ACAAA=''',
    "Think in Spirals": '''H4sIAMQCKWAC/22QvU7FMAxGX6XKTCXbRQx45BHKhhhCm6oRvUmVn+FS9d1xkjIgWHLkY/mTnU
NZt+fUf3lnonruDgX1rbaIt0Pd/GamvBmp1Ji3JQceGRGfANRDpyafXZIe0vl+niJ8Tv9F/o3p
xt0GvV1phEwCJCYSICNVCRdaD0AqYoQ20DAIgHjABmoYyoZMAgLGBqj4tTbUpT+8m03of+yjqF
XHPhoXfRCRQjbi0n2vBwQTjQ7TWpKcvlX3ulr32Vl3nRVLT+e01nn1EqyefXGzXRYrP5Hu4ofz
G6M2BTKDAQAA''',
    # Volume 4 Issue 8
    "Yellowcake": '''H4sIAMQCKWAC/4WQwU7DMAyGX6XKeZXSIKGNnpA47MQuTBNCHEzisUATV2kCK1N5dpwyAWND5B
DJv+3Pv70TAbwhV1rfpli+kcdOXBQ7Icd/VLNwtxOOGtSpQY7ECiKGev4u1aKu+MlaVVNZ1UpV
UopJITQlH7nybJgUh603YH1EU3wilos5A2bqb8L5f4S9iQPGTP22cT8wR1CKp9b8SV/yQWxyxZ
WlrTXIDnkAgxmpeMxU8RQ1PcRXMsPVEWvem0CP6MdLfR2qOmrO3bxL4MWyWY4cbMuAoCOFbi9t
oCvBvIDXaFiKIeFe7VKL4YG8wfCdiH07emgDmaSjJZ+HenCjeotNQ68anjGrkOKGcq+4jOSsvr
b+CVYIHTY5bex6bXmn2HOJGj4ApkvmTTQCAAA=''',
    "Thiourea": '''H4sIAMQCKWAC/3WPwUoEMQxAf2XpScGBpMKu2NPixdN6UPEgHkKny1RmmqHTguswfrtpXWEVPT
Q0L01eOqtIoeWh8WHMqXnn4CZ1vZoV1FhpAc+zGrh3NvdOMvUYHZmz3e0H6HM5N3cGcINoNG4A
DeIawQCg3EEjgNFfsRKEK9DqYqUs55BkGurlZVkEcE5/LXEqfug856O8mu+/bSf+/824/qWGKk
4uRvJBwKVkA701orCJ43REHU1NyLZ3FIWkmF3pOox1pzFym23yHMroQMOPTQujnDounWqbePB2
58MrPTmaXF/Krd/vvfwwHeSJXj4BPZM9E5QBAAA=''',
    "Downgrade": '''H4sIAMQCKWAC/22OsWrDMBCGXyVobkAnBw/RVNpCp9KtQ8mg2JdawdYZWaK4xnn2nC4ttNDlR/
pOuu9flA9jTtsvCjip/WZRWlJoAe+LGqjHJvfIN/UaacSA9uGiq+eLri1ADWAN1AZsBbXm1FDS
gNbWSIKkBgA+l6m626iGcki8Esx6WFcGlNN/TX7bn1I39996w/rdbV0pwfqbxggxUkX0f2RaVE
cKLcbtD90xSvMoiogTuth05Vdwg7BH+gwf0bVYoMupo1jwfaLBNy8+nN0bugn7Mm796eS5b5r5
SbVeAQ8LmOZgAQAA''',
    # Volume 4 Issue 9
    "Wood Alcohol": '''H4sIAMQCKWAC/32QwWrDMAyGXyX4vIDljlLm0xiUXkaOO4wdvESdA44VHAeWhfTZJ6Ub60aZDQ
L9tj790qza2I+5/KCIg7orZgVrXFURnmfVUcB6DMiZenIZkz2ctKks8NHWwE6DNQa0VjeFqmmM
mX+CWV4WzvW/uD2lzoUG/dSgfThjtREsMNZYMFtpcRUudBrzNfeXLar36Q2jrU6Cg92X4984/e
P0svQRs3eRwupsUx24fgtgQfO1ep0exJrdgEQj9D9cAb9SbDCV3+otS94NZcaAPSXeJ4s5jch6
nvq1c8IBXaq90KLrzqsnaor7UJOnILobsyepVbXHbuhdjSI37fHY8gR54iezfAIrqfm34QEAAA
==''',
    "Allyl Alcohol": '''H4sIAMQCKWAC/32PwWrDMAyGXyX4vILkdKHMp9JLL6UPMHbwXJUEHDsk9iEL2bNP8rpD2BjGwv
6F/u/Xorow5LT7iIEm9VItCkstqgivi+qjJ5c98U8dHaXZUyBz+gR95msQGwAD2NRoQCO/Efio
p0q5mEPiMdTr28p/+Nf7Qqm1IXpzYt/6ehZnZE9EfHgaLP4aD1L/pAgm5rTd6Zu72cP72VdH72
IrQOYx81mY0KB+kFFL1YUJICmEKfyi6JKrPohes7LJAiXJeww3Gnc/6p6lNA8lwUgT2dG1MhVs
/zuVNGxObRyl5Vrqp8E6EvnW3e8dr5Jmbun1CzXC4KbFAQAA''',
    "Propargyl Alcohol": '''H4sIAMQCKWAC/32QT2+EIBDFv4rh3E0GSI0pp00v3rb3pgeL7GqCYBAO1rifvTO6zf6pLSQk8w
bm9x4Ta12f4u7LOzOwl2xifDkXlYT3iXXeGp2swYqVYx38yThVnkEojguUwAPYU8a0Ty7iLS7m
jxlr+HfUW/D9aLO91b7xVr2eQeJQeSgVhxwkDs+BKy5yzhXAAhIIUkA8xWVBitxCE9unuJXr0U
AVTn95wK3gGpD8oBMhLq4k0QvSJbbvPMA1/C1vb+1v1vOal4vL/Lu8QNyVfpt9Sb3+wAOXwJ/e
1SbsftQCpTj2i4NgBlMF3dArV3Xbv0DNKsXGB2rrxnRDX2lDct0ejy3GiSO25PwNMQGFAT0CAA
A=''',
    # Volume 4 Issue 10
    "Condensation": '''H4sIAMQCKWAC/22QwWrDMAyGX6X4vIDstGmZTyMwemp322Hs4MXqamjs4DijWUmffbLTtSsZAS
H9sX590ol5ZbWrM2ObLmTfzmLLHmcnBikmNQpvJ1a7A1bdAaliT5WnylhZniFfn2G+lcALwSUH
+iQIDiAh5SLlAlYgJOcFp5wXwNnDjFWus4HsuBjeh4GEnTminqDwNLGunTVKbmhaTkZLMgLOKY
4jBaUQTWHkw6AOGve9RlnGlnK9vXsfUSj+gUtYIy6LMK4LU477M7yqgF6SvdiSIU+7ra4mfzeE
4YJ2b/DSe6ONxXjHgnwWm8vVxmuCSDGPkDdsykWCz0f4cf0iriCW/80Vk7nrXnv3iTaxX9Gn0L
GbVvTKWBLmVNXqmHlUVXA+XmVB0l61mdJfylaoSQq+w4vadg36D2c1+tuP0DeJofFOd1Uwzsah
VtVJLeNr26pfXXVh72I3ezZeRUWb3c7QIqEnVQw/TB6PxMICAAA=''',
    "Silane": '''H4sIAMQCKWAC/22PPWvDMBBA/4rRXIPOCaRUY6Fk6OZsoYMqX/CBIgV9DKlxfntPcgNx2+WEHu
i90yTIXXJqv7zDKF6aScg6Ky3gOImzt2iyRb6JQyAzWh98JKsdqn1Pr+83uVESAKTisQVQIGEn
QXXAB8OuHOKpEcZnl1gD3fwxzwx8Tus61PlY7MmS8a45YAq6tmlAtWS3v4K8xA7uwZ/8qitLVP
7XKJ/pab92LsrFuAj/+Irw07sBQ3unz4xGHduILvrAIIWMzNL1UmsBI+pgxmJy+vywQSE6p7G+
Em8UdCEDnU7Eq6Yr0838DbNjD3OzAQAA''',
    "Phosphine": '''H4sIAMQCKWAC/32QwWqEMBCGX0VyaqELM7EL0pz2snhbbz2UHqxmMaCJxARqxX32zsSWdstSD8
F8Md//j4swdoxh9+GsnsRTtghMa6IMXhYxuF43sde0E8910F6VF5AnhfSAklgAKikRQDxkonHR
BvoS5fq60h7+1R36OBgbh6zq3DR2ptXq0FdszpMa9zesrHUx3Kp9013OrXfvm/vuVN5fIN/6Kp
QFxSAUiDwHvefIXEI65RZ4FQ8/I/2O+mpvtapKttPNPSmRNCzeov7+IEiDvDnbar/7po+Ewjwm
q9eTrn3T8S1bD9dJDOsYOucZH42vmbTmfDbUKsxE8/UTJdtwHd4BAAA=''',
    # Volume 4 Issue 11
    "Nuclear Medicine": '''H4sIAMQCKWAC/22PwWrEIBCGXyV4bsDJhm2op562PXTbQ2+lB9EJEaIGd4TdDemzd3QvLSzCoN
84v5+rSDrY6FsXlkztNQY8iadmFbLWSgv4WoWPM5o8I5/Es/cxuOzV8eVH9grgEUCB5KUkAEgF
HUipOt5K8dAIE3MgHoRu+942BqM7o737qDhoG2dX0w+Wo/c9Z5SZmOme41+vD0yEZgpImlB9mv
ebXb+regPrdTDIoleqhAH+68kqR5iSdoHBjk9en9uE2lBM5dme0aRPbchmRp2YUMpYpi5LdVhS
tNmQi6FEB+0rPd6uN29onXEBS09nmmJJEK/JWf5wgdaNo+P/0IUb3fYLoeDYR6EBAAA=''',
    "Oxygen Supply": '''H4sIAMQCKWAC/22OQQqDMBBFryJZV0jUhTQn6MpC3ZUubBxrQBOJE6gVe/ZOUgqldPMh7zP/ZW
XaTB7ThzUws32yMh4z0gDOKxvtAMoPQC92BIegegPYIMhaVU9eSCFKwWUmilwImfGSU2Yl5zIX
lGyXMGW9QboX2XbZNgLW4z/tt6p+e7QfyUOOIv/Z4nHpak0LLv3QghAuU1xwMEPjVB+uTDNGVt
2XG5jk5KdpWELReOytC9XB6ZZsAba66zR9BBcq8u0F4GWErCYBAAA=''',
    "Red Cross": '''H4sIAMQCKWAC/6WPMQuDMBCF/4pkrnB3FoRm7OTatXSwGmmgJhKTwYr+9l4ihQrduuS4713evZ
uFNkPw+csaNYpTNgtMb6IRXGfR26dqwlNxJyqnWx16WTmJWJYA4pCJxgbjWUVabgv38KdF9LDB
73Ntpj+MsrOz48h2K+AKlEwRJVFZEsmC4gpZxE0kiQuhBEwaFUlDLsSFJ5Ek0NbBNgLx3y4hpH
x3a1rl8g89MvLTkHI5NaraNY/4y9R9YhfVbjkjrIN/WPd1QoSt7jrNp/mJhWJ5A1o3PRWZAQAA''',
    # Volume 4 Issue 12
    "Fluoromethanes": '''H4sIAMQCKWAC/32RT2uEMBDFv4rkXCETirDNccvipZfSW9lDqiMGNFny52DFfvZOtKJbSy8D8y
bzm/fIyLS5xZB/WoOePWUjg7nOahLeR9bbDqvYIXXs0kXrtEF5kQAnztlDxiobTaAhiOk6Uc//
JbxgaIcOCVF+cXEmTMFBAodUBdwjC+Id1+l+9qpqXalOnsuZwBfC/e51SnZsDH8l3EOfdZNy2Z
7ganO2eIICfpxJDifgUhyC8y32HvvmfnEXs7DG3eHowBGaqB/W1OjyVX0kqVU+92i8dSQEF5G0
MNzmkw49Kle1iWRUv/3Z6sGniYqhnbdZSXuOnpFY66bRZD0MNBDTN98vW9saAgAA''',
    "Exercise": '''H4sIAMQCKWAC/22PwUrEMBCGX6Xk7MJMAmWxRxH3IPgA4iGmszTQbZY0AWvpPrszUwQXvPyZfC
T5v6wmTtdaDt9potk8NqsBTaUC3ldzSSOFOhLvzMu4BMp+7GlYeuqebuBON2jfeO2cbQE7C8gJ
9og821YSj0xQZ3AI0FlN3BPlvOMztnNCzENjQqpT4T6028e2MUi1/Kf5V+3VhxJD40Ps770QtV
mK2EI71XE31U52F8fdy+rsUH7jQLysvHDnBWr1maae8uGXWkZluapNppl8DoPcmvxF2fMX5RBn
EuZrGVIWevK5plKS0D6ez5E/VBZ5bvsBGb/VuJ4BAAA=''',
    "Nanoboxes": '''H4sIAMQCKWAC/7WQPUsEMRCG/0pI7eFMAiKm0mssPBvBRizGvay7sJcs+QDPZf+7k1yEE661mY
e888H7ZpGjm3PafHtno7wTi4Raq1qEt0Ue/GS7PFl+yWdy/sN/iXvzGMW1eDEACLdaG6wEoxp1
IWijsVE16kKe06c5bIRfljnUBtqeUniDaJABKK+E7Hx2ia2gWt/XlQWf06UEl1w/nFzvPrls6d
+9s2k+yRG4/vUO1flAcdPnaANLKWTbpDhPY0rnajrONUew0VLohnLL0eE8G2dnkXIafFmUT/RK
He18oD2Vzn7s+5H/Ix25q9YffDva7fgBAAA=''',
    # Volume 5 Issue 1
    "PAX Challenge 1": '''H4sIAMQCKWAC/32PQUvEMBCF/0rJScHCTFoXMaell72IHkXxELvTbaGbLGlyWEv3tzuTVRRZJD
Awb968fDOrwR1SLD+8o0ndF7OCXLMqwuus9n6kNo3EnXqg2FtHptmcoDaAiGAQ+BnEFXLVCGA0
y6BuCtX65CLvoV7eFu7x3/DGhnfvTCNZF/YlwKd4Cfd3yrqlyGNzJYzV9Ql082h0dcdcWK00M9
Zn0lxR2HWmBsE2UEvVtSh4+/cOyBS9ncrRhh2VZx6exJCIJ8y/pVB+++svc5cmCj+ueDxk1EAT
2dD28oWz+6w9rZ+LprfjSG5HBcrIpth7WVcv9mzeDl038MHxyGq1fAJ6fY82xgEAAA==''',
    "PAX Challenge 2": '''H4sIAMQCKWAC/32PQWsDIRCF/4p47oLOJiHUU9geektvLSk9WHeSFYwGVyHpsvntHQ29NKUeBn
xv+N6biVt/yqn5Ch5H/sgmLuqsahHeJ34MDk12SD/+qhNG9XwVsFWSnlAg10IqACkEf2DchOwT
bUqYP2b6y39xnY6fwbMnG862R9VtCUzEFQjVEldQxhruuQUccvqr+D3dGrYxtq+lS0CroF1RZd
kSmorX+os66R6ay9+niBo46LFxOh6wuUWTk2JGciikx9j87C9ISpdTrRBxRB3NUHheH6v2snlj
3aCdQ39ABsXSOQ0hFnOnb8u93e8tHZIupML8DUKNkeyoAQAA''',
    "PAX Challenge 3": '''H4sIAMQCKWAC/32PQUvEMBCF/0rJ2UImVQzmtPSyt3pcFA8xnW0D2WRJE9ha6m930kVQWbxMmP
dmvjdZmPXnnOqP4HFiT9XC+FY3tQivCzsFhyY7pI51l3lArzoFIDlndxUzIftEFoj1baUe/t3f
z30MZnQhWlPtjO3VvnUEA+BKADzeYBZoyOnWlT/J7R9o98kbJR6AE/heclCiITw9QnKhoJHidx
TfgkY91U7HAetrJDkpZiTnPfgeY/09L0lK83mLjjihjmYsPK9Pm/a8O1TtqJ1DP2DVFEvnNIZY
zBd9He7t8WjpA2kmVaxfsLa7pI0BAAA=''',
    # Volume 5 Issue 2
    "Fill in the Blank": '''H4sIALbnL2AC/22RUUvDMBDHv0rJs4XkMoXZB1FQfNAnfVMfQpvRYJuMNIF1o/vs3mWpdGwEmt
yvyf3/d3dgXtnG9aWx2xjKvbN6YPfFgfH0TZTA14H1rtN17DRG7F2HVln9UH1HLter1yNfVUIA
l0JUguOquBCCVwIE5xXgkbObgtUu2oDvBUw/04RgY3a6uarNHmsdxk7PImp95IA6kHSE5FkBKM
JdzhqCHn+Un96ovfl/LY9cnrziAdPICiTZRYu4AyWQZJVDso1JAbAUwDsoCbk0wBhXFqMCXAzX
+rbs1YWX9YWXVBLqzTrkKRWXPZKuoNKzn6S/dHzWXD7lNpz7eF6MjPpB3byb55Rmlsom+dPUEo
PMIDF5MUme5hi098pYBLcY9WpXeq3q4PyQUauGcgjK40UkwUedodf1WHdLGsZt8rv1rol1MM6S
oFV9oi+m6wpji9Dq4qlT9pd+qhhaRynYG5KRUGM2G4OlhxGxnP4A2jFbgOgCAAA=''',
    "Break-up": '''H4sIALbnL2AC/22S0Y7TMBBFf6Xy80Ya25AW8oAAIfGAlg8AHoztqtY2duTaaEPVfjszE5ftbl
dRRvFN4nvmjo8im+jS2IU41dL9TdEfxPvVUQBXVkn4cRRj2ntb9x5X4lMtPvoPw88K2ugzqM94
fz3DZpBagZIwSNWDGqSklRyU7LGClvgGJFUJeA2KK8kwKMVVU6WfQNythE01FnTsT3erGwTjAl
OQ+X8SpOibryIK9CJ3rLBoiw87NBYNpCAJPRPLc+dfJzQX2/Do3asxiY/Wl3m/oBDHuzcIQc33
um3YjNAeMwBB+6VaXkv8usUvZcfbumDGED33ef8U9JpjXFOwjK6WNjhqavwS+BJpi/eK5iZkCQ
Qmbzjug7EhPk27R4D10uj382XKCqepWurtDKjL9DW3jVA8g8s5uJ4AI2pGbKcBlj0lbHhCG8KG
W2AiLj5nEyIKb3E1mscue2NLyhRsj9LOHDrj/phovUOp5OqbGqvde5Ofi4c6+fw7RedfvMjezv
j9lVrmiSOacnLVlpAi8UUzLmcUOR66OpFmatkl+lN8M/FhJsmF7TZgyGVGWZ/+Aa888QGMAwAA''',
    "Average Out": '''H4sIALbnL2AC/22Q3UrDMBTHX6XkeoWTdBS0F6JD8ELwAdSLY3O2FtukpMmwK92ze5I5dMObNO
eX/j+SWTg02vZ5a4bg84M1NIrbbBaQ1kQjeJ1FbzuqQ0c8iQ26D9vTDqvNW4ACbyolFUiASspS
gVhlorbBeP63XFbZpfjRN1NHhu7O4qcjrCvJcpnkvKpopRI5GfM3skvj94W9hQ3+v+p/Ex/IHE
6BRyhOmbzh2LKCZA4xhINBxXgo0k3OhSTvFZ9LnorrYoqLlXEqrupJSO08OYetYaB46vErd4S1
ty52XTNqcMxR79HUpBl5F+iHjmEgfmajyf0e+GlIVxqc1aH2rTUx1GCf6P2eHO4oewk+Ygy+sV
EsntF8ThHpdrtt+V38FCst31R6oq8AAgAA''',
    # Volume 5 Issue 3
    "Fake-out": '''H4sIALbnL2AC/41RQWrDMBD8itE5hl05ddrqkEOg5FBK720PwlYaE1sKigRRg/v27sqkEJJCD1
6PBjQzOzoJr23rhrKz+xjKL2fNQTwWJwF5ZpaJt5MYXG+a2Bs6iVUcCFmjVt8wX9OnEGsJSuZZ
YQ2ogDBNQMYSgfiMK8ZiVojGRRtIrR5nxW35JevL9wjVw5zAlRGgBJIjQ/rDP80+RvITm+5o2p
tbi3Vqvfs0VpGfJD9E9mMdvuhiuNXURfykLQss1RR99cJCgIsKSI6iZsG64qYWl/EQ2AOvJF9d
n0zYpt9WqkmaIt4rmVclRUSFE84VTF7ETYWcXwXPFU11/VEUJeEowXivO0vEHZ0GfSy90U1wnp
evidrqQ2lj0xvtiQk+Gr6V9jn23rs2NqFzlqWtHjL7pHempB6Z0zFsHd8Uz9ruElNtt9l0tHhI
RMvxB3ZDFUejAgAA''',
    # 5-3-2 stored with the same-named 2-1-2
    "Master of Disguise": '''H4sIALbnL2AC/32SQW/bMAyF/4qhcwOIUpo202EosN22tECP2w6aLS9CHcmQJaBekPz2kbKNOX
HQi2M+GnwfH3NkQbvKH1bWtSmu/npnOvapODKen1kl4ceRHXxjytQYrNhrauoUbFk8lbb6rH4m
LrU8c/FKb9v1ma8VB8ElgOJCcMG5AnxKLhQAbAB/BJVcUVNwUAJyze4KVvrkIrpsTnfFpe3L3n
ft3i+N5cvMeJw4AFwY3yNPNoaFsRID5yXArxMysNq+m+pmQmxndWndCLI9881EdD8BiZ0S8mHc
FAQoyQfDzIUgmRcGAMBkCAgQDCTV2JdDX05BwjCHFsEZeU/q56CBMyL2Kd465zzLr3HfN8aZ/+
xiYl9nNgpn7iWurkWMN0IDTgCw8NvZeH233ZSRRKOH2any6QQfb/OBjVjYPNPOg8F2/XzOd3+E
+ajHxSCaFE0I2joUJFYH/b4KRpfRB8pvg9JedyuXysbogEoMyYxil1oTfntXmatGMGWP38/U2L
cZsg2+SmW03hGJ04esftcdUhS+Lr7Y7k+ynaGuThH/8dT/pt1bT1Jl69riwrEn3NM/p4eTFMQD
AAA=''',
    # Volume 5 Issue 4
    "Thermoplastic": '''H4sIALbnL2AC/31Qy07DMBD8lconkIi0dkII5IBQLz2AyoEbcHDTLYlI7MoPiVCVb2fXbdUKAb
K09s4+ZsYb0Zl1DNmnNejFzWQjIMWEMvC8EYPtsYk9UibuGgxjjwZv6+lLhPy6mH2BqkFKCbWU
ZQ61kgpyynKCQFxMRGOjCTQs1fZ1S7n8l+EBQ6uN7espbc7ns8NuoMMMkqKizcRT/cnCNDaG35
ydcj3afrQf40CUe1NnR1fFnJydszt5WRE3lDsdrACA3wpYh5RclXmKir3TXSSd5S5TJfeBSjNJ
OxTpXaT5q+qHA0j6W+2zXrs3zHZOqBJcRKosrFmiyw791b7Zo/HWHdsYW0WPJ1AY18m4Q4/aNS
3TGj0k7KlFN9h1r33oGi7oGNq0T9xr8z4ytOxWq45+L4wEq+03znoy/z4CAAA=''',
    "Contaminated": '''H4sIALbnL2AC/6WQwUrEMBCGX6XkvIUkrQuag0gRPOwbqIchzdJgm5R0AnZLfXYnsYLorggSmD
AfyZc/s7AArvVDad0YsTx5ZyZ2UyyM55ppAo8LG3xvdOwNdexOG5x748yteoq8uq6bhzcuFRdC
cCXEvuJKCskr6ipCnO0Kpn10SJfrdVdcsKmGLGdM+7957rHbQjUfqUhVK8FpJZWkKkmiZCY5YN
rlD/HzSm7mI56byf+TC5704rLtc6rfnRT4t8mSN4nRhADWEbiiboDXMhjQ6MO0oQ6mckIIdJAI
hmg2GIyedf+V4jzmaGPwbdRovUsPOhgybbxDGKwDNG3iELHz6TY7gHuZE2rt8WjpgzgTlus7JH
PnaXACAAA=''',
    "Running Low": '''H4sIALbnL2AC/32PwUrEMBCGX6XkbCFJtaA5yLIIHvbkVT3EdtYG20lJJ2gt3Wd3EhQXKRIYyJ
fJ/80sIlhs/VA6HCOVnx5hEjfFImSumSbwuIjB99DEHvgm7qizCLfmKcrKXu/vT7I2UikljZJ8
jFK14qqVlEZnopVODUZnVnGrFBeFaHxE4kSl1+d1ZeAjbQ1yLt81QHMPCGZ/kprd+set6op97N
4yyBSv/kn7XeZvYBp9OzJlEoRgHTK45NtgP8oAtiEf0gJXjDo7lRibHmxgQiHCN5ziCOHFYwtn
DzSPebAx+DY25DwmJ9oh04eI6PC1OPj3hG2kzqfP4mDxbU6odcej4+1oZqzXL0mNYhziAQAA''',
    # Volume 5 Issue 5
    "Not a Planet": '''H4sIAMQCKWAC/22PPWvDMBCG/4rRXIPOdUNajV469MNbh9LhsM9ExJaMcoK4xv3tPYkOockiuE
d6n3u1qoCu91Np3Ry5/PaOTuqpWJXOZ6YJfK5q8iN1cSSZVDtG9s7GybTRADzWWqu7QnU+OpZ7
qLavbRMw2DP1N92qoZDyDUn+YS/59N5HvlXjcvUHMgXz/KOrd1PBXoPkAbSpKvhXQicjXAleiQ
/oyDTiqI3OYdCQRTuQM4lEfa1LPlke0DoBtUwTnstA2LEPqe9O0AFPpYvdSBiEcIj0BwN1i+AL
ysucG83B97Fj611a6HDK9M1zgUU7SldOHCMffEqrF3THJaHeDoOVf/Ei+H77Be/+2+nNAQAA''',
    "Back to Basics": '''H4sIAMQCKWAC/12OsWrEMAyGXyV4bsAy1xLq7W4t9PbSQXV8xFwiBVuGpiF99tqe2i4/6BP/J+
0qIo289IHWLP0Xk0/quduVbtloBW+7Wnj2Ls++TOo6cVonFG+vr9/6ZDUMoC3oQRsLAI8AFsyg
tTVQUj10ynEmKVUwx/txFMBZ/l6Elr+vXDB+MNlLUT79s+jmEB8jBirAlGnBzz56dMKxGk8FTZ
h6ym72GAuRmH1tbWvTr5HH7CQwVTXh0ugZ3b0T7s6Ygkt1g1kmrn31gnTfKhrD7RbKm7LVZ44f
e6WMFUYBAAA=''',
    "Not Helping": '''H4sIAMQCKWAC/5WPwUrEMBRFf6VkbeG9qEwxK+lmFqIfIC4eSWqDaVIyiUwtnW83CYIWZuMm8A
7cc3NXFsgpP7XGzSm2X97pE3toVgb1rbSA15VN3mqZrM4X68lKk6amH60PRmnRU28vwAVHDoCC
czwACEQ8ILCbhkmfXMxJ5NvbtmUwmLNWV1tZlVLMUvtygdtq4SAAO8xK6GpNB9WL/wqUYp/ita
W7dXWVbB6lUeK4l/7R1QIUwBH2G6EujDoEMi6Du3xNdG6DJhl9KLX3GY10akl9kpNaZRRD0j/U
JWk1hV8Yl7n+bA5eJRmNd6XQ0VTps4/NUdvZuPeCKcXRlzB7IvexFKTMMJg8Ly4Z8+0bKmya5v
YBAAA=''',
    # Volume 5 Issue 6
    "Two-fer": '''H4sIAMQCKWAC/22PwU7DMAyGX6XKmUhJmBCix12pdhi3iYNJ082isass0Vaq8uw4PSHExZa/2P
+nLCoB9Rw10lSy/mIKV/XSLMpsdaMVnBYVeQy+jEEmtYf0wdR0THzHPrT7Q2vtk3Gtdc/GqIdG
eS6UZdW69X1dBXDJ/xl+p3ZwlkcssTniiL4Gd+dv444o6XbnTGusddKctD8as0lySAmQBDzKFO
GuUwCfOVXlTtAFrpqKHwMkITmVUK/mafNPifviMzLVaIK40bcb6yGkiqDkC9dD9Qr0OVfU4zCg
fCDPgt36A5DfeolQAQAA''',
    "Oxygen Synthesis": '''H4sIAMQCKWAC/22QQUvEMBCF/0rJScHCTBQt9iQe1oNQwaN4COmsDbZJSRPYunR/uzPtZVm9PD
Jvku/N5Kii8W0YSufHnMqf4GlSj8VRwaqrK8bHUQ2hJ5t74ko1h/mLfN2cQNeIlYZaYwWgbgpl
Q/aJ76BePpeFjZDTf+hz3I7iYLyzxZN1bb2jq+bl+gR3jL7ViDUAAisfOUcjsIIoQiVdrHDLxx
r15RQgI+CfxDeKtutDNInq577ZwvAB9bbIBhK0XmNAX0CFmihG47wYXA3mUEYyNoUoa96z1Zmp
9Nn2ZCI7KWaSV/O4TjDG0GabXPCC9mY4+9jiffapo8lN0jM5dUEI6tX471ms1u33jndJM9t6+Q
XVGOPFxgEAAA==''',
    "Stupor": '''H4sIAMQCKWAC/22PwWrDMAyGX6X4vIDl0nbMxzLoYWsPO44dvEQlpokVHBmalezZJ5sOyrqLQJ
/s/5MuKrrQUF/5MCSuvijgqJ4WF6VLLTSD94vqqcM6dSidekVupw4D2t23NlsLsNZgQUOuBrRW
DwtVUwosr8HMH/MsgBL/J7kNfubWBersVmIlenXYWQ0A+jcb1nA1WFOIKcQUsoRHIcs7v85yuH
PtPUdK4+Jw9g3avRgPItssRQYbURqJ+xuUkxhjdD4IMNL17lxFdDVTzEetBLVurEKqO3RRCMeE
VzimAeMnhQZvBjwNZZ0hUpNq9hSyM7i+0DdOA8VMXOKW8j/14sJpyqjxx6OXc3jKy8w/dF70j8
0BAAA=''',
    # Volume 5 Issue 7
    "Oxygen Synthesis for Kids": '''H4sIAMQCKWAC/32QwWrEIBCGX0U8N+BIWUI99bbQhS3kWHoQNV1p4oSJQmxIn70qPeyh9ODIfI
x+v+6cdLA4dz4sKXZfGNzKn9jORauNVvC28xknZ9LkSsfP2RJ+uMBeHeHmrVPnbyGvZSmAHkCB
BCGUFCBASeiF4A+MG0whluMgj/fjKABT/Mt6bxrSNCbyhj0bb5tlKJpHJZpGNA2IvonhBGWT/T
9m0bzREWkfCpClm/XWkdMmItUUp4Jueu1CMpPTVEik5H4hOZMLvqMxLy3oQmiTiR5DFQY9N3rd
cv2mIYd4c6tf2YjEXrxd65BO8Yb1Kn7R4TNXZP04+vL2mGva4wdqceffnwEAAA==''',
    "+1": '''H4sIAMQCKWAC/23OwWrDMAwG4Fcpvm4BO+12WJ6g0AcojB6Eo1KzRAqqDEtD9uyVzQ6l9GLzf9
i/tDgB6nlsEk1ZmxsTXt3XZnG+nlULfC9u5AFjHtCS23OfCLv9n2+7ED62wXetXd67942LnEnt
VWjX07oacNZX5Y+FRySm7oilbfdU42uJoggkMthaGuG3EYSoLKXy0+gC14ZyHBDERCXjPwrG2f
hBdZ7q1Em4z1ETUxlIMFZ9CyVB1guXP+4A9DMX6tP5nGxjnY3b9Q4F0b50PAEAAA==''',
    "Nuclear Sorting": '''H4sIAMQCKWAC/52QwU7DMBBEf8XyuZGSAG1FjrlCKsERcVhst7VIdqONLTVE+XdshwsNEoKLpR
3vvPF4kgyoqcss9t5lH4RmkPdiknk6kxqFl0l21BrlWxMm2VjHVonDxWpTNYeqKHZlXpXFPs/l
RkhFHl3Yu5034ruxHgHpZFA8gbYK2qpugnl7E827X83Ab4TikZBScB2D9yl4e+19nYNdknc/1f
pHlSKPvGJl/0OhBVGuEetaKT5yymtCRDjDDBaDcBemDi4ZG1COePiSzjBk6FVrgIPi2JvoGvsU
1zNpr5wljGiEbvmGZV08EzuLp3gF3p0pAuQD4PsYJW2PRxve7cYgl/MnK/tbpD4CAAA=''',
    # Volume 5 Issue 8
    "Fun with Oxides": '''H4sIAMQCKWAC/22QwU7DMAyGX6XKeZWSAO1EjpM4QfsAiENIMxqtjavUES3V+uw4hcPYuFjyF/
+/f2dhQfsG+tz5IWL+Bd6O7DFbGN/qRhN4XVgPnTWxs9SxymFwJqsn11hV1UqIUnIlxZ5ztsuY
geiR5orzLvsrPOjwDj57AQ+b9lCTquCcHPbySvt2JjmDiP8luzStJ91pJLOVy3rl90rwPZdKUh
VkXAixLZFKSAqopLyKKXhaJG5805XwYb2q1iQW5V26sbwRJzXaELTzBCR1vZ7yYLVBCCn0A6FW
j/mIOtAgEQzR/sJgzWy6S4rzsO0fAjTRoAOfFnrdb/Qp+uzTYfvz+2N60hFbSAbsWfvTnFDjjk
dHh+CcIp2/AXKy0rHoAQAA''',
    "Overflow": '''H4sIAMQCKWAC/22P0WrDMAxFfyX4uQE7ZbQsvzCSDxh7ELaymiVScOUuaUi/fXY6GCt9Meigc3
21qADkeCg9jVHKKxOe1WuxKL29G83gfVED92hjj2lSjZfAn0h1c9NVbcxhr+vKHLRWu0JZjiRp
y6y74r/WTnOW2rt0rLJ0fJDM+rEmUXGUZ40eW3hbtJN3WDdt7vE0Um+BgiGApwT2aRpgKgOCFQ
45/iWhE5xLcBcgiy4hCRF/KUXbI4Q/KPO4NRgDu2jFM+UPCYb7mRcMXc/fmUGUE2dTvQF9zRk5
33U+3SBzwtX6A1F9bvaDAQAA''',
    "Conversion": '''H4sIAMQCKWAC/22QsWrEMAyGXyV4bsAOXK80Y9ZyN3QsHVTbR0xtKSh2uTTk3SunHcq1Ggz6zP
9JaFUM6Ci1AaeS209CP6vHZlV6f3dawcuqEkVvS/TSqQH4jbAfemPutVZ3jbJUMMuX6bbXbRNA
Jf9n/G05hczBNudrcL4/nUV27HTfmYcbpa4+8yf+TC6U1AxjJN4NMERJm6PWopK6tVRN9swQUE
AnXYJryx5sJq5LHgSNMLdYbPTAQjIXX1PLtI+cmFyxORBWNUL6vgbhh+f5h0LJI9WsegJ8Xypy
4XIJsnZe6tztC/uj6nJ1AQAA''',
    # Volume 5 Issue 9
    "Benzene Machine": '''H4sIAMQCKWAC/2WRQW7DIBBFr2KxriVmnFpR2TWbLhrlAFUXBE8SVBssAlKcyD17B9xFoix4go
81/yHfRNCu80Nt3ZhiffWOzuKtuglZWNIcfN3E4HsyqSc+iXdyV3KkNr+y/eClAFoEhdACKAkA
UkksbDKhaTOxlaiw7JsGJBMLIROxBRQvlTA+ucglgPP3PHPgU3x0g8J7n81ker9PUS9OK3ZaZy
e24VYmLnzyg+KBCyVI/r5wcSp+D04yC8mn/q0+spxNQ7W72I7U9rjjekDkqbB+mpGHRApBW8fB
ik+DvtSBtIk+5De+cnTS59ol05MOnMSQ6D88p5HC3ruO7i7iNBaTMfgumWi9y51OD/f/q9pqc7
KO8pVO8eTzAPGp3c+Uo84eDpafFKesOf8Bz9BJJBwCAAA=''',
    "Speedster": '''H4sIAMQCKWAC/7WQQUvEMBCF/8qSs4XMVHOwJxXBg548ioeQzrLFNilpAttd6m93JnZhkfW4hw
yTj7y8N3NU0fo2DFXnx5yqQ/A0qfvNUelSCxXwcVRD6MnlnvimHskfyFPz9K3NC59Ga9DQaDDI
FUutQesGCgcwwD0a4L5wLBzBaGwQjfTC1c1GuZB9YhPA5XNZGGy7PbUXA6o3SjsrOTjELdsDnF
tyxWIG69cgmgdHae7X9MhCPAnB1PJYstZFIu4hp0ubOd/G8xri9zvzf47T0EywkBr+Dq2XNeeV
LfDKFuKRKEbbeQZ3fBvsvopkXQpRFmkY7exU+ex6spFJiplWGMnNjM9omseScoyhzS51wYuht0
Oh7yNRO7GfQJvTLohUvVr/NQtqu+2240HTzBiXH4Dn10P2AgAA''',
    "Carbon Splatter": '''H4sIAMQCKWAC/22PwUoDMRCGX2XJ2YVMFiOakyyUHtSDHsVDujulwexkSROwLdtndxI9FOtlyH
xJ5vvnJKKlMUytozmn9hgI9+KhOQlZa6UFvJ/EFDwO2SN34hnTzhE2r3Z0g/WmXxsADdIoACnF
TSOGkCnxU1DLx7IwCDn9Z7icuvI5xLBBOiKh6c9Sr8/ydmWkBAlGglZcVa0dawxU/iMGpYHPla
vKFWipjFK6nLv7P7FkyQRXER4HTIFcis5zAtZ3/QubAS5tXFX1gO6k6eDuanYZnjBG64hBx91k
v9qIdkghlvU1o53dt5QHjzYySTHjL9znGeMm0IgXF+kw14RzDGMekgtUnGSnSntbPjRvs7eJxe
XK5rQLZYB4svR5KGh0263jVdOBsVq+AQTrpn39AQAA''',
    # Volume 5 Issue 10
    "Eth": '''H4sIAMQCKWAC/5WSXWvDIBSG/0rxugE9dqEsdxuDXmz0chdjF05PaViiwehoWtrfvqNdWb/oGI
GDPtH38ZhsmFfWuLaobRdDsXYWe3Y/2jCea6YJvG1Y6xrUsUGasRcMS2Wxepzt+KTiQgheCU5P
JUQpqILgvALCnI1HTLtoA+2bbMeja0GuyUlyPruRNSUu/058OgTuOFDm3a3MTCATyESKKREJF5
b3LYnYol6huXpVey0erOW/nMmW4l0M1z7CcXcPaNe495R7T87jogSqkKtMqb9mGkP2yxM/B/KX
aSzPuhU8HUZcuF9VQF+RFeYUnNqDfF0AlwEpgVZ7VVsCQLNWrQqPSgfnU3MloaXqC2W+lNVoCA
Uf8YfaqBtU/hT2sUP/4azBsxce9UDrj2gYunzkzjsTdaidTeezqj38ImmqYli6tIk9K/s5JGTq
xaKmfsOQTr39BriKKNkeAwAA''',
    "Large Scale": '''H4sIAMQCKWAC/3WQy07DMBBFfyXyupH8QEEiK9QNC0AIlojFyJlSC8euXBsRqvLtjKdBBQqbq+
RGmnNydyJBGOLYurApuX2PAbfiotkJycltLR53YowebfFIb+Iu+gnzevIYsF9efUjdK9kp1SvF
qTlNp2QvjaqpORWnrKmlkpSKU3MaSrFohI0lZMJ0+0VzygWLeQYT94ut663KI3Z9ZrbWs5NWxJ
ud9P9Ohp0MOxl2MqdOT3vSErHkvwb7LntJojG4nJw/jGSWtzNOEeg41mGIzlT0+U+ckhWmTm7f
0PouYHMPg7Pg6Txfmwf9daGeyJgSuEDFGb2N8NYmBJtjqvYdVWvYtjC8QrA4UJVTwbkNxXqEdC
zztGGJTYpDsdnFUIEBRm6vIT1j80BWWGsoeR3T4UN4mWo1uNXK0Z/kiWq9/wTJOkOehAIAAA==''',
    "Revenge": '''H4sIAMQCKWAC/22RQW/CMAyF/wrKeUhOOqBaj2gbh6mTdp12yFoD0doEhWSiQ/DbZxukMYGqPj
mvrf09d6+i9W3ox85vchr/BI9b9TDaKxAVl433vepDh03ukE7qKfc22t61WM2PcL84wrQ+gnml
u9J6qqECUl2ZU21mVGujgeqCVQNdlTmp0fROIX5hZuQUesoKJXUDVnU3Uk3IPtFsbQ4fhwMZS7
fD9ia3WgxtDCv0o/lgPUMu5jUR8RyiK4C4ZgCKu4ScbgW/DPvcDY3zktRQ0kktMY2ZakPAJaMK
vClKjqYlrEQ7j5Tg5rQQ8Quy4V8oYBZ9NfoxrYcOPbaOlv2HUNayaMMdtfTVIFOLGa8btPwAUV
ku8EDiE44zjShcczBIwhit82QYOvV2N45omxQir2hC1tpux9u8wfgZfIuR3BQznh9EbIamu3TT
sJE4mxja3CQXPA/1thf3Db/Rr5Atm9M68Ifqxfqvga3WLZeO9pEGxjn8AiPPG02xAgAA''',
    # Volume 5 Issue 11
    "Excess": '''H4sIAMQCKWAC/3WRwWqEMBCGX2XJeYVJLB7qraXQQ/sEpYcQR5RqIjEBXXGfvZNZwd3uFiGYj/
jN/8dFeG0r12etHWLITs7iKJ4PiwBemSbwtYjedWhih7QTb6HRFsvXM6j3MxQlSCmhlEBPKWUh
aVUSoFRMFBPFJKeDII4HYVy0gVzFejzcyecOd/3TLlZ3YtjEt8rvlayibiesHjYTn7g1YP+/8T
lsUrkYHt3PdewXtKctdXG5FPYBpwbFa56s+xx6Vzwtv+2kqBM3y/80k8DFAnqvW0sgp12vp8yj
NsH5lK0g1Ogxs9F0qD2R4CNu0KOZCV/RMA8cf/Cuiia0zqaBVveXfzEZHMdEdAyNS9+JD21/5o
Sqtq5bqh9mwmr9BfOkTlhMAgAA''',
    "Carbon Compounds": '''H4sIAMQCKWAC/62R3WrDIBTHXyV43YDHlBSWq60MdrHtBcYunJ7SsESD1dG0ZM++o01pQjt2s4
sc9Bf8f+iROWm0bfPadMHnB2twx+6yI+NpJhrB25G1tkEVGqQde0BzQIPV+puXT/RVnAOHikMp
aIo0C+C8gsQBSqC1KIHWiYvEBZRcVEKUcR05W2RM2WA8mSyHRTZ3ffRbeTIVJ1MAmFrQFDNxIi
KRAv4Uf8FRnaSXv0tfC70PpMU29R71zVuMsfsGL8GXF11xFZmPkaMHxNP3Cv3suDiHg7LgqeW5
X8xhg7/1kNOm614a2daaFF8vkquCj+90zrKaZjn3BT6Myf5XNKp6dE7WJt4q7Vq5zx1K5a2LTU
pCW7nLpf6SRqEm5F3AkZqgGpRuDh2qnvCE+r5LaTtndVC+tibGoOCnDtJ9WJOtbdtRML2L/2Tw
WxsV2LM0n31Eut5saurte8Ji+AHO+L96QwMAAA==''',
    "Magnesium Bicarbonate": '''H4sIAMQCKWAC/32PwU7DMBBEfyXyCSQi7bppFZEb5ZADVT8AcTCJm1hN4sqxJUIUvp1dB04tXE
byeLQzbxZmuASfftpBj+IxmQVEjS4br7Pobaer0Gl6iYNqKGhCn5RT7eyHqXVxaO6O5f0XyAIR
JUIhMQcoAHPEAsggBxBQPCSismHwdAjl8rbQG/9t2yv3bofk2axF++NaspPypwMl6dVdPmyDv8
V1m+XJVLFJ+UhTctFmJdogbaeeHbFgxgpZToy45X65jXRZzhlkBURWyRl5tQ7itlaNaadco9N1
Jf14FzT90IZau/Q3n5Hlp0tc6/Solatavjeo/m8CDqjgW+s48qKG88RWbU4nQ+h+4iHLN+BBwp
L5AQAA''',
    # Volume 5 Issue 12
    "Impostor": '''H4sIALbnL2AC/5WSQWvjMBCF/0rQqQsNzEipk10fwhIoLSztpbe2B62iUrGxFBQJNg3pb98ZWa
ZOtz0UY2v8bPl988YHEbVfh27q/Dan6Uvwdid+TA4CyrWoLNwfRBc21uSNpTux2ptN+J2T9nbZ
rl5BPmRQ32dUXL3CokXZILaAiNAi0NEqiQCtLLVEfoqKFYVFlxIUa9ivIHmn5DfE+USYkH0i29
nxfPIpB2PMRu6I7xnqV0t96s5v9lSV80vOy3bovvrXLuSwDt0Na/GuTIVv1O9JUoXvlOPxSCgi
5PTRuMaAd9HpFzemUzd0EmFT/Xoe7n/OPDgHWZllTQagT480SX3AHHBMg8As+J/1Ze50dGby07
j1sj1b3d5efaNf46wHKXU1gj4sxUE0ZAuwKEH1w2nK0BZvcZRawYL3y2Gw8A6JmZKNUTtPwgXd
dfrvNFptUoicVkPSs95NfTYbqyMpKWZbxWgNTdaO1LTflq62MayzSS54NvS6K+p1tw07+jBrOq
fnwDvFL+3/7Flau6cnR7mkPcnq+A/S130wbwMAAA==''',
    "Master Plan": '''H4sIAMQCKWAC/4WQzU6EMBSFX4V0pcmQ9GcEIyvDxoWOJrozLmrpOI3QktIamcn47N5bWMzoGE
N6Awc437lnR7y0jetyY/sY8q2zeiBX2Y7QNJOKwvOOdK7VKrYansi10mFstdVV/UX5DZyKsULQ
irOC0YoyBlPAoGSREeWiDfDbcr/Ijn3qUVr3pm11Vq/O0YWyElxYcuHJUbDyPxdM46wJ3rQQCN
KIejVnYBSu5AeTQ56/XV/2YExcDKeKOMQ95k/eyK2ZthfIW8EBf6SAf9qj4MgtcQ8OrIryksOc
8oiUBO8PMzCKCdgvYD0GN8y4JeAuEHcPjgVLvfOpd2DzAklAZTOJiktQWGLjzqwSqQUx5TiRAC
ME7b00FmuBp05+5l5LFZzHSgqQNnLIZfMhrdINSMFHPas2qlZLfywOsdf+1dlG/3jhtRrh+wM1
jH3aufeuiSoYZzGflV1S7+QA2bKHViZZxrBx+DO5lfZ9RKkx67WB4sIIsth/A2sZD5PgAgAA''',
    "Rags to Riches": '''H4sIAMQCKWAC/22QTW8CIRCG/wrh7CYMWrXl1OzFQ61Gj00PFFiXdAWD0Lg1+ts7rE38vGzCM/
vOMzN7GqTTfl1Yt0mx+PXObOkL2VPWfTuawceern1jVGoMvmjZSudXxpGF1FbJRpTvAmDYZ4LD
iDHaI1T55CL+C4ceuQnL8OUdmXrnd1YbUc5ylufs+Dr7fJedmlhbZ87eSc5CzsJ1lh8+Dxinld
0Z/XA9WtaND9hNlM2RcWwEo1OnvELO+hQfXeVyoHntt5sa2yjyqqwWkyPrz2dHNhCMAQPBYIw9
gY1PgicAATwj3pW7lQXnN8MDy3q4sy1TU6VLF1+eXGhBV25zdg2BZxe7ct1YsiaaEKR1CAb4Ws
tdEYxU0Ye88xBRLbeF1D/SKaMRxZDMP3VJNUaGaxiMahFf0NhuuvE3weukovUuj+HkuqMLudqS
6MnCqhrvjBWZIp40196k+24z0raqLJ4htoj7hz94ve/TuAIAAA==''',
    # Volume 6 Issue 1
    "Plutonium Separation": '''H4sIAMQCKWAC/5WQTQvCMAyG/8rI2cEmHvz4AZ4EQTyJhzgjK2zN6BJBx/67acHDUBAvhT7p8+
alAzjfqeRP9tTDOhugSGeiEZwGaLmhShuyGxwDeqft5rgpy9W8KGCWQcXqxYZlMc6y6fN9o8JJ
2Gs0FlNjPp5Hc4BVvpX4IynthvJD+9E3Shf2Vwr5my4N1djnQg11HISCQQlKxuXRpdRAPWGo6p
jmsZ0WzA7UYUBx7OMcVWqOGbBVvOOOW7I9Nri6281ZT3mkn3gB98vsW4oBAAA=''',
    "You're Doing It Wrong": '''H4sIAMQCKWAC/22PQYvCQAyF/8owl71YaIuga08LC7Kg4E1k8TC2qR1oJ2UmEbT0v5sOuyDFSy
DfS95LBm1dz5Q80EHQGzXoNNZIJ/A76A5bKLkF6fQW26r44iLLVp9pqhdKl8iORMry8TxKn832
z+NEkeldzKv1DkxVHC5ivc5n1mn0uKCrwCf/dCmoMSEJ4AJ6AeQZ/ljNAWYo9K0leqV072Owhw
DGl80U6UwX2Qn5w4P6Ruuu6ofU0aO7TgOGqYlpesvmZvbYgVwjQmXr2sovdBcxH58yfZWSWQEA
AA==''',
    "Synthetic Elerium": '''H4sIAMQCKWAC/22PwWqEMBBAf0VyrjQJeGhzlnrpqceyh6yONaAzS5wpuOJ+e5NAoQUhBOZNeI
/sKuBNuL4Twqpeq13pcheaweeuFpqhlxnSpLptiPQF6DpnjNFaPVWqJ0FOS2OPy3EkQMJnzr+e
jw15Ag591c4QgyyufWhTTuOseWm0TgGrzf+CLv4r4QCx/qU2ocmv9SgrxDRzFEiIt1tJRVjBx3
7KIvTLeT4vvfBEWaDexH/7d1oA+TkwRM+B0OY3QxjHkD7BWw4fP3UUslU/AQAA''',
    # Volume 6 Issue 2
    "Deadly Soft Drinks": '''H4sIAMQCKWAC/6WPwUrEMBCGX6Xk7MJMoqHYk7bgXqQHj+Ihtlk22CZLmojd0j67k8AeXL15Ga
bfT/75ujBjTzHszs7qid0XC4M8M03gdWGjG3QXB01f7FHbszNd8dCZvqo3kPsN7uq23VcACFgB
Sk6T5ykQoMLMESXSziXSnjnPnKMEXnGeUsHTLrAkLnIqRAnAbgrWuWgD3Ue+vq0rARfDX9rXqt
rqi6X8r2HaE//hA0kGf92ulX93tmiM+zI9KbQbddAFTq30f0AWJb9uSlX0qtd+d6G3hMJ8yp1e
T1r57pheWTVm1mjVD3Px4g6haLyxH1NKVQxH51P+FNWnenajpjYKenM4GHIMc7q4fgNgqE7y/Q
EAAA==''',
    "Deadly Fluorinated Water": '''H4sIAMQCKWAC/52OsW7DIBCGXwUxNxIwNWGt0i5phwwZogwnc5aRMESYq+RYzrPnQNnSqQxIfH
d8/79IH69UNrcUcZI7sUjV7kYrOC9yTAE7CsgveYKC2X7dlfmxmo+yRr8rbY3RSsk3IbtEsfCm
NutlXRkkKn8F/E+qqlG/CI7JeRrFPlDK3qH9hn0TNdP2xVElA0ybnibMjEomZFTma7NlnBByN9
RfEcbGPhBcmJ8Jkfs60VrXHaAypOqRnwS/cEgjchIPnO97zx3LXHPXB9D0/HZsAQAA''',
    "Deadly Microwaves": '''H4sIAMQCKWAC/31RTU/DMAz9K1NOIFEpTteCyLFI7DLBHXEInUcrZUmVJoMybb8d1+VjDMTFtZ
+d9/zcnWhdl2L25h324nq2E5IjoyPwsBMbb7FOFqkS994OGJvBokN9tqgW505LAJAaoATQilKp
pWJElRSVIkRczETtk4vEAWr/uKca/hVafqksDlJVRyJyEvlFOXL6FP9yc0x80/rX1unqIIGIiX
xeWQp3VGgp4ZL4c/qQC5AlKK04krCE0ZEij2rMFfud1srZNeRX48ycZzhXc35VlMStCuYp2QBH
Ima1ktVkwUzFqTXJxhrTZ9aEZ8wmi9SJISF1nrxbYcg+568+hnt0vQ/fYyO2Tj2eQH1n2xhP0Y
gWOx9+4HHo+H4BezShbsYlndlMN0WzssNs2dbBv5gt3Z6aJsWGNxC3yWzN0m+QNqTGql2vW/od
caBmvn8HF/oe54MCAAA=''',
    # Volume 6 Issue 3
    "Carbon Snakes": '''H4sIAMQCKWAC/42RT0/DMAzFv8qUM5PsVFSI3LbDuHDiiDiEktKKNqnyB2lU3WfHNggGmxCXp/
hnJ35PmVXvp5LXb8G7pK5XswJRoQzuZzWGwTVlcFSprY2Pwa/uvH1xZnsAPEBtAGpEg6RgtGgF
NZBiDWg0MkHkGRACmhW1zGuZFFJVfNaVzIsCq7pYqSYUn8kA6uVhoRr/dLkJMXizoaWXcHqd74
eSz8U+E/XG5qYbev/Mca8k63FKlJTAydj1R/cr8c/l8O38f25BvHY2rZPzKURiORb3ydqS3C+U
pqHP+Zjm/SRLokvOxqbj970dTz4zccOW3MkWtSv21d6G0ZERajz1bduT37ynpl7eAR+Spas2Ag
AA''',
    "Catalyst": '''H4sIAMQCKWAC/32OPU/DMBCG/0rlmYq7GyqERwYm1KEj6mAFh0RN7NS+o02j/Hdsp0h8VCw+3e
N7PybVukF4ffHORvW4mhSUt9AMXifV+85W0tm0qZ10tQS900C4IdCAuAHSAGkjjXmgJiiQlj9K
lwAaFwHiA6C6W6nKi+NkiTTv5zkBL3yrye30Je8r/WoNZfyT/iMXcij+ydiex3fr9LY0/a3Iks
bEdS3RhoQ4iL2iOHQt83fK41Acg43WhKrJXs70hT0ZNt0YOTMj3PisUxdzxHM8ER/4cP8s5sO8
+N66cvXW1nWbSvKYLmn+BKqo6CW5AQAA''',
    "Catalyst II": '''H4sIAMQCKWAC/32OPW/DIBCG/4rF3Eh310pIZeyUJUvGqgNycY1CwIFDrWP5vxdwhn6pyyvxHO
/HIqyfMu+uwZskHrtFQNNGK3hexDk402dnykscLMfwZrw6KABJpLAoKgIJpAibkgRQSJJAwaYo
sfxEfEAUd53oQ/Zc0pDWl3UtIGT+a8S/xdDKtoKtbCu+jWiD6jj41gi1Dn+lH62zffDqaNtM+G
mqrlGn3ZCTiQVxzOaG0uQs81fK89RCo0lGx36sWV6fG3vSrN2cuNvvK9aZx1Ct4qov+JHeiU98
qpdXOwy2zOO5XO/XT+up1IWoAQAA''',
    # Volume 6 Issue 4
    "Unbonding with no Bonders": '''H4sIAMQCKWAC/32QwQrCMAxAf6X0rNAN8eBuXjzqxZN4qGvmAls62hTRsX83LR48iJeEvISXkF
kjTYnXL08Q9U7N2pRYaAaXWY9+gDYNIJU+WOcHJExjc3BNVW03tWlqScboldKtT8QyV9XLdVkE
+MS/9P+V1U+lKcLexnWXIgRBHBJ8UJwGZP6m/JyKPkAEG9o+u8iOhZ3p5skh3dUDuVfk1V5qCD
EP2cS9zyJ9lBegg5ONeZ+0HHYdyt38lHa9vAE22occPQEAAA==''',
    "Breeder Reactor": '''H4sIAMQCKWAC/1WPQWrEMAxFrxK8bsCTdtPOrovuCkNhDiBshRgSKShSmXTI3Su7hdKNwO/5f6
F7GMsNc19oNe2/mHALL909RJ/hKkDFlvP1PJyehxjD8dAFNv3/dWhz4RmTzVhzl9mUW/JiNfrk
UU8mNlL3p3jUIkURKOQg+muBWy8ISVlq7aOjCbYe8idQwuxIxfCXkqUZQf6g7mvbvApnS1qY6k
KCpdFXQcwo3cdPf1VgOrE0Cdu0d+/pDdW2qnIZx+Kn6O56OL4BADsIQyIBAAA=''',
    "Nightmare Factory": '''H4sIALbnL2AC/32ST2vDMAzFv0rweWGywwKdT6Mwyg6jbMdtB89R20BjF9cezUr72Se5f9bSUk
Ic9CJ+70nJWgTjGt+VrVukWP56h0vxWKwF5DOrLHysRefnaNMcqRKfCSozKJ8sxn6ODvVO2IIa
0a1BSglaSgWyAq34SXVFB4i7QlifXCTMYHNXnHOHJnx7V7y1bqqHW6i1hFopraAmqpT5VLUipq
qByaScEqvN14agYtKusLk60yH6eImp8Rhn/TE9Ra+GI4Yew8v9KDk6haGLAvAY7OJTvLa0i4E6
nJrife9yP9SQxwF2UHAci6rz9UhgE3mD+fLPJIrar1pxXqYpXfGaLpnqBnN8xuRkwMzDR8gOvA
u1c5DVpQNbRAzBtI6EB6o6syoDGht94E3VJM3MslxGE6iRlBgS7kXT/BhnsTlXA9rezk97Y7/I
0RfBN8nG1juO4UyX1dd2OoudCVg8Z9ueX5oUZ54RwqIJub9pJ5OWthD7/Pv8AbQPQYIQAwAA''',
    # Volume 7 Issue 1
    "Fructose Factory": '''H4sIAMQCKWAC/42QwU7DMAyGX6XKmUq222YTPYImLogjB+DQdRmr1LVTmhzGtD07trNKTHDg4j
i/nfjzfzLdcIgh/xoHN5n77GRAo6oivJ3MfuxdG3vHN/MeAVoncU31wwWKpwssXvisiSxiDYQI
dUEIUCMtOadCc5QcUKqE0kkgEUF10FcgnQWnYO4y045xCDwT6fxx5jv+FwxnsCqBXcchYPr8Fo
Ys64xKrBeKUSxBsO11EfwFIzRjDH/59hPpMV/52IZxcgJkGQgvQMxkZyadLZNmssSU+BJxIktM
SnOlpFJ/qNTEUvqx0q1KqUKlm5RqaCWRrE6xmi/UBav9LN/aDbrfrpnyvvGfLk+bciX46LiyHo
eN8/ncTyyF40E39m5yjW938t/Q7FWbPchWDZ/+KLUmht3opfra9ZvsWbRNt912bF04CsT5G9JF
fhuZAgAA''',
    "Misfortune Modifier": '''H4sIAMQCKWAC/52PMQvCMBCF/0rIbOHSChUzOtfFwUEcanulgTQnaTJo6X/3EnARB/GGwH1377
3cIo27x1A8yeEs92KRkN9ME7gsciKLXbTInTxRb+IkDqMlb3rUx/ZgdalUDaBVKpAbITuKLvD6
dt2IH/RVxTrQZaXqv/QAnK80pPgP/XVlC0kxfDvy/8MUZN8buR598aY7RuFxz34eZ2x9NyaVa6
fMGjMP5EN0KBqOGwz6NG5jGMmnhbOxvWgS4+lg+G/hwbxcX9peZmunAQAA''',
    "Particle Accelerator": '''H4sIALbnL2AC/22PMWvDMBCF/4rQXFNJBkPrqWQJgUK2Dm0HVTonAlsyFwniBv/33qmLabNIvE
+6997dJNro09SEOJfcfKcIF/ksblLVs1IG7zc5pRFcGYGU3Fn8ShOcrDj2H0W19kk8il2vdadM
r9tOqV4bozQpoypTpAwpzVTJByFdKjGTmTbr57oSGMIV/N0im7zDnzyjfj3pbg3ntjXBcILm0f
3iMZ0g9nv6ztEclUq+t+52xX9z28qqFs6AaENkQGqy1wbBupyQPTtCZ3tpLmUGKh89INGMBXhy
mWvIjMkXl0OKbB/tVOnRYg5uBPHiHIyAliz53ZZ8Tuwi38LoxSszH4YhUOe8EDfrD+RVtjHQAQ
AA''',
    # Volume 7 Issue 2
    "Sun Simulator": '''H4sIAMQCKWAC/42OPQ7CMAxGr1JlplKakV6gCxMDA2IIrUsjpUmV2EOpytlxIpD4G/BgyS/2y7
cI4ybC8uodRLEtFiFzzzSB4yJGb6ElCzyJZu6Cv4Crm5tUdcUla8VNik0hWk8OeatS62ldGXjC
X/I3IVhDY90Ay9SHRiZH9X3yVwaZE5y96yCUT6oYDTqWPUUIPGMgeKA4WYP4SnGe8n8BIujQDk
nv9JjZnlyxNyNZjT6kB004+HQsDsZ2xS6xzvS94dQ4p0DrHReGl8FsAQAA''',
    "100": '''H4sIALbnL2AC/22OT0vEMBDFv0rJ2UISPai56rIXb4IH9RDbKQ3kT0lmDrulfnYn2RVW3MBkeD
94780qXFwI+2OKUMRjtwrZ/kYreF9FSB4G8sBKfJC8fbjvn5w9QgRzkt9S73mMUkoqo7SWUkuj
65a8KxU3nRgSReQQpbfPbWOQCK91X/btIAdHwexCS+f3J0nWGPXP9ewhQMTudQa05yPZr6/4a8
BXiiPk/pfeMZpt6ScqkFljJjijsniHeEnxsLTKDAVsHuYaH21oTJ3aLOGcqkW8OT92L5WNbpoc
n4sH5nr7AWUyEWiHAQAA''',
    "Hypothetical Synthesis": '''H4sIALbnL2AC/5WPz2rDMAyHXyX4vIDs7uDNL7DL6KGFHrYevEQlhtQOtgzLQvbslT069u8yH4
T1Ib6ftAjnp0ztW/CYxH2zCKi10gKeFnEOI3Z5RO7EwzwFGpAcoXnOsLnTW6OkAn5GSi1B3DSi
C9kTT0u1Hlfu5b+VVXUV/1IWZ8j0195fxR+ydo8Uw6vrP+3vcMsBrFbKSNCgDEiteH+loYTqH5
FQA1+C7zG2V6oZDTa1CX0KkQHFjMxonmp4xIQ2dkMxeXv+fmlnx2Y3e/4nl8qEzTRUizi4sW8e
C+vd6eT4FpqZq/UCE8v1pKoBAAA=''',
    # Volume 7 Issue 3
    "Halogen Sorting": '''H4sIAMQCKWAC/42OP2/CQAzFv8rJM5ESSlsJNlhYOjEwVAzXxCEnXc6RzzdAlO/OOaqq/hNise
Tfe8/PI7gwJCmuFDDC2oxQznOmCt5H6MljnTzmDXadJ3YBNzu/qarqtSxhYaCmFCTLL9PC/PRv
mXq1bznbn55/209TTgAl+e+Hx3uXKz1T/Undbc8hTX1QaJCLL5pRZ2PRpoicd+GEnygO3ol8p3
IZ5h7GiJbrTs8H289sbz2dMZgDsbhwVskm6UjjcHS+MW/KGte2Lv8rFy2fbqw0GpCQAQAA''',
    "Metallica": '''H4sIAMQCKWAC/4WQTWsCMRCG/8qSUwsuJNki0py8VBZahF5LD0M20tB8SHYCbkV/eyerWK3SXj
bMw77PfGxZgtBFX9uwzlh/xWB69lhtGR+/Iy3gbct8dEZnZ6hir7lH9WT2XC73vFFSzjhXQswE
V1zIaXn4jEslqeCSTSqmYw5I0YfdpLp0zV32NoCau5NOiIbCnB5x0h58pdHfugU4Z7O/a9v2vl
pubGfUAn7MZCzmRvxvft+RnMWMty5z3rJNMdA1yEfbXkgELwpxlTjsnD0tTSna9kZKXqWOq9E+
ajzN71BJoUkJbCiAKg+bOhnQGFMZfkroA/q6R0j0IxFM2RxhMnrQ7pzisB77rlPsskYbQ2kYwI
/0xWCZR0OBkPEjlih7hvA5FNTZ1crS6DgQbnbfq5T/MmoCAAA=''',
    "Homogenizer": '''H4sIAMQCKWAC/32QsW6DMBRFfwV5DpKBUkXNFKYwZO5QdXBtp7GE/ZB5lkoQ/fY+A2qbhmax5C
Od63s9MC+cApsa1wZML+B0x56SgfHpnGgELwOz0GgZGk03tu9QoHE6OYIDA8oovdtjvcuybZnx
XZ6VBedskzAJwSEZD+MmuRPx5sHOGZUnuyg5X7Luh1TRu65R+Vij+K/G60ghDAKuzV3rR50+ef
6zbFteR2Y8BmY3fk11yK5nuSxW+8xyfiMvu2hM1L8/pPjzIaRHH7X3wjgCnG5WfKReC4ng47ZH
QmfRpS7IRgtPBH3QC/Ra9oR/UezbqUHrQQWJBlx80Ak70QNYeNfOXEghLAKeIcrs2TQqOUamzO
lkaAf2xIvxC2cPc0xhAgAA''',
    # Volume 7 Issue 4
    "Dessication Station": '''H4sIAMQCKWAC/42PzU7EIBRGX4WwdZoAcWFk66IunC5mMQvjAsttStJyJ/wk02nqs3tLNOrYRF
lAOHA+Pmbu/Cmn6oIeIr9nMxdlLnQFzzMfcYA2D0A7fkDr8sge0eu9udGShhB8x3iL2Se6IZcd
+6nUkw14dhZ0U1dk3Emh1d/a0SQIun4TqimS1FKRtKGK5WUhnWNOW1/ZqP9VaW+a+jr+Ol+t4f
JX1v8LqlLvFb2FUH3SW0K9iVUEHzEQSCHDB+tyhG8oTafyYoAIJrT9Gu7NWNgDxOhakxx6dkhl
XY9NTn1J5Uc3WPa0Muu6zlH7NBFXyzshUnp9+wEAAA==''',
    "Vinegar Distillation": '''H4sIAMQCKWAC/7WQQWvDMAyF/4rxuQHZgVHmU+kKvQV26A5jB+O4q8GxgyOXZiH77ZPNBhvbdR
gE+oTee/LCkw59HBoXxozNWwx24vds4VBrpQU8L3yI3prsLXV8Zyw6w3bG9Wp/fId233VHBUII
UALoKSHuBFUpAJSELUgliYBqxZambeF8w7iJOSApinXDflo8abRJkbbsSKwIy7oqf62K9WWldR
4z/nXD/+aGak1Rk3aBAFA36FuTrDYYUwkiCV301IRsvNWJCKZsP2GyZib8jeI81qxjin026GIo
hkEPlZ5csK86sQc3ofNef811xkssKvxwMz5P7mpZ91gmvTufHX0AziXL+gFwKPSJ8gEAAA==''',
    "A Glass of Water": '''H4sIAMQCKWAC/6WRPWvDMBCG/4rQHIPkkLTUU8lQD4VAlg6lw1m6EFFbZ/QBcY372yuJDk1phz
aL4J7T+3AnzdyB1TRUxo4xVG9k0fM7NnNRzkIzeJ75QD2q2GOq+CF2Rps4sHbSjs5GY3Po9m0j
5fpGiqaWt0I2dS2F4CvGFUUbUmy9rNilZ4f+0rLzxbLZ/MXyBAFd076Lep+y8vfodnlZUppTDD
9t+y+nFNkorxXUVwmyId12YGx+oVQNcK4cggrk8orbhE7gKxtVj+ASCS7iJ/RxRNeR1fit4VBN
6f4XGqaxDDc60lEFQzZPYmEo9J499OA9oyMr0+cexHCibOCPYF+njLQ5Hk1aM0zlOz8A0Bm94I
QCAAA=''',
    # Volume 7 Issue 5
    "Pertetroxide Synthesis EX": '''H4sIAMQCKWAC/22P0UrDMBSGXyXkSsFhko4xzOUY9MIxQUFBvIjtGQ1kSUlPwFraZ/ckMBT15i
f5cjj/l4lb3ydcfQYPA79jExclC83gdeLn4KBJDujGD4Cd8cCeAKMJTu+ujvX1ItZayK2UWigp
hJYin6Xc5FRbIXUlM1c0QynKTEXJbxhvQvJIq6Wa3+aZQEj4n9Fvi9GxB4hIHuHDtqB39SKq4y
I29aWZeshIUjVZfPdXZEQps5dS2VT9cRHF5D34FuLqQteEOjOsEBz0gaojQYwJiOPYF7MIA5jY
dHmbN+fCfmqyx9FjB4Md2P4lD5mEXciL+D2MziLcPlvXskN+a+3pZOnPONJ7NX8B/pyUg6wBAA
A=''',
    "Fantastic Metals": '''H4sIAMQCKWAC/42TXWvbMBSG/4rR9cL0Udp5vkoLuSsrY3djF5qtEIEsBVmiTYP/+86HNpK1sE
Hwy3uOHB6/5+gsso1Tmjc+HmvZvKboFvG5OwtJT6pi4ftZzCm4sQYHTny1z91TsMXHOg9PpfvY
besg5d0npQbNohSJAZFQ1OQkizIgcjAgUg5K3vXYUyQGHL7QnGZnwMFJzSfJiQ+dGFONBYCUXn
+sKxT2/sVN736M2LmcU/HFRg/QOwfQ3zxA61uCJlGKxIAQNDnJogwIQkMPobUmaBJ4kjMgEmhJ
4KnpS6hnJDqEVkizDXXG9Lr7nOKrGx4qhhiQp2eennl6JuiZAFPQ7ACkBxBgxYSMVPADLGUIi8
WAYGzkNBeNppOaegJDS7W8N/zLgW8nO9sI83acHJNeRHYdUkuupdri/JMcYzBwg2rAjbRxM2ID
vhq3XFuO15Rfsh8PNoww3y3m+UBLyUHy5vACKV4nzQ5WlHaMT8JS9jxfXkpOniPX7GCUFLnWvJ
s0FUnyllK/oXz05ZB94HtDK3h5Ydr1+a97c7FYv9fs3wv5FyIyFrga1kco3ICb7csmOzuWlHEd
bqF0sMtmqUeXf6Y4uQzVkqvDN09H+qZjTlMdi08R/z7amao7WBm7FD92j67YsGDP1nJI+A/iPl
TnTm7KtmBj8vu9h4zKCZpm/QUjFUEfmgQAAA==''',
    "Reppe Chemistry": '''H4sIAMQCKWAC/4VPO2vDMBD+K0ZzDHoYE6opZOnQEujSoXRQ5QsWsSUjSxDXuL+9dyod0hY6SN
x90vdaWTS+C2Pt/JRT/R48zOyuWhkvd0EJeFnZGAaweQDc2MFCWgbwoI8fXN7j0VwIwbUQreJa
ihZnhQBnu4rZkH1CWrPtqludo4lvwVePwYer61DtRAqSFPb/cZ9NgqjJm0hkTiShpfxl+7ohm4
Wc/up42ysug7PVwbqOqimUb05f9VopKJz4rse5QDdOblqUWfI9/lQlhfqZQvASAjNH4zwCErfR
XOsIxqYQKVKDUG/mek4m4kdEUsxArGUq+aYYumyTC56kvRkL+gTTBNWxh9HNKS70ZHLqAwmwB+
MvBerc+eywaFoQVtsnNfatSfoBAAA=''',
    # Volume 7 Issue 6
    "Better Than Graphene": '''H4sIAMQCKWAC/31QPU/EMAz9K1FmKuXjekFk68JEJyQGxBCuvmulXlKl6XBU/e/YPhBCnFis5+
fnZ+utcojTUqqPFGGWD2KViiuzRLyu8pxGOCwjYCeblFP0jde6VkreCXlISyw40WZ727DX/663
Q8npBNG36OBuOJBFWsqtl/68Icht6MA3rVfKae21qpX2SlNFf2IMM4awYd6w0rLS4g9YWWNYoy
1VtWNcM94zdk4rbxhbh597W9OuYaW1hJXluzu+WDPeM3aYlTdcLTOGp5aVhrZ+5aA4hT7M1Rjy
CaprHjgpeQGcvKfYQa6+9fdf4hninPKPrFwmzirDDCEferoRw/maH5QCWTz3IYrHHKYeItA8LK
VnD/kyjJ14Iq4bjscBgy8X5M32CYFsf8syAgAA''',
    "Magnets": '''H4sIAMQCKWAC/32PT2vDMAzFv0rwuQHZhpHN98EOpccdxg5eojaG1C7+A8tC9tknKwzaUXaR0A
/pPb1FOH8puf0KHpN4ahYBXJlW8LaIc5iwLxPSJF5i8OYZv0EZKdWDAqOoAYhdI/pQfKYlve6a
u1d8crv7uL7TtpD/mh4+5xN6c9hcOzbtbnWkIqGqFEq+l+dabm9PHrPLuAUhWW2APpNgpOIG0G
1WII1SXDWH1fqvL7DrR/ADxvaXdoRGm9qEPoVIIMeCxPJ84Q8iJrSxH6uSt+err1JFtuSRz8Sr
m4ZmX9ngjkdHCfJMXK0/z/VZXbgBAAA=''',
    "Precious Oxygen": '''H4sIAMQCKWAC/32PwWrDMAyGXyX4vICdFZrNp552Gh300EPpIUuUxuDawZbG0pA9+2Rvg1LKLg
J9Qp9+zcK4kbC8eAdRPBezkLlmmsBhFmdvoSUL3ImdsR8Q9OaklVqtpRQPhWg9OeShqpbjwr36
1/Dibac3xPvrpzv7SeAJ72W6tmw/pxM4vf2SFZvqSupK1Tc6mWXv3nUQyj9aMxqaWEZw0QcGGA
h+WU8RblAcrUG8pjiNOUGACE1oh3TSNefM3gK0xlMsfuKlUUM45Dtib2xXvCbWmb43/AlOzB+X
b1qM4bKEAQAA''',
    # Volume 8 Issue 1
    "Dewer Benzene": '''H4sIAMQCKWAC/22PwaoCMQxFf2XoWiGJ0IXd+R7oxi8QF3WMOOC0UltFh/HbTTsKwrhoSE9o7m
mnGndOcfrwji9qXnUKSi00g02nWn/iOp1YbmrB7sGOzd8T9EqOAUBAA6hJKpU6QwCDhSNqlJ40
Sl84FU6ogQyRzn3malKp2icXJQSp3/a9AJ/iL7dvn3++cahGVkP64EYfQ6RsiIMVvq2+Td7mg+
fICorTzrs9h+mHkqB4PxeXwBe2oT7mV862Y788sCkefcijZbJXu/YtyyIZ7JvDoZFvxXsO61/T
VUh0mQEAAA==''',
    "Natural Chemo": '''H4sIAMQCKWAC/22OwWrDMAyGXyX4vIKkQAjzaZRBL1uPPYwdvEQlgcQurg3tQvrss1QGGxsGIX
+S+L/FjP6U0+YzeD6bx2oxoFWpgLfFzGHiLk9cfuap41RWq2cfJpfYbm9Q727Q7C1ig2gRyrOA
iGCREMASNkCWSKb1ndRaoRVS9sE8VKYL2aeSgLS+r2sBIaf/xH7K7C+cnP8rcY8n7WuUMNR4ol
Z6VUSVANJNIb8kQBU+gu85br5pW1C6njQ68pld7Aa58m5W9upSjm6qtgPPQQYupyFEGR3GqX8R
1I/H41j807VgWr8A9ZjKl38BAAA=''',
    "The Chem in SpaceChem": '''H4sIAMQCKWAC/22QwWqEMBCGX0VyVshMrEg9lb30svTQQg+lh1Rna0ATiRG6FfvsncSW7kIP+U
i+GZx/XIWx0xKKT2dpFrfZKmRislG8rGJ0A7XLQPwSRz2QabO71nTN4UuW93we+DQgK4AGoJLY
AFaS76oC2UiASEyUNTJVJMqaDapIJUEyFVPkmWjdYgMPA9xet42FW8J/GS9zQV4WnXEf2lKBuY
p3S9cJ9wwR0CiME+GmZmIiZ+b8nIeriPsusRPKCnij3Ze83VVCmfL1ei4G7d+p2JNyJfiFuPLm
bEe++O2vf5pnsrPzf23RBRpocj7QhQ/nKW3naSbt2z7OtnpM7qmn7NDTmBmbPU66pfiIDXoJff
q4eDZDd4yqM6eT4V8Vzqxx+wYnhU199QEAAA==''',
    # Volume 8 Issue 2
    "Airborne Aldehyde": '''H4sIAMQCKWAC/32RT2vDMAzFv0rweQXLGSPMp5BLb7n0NnbwHLUxpHZxbVgW0s8+KUtZ9/ci8H
vo9yR5Es6fctq8BY9n8VhMQi51UVl4msQxDGjzgPQStcVkhg77sUPdbC+ybLatBqik0qAeQGqp
gKoqQVIlBTQLoEtFirgrhA3ZJ2KBmp9nesO/ge3reECv2wsHQMVoCvsJYlLI6bddvuDYZFq50u
QfTPk52m1/Y+JL8M4WtXWdpv1Vc4XdXKCireV6gYp2X67xDc98QnUYN1f1nqQ0npagiGc00fbc
5c3x4/iOwqPHol5/gE2TUx8i27uQD/2u55rY6dx+72jwNJKr5ne2COVa6wEAAA==''',
    "Natural Gas": '''H4sIAMQCKWAC/62QwWrDMAxAfyX43IDthhyW0xijvbQ/MHYQsbIGEjs4cmkW0m+f7HWUQcYuxS
DQk/0saRYerHF93tohUP7pLI7iKZuFTDHRCN5m0bsO69AhZ+KAdAKL1cv+KotKKqVkpSSfSqlS
cdRKykozlmKTidoFS/yuWDbZb9HrzXOVmlXl36pEdCI6ke3/8ucaaerw7tc/flVuZbKtet4XVo
mmvaBZ3YvYT8a7D7RVcqrk/B42PnSB1nb5gP0pGf3qsTr9QF30EXoPrWUgOevhknuEmpyPyygY
nWDMRwLPF5mQD3iDYM5gazR3StOQOhq8M6Gm1tn4oYU+0SNQ8NBlOxgjhkAnF5ViF+AMB9cj98
UF0zZNy8PRxEW9fAFmCaMf9AIAAA==''',
    "Symmetry": '''H4sIAMQCKWAC/32QMW/CMBCF/wryXKQ7GyVVPZUuTDBUnaoOaTDCUmIjYw8hCr+9d4dALUhdTv
Zz8r53b1Q+HEqen2JwR/UyGxXIFJWFz1H1sXNt6Rzd1EdyjX1bnWGxPoPeWMAa0SJWCFYDAlqN
NU+NABZEATkjPINWTzPVxhIyeaGevia647/A1bBNzckHZxnIYKLVTBMyICJ7441pSIAHDoNiyX
9XvZB/0177Pgbf2DWBjIDwao6yhL43B3aGB6OlL9LUJXNF2RcbOlPeiiwNd0Ht8DRYkb3R3BoY
aU0L9tLabdfbljKNfKk51V0czvMdw9al+VVdkJSHgwRL7uia1O75r9D0or0Pfe9yGlhrSt7HJC
t0xbnBUf2ZH7Z+t/O0Xh7o0Uw/IXCD8TkCAAA=''',
    # Volume 8 Issue 3
    "Fenton Industries 001": '''H4sIAMQCKWAC/52QMYsCMRCF/0pIrTCzgpyXUji0srQQi9w6sgs6kWRS6LL+9pvkrlmuEZtAXt
573yOD7fmWZf4ITMl+msFCPatahMNgr+FCbb6Q3uzax+/Abu0QlwB2ZmwbMos+LcaZmXr3Xii6
zROandoRwTX4AeiaBqfR1XjUsMU3yav3yQslF3TIMv2F3y2v8RFKBfxLvLxCC0pD59M8EacQVZ
OYSTW532pXpEQ+tl2Jsb9W7YtYApstn3KS2FMyAFgMPktXS/4sRTv153Ovy+RegOMPj7mByfgB
AAA=''',
    "Oxygen Candle": '''H4sIAMQCKWAC/22Qy2rDMBBFf8Vo1dIYNKI0brX0qoSS7rooXSj2JBbIUtAD6hr32zsSFEKcjU
BnNPceNDNtzynWP85iYC/VzHg5C83gc2ajM9glg3Rj7y6qEHQaq1dn5e5BAsAz52xTsc4lG+nN
07KprpbQd4NxXkWUd63Z//LH+zpvbkFI4A0XkkMjuATRcC4FNNeJXwuFMpfiLdfbfm1u1D3KXW
uKJeRk2K5lGaxi9t/TCa0kUxIsaispEMXp4GyPvv6nDaFBhTqgDc4TiD4hsTidS7DHgIp+IydZ
NV6UVa2yPbXTQKU4lGX2oU3/llGvj0dNdnEiLJY/y5Fl0bcBAAA=''',
    "Lies": '''H4sIAMQCKWAC/6WPsQrCMBCGXyVkbiGJDsUOglMH0cFRHGJzpYE2KWkC1tJ39xrtIuLSDEfuO+
7jv5Fq0wWfPq2Bnu7ISFmskc7gOtLWNlCGBrCjF6t0aEkxKGcfWkF+kuci5/hYLnjGeC4E/hlN
CC1tMB6XtlNC/lv2iyaLGr5W807z8WTfmtuEJmqD/3X42mM5i/a7NQpculCByA9dtDroQbqynr
eMbCM7agyBvQy+tm4mhyYADKCc9PNA6arSmMsPONxML3qXFqe3AQAA''',
    # Volume 8 Issue 4
    "Liquid Glass": '''H4sIAMQCKWAC/22QTU7DMBCFrxJ5TaSZSdJW+ABs+Fl0wQKxMIlLLLlxie1FicLZ8dhFUInNPP
mb53keL8JMpxjqTzdpL26rRUCumTJ4WcTRWd1Hq9NJ7I01vZJ78/QFJImwBZCEO0CJtEMQN5Xo
XZxCMiOtr+uagIvhv4yruW4w8ViV8UHLR5Xm55RGImKLaT5wCmeBBExZEpvS6IpskwA/gx/T5r
rhCls205YvUpdrk4c0zKHLXUBk60WoSFtkk4UKpAIpw6t1IS87Kl9bNb/ruqydOmGOOnXe3DTo
uf7x7y7mQ/R6/nUx8idrQvhLw/mU/2nWXqu5Hzl4UsfM7s1HNEN1Z5X3zFUMo+O74tnY4YHRYA
4Hk/46nBOm9Rv7xSVt9gEAAA==''',
    "PVC V": '''H4sIAMQCKWAC/32QP0/DMBDFv0rkmYg75x/CYxYWJMRQBsRgEpdYcu3KsYdSpZ8d+9ICEhXLU9
7z5U6/d2Ta7mMoP51VM7svjgxIKc3B65HtnFFDNCo5ttH2YIp+Ms7rUYn+BPzhBFVvBGKLKJC3
CAIQs/KsnCMkRewA2E3BBhdtSKuQL29L8vjvvfWSVcWzHPUgjaBLV3flZS6GazRXNsqgxuJp0/
9CuD1/8t4kEQgXILzAVaQ1aUPaknYEDbiid9/sUJE2a1STaUk7qqajatqMI3hDpl5NRYavBsnA
H2og5knOpZH+Q5UrfXoJPqr08u7sqHx5mb87D2/jrPzPVDjsqRivZiX9MOUTVu4oSwUVmxzIGC
aXf2Iv2oyPORr1dqtTq+GQYr58AXhiICJKAgAA''',
    "Memories": '''H4sIALbnL2AC/32RT0/DMAzFvwrKCSQq2Un/ADly2QEm7sChbN5W0SVVmhzKtH12EqcIMU1c2p
ffc54t5yA6MwRffFlDo3i4OgjgL9MEXg9ib3tahZ7iSbwFUPdlsey8s1syOp+XGrFRoCVKUADi
9kqsbDA+3kB5fD/GM/4bu5jWOW9xAhnDEFMYXohKWTb4SzNfmPPF9lO7Ij/1ZEhfZ/qYmtyc4E
4j1BI1QG5XI2qUiUjFumRdsa5ZN3WsVGkwDWk+rRTrknXFumbdJI1N3IeM2XX8RwoNezV7Vfag
4u5lrlAle2r2FHty9iR7OHt5STB7cL4s4FXt2rHoW7elIi8tOt4Fis6HNWtyxU99ORePZEbrfs
sS24SRztA49J3359RTT4N1f7ifBn4RRyO1brVLQ5p2z+yZ9tZ18REja4PfcWPx1JrPKaF1t9l0
8UX9FLE6fgMWbtUgrAIAAA==''',
    # Volume 8 Issue 5
    "Tumbler": '''H4sIAMQCKWAC/22QTUvEMBCG/0rJ2cIkVXextxXR03rxJh5iO0sD+SjpBKyl+9udpHvwi8LL5J
mQ96GLiNr3wdXGj4nqz+BxEnfVIqBkoRm8LsIFi12yyCfxQMNsq6OhaAjb+zOopzPcHJ95aJW8
lbKVWwJ/rSrZSAnQKpVTlgS55zvQ7POsdqDEVSW6kDxxh1Tr27oyCIn+U/uu82jnzvjfIpsCXB
Ry1VbLgrwFuWOiVC7fNKFsG57hhwgUDcIYtfEMgE9Of9QRdUchZqlrRoOeaj1N6N7tzIhiwgvt
zfR3QfNY3McY+tSRCT6Xeu0KfUl8G2NGOtEQYoYHmxBn7KOmvOjN6WT4F1B+Va1fyVODGcsBAA
A=''',
    "Molecular Key Carving": '''H4sIAMQCKWAC/3WRQU/EIBCF/wrhbCNDzRrtzT2aPWniGSl1SVpoWDBbN/vfHRjWuNFeeJnXYd
7H9MQHezR9Y92cYvPlnTnwR3bigCff+nk2odumTgj5ANABiSRpUQQKFJFALSSiiiSTRJK0ku61
KKKTKCA6IBFF+PmGcZ/iNZMo5+RHo9NoMuCzWbQKPYPNfaYsQPIyMSNglRFQoFY1rZpUSapaaq
lchVJyBNE+uYhxIDIWrFLgmExxGVopaHaFqUnyCkaIv7kXGEnfYAVGrq8E2rKS9SX/bOZqQVBh
/gvMidGEoKxD4w6rSR2bYJSOPuR/tEFrrw7NIaqAjejEkEw1g9GLHn+7cZkL8xx8n3S03uVAp6
bi7uhVKjB8E9uq8GndR25QKe59HsNf7PuIJvMDe326fbNjv8sNvR0Gi1fjgk3y/A2vjDcH5AIA
AA==''',
    "Sensitive Explosives I": '''H4sIAMQCKWAC/3WST2vCQBDFv0rYk0IDu4loaU4SLHjRQ4+lhzUZdWGzG/aPRCX97J2JaWvBXk
L2Zfa99xtyZU6a2japMm0M6cUa8OwluTI+PAeVhPcra6yGKmrAE9uo4Gz0ybZTNRSbT55tCyEW
OS8ysRC8yMUz5+wpYZWNJuANkfUffY/CXnVQP0xjb0qfwCWT9TQpj9o6sl4eSo3OMzLNMOHmKm
i8PEtjD2CKSbmZYgMcm+MUH2vMc6pBFyjWxvCI757plmkgWV4oudSIlRNVJogqG+0KkX3X+IHj
/Vjqr+Md0GvUjTIyDEQbXFY2G7ywpvh3Z3zYWADnpDIk4KmRXepAVsE6ApmhdJQ+ld5Ds9NnlI
KLMKq18o8/OKjOlQb3q4ZzO3Runa1jFZQ1VMXI5kYCxqugTpCsulZbj28+WdOEjOFoyYeturgD
/JsqIL1W+73CRQRKzvsv69sCFWgCAAA=''',
    # Volume 8 Issue 6
    "Waste Gas": '''H4sIAMQCKWAC/22OwQrCMAyGX2X0qoO24MU9gH2AgQfxULdsLWyttOlhjr67acGD4iWQL8n3Z2
fWPRO2L+8gsnOzM15rpQXcdrb6BYa0AHVMwWLT2qhtDHaEToE6dEJIwTspBOfs2LDBJ4e0K2S+
50zAJ/wX8aUln5/BdYpsv55TtTy8GyG0HyoJGR3bCC76QABDAmK4PasxQAQdBlNMTq+VXXVEaC
46FqgTmnrIep9m05tSsUxGO02WPsOtpOc3adNC9iMBAAA=''',
    "Ethane Scrubbing": '''H4sIAMQCKWAC/7WQwU7EIBCGX6Xh3CaApkZ7XDV78ObReKAw3ZLQoaFgtm66zy6QNdl1qzdDAu
FjMh//HIgTqOxQaRyDrz4twkQeigOhec80gbcDGawBGQzEG2ElLx51Z4J1FnwvEJrNkfLtkd4+
x7OhjDHaMBpXw1jN4s7vKW14JjwTnslNLKSkLIi0AX3sXS9lsSaTvbmWbcxvNnZ3pctoxfe+RC
Xp9B7U6hjIdlbO7gCbbbKxbOPffdjfFam1DX5tuOcZny5y1euRrhOtBWJ0OX3rPxXJ4cE5oTEC
Hm+D2FcOhPTWpZR1RL2YKqE+BEpQEXkX4EQxSAPCXcIpjOBaiwp+PDiQc6w/o34ec6jRWRWk1x
bT/1AMZ1GLV+lC22rcpTcRfG9TB/ICs9EeElS663QckJ9TiOULRwAoqg4DAAA=''',
    "Melanophlogite Clathrates": '''H4sIAMQCKWAC/32SwW6DMAyGXwXltEpFikM7oXHcYYeq2qGXStMOHqQjUkhQSKp1VffsSwjtQE
W7GPzb2J9tzsSgqnSTCtU6m35rxTvylJwJ7W2vBuHtTBoteekk9x7ZmFNrtUqeJdraoOXFTrz+
UPawMYsCWA60YJBTKCiDFfhHllNaUBodyL1l0WExgfUJGQsWaIhntH+H7BGALBNSaqes7726LJ
MpzJ6rOZQ9X4w60lvHUJ6OwAJrdAL4FSXiR4gBK1uvgP6PsuUSlW5rqT/FjeRGMYw6GTyiDUx9
5/H6Yv/Rcqbt3y+egGhn5243c69iY/qNTusADVXY3Uc7IUWJ1yEAIjYMjHc1QhHLjUGhguC9Br
9Sw7G02gSwtZdq7FKsjqhKXnnJGscHVblScjRTsXMtNx9aVXwUsKe252uNrlxphVaBRGEzc4K/
36ILSehsrUMp8uLwiFvdcI/vA5U4HIQf3J58kF1+ATx1UbwXAwAA''',
    # Volume 8 Issue 7
    "Largest Prime": '''H4sIAMQCKWAC/22OMQ+CMBCF/wrpLEnrpowuDJK4G4cKBzRCS653AxL+u9dOxrhc8r6X9+U25f
zCVL6Dh6jOxaZ0vpkmcN/UHCZoeQJJql47DAP4qq6MMVqrQ6HawJ6kNMf9se8CAtM/57enAUce
0PFcNZRVpx+ZzqrRxrLnCCiIkEEQrUtWIESw2I5p5e2c2dXiAJGKGzoBUlimMaSxulicnuxfiX
au7528Qqs0x/0D6UNRFAUBAAA=''',
    "Three": '''H4sIAMQCKWAC/22PsWrEMAyGXyV4bkCyIUnrqQTKLb1bCh1KhzTREUNiB8ce0pA+e2WXgxs6SN
ifkf7PuzB2iaH8dpZW8VTsAnLPNIGPXcxuoj5OxDfxEqfZWNMXz70Z9Kk9XzRirVBLrBA0SgTQ
ChsA8VCI3kUbeAzl8XkcDFwM/6XdJ7RbZ6O/JbQ/oE5cZ64LlwasUXJmJYEza0ANskLUCE06A2
aLOr3KZASq4a4kG2lUf3YIeG/3mNW+nB3IlzfYMBq7tQw00eJ8IM8w+EjMw7ZkVU8rdb4f0zLb
zZm9jZ4ogS6G0aUh8W6m4TWhwVyvhv8ZNsby+AXDYBscfAEAAA==''',
    "Θne": '''H4sIALbnL2AC/23PsQ7CIBAG4FdpmG1Cq4PazcY3cFMHpNeUhEIDd0Nt+u4C1qQaGUj4jvx/bm
LKDIT50xrw7JhNjKc7aYTrxHqrQZKG8GJnDT0YzC4doKhuxLeHfVUUJQ+HbTImLRkMH4tyvs9z
AEv4L3+dWQstFfVVLZakryCeYh7WNODyj+4CdcLnHoy3LgA6gsVa8vBDftAKca04DqnbgQfhZB
crjeiTvbcyEE0QdqmAnTQBjNA4gXHQqLZVYQMcw7CcX57b5sVIAQAA''',
    # Volume 8 Issue 8
    "A Small Push": '''H4sIAMQCKWAC/22PwWrDMBBEf8Xo1EICu3IwoTq1puBDIYUeSw+utYkNshRk6aAa59sryaS0pA
jE6C07M5rZoM/ebb+Mpok9FDODfGeawPvMRqOo84rii+FmVzx5F6wcWiWpD5JEfQHeXGB3Vx+a
+6gFYoUoAPZRw6o5AogykxIrQFFmwvMUIR6BK1nvRNimYJ3x2sVg5MvHskRgvPuv7++Oz64nHe
eijq14fbj6Y8V/UqKOfXAP8CcFUgTeODZBWnMiLZr1e4jJAm+W0/an0ZLs9kp5RC6cs42liVrb
9WlLt2Nmj8Xb2CpVvPop89a73tg0eaGgBkcJyuF4HGIZF5Lj8g1PU4kKtQEAAA==''',
    "Pushed Together": '''H4sIAMQCKWAC/32QzWrDMBCEX8XoXIFWckypjqHQQyE95FZ6cONNbLClIEtQ1zjP3l25hdCG4h
/Q7Hi/Gc+ic+cU5ad3OIqHYhYqv7PKwussBt/jIfVIJ/EYW3Tktduni9LbnQWoNFhQdFnQoJTV
pChr4F4pcVeIg08u0qegl7eFzvDv/n3bjQXd+M0povc3WVeUlfuHxTCf4q1218RSDgSbesJ9YK
yd1DL3u6iSsTt6LJgK1npglQGgkoajGMN4XeYQZQXk3FTs2bAHqt+xVA7V1qPs63BCucajSQwJ
afLuXYNB/vg1SXE655gBR6zDoeV9rh6y9pLGFpti70/8uwKP6hRbH3j4jFPfRWSx6Y7HjvrGiZ
cuXx8aCob0AQAA''',
    "Repair Tungsten": '''H4sIAMQCKWAC/32QTWvDMAyG/0rweQErG+uYT6OXHHYagx7GDp6tNgbXDv6AZSH97ZNdSmEpu0
i8j6xXkmdm3JhT++MdRvbczIzXWGkBHzM7eosqWyTF3rM7xISuGfBbqsH6YDSK3dae+KPgABvg
AjhsOAgSDwCCk6LUwRl29UlHiXN21zDls0vkDN3yuZCGf8f3kw7+gE70J97RBCheFNZWxcvndO
u2leH5DtW8KKNFv7VX479L8uuKt35F7OrVq6bS9eWdxtBe6BOhQcY2oos+EEghI7E0jdUyYEQZ
1FCcnDxW9oajNKG5TCslmdNQ29krTtYkLFCb/d7Qbmmiwv3yC54E5vHkAQAA''',
    # Volume 8 Issue 9
    "Shared Space I": '''H4sIAMQCKWAC/82QsWrDMBCGX8VorkGnJkqpt3RpIYRAxtJBtc9Y4EhGlgbbOM/ek9LSOqTQsY
OOu09I/ydNTJsu+Hy0Bnv2mE2Mp5poBK8TO9kWy9AiTWyLZkSDxdOZy2daBefAoeAgBVWR6j1w
XkDiABKoFxKoT1wkLkByUQghYx85u8tYaYPxFAJifptphv9hElVs8Ld+6afPYXC60hehNQmt9z
eMfnWBzdLi4r5w4d9/cpWrxs/cFeWu9me6ahm9Efzv0VehMfXdmgpd/kUfCDWqz+vQo6PZu4CE
/NAlI4c9Klc28SKjTokdG+Wwyo6dKjF7iTsq+MbG02yHQ6s9Rljputb0Mj/E8PkDHuth/J4CAA
A=''',
    "Shared Space II": '''H4sIAMQCKWAC/82QwUrEMBBAf6XkbCEzLlkxN724ICLsUTzEdkoD3aSkyaEt3W93EhEVZI/iIc
PMGzLzklVYN6ZYL97RJG6rVcgSC83gZRUnP1CTBuJK3JFbyJG+P0v1wEdLCRK0BIUcscRrkFJD
4QAKOEcFnBeOhSMoiRpR5TxzcVWJxicXeQng9rpxDf/DJKv4FH/7pe8+z3Mwi/0Q2rHQ7unMg3
9K7fGCDuwviMivD/nLpXnrm3cthfqT3jDqzVR3aaLAdQyJGMV5LEaBJjKh6fMgZ06FHXsTqK2O
o2moOhxyy6TY+3xdPNI82EgZtrbrLD8tztzA7R2Hd0JRnAIAAA==''',
    "Taking Turns": '''H4sIAMQCKWAC/31QTUsDMRT8K0tOCi7kY7cFc5JV8CA99SYe4va1G8wmJZsc1tL+dl9eK4oUCY
Rk3mQmMwdm/T6n+jN4mNh9dWCcdkIL8HpgY3DQZwd4Y09pMB50d+Ly+cQXmgshuBYclxZiIXCX
gnMtCZGESEIUEjm7q1gfsk+oJeTx7Yh38a9hNxsfduD1Tbe6RVd0XCpOXrzoq6K8vKJcpENO18
L91n+0kIbZGZdH6/NY9ehnN+h2TtgWzwfXrbRQuDCMIkuFlhiVAlPIcxFcCvoWVUCxL9U0xGyJ
2RCnKVPe0rkl5uJvQZxCDGaqnYk7qM9xcJJiBpy8B7+BWH/zmwt5myeIP6w07ylphAlM7Idi4c
1I2Np8WL+r1jn6qeAmpyGUt+wFZmcTFHBjt1uLfaUZB+r4BT6bWzUzAgAA''',
    # Volume 8 Issue 10
    "How Ionic": '''H4sIAMQCKWAC/32QPWvDMBCG/4rR2hp0cqlJNRkv7ZC5Q+ngygoWKFLQByUxzm/v3UG7JHTRix
6k9x5pFS6camkvMdgsXppVSF6ZEvhYxTF6a6q3uBNDTc40bzHooXYPGqDfSSkeG2FiDQVPgNo+
N9zDvzXj4mNys9Wjb7EE+jsl1BJruWd3a/RXONSrVKO/ymetVL8DYEcKiVNAK+CQGCA1KI5OkY
FW3Y2IZI2vGGab2l/6hGiZcpttyDEhKKlaZOV8YqVks52SWagpTEdmr/Gbvs0ZglMtC18U787P
e0KzOxwcvqmcaez2A2wNIm+YAQAA''',
    "Two by Two": '''H4sIAMQCKWAC/42QMW+DMBCF/4rlKZGC5DNQlHpqM1TZu1UdCDgBycGRsVVRRH57z+d0qJKhC0
/vHbr3+WbeD5fgs2876JE/s5kL+lIag4+Zn63RTTAaHX+zpmWr/ZrtOmNd32q1egk7s74KqQCg
AlBSQiWEAlltQSg0WwF8w3hjw+BxB8jlc0EP/yna31VdRZ7a4n6g/Si3boEWSyEnhBtJDskJlH
uSiGKDf3SEBzwbdoeEMJGqICqZqCCPr1ayIIGSQlEmuKeEU6YzFZFKyZwEZDohkMuJ/w+xIN6u
HjNTu5POEjlOvAsaJwc7tNplv/9LjPx0oRc4PeraNV3cN9Rnyt6/LDtMDCWmdfCddTF/NUHrSb
eu9nHQ9sdjj5fwU9y5/AABJfH/NQIAAA==''',
    "The Gold Standard": '''H4sIAMQCKWAC/5WPQUvEMBCF/0qY8xaSsija03px73oTD7GZ2kCalGTmUMv+dydV0RURvQTme3
lv3qzg48zUvKSIBa7VCnp7N1rBwwpTCthzQJngNgXXHbgz5vJKa9gp6BNHEunitFPnfw9cKNvg
eXpztHr/3fIoJjC/bjwuLqdnjN1RIsx5gGkloUYkpp+u+Ftzoz9b/Ku/GKvzKUWHufmge0GjLc
3ABbPMlBnfUZmDJ/pKaZm3XRkL2tyPNT7aaWP3I6raWt2Rjc5mV0XLNKYaADeBERd02VIVnB8G
L9VpEbE9vQId8WZN2QEAAA==''',
    # Volume 8 Issue 11
    "2 of Hearts": '''H4sIAMQCKWAC/32QwUrEMBRFfyVkbTEvZaCYla5m14XgRlxk2ldbaJMhTcBa+u/eBAWFwU0g57
53OckuJ3dNsfr0jlf5IHapylloBq+7XPzMXZoZN/no4rR4t5nniyE6kVLyTsjOJxcRkz7eDtzp
3472Y3tnZ1oUNDf2c4FP8ZbV75YXOzNk3BQZMuJetEbVDSmjqCEyuka3URqKZKg+EZIijAgQE6
TyXK3zHOm8qVXJ6+8x9Py1U8Xt4l3PofqhDdBo12plt/oAEENisLhdi2fglW3oxtzk7FKYFn4Q
Z2B8D7BNcSyr8mlOzBv3wcYc9NMwTHhw3BDq4wuBS51TrQEAAA==''',
    "Miracle Cure": '''H4sIAMQCKWAC/22PwUrEMBCGX6XkbCEzK2GxN3vxsnj0IB5iO6WBbLKkCdgt9dmdjIoKHvLzzw
fJfNmUC5eS22sMtKi7ZlNaUmgFz5s6R09D8cSTuqdwpUBd/67NA59Oa9DQaTDIiZIH0LoD4QAG
uKMB7sJROILR2CGa2itXN40aYgmZlwDuL/vOIJb8n9tvn34dfJzpzQbijF9mj59mR97BZiBmwP
1wFLPKf8y4C0fh1QzEjHvlf8y0eL3GMFJqv+kto9ku7VQWSjznVIhRXi+imGghm4a5PhTsWdjJ
JTt4avqSqHJb8hzrXfXk/HiqaHTT5PibeWWM+wfNr2djqQEAAA==''',
    "Oxygen Snake": '''H4sIAMQCKWAC/22Ry07DMBBFfyXymkjjcR8R3rJi00WXiIXbuq1FakeOLbVU4duxb0EUweZIvv
dkRppchfNDTu178HYUj81VEIi0Bi9XcQq93ebelpdY536fY/PkwtntrF6vPog1c0ekWcpFeUjZ
MYmHRmxD9ql8I3l6naYShJz+W3U/fnW+HKxv1t68WV1mqzqeqJOkJcigoo6kVvK2Fi1IhVITIw
EZVAxfwVdoQVLwZ0hABtUM/hz+HC1Ic/gLJCCDagF/CX+JFqTKX7cgXOJoxrY38WDb201Kk2K2
pdkEv7Ox/fZnX/Jo/Rjij4Zs6F1K9i5NlwFXjHa0Jm6PdbM3pz+XrbnJ6YiJ4tnUlZvs+lSLnd
vvXfkf6VJKnj4B6qsKPSECAAA=''',
    # Volume 8 Issue 12
    "That's a Relief": '''H4sIAMQCKWAC/32QzU7DMBCEXyXyhQuRvE7iBnwChMSJIoS4IA6m3ZBIqRM5zqGt2mfHu6E/CM
RlJc+uNd/MVjSuH0O66RwO4jrZCsmTVRLetmLVtbgYW4wv8dq4dZvchxq9udvL/GEv9dxIpQGM
BA3KAJQgjQItlVGTnoGUBhTNjKdiRUqQYBRNcZmIRTe6ED1A7d538Q3/gtyi26BDgtAEQe4Kor
s+ukcqUpghkkSvyRFOvge27Ej1i4RQujH8VdI5z80Cg101rutrdERVzvdSPUa0KwOaoaZZUEkq
JxzIGbAg2ExzPQUXU0C8lDlPXVKFswlwRr8y0hWHy1QpOS5QdNY5Fp38jCI5SG2HtLX+E9MpUt
wEP2LcfHRuiT493Jffx9U4oD9dkRSwxb7z4VwP655b8Dig9YuarJ1dsfZS23AxJDZ5xrbBilZ2
DHVH38UTVhV6R+Kyqaom1hnWcZHtvgCZy5pJmgIAAA==''',
    "Headaches": '''H4sIAMQCKWAC/32QMU/DMBCF/0qVmUh3dhoCmQpC6taBETGYxCWR0qRynCFU7W/n3aVICBCDT+
d3lt+775S0/XGK6cfQ+zG5X50S0qqqCC+n5DB0vpo6j1vy7Lq2mnFWm6qty8cL3W4vlO8uZEsi
Ji6Jc4NqtFomKll15pzRm5zRq26IoRjopjQmxxu76LaAbjknU1oqRDcFUXKzSqph6iNysDm/nn
Hnf8M+xWbuh05SGqQ0O4QTS0SxizFsjFhahs0vA3EYpvgXn+82m/HYhrYXmzvYFICRCQz8fvUj
WRGugkHBWFoA6OosSK4AWIFZ6YFBaqbvMwAAzsJguvSZwlsrzrX2uW6y5h+oSPdo3Jh2Lrz7dN
kIkxgmj8nb0Nc+pF/vM0hxPupmwY/ehaqR/3p3UG3rXe2qBjQguik2QxD5oZu8n30dXJRB3e73
LQDFGUN7/gTfGd5uZwIAAA==''',
    "Under the Counter": '''H4sIAMQCKWAC/31RTU/DMAz9K1XPTLOTLSv0NE1Ik/gYF8QBcQhdRiu6tErTQ5m2347tgWCAuF
jK87Pf88surXzbx9Fb412XXiS7FKQKysDjLt02tSv62tErvYzl4Ic6uQtNO/g6uXKRJvPFAczy
AJNVrgABcgSDkAMYjblSBjFHzBhXgqNRhCMC5loxX2muoIyG9CxJi6b3keRQ7Z/29MZ/Pc0LF6
simRfVOl+QC71YrZYkQvvJCIsgioWjFLIFBRmoD3FN1vCXLOs2ffwrnO/idzZY0reEcQoZ6Z/f
rg60nC4WUaPkMiQ5fTQgVVIBLXUiNsQMaslGs0mczLgrOXFwtGea0TacGkZkioJm5kxmDT1ODg
E5o7TdqLbhxY2OB1Enht5R57nxaxdGn/zsg9w53zXhi8bYpu/cD6hr6yrGn2h0tWubcILHoZW0
guucDUXJJr3dCnbPFpJYumTBNmiMmraPpThIr61/HcYFjfnxQ1Wvb7i9rjabir4gDkTR+3cqJQ
kyxgIAAA==''',
    # Volume 8 Issue 13
    "A New Beginning": '''H4sIALbnL2AC/32SQYvbMBCF/4rxeQPSqPHG1SFk0w2Blk1hL4VtD8JWNqK2FGSJbhqS394Z2a
FxN/Rg2X6G971542Pula1dOzF2H8Pkt7O6yz9mx5ylM6kkvBzz1jW6io3Gt/zZ1Sa22XNstiro
uXxSZwbfIxOq3JzZB8nZjIHkMGNMAqeT8RnnknNgeEk6GZcM8MbyuyyvXLQBneF0l41RX11QXT
eifR7DrgFoXPbGJWp9gCFMj/4/bKW9d7H7i1rpfwYbBrh2HvOhSHy8jQabnX6cEJdvzZuub7ad
P4adsq6Zy2UCis36zAr0xY6QRH0RHahG4FRs0oAXxE2KwCRcChhK5eS6aLU3FfYnFy0alFP8Rk
FcDLc2ft3GWjWOMulLpHLZrB/86lKJwHBlCkedc8BwVEofKBWFYfgQ9Z6ygpiOa+HsNAQdo5ff
kNkgaABv1lR2v2DyA/Rj/TZwA1jKPeWAgt9wh3fuj5/msvfFisUSD1h0CYeWQnB2aTU1PIwA/U
C8HwWfeyRtB0RqH/i74Ygf8KdSxqIwxbdWvU28VlVwnnovUNqpbmJj1WjlUQk+6kH0ujqgfKWG
wz5NsPeujlUwzhLQqjapi+xJ/8oe9Kux1thX+qRi2DkyyL8o+/NAUm22W4NVhAPK4vQHTcC15Q
MEAAA=''',
    "Discombobulate": '''H4sIALbnL2AC/51RQW7CMBD8CvKZSLsOUFQfqjYVAqlSubc9mMQIq4mNHFsiRfD2rg2oUOilh+
xmxvHM7GbLnDSVbTJt1sFnX9aolt33tgxSTWwk3rassbUqQ60IscdS+a5WRoliD3xKjwBEBIE4
ykFwHNF7TgSwfo+VNhhP1wa7fu8PnQdRvAfIZX6hxYH/U+0gdsqW7p7pUSfF5HKp+LEjUbbUG1
Xd3AibKOekV2KiXvcwIIlxDApjMiH5EUeBfAzRgyqLYjb4W5s9zz1XxdNP5NG0qPcwJFWKSYKc
H+LmgHdwSk8z8QTxeJqGoxSpIgqgr+OM/NAwtasdIsSIeJ1oZdv1yrrQ9ma20pUSc9rjLI7M+T
BPvoeGOCQ3BEIUlVBsCf3yiUY+bk8bIoaEGrnJnJKlt649UivZZiaUtZKOGO+COpJOlR3RZ6zv
1inq2tkqlF5bEw2NbBL7rNvSNgu7CDX9rngig6eB4tmLNJ9dpCq9XGoa2XdE57tvz6qi9wwDAA
A=''',
    "Magnum Opus": '''H4sIAMQCKWAC/22SQY/TMBCF/0qVC5etZI93s0AOSHDhAkXiCByM7dJIiR05NtpQtb+dN3aKWl
RFmXjeZOxvXnJsovY2jNveTzlt/wTv5ubt5tiIEovKwrdjM4bBmTw4ZM2X2WUbzJLC3HvXfTiL
x49n8fT5LNTuXScE4ZKdkCSUpE5QK5EpKUQnUUG9k6hJiZxakp0sNSjoIvnMET2iU4p3wpOwE1
SFFtk8bBoTsk8gaU8Pm3toOWrTDxewR4DRDjezyULGp1YiQc+gk0WXsi1MzAZGxazMVZn5dGTM
gg5a2ahMAjZC9Zbtxwl4zb5/cfauwSus7wHrGbYtLq6khbESESKxJ8y4ni+Kc3WeSk/V4ZWrTq
dqlNVbdZmEXsNHhgs53fvwN44e+iHMYTq4+GrefE14tfuehTCOo37zb03WXOnqssbRlj8EWFvC
FKIVdRZRZqj/BNHqO1VHQVr+H9BeeypFsTS5GHXvITwhG/XLNjptUog8QwvpoOettr+1N85CSj
G7VfXZDE7HW3HOk4s/g7fuv0J0ZsH7V2papuLKFIPNJvXBM5/XY1E/6V8+j5vdlGeWdU6HwM3N
+yE7tzgbdeKC7ff7HganBUV1+gstwek9hwMAAA==''',
    # Volume 8 Issue 14
    "Organic Fusion Chemistry": '''H4sIAMQCKWAC/4WQT0vDQBDFv0rYk0IDs5s0FXMqRfEiehcPazptgulu2T+HWNrP7uwkxSqKBB
6bt7O/eTMH0Zl9DPmHNejFbXYQwMpuMl4OYmd7bGKP9CceMbTaYL16OEFZg5QSagn01VJWklRJ
gFqRDWKWicZGE+hdeZxl30HLBsPQY0KdQBFNnWmyKhKhonPxP+duyjNCqr8jsaPYUez8An89El
/YGH5byWXXZ9sPtIlxgKupeXltajnnliW3KVMbqdgZo0BSmKeIULIWrIqVowMkTXGnPU5x1Zxp
BZMLPlfMXKRNJTDpgt9WXL/4MZ4Enq7VPu+122I+zkk3wUWkmzdr1ujyc/3NVOzReOu+ypK3iR
4vrDDseS0OPWrXtKmt0Tv2ntxWm67J7qPvrMlWLe46H9yQanQMLaPFsn8frEneuttsOtpzGMgv
jp8kVUntoQIAAA==''',
    "The Soul of Iron": '''H4sIAMQCKWAC/31RTU8DIRT8K4STJm4EtjUbOZkmmh7MJurNeKDbt91NKDR8mK7N+tt9sBprox
54D2aGYYAD7c0uhuLNGvD0mhwoyzWjCXg+0K3V0EQNuKJLZw05Wy7PSb3v1yBvoZaciyvBpOAV
Y/SC0MZGE1DMxfgy4pr/61jvhw0YWb8zgU7Vn0bJycbwW9hju4e4GsjCDT4oLW80uSQ1joWTjP
OS83QEZ5KJinEppooENlZmns2xYQZsDFs5cbMk5PO0VUzzUsz4z5AsR+yUL7RyGyimsMgEFwGZ
lTVrcMWXvvoUezDeum9Zwtro4QTyO92HcIyGYZdv7MCDck2Xwhi1zdhTB+TRRk1sS9KXJU7F0O
WD6F1Ur+rebgGDILHu27bH9wsDkuX4AYFmi+MTAgAA''',
    "Serbalcide": '''H4sIAMQCKWAC/32QwU7DMAyGX2XKmUpx0nUTOVVcdkBw4Ig4ZK1HI7J0SpNDmbZnxw5DDGniEE
v5bP/+7aNw4ZBT9TkGnMT94ihkiYUyeD2K/eixyx7pJ9oO0+wxoHk4S7WhZwAa0AZUA9IoAElR
URR3C9GNOSRqA3V6O9Ef/tXeoHd5bzZIkuqGACuMOd2yey3T+6r1NriAizYMcx9dX9w25BbOUj
6R6Wc2rsg40Cxg4xIkGH2xX7haUZS8kdGqcN0oMKpeMdFrIrpmDnWp1w0pSL1WRJZM5JJ7aQj3
LjnKmsifvWTZarBT5W18x+p7P8qkmJEy2zH0GKuf+vWleJcnjL9VjKaDdyld0zQfykEiTmhjN/
DgYPeFvWDcWt/RaZjanIaRO8WjDR8zo97tdo5OmmbC+vQFUDFU+SgCAAA=''',
    # Volume 8 Issue 15
    "Precious Tears": '''H4sIAMQCKWAC/1WQwUrEMBCGX6XkbGEmXauY0+LFy6JQwXNIp24gTUqayNal++xOggclMEy+mX
/mT65ishcaW+uXnNrv4GkVT81VAEcxWPdFUR0/FeLhAUDsd40IOf1vlTXOwZHJjooO2yG7yfrN
LTEs5Ek936B7uUH/OvCoHlHJGhH4KEBEUCgRQMlKOqy57CV3diXvWFAK3SPbYBcmZJ94F8JeTC
WKUVvPQPJt1pc2kjYpxGLxntFZr63PxpGOTFLM9AsjmY3xH5q2pb6CvY/ZJBt8Wej1XOkbC2zI
a/POo9ZS0TmdQ9GLD+vGU0GjnSbLv5G24mj/AZiMJB5lAQAA''',
    "Desperate Measures": '''H4sIAMQCKWAC/5WSQY/bIBCF/4rlU1faSDC27Gw5Rdljm0M3t6oHak8ctBgiDNWmUfLbO2Cnjb
fpoRdGjM287z045U6a1vYLZQ7BL35ag0P+MTvlLK2pGxtfT3lvNTZBI+3ytbP2FQflUazDhS1f
8MJKwRk8cS4Yp8IEh7QDPpYCnhgTBYyF/mRcFLwoqfCiKOkAMCq046lAOp4/Znljg/GkWp4fs3
9hZB9W3YNYdZGmvkszTZ1oRqk5xsQWuW+gRm6Asv4fmq1+EFv9N81c+BaKXTHexQdLzn+zTTQj
25zm25mA8p16w/buZeYb5Z3t0IjNhQFJ1wXN4zVLc3gyIN13a7IvynRifWEVMVRAaqwCIPIqHY
srjCtUdDiq2uDvvZ7bcF5Qo1GhzwxhqBZFimUzRpOSZqN9mN4EjE1Wp9TqGAzU8UJgQr5a5+w8
GZgrPqtB6R/oMtmgP+qouerI+jraZ7ys06uoUgpVir+8OxnuTPZ7qXV082f2Vl9nF3zJWfRDNz
eTeDc7DvfonFQm3iDtevm2cCgbb13MsaLWXg6LwUtHP1LHu4BT02FzbPRt1x8PCe/gbBsar6yJ
gkb2IzQOB3SSHudnlENwdFP0VQa/t3FG/gnJh8fYbNVup8isP9IHOP8CL5WrYyQEAAA=''',
    "Hydrocarbon Stitch": '''H4sIAMQCKWAC/42QMWvDMBCF/4rR1EICd3LwUI3OkCVQ2rF0UO0LNjhSkE+Da5Lf3pNMadKWUg
1C+o739J5m1btT5PW7dzSqh2JWkPdME3iZ1dEP1MSB5Kb2xJ11ZOrdBUqDssBorACN1ghyBgRU
q0I1PjoWRXVeFT8tekfFk237xg5ideUDt9pXUSv8M1Ftw5t3phaTb3LUok8GPvJvHa9dHv0wSa
5pICl3V19AS8HNvTMIFaIByAEhVcSykjPqxOXNNC3TFHTelypl/ozlSwTc5oKvVv9sArmHTFsK
60+6EdTZcT2SG30QwCGSMJ5O2S/QSDY0XXJy9pjZbmqDb/JDxTP3vExt5C47qC3tLXNibX849B
KNJ+Hl+QOfeqmUKQIAAA==''',
    # Volume 9 Issue 1
    "Prime Time": '''H4sIAMQCKWAC/22PwQrCMAyGX2X07KDdBMGdZFcRQW/ioW4ZK3TtaFNwjr27aVEYYg4J+X7ylc
5MmTFg/rIGPNtnM+OpJxrBbWaD1dAEDbSxo8JehaE6qqoQJedsk7HGBoMUimK5LwsBG/Cfc+25
2DZqTvKga12JWJyMoqRRCrH7MfPkfVjTgsu/dEuolz7vggdHO7oAH+RHrRDXFKcxPezAg3RNH/
VGDomdnRogu1KLVAbsbbxktTUIBtN4Ysxa1XWK/oAT5cXyBuXqIVk+AQAA''',
    "Water not WAtEr": '''H4sIAMQCKWAC/2WPsWrEMAxAfyV4bsA27TU0U4eDbjfeLGyFGBIp+OTjriH99sqhkKGLhZ+kJ2
k1Q3pgbBMtRdpvJryZj2Y1Vl9zBcHcXz/lnHvr3l+d7Z3r3jR4d+qsNdtLY7jI/9bVzDxhKBMe
nq8f6y8qcHt/Z13vvVOJOgIXEq10dqtKrc6QSIHV3wyPNiME4VwHnBSNcGsh3oECRkWSC/5RKm
FCyAeU57LvsGSOJUhiqgMJ5mOzhlia/cqagiIjV4EJI6LAWGFMw5D0HHlqwm+/CYsFOjYBAAA=''',
    "Carbon Products": '''H4sIAMQCKWAC/22QwUrEMBRFf6VkbSFJpYhZySCIILpzIS7epBkaaJOSvIC11G/3JY7D6LSF0J
wXzr3pwgK4zo+1dVPC+tM7E9lttTBe1kIzeFvY6Aej02Box14BTVAPX1w+K0EPV1LccKGkFJyz
q4ppnxzSSSHX93Ul4BNuBZxLnwz24Izakfda8aIVnF6KaAWtWU5B/yN49osL3T3282Cyj2oW5U
kmT7JCpGg3uxexvBDfaYN/zPK3rGibXLCl72ajZtbRfwtgHYGGdiN81MGARh/iEfUQ64gQ6CAR
DMkcoUt6MHAGcZ5Knyn4Lmm03uU8B2OhOwh776qXn2HMI0jY+yxgjz7sY0MXzrizh4Oly+FMI7
l+Ayvym3ATAgAA''',
    # Volume 9 Issue 2
    "Martian Respiration": '''H4sIAMQCKWAC/32QQWvDMAyF/0rwqYUVJKUUs9wLOYzA2tvYwUvdxdDaxbFhXWl/+6Rkha6FXS
T7Ofmk907K+UNOs+/gba+ei5OCoQ6qCG8ntQ872+ad5ZuqY/CTuq6nRfPlNraaLO0FqLlAOeVe
EdICsEKiBXJDzZVIA1RYaoSqLOVMJS2IG2j+FkDzGYH/APVUqDZkn3gU0vn9zHf8d5+V27k2+G
rleBrO4REhjJDTX5Mj9AFkmNOID2HxVoCyG6G+44JA4YHxG85NNg2nMheLnAOQJDCmMVofTV9D
g5vs7sfJvI/gNzbOrqpmqTP9rLe+D5GFFLNlLR0PwzLR9tbEthOSN/tBezExOeOLV9sfXDTJBS
/PJqduQKh1yJ/dupOa5GXjtlvH9tJR9jj/ABmfrwguAgAA''',
    "Blockheads": '''H4sIALbnL2AC/3WPT0/DMAzFv0qVC5dNctyp2siNiTvSjsAhtJ5a0SZVmhxKVT47doCJvxfH/l
nxe29RnRtT3L54R5O6LhYFuWYq4H5Rg++pTj3xpO7arveTH1sKV1NxivzNPCQo7UHqYZ/7Mve7
4yvsDECFaBAqQANYIRjECsBoQECZNELJO80Dt0YKAKpNoWqfXGRRjevjujLwKf7l9au/ow1P3h
U3va+fTTagdTagqyxyMfBNAOS6/nXstqeBXPy49l9MVpAoeImCEkUi8sspfyiJFFtsKGw/6Z5R
nMesGWgiG+pWfjk7ZJb1W7LNJNSm2PrwzhPRTE2wURZNdz537D3OvMT1DaKiffjbAQAA''',
    "Greed": '''H4sIAMQCKWAC/32QwWrEIBCGX2Xx3MBoF9zUUxZKr3vrYenBJrMbwWgw42E3pM/eUSi0sPQyOh
/6za+rcGHO1NxjwEW87FYBtVZawHkVU/TYZ4/ciVfeUsqT6XJ3NVLqVoFRcq8BxNNO9DEH4nNS
bR8b9/Jf2clbcoFlJyqqwwNHkcRMjyL+Nh2z966KvuC5y6VcuRgAfZDSSNAtLwo4p6yjSqfKRA
6vW4bAbygnFS9gQPGFv2mgZvmMYcDU/NA9o9EuDaHHOSbCxJD/B5nTba7ZEi5oUz8WW7BTZW8J
cSjAZhpjqugdQyGDu1wcv4tuTNX2DRI/NtWhAQAA''',
    # Volume 9 Issue 3
    "Comet Chemistry": '''H4sIAMQCKWAC/31PwUrEMBD9lZKzhZm0LsUcy6IHYY8exENsZ20hbZY0PcSl++1OZlkQFS8vk/
eGN++d1Tif1lh++pkW9VCcFQgKm4nXs5q8o251xD+1j0NyNFNhXU9D6sm0F6ieLlAfDGgEMHhF
3CEawJ1mBAQ0mhkwFWZVQwNa3RWq8+sc2Rf19rbxH/89/mIjBcPH9IEPsBObNtk6n/xll/38Gv
9q99300aWOgne3Is2BX26R82MlWAuitNBNbiEddSVzlWfuzjNUgnVGvJedWnbqnwFB4g12KZ0N
H1Reg7ISw0qsvPu5p1De9mumYjpJ4EAL2dAN2W+2k3CtnygW7UDTuMSQsmTXOPiQxWdKboyUyX
48HkduHhMLevsCmxbMSP4BAAA=''',
    "Ferrous Wheel": '''H4sIAMQCKWAC/32Pz2rDMAzGXyX4vIKkgQ/1bYOSN+hh7GBSZTGkdvCfQxqyZ69sduhY2cGy/B
PW932bcn4p+XALnpM6dpuCVhut4GNT1zDzUGaWl3pjf2PP5v0bdC/HACCgAdQklVp9RQCDjSNq
lJ40St84NU6ogQyRrn3l6qVTQyg+iwjS/rnLG/910q+XGL7Ym162PdtQV4SSn6V73HPiGENJ3X
lins2JJUuLgdW1+JWrWZULJKHMaqA6+6UITW+y6TCWxFFQjoV/UFpml/MjzevS1CMntnGY6i5v
r38d1YEteQr1szrbdQlOFIVe3Dg6SZFXmdB+B8l6cjbKAQAA''',
    "Barbituric Acid": '''H4sIAMQCKWAC/31QwWrDMAz9leBTBytY8kjDcup66WXLaQw2dnATlwbSuLj2oS3Zt09S6Fa6Mo
xf5GdH7+mdVNvvUpwefe/26jE7KS0oLBMfJ7X1natT5+ikXoOz5aKavCy/NN7RLkHTKlEXVCPk
oEsDM2IAZkCIoImRN4ZrdZ+p2qc+UjfA4XOgM/wr+Ww737d1Nq/bplyw7mRRVctRHHNAEQcWR0
JiCI3IijiYgmtg1FiQQQ1sB/jzxw778SneyuTS1JMNqzamcPa1ZZOHLnE8Bnl+I4mAoEaQXHLJ
JZdcBMUmjgmKTRwHouzovbnOS/+mdWnmzUYXSk6movbFT+yset2AO6x837gwPbMPRMXDTloFt3
c21Bv+q7fbW7PylU1x4wNfvncpHplq2vW6JUfxQLQZvgFx/oqzWQIAAA==''',
    # Volume 9 Issue 4
    "Really Easy": '''H4sIAMQCKWAC/52PsWrEMAyGXyV4biAJ5aDN3Bs7tGO5QbWVxmBbRrbg0pB3r206tNDhqAeBPs
v+fu2KIRjyvQ1Rcv9JAZN67HY1tNpoBW+78uRQi8PSqVcyVnx3dkJsDc7PcJ7HeoZ5Gh+GQd11
SpOEXIbH6bgcRwGLvaL5U3TTf+NNg1VEkn87plb/vcDQ4mdkBhsKuC+dh2vPCDoTV8epoBVSH0
Q7BC4ks+A3TBKR3ykY/HGRt9iSRCYjOlsK1RnAN/qC4NzWPUHaKgbJK9XHKkX40Cv6So1dFls2
yltNeXwBL+bv6MwBAAA=''',
    "Modern Alchemy": '''H4sIAMQCKWAC/12PMW/EIAyF/0rE3EiQ3mUoU5fbbrnlZgpOQUowAlxdekp/e03aodfFT3zPfj
Z3MYUbuD7ERLX/xAhFvHR3obiKE+SMVLqrB5j1Cb7kqJUaRqW0GlikHn7kmUWysCeVHlqLFNtT
J5DqY67c64IzWJqhLbl4dIEWffGcfThKKXjOIsXKrpJbi6l8iAmRwZFfi7n1GYytmFvoyMib0h
v3YaIFx6hmgl8ayc5g8iMslCC/YXTwz8hgV+7/Q+ua9jNTRke2BoztvmiWnZ6RI2L3OlsPy9oc
Q9VjmxclmfeGG3VhmgL/uK7sDNs38iWk3nYBAAA=''',
    "Gem Factory": '''H4sIAMQCKWAC/62TTU/jMBCG/0rlE0hbyWOvUEVOfAi4dcVhL4iDm7hbS4kdObZEtwq/fWfGAQ
Ittz3USl5/PI9nmoOIxjehWzrf57T8G7wdxOXiICSPnFLwdBBdaG2dW4tv4t5tNoNLtrpqz9YP
569SVwpAA1RKriRUGlZSVgArkJWWgAn+8BkHHJXipVrxUg24VGneoGkaFG2TeKAUPxaiDtknhI
Ian8cRg617sc1JYXEd7K4rXmsSI+xkNZngwfwMk25RBJ7gZyhyOGi2YBfNqxSbcvJuXRyB4LfO
DH2IR/BShqk+RAeqg5RcJfg4Vr7DiYojM4DZqujM76GpZIIKEnI61bx5w25CzL7JHbq9SrWmhr
Edt0RTf9RUj7klXxW4NcVv1t1PrZHjVITP1EfbLI7JlzfxA65+/h+4OoL/yrFv7Sn+b+IeX/rN
6Rt8+U+zxBc88ZON0ThPAb515mUZralTiNSRC4x2Zlj6XLfWRExSzHYKh9zbuAm+sV8moq33uH
6Wpn3PV+tjaHKdXPBk4k1XPkrbLe6YuafY5LQLtFkMvflT72xHaeO2W4clSnuc0eM/SP1v2wAE
AAA=''',
    # Volume 9 Issue 5
    "Unlikely": '''H4sIAMQCKWAC/22PwWrDMAyGX6X4vIKkdKPMxzLoraexw9jBdd0l1LFDYh+ykD77JIfBSotByJ
+x/k+TakKX0/onBjeo19WkoNRCBXxOqo3e2ewd39Rbqk2IXu+uQPsrPB/2GhARNAIfjfiCXAkB
NBVChVAhFW6ZVNKrp5WyMYfEQ5Hmr3lmEHN65PI/fzdaH485meDEYcMO2wcGQEJuDKrFQCou/W
JJizHXGycQIbzL/zDJ9ZpT6cBRJaQsRXdLQVnpGMPJ9es/umGUxq6M6t3gTG9r+RVMW9h78M3F
+VGYyamOvdChM9+2dq3QU3M+N2yTRn6h+RcWfAmqwAEAAA==''',
    "Chalcogens": '''H4sIAMQCKWAC/32QO2vDMBDHv4rR3IDuXIqpptIM2TJ46FA6qPI5FtiS0WNwjfPZK6lvErrcoZ
/Q/6GVaTPHsHuzhjy7r1bGyyw0g+eVTXYkFUdKJ9bSSMZGXz0o3YnDmWNLxzOvBUJ9iyBqaDgX
iGXyhoMADsAFYJrspmLKRhOSEuD2sqUz/Gt3WDpnT2SqNo697ujDUQBkzSR5lwwQgV9KZ20bw7
VuF310nKq99p8WLbXJpBTKC5NJ7pIW/nHhP/F/Kz7JQK7kPH7nbK7FrHkJ+WpNR273RZuEwjIX
KUeepFNDfmXkVNjjIEeVv8RnKmMYrMvcz/KkBpoy7XTf65QnLOkGt3e//Jcx5AEAAA==''',
    "Chlorine and Ammonia": '''H4sIAMQCKWAC/31Qy07DMBD8lcjnRtp1EFT4VAWknPoDiINxXGIpsaPEOZSq/XZ2t4UWgVCkST
zrzGMPKsRxyeVHin5Wj8VBgaCwTLwc1JB675be00nhSpdPwXV9mpLPnY3e1CfQzQnu6p4+DOI9
otGCgPiAYCp6ARgEeow+o0ZmGNWqUC4tMZM86uPrkc74b4bNMKQYrNmSa2XYgw2/Bc9Gv2RZNy
35r7K34s9SquSebbBDuBZcb6/9UAtWXA+BAwCVBWkHlzDnjrpipCFNQQvSPn62hmvn2yjNvp2S
rDq4YuNCa5q6pwBiJDu9VdEgFd9SbP1UfrFrovJ+FL3Jz95OruO/oh2Eq0U++sLGtrgslud2yV
2a+MY82nfX+YHZNux2geLlPRsePwFS2zbaPQIAAA==''',
    # Volume 9 Issue 6
    "Combustion": '''H4sIAMQCKWAC/22OwWrDMBAFf8XoXINWlBCqY1rILcceQg+Kva4EtmSkFcQ1zrd3pVBoaTAsaM
AzbxXOz5nar+AxiZdmFbLeSgs4r2IKI3Z5RH6JN7LLiB714SbV8SafNUj+NMBO8VUgpVaVKNiV
W4h4akQXsic2gNo+to1ByPQo/Dt2MPESfPPqwtX1nDxxs5a4AXsuSdirv3ZZ1PDP9G4Io+a96s
QCgLvg0TxZx3G2x9j+UMXImtQOOWHkN8WMjGiZqz1iQhM7W0TeTPftYbrkRC74Qk0mG8qfIs3m
s7M4Fdq7YXA8kZbS2L4BcFAKPIwBAAA=''',
    "Low Power Polymers": '''H4sIAMQCKWAC/32RMWvDMBCF/4rR1EINOsmWoRqzZOiQvXRQnUscsKUgywQ3pL+9d1cKLYQO/v
z0nvwsTld1iuel1B8p4qyeq6vSQnHZeL2qKY3YLyPSSm1Cfk/RbzyA01o9VapPSywUgbm93WgN
/36/Xfc5HTH6LTXAnQauSEu5d6bfPbs0rliGNaJ/2Hxqs6XnMXronNFed1TtbUf93rQOwEPLvr
GirWgQDaxBOwOeQtpvW2EjtEIjBKFmas39GoRGaIWNsBU6pqEX0TDB8F9MI7oR7UQ70R3pP9PQ
MoshzPUY8hHr76lQUvKClNA97DHXP/sNWWU9y3QyzhhyP3BfDJN4L+lS7dIFc8WzmzDPnIalDC
lzPp/DsR9wYnd/OhxONOqyUmJvX9XAcGMlAgAA''',
    "Photosynthesis": '''H4sIAMQCKWAC/32QQWuEMBCF/4rkvMJMAiLN0R56s7ceSg+pZteAJhIjaMX97c1ku1Ta0ktI3m
S+92Y2Zuw4h/zDWT2xh2xjkM6kkvC6scH1upl7HV+sUv7d2ezRuMW0Wlb1FbhELDhIjiWABCw5
sFPGGjfbEFuQ7297fOO/3BcVtJdPkVZHHOINh5JzhN844rk5/BX8COUnkbemW1vvlnX0blRW9b
K6gohGRYwuokuB5EInQowukZfkLpCG4ZRE8HS/pYL0E+mPQNIF/EwI3+Me09TLetFWfm2svG/s
2CogjRY33Gqf31UepbCOCeL1pJVvOuqyakjac+eCm1YbOj2ZiSpqDp3zVJtGdWk6PZDamvPZxD
RhJav9E9HmwUH7AQAA''',
    # Volume 9 Issue 7
    "Break Up": '''H4sIAMQCKWAC/23OQQvCIBTA8a8yPDdwi6DardMuO3aKDubeprSp6POwht89lYIFXYT3U/+6Eq
mMx/KlFThyLlZC85o1wW0ls56A+wniRDqQqMBKPzcdNnVV0ROlZFcQrr3CeKKqwz2ECNrjv/A2
1i691SOops2ln86B0px5aNWDLb98jCSYKwfvwMYZrYcPOTNJxK3iYvI7Fhwwy0XqKzZnu1hgz+
JqkjGPQqd7xBk2cgFz0l4Og4xfxSXu7MMbzDk+HCoBAAA=''',
    "Chemotherapy": '''H4sIAMQCKWAC/31QTUvEMBT8KyUnRQvvpZUu5iCyF72Id/EQu+k2kCYlTQ7r0v3tvlcruijmMC
Qz72MmR2H9mFP5HryZxG1xFLDgwjLxchRDcKbNztBL3A9D8DYPxWPw6unhBPWVktggKqQDSkoE
UBUySkBAcV2INmSfqBvl/DrTG/9dse1diHZnlhVbV9J8bAB+DeJJIae/3J+Ns9PodLL+Tj2nrT
uBvGDf1SXdFFbNhrxDRRHIcMWLFMolT80IklNxNFyzyZoRbxihJuHMGCy2ej2VTse9KT8NkpJi
NqS8Bb8zsfyq36zFXZ5M/K5iilzblH6y6TAuiaKZjI5tz4u9HtZPM0NIvYl6PDCvc+oD94pp1P
uWVGZ3tussfUw6kFLNHwcJHtv9AQAA''',
    "Stuck Together": '''H4sIAMQCKWAC/22PsU7DMBCGX8XyBFIrOUGoQKaqDJG6IMGGGIx9qS2SXGSfhxCFZ+fiUqlF9W
D5Pvu++z1J3w+J1t/YQ5RPYpIq75ku4H2SHbZgUgtcyXq0AY1rMXgjtsbbqt61VcFLVWVRbJSS
KyENpp74+WZeicv+FyQdo0+d2GWJhWp/FDxeNdzPHzNLJCa6FvMimtiLZ29O2pq9P6o8z1ZURX
mcU/6fc6fymE/sLYT1iT4wcjqumxQhcE0hwR+KQ+uJzimNQ84RIIIOxi36XneZvVIyX+IND0CO
e/hGJ3K4dMs46INx0ImbDq1vPNjb5QEfG89/o3GJN/8CcL4GG6kBAAA=''',
    # Volume 9 Issue 8
    "Antimony Mining": '''H4sIAMQCKWAC/32PTUvEMBBA/0rJ2UImxUXMyYvgwVOP4qEf0zbQTpZ8HGrp/nYnKaKri5cO80
peXjZh6BxD+WEJvXgsNiHzN9ME3jax2Bm7OCNvog6mJRNQ1+1FqvoiKw1wDwBaAZxA6oo3CbpS
cJJSQx7irhCdjRTYAGp/33mHf695cZb0M/J5laTqGBWPG7akszHcesZP5xMFs1haOf1oZm+KvR
bK77jfQYWP82B6zGFwhMGf98nc01rq0ZVf9IHR1PjSI3nrGAQXkVlYz1nv0GPjuimZqFmueotX
Q4bG9KuJYcrHxTiOdk6oN8NguDKsjNX+CUMCpqzQAQAA''',
    "What a Waste": '''H4sIAMQCKWAC/13OsQrDIBCA4VcR5wY0LZQ2U7v0ETKUDja5RMFo0HNIg+9eFQJplwM/4b9bqT
JzwOpjDXh6JStlZRbN8FzpZDV0QUN60YfVfXMLDefnC2P0QGhng8H0xev4ijGBDfhb5GXuK3dw
i9YqTM0dUur0V2Kl87amB1dtWieSwlcejLcuAboAm81aIcJOcZnLJgcehOtk7hsxFWulQCJIKz
xCdhFQliIdx9HqTL0aBpWuxSXxMX4BjV6xlyYBAAA=''',
    "AC without AGW": '''H4sIAMQCKWAC/32QzWuEMBDF/xXJucJMIoLNaVlqvfXYQ+nBavwAN1liQrHi/u2dRJZ+Lb08mB
fye29mZaM+e5d+GK1mdp+sDKNGNxgvKzuZSTV+UjSxBzfUWsnjBXh1gVwizxEljwocESSSkBMV
BQJIHlVwUnaXsMZ47YiFfHvdaIZ/A8vJGztSZEmRBC8ogmNxAxVYxrtb23wHVktrTa+0rHYgRu
DvbvDV7Mfn8ilFLrKlCycQAUG9MskhR4LBDsvhehIBYfW9NfLYXRTxGMWfwJD4ZnSrbHp1M7KG
ek5npWdjyXDWK/Lcco51rJpVbZshkHR9it7hmLyPbqBLJIfH5/BSexrDb9b3vZmC1Y5dN9JSbi
FbbJ8XDrVjBgIAAA==''',
    # Volume 9 Issue 9
    "Strong Dimerization": '''H4sIAMQCKWAC/22PwWrDMAyGXyX4vIKkZmHMx/bQ83YcO7iJmhoau7j2IQ3Zs08y7FC6hHzgT5
Z+ZTE+XEve3GPgm3lvFgOV1ar4WswUL9yXC8vJ7Ob+Eo8lu8FzYLv7gfYgn0WQ1yJ2JCQlVUPY
KUmJWwSwpDQvjeljCVlmIq3f6yoilvzfKg/xLh1jaD58GDX7zQJ0RJLekUyGDsgCKqkSSD1W6g
6PuaCh+JRxmIcURw5WfkxGyyPNiE/N2i3LDJw2f7YVledrHZP4xi71Z+0KbqruM6cYxmbvJ07+
7rKPQcuu5HNMegFp2756ZlY9+NPJy1Z5lhKtv8NuUKirAQAA''',
    "Philosopher's Cleanup": '''H4sIAMQCKWAC/32Qy2rDMBBFf8Vo0xZqkMYuiaNVKN1nX7pQ7ElsUCSjByUNzrd3JKekj9CND3
NnrHtnTmwwYwzlhzXo2ao4MZ6/WU3C64kdrMY2aqSKvZhWeeyKvdWdXMfN9syXUohFI4QEsQRO
4BmCQCK/QMwAApdiBhA4Z48Fa200gd4XML1NVIt/Q2y0CpRBo+rkZruOc4ZsAHzRcCDzRQPJnA
BkTvkIQFUyzwACJ4j0w58MKYSN4dZpfiTpB229HXt0d7547xG1vE9neTjz+upEa0LePYWpCSTW
aXcJ1Zy3zpO8+h2myUl65Uut3B7LORM1gotIna01Hbrya3x5GfZovHXXsaQF1DhaF/CbHo5j3s
OhR+XaPlkbdbix2zNd28QxDagY+vw4E1DVTwMiJrkbdruBDhOO1ILpE+Bfjr1aAgAA''',
    "Upscale Downscale": '''H4sIAMQCKWAC/32RT2sCMRDFv0rIqYUKM0mp0L16FIRKT6WH7Ro1kE0kfyhW9LN3krGUqvSyv8
ybTebl5SCt35U8+QreJPksDhLat6lVeDvIMTgzFGeoksuxd04s0mjLKF6s33SLdILHDnH6hNgp
AmCHiiroFAFAPgg5hOIz7Ud1fD9Sjf8OmfdxY8SyuHWJPGR5AjyB6gCwjsEKOp+hCTQUkKEYmn
ssahaRRXXuEW7Yq/5CybdSuTZ5mcTZ5ZRdcgoMDS0azQlpxdA1IbI+ZesM3TYgQzX8cQm/EV6/
zUVs9WmQn4YjUByBuro7tJt/BL8ycfKjKpK2fZok41OIJORYDGl5v2szo0mmj8O2nuT7sWmvuz
T0zohZ+PRtVZt9ydt2gJybvbPZiLsxrOzamtV97dNybekmeU//6OM33fI9spgCAAA=''',
    # Volume 9 Issue 10
    "Molting": '''H4sIAMQCKWAC/31RsW7CMBD9FeSplRrpziZJRUYWlnZhrDq4yQFRgx059kARfHt9BxWthLo8ye
+9O79nH1XvxhSLL+9oUovZUYGgsEy8HdXeD9SmgfJJLW348G62dvaTmuUZ8AxVY6ACaDRUCA0K
QkZsACvIqAWNqIJa0BieMqIacWoUD/IsanFmFdTTTLU+uZgDoD69n/IZ/025OnTBb8k1q7wN72
zgFT7Fe81/71nH0I/UXes+vC4fz/DMMYFj1lxU1yBF8VaReT1nPhdlLMVfir8UZyVTtfhr8deX
J8z8n7AgUXd2KgYbtlRcQmclhkRZyZ/RUSh+/POreZMmCjdXPIzSJ9BENrQ7vsLZvXAvfoi92z
JlU9x5HlOozbzsiYjprt9s+vwk8cCJTt+k9Z6WMwIAAA==''',
    "Unpacking": '''H4sIAMQCKWAC/22QTU/DMAyG/8qUE0hUstOPIXrkwhExcUIcSueuFVlS5eNQpvLbcTwQE+LyOH
3s5G1yUpOdUyw+nKWg7jYnBUKxWbyc1NEZ6pMh/lK7ZIbkN09u3+4+oWoRsAFsEc9Fn0vJBdTN
RvUu2cj7UK+v68rCpfhf3GXEozMLxXExZKm9uv8E/cBJ1zkNOAc4rEFsoZS1zmsshZV4nT1Umb
pCYJZCLcRMBJkEmQExtZzQCLdN9rXMN8JtJtRyciPcMi9vWMn1xi4UpvMHKs4X5Ub0ibjz5uye
fPEzfvs9HMgG53/HshtSoD8qzGaK8dLGZZbX8hSo8/2Y/8V2R3HPdu7698kesuxSHCVBoS6rei
KirPfTMEz85HHhll6/AC3VIeEIAgAA''',
    "Unpleasant Dreams": '''H4sIALbnL2AC/22QQU8DIRCF/8qGs5sAW81WTqYeejE9VE/qgcLUknRhw4Jpbdbf7gytibVNNm
R5wJv3vQOL2tvQ1c73OdVfwcPA7qsD42UtKgmvB9aFLZi8BdyxpfvonKkejLPqLfNGN3PVCMkl
50oKITi7qZgJ2Se8LeT4Po4orN0O7NVJbNHBh0Y/SPsteFDz4jqdHW0FF0pKUczvpFAN/dMIQW
+fN5A2LnfVU/Bh5yyUSNN2Ud7y8qqVnFGEkNM1zv9saKg9/KJ984kSRCcE0aEhJ0YlSiRB8c54
+XiKdm4803EVCucyr45BF7MT56IMwA852yMnl4rzllZk5pcD5MUAKoJ6eHRnNXyjBzZAUakPSf
HbC0eyTBCjdh6FCe46vasjaJNCpK7uUNroodb2U3sDFqUUM5xUn80WdDwXh9wDMnsL/w4imD3e
/6OmfV8Y+hhsNskFT/m87or64nt0H7RP1SNG6gY61DltAlkwIZvJrQMAkq1brx1WkvZ4JMcfcF
0F3eICAAA=''',
    # Volume 9 Issue 11
    "Electroplating": '''H4sIAMQCKWAC/32QT2sDIRDFv8riuYEZk9I/ntLQe6HH0oPdnSQSo2K0kC67n72jtpBQ6MUf80
bnzXMUxoWcFl/e0Uk8dqPAela1CG+jOHpLfbbElXg19pOiWu8ULFd3AOKmE73PLnET5fQ+cQ3/
Ttj4ECh2T9b3B7XJM6wUonxAVJIBDMkAhQz8O78Y+Jyud26Oly4vVicaOqedDzom01tqZuvdDD
iDvDTFZsrAhiVwNgY2yIYaWEkG8noN8AO+wu8AG6ACG2TFVRCoMT68GyguftV7ltI51PUjnUjH
fl9eOX2s2jOnS9EHTmbcrnR0TnsfSw95q1tDREUezHZr+CPSmVty+gZSNIgn4wEAAA==''',
    "Doping": '''H4sIAMQCKWAC/7WQPW7DMAyFrxJorgFRSpZq7QECZAw6OI5iCXBEQz9DavjuoUQXXYJ26qKH91
Ei+bQIH+aSuy8MNon33SJkOxut4LyIO052KJMlJ05+8gMGc/JGStgDGGBRLBIYsmiCkmqbg+ak
4issikUrrmly0gCLYtEkUoq3nRiwhExrgFo/V/Lw665Hh2l2GEsyxzrn8KJJ7YIlv/qCP2IDHH
7Sb7G3T/iv2Fq1fS8YrjZ233RPyPWpSzYkjARyLJZYfsxt92iT7ePgaqfQ3xv7wNmHsZK+ZNde
iXEccaro6m83T8nzo85cn7weBj8jAgAA''',
    "Mass of Osmium": '''H4sIAMQCKWAC/32QTWrEMAyFrxK8bsCyIIH6DGUOULpIM84PJPYQ24tpyN0rWc0ipXSjh57s50
/e1ewfOdVfwbuoXqtdQanFZeN9V2tYXJ8XR526xXXOq71Fa0zbaK1eKtWH7BMNwRwfx0FGyOma
qUv9OwegbYyxRgSMdCLIb6BFKKL5CIkRwbZBbUHEiCAylNWaOrTAQmEiqDnlAqyZFv6B+wkqCS
B5UDgACzjPpJP0E/UEFxxeiq8Lo74Q86YAZSn4Dcd0n8Hf3VafriFr6mIdnY9hIyNt2ZGXno+C
vrnouq2fOMl3a/HeuhirMFSyFk+6nKZyW43jGBa27vMwzPQB6Uk2Ht++5jKOGAIAAA==''',
    # Volume 9 Issue 12
    "Spaghetti Hoops": '''H4sIAMQCKWAC/4WQTW6EMAyFr4KyHiTHqRBqLtDVbFiOuqAQSlSGoPwspoievY7pLDpF6iaWn/
PlPWcVdl5SLD/dbIJ4LlYBfLKahcsqrm4yXZoMdeJsuw8zFU2aBtsbfbaNRikrAC0l1gjiVIjO
pTnS5aftVBzRRP3cJhZr+AfKXsnrhhhZMZP9fjOvG2HCpXi0y2GCL6g5BKCWQFlQq71TmCNpBd
wh7DmRi8THHSVkY/nH5x6abUBWUnJ8oILU5Re5KOTPU/tMARfMwKNN9nlzc298eVdrksY2lMHM
wXkSok+GtHhbOIQ3wbS+G/NLc3vdgy3t+2hitMWLc0vIozbFkXERaNiN5prV3g6DpXXijSa4fQ
O6yo2cKQIAAA==''',
    "Handle With Care": '''H4sIAMQCKWAC/31RwWoDIRD9lcVzF2Y0sUs9hVxySi+FHkoPZneSFTYaXD0kIfn2jpZCaUsPPn
SevvdmvArnTzm1l+BpFk/NVUDFWi2Ft6s4hon6PBGfxNrGXfBmbRA1gHhoRB+yT0yhvL3f+Iz/
vt+6FEOem1XvBrPZPt9BstQjMsoOwEisCAj4S7yoh5z+ivvd4iU6X1x25C/kyazvoDd3UFte7K
fZSbOflJq9pdKIRi40oMGFloyq7CVnQgOqJJPLgkohJ8NlRcRyB7qioEtitaxY0wN3wm8X3Y8B
Qe1gtHM72Xig9rMXZlLMxAwPdqDYft3vuJTOp9pTpJls7Mei5+2x1jbWDxM1ry6NDX8LFc7mNI
ZY2PlkD/1Ix1Id3H7veDzpzIy6fQCwOhb39AEAAA==''',
    "The Greatest Honor": '''H4sIAMQCKWAC/22QTWsDIRCG/8ripS1kwdU2m9RTTulxKb2VHqw7yQquLjpCt0v626umUBJycZ
jnnY93XIiXtndjre0Usf52FgJ5rhZCy1toBu8LGZ0BFQ2kjOyd6cUuCta0W0rJqiLKRYtJWp9W
1WVtZyRqG0fRYa7fXNd/nFILcRFvGbgY5LVVEMJd9artUdx3uIsPP3QtKG23jAmah6fAkqcUeL
thVDS0BJZLUsZLYGeN09LAm9LA2Tnj1yc1tDhE8F5qm0HKRvlVe5AKnc9+eUKDDLUMAcZPMyeE
PsIf7XW4LXhQszLg/ynOUzl28q6PCrWz2YqVY6FvA1T7tBYhYPXirPNZlREHl2eQhvHHJw0AGf
f6cNDp8zAv5adfwYEjbusBAAA=''',
}

unsupported_defense_names = {"A Most Unfortunate Malfunction", "No Need for Introductions", "Exploding Head Syndrome",
                             "More than Machine", "Don't Fear the Reaper", "Freedom of Choice", "End of the Line"}

# Dict of Resnet puzzle title: (volume, issue, puzzle) id - with shared-title levels storing lists of ids in the same
# order as the sub-lists in `levels` above.
# This allows us to specify the exact level we ran a solution in if the user requests it, without cluttering up the
# global levels dict
resnet_ids = {
    "Tunnels I": (1, 1, 1),
    "Tunnels II": (1, 1, 2),
    "Tunnels III": (1, 1, 3),
    "Fission I": (1, 2, 1),
    "Fission II": (1, 2, 2),
    "Fission III": (1, 2, 3),
    "Chloroform": (1, 3, 1),
    "Cycloaddition": (1, 3, 2),
    "KOHCTPYKTOP++": (1, 3, 3),
    "Quantum Decomposition": (1, 4, 1),
    "Propane Accessories": (1, 4, 2),
    "Benzoic Acid": (1, 4, 3),
    "Electrophilic Addition": (1, 5, 1),
    "Diethyl Ether": (1, 5, 2),
    "2-Hexene": (1, 5, 3),
    "Mazeite'": (1, 6, 1),
    "Silica": (1, 6, 2),
    "Galvanization": (1, 6, 3),
    "Industrial Methanol": (1, 7, 1),
    "Glyoxylic Acid": (1, 7, 2),
    "Bioplastic": (1, 7, 3),
    "Chlorination": (1, 8, 1),
    "Sulfuric Acid": [(1, 8, 2),
                      (3, 7, 1)],
    "Bad Times": (1, 8, 3),
    "Friedel-Crafts": (1, 9, 1),
    "Wöhler Synthesis": (1, 9, 2),
    "Diels-Alder": (1, 9, 3),
    "Bad Times, Part II": (1, 10, 1),
    "Freon": (1, 10, 2),
    "Benzene Derivatives": (1, 10, 3),
    "Portland Cement": (1, 11, 1),
    "Solder Coarsening": (1, 11, 2),
    "Graphene": (1, 11, 3),
    "The Big Cleanup": (1, 12, 1),
    "Going Green Part II": (1, 12, 2),
    "Waste Treatment": (1, 12, 3),
    "Pyridine": [(2, 1, 1),
                 (2, 8, 3)],
    "Breakdown": [(2, 1, 2),
                  (5, 3, 2)],
    "Vitamin B3": [(2, 1, 3),
                   (4, 6, 3)],
    "PVC": (2, 2, 1),
    "PVA": (2, 2, 2),
    "Naphthalene": (2, 2, 3),
    "Anthraquinone": (2, 3, 1),
    "Soap": (2, 3, 2),
    "Glucose": (2, 3, 3),
    "PZA": (2, 4, 1),
    "INH": (2, 4, 2),
    "PAS": (2, 4, 3),
    "Fusion - Germane": (2, 5, 1),
    "Fusion - Silane": (2, 5, 2),
    "Fermentation": (2, 5, 3),
    "Hydrazine": (2, 6, 1),
    "Organometallics": (2, 6, 2),
    "Nonsense!": (2, 6, 3),
    "Iron and Ozone": (2, 7, 1),
    "Normalization": (2, 7, 2),
    "Decomposition": (2, 7, 3),
    "Phenol": (2, 8, 1),
    "Uracil": (2, 8, 2),
    # Pyridine 2-8-3 stored with the same-named 2-1-1
    "Phosgene": (2, 9, 1),
    "Ignoble": (2, 9, 2),
    "Alchemy": (2, 9, 3),
    "Bosch-Meiser": (2, 10, 1),
    "Beckmann Rearrangement": (2, 10, 2),
    "Stock-Pohland": (2, 10, 3),
    "Swapite": (2, 11, 1),
    "Hardening": (2, 11, 2),
    "Keying In": (2, 11, 3),
    "Ethane": (2, 12, 1),
    "Cyclobutane": (2, 12, 2),
    "Styrene": (2, 12, 3),
    "Thinner Line": (3, 1, 1),
    "Decomposition of Ethanolamine": (3, 1, 2),
    "Anesthetics": (3, 1, 3),
    "Fertigprodukt": (3, 2, 1),
    "Novel Semiconductor": (3, 2, 2),
    "Passivation": (3, 2, 3),
    "Life": (3, 3, 3),
    "Cyanamide": (3, 4, 1),
    "Acetic Acid": (3, 4, 2),
    "Combustion Engine": (3, 4, 3),
    "Smelting Iron": (3, 5, 1),
    "Neodymium Magnet": (3, 5, 2),
    "Carbide Swap": (3, 5, 3),
    "Fuel Production": (3, 6, 1),
    "Siliconheart Piece": (3, 6, 2),
    "Raygun Mechanism": (3, 6, 3),
    # Sulfuric Acid 3-7-1 stored with same-named 1-8-2
    "Fuming Nitric Acid": (3, 7, 2),
    "Rocket Fuel": (3, 7, 3),
    "Hydroxides": (3, 8, 1),
    "Nobility": (3, 8, 2),
    "Sortite": (3, 8, 3),
    "Radiation Treatment": (3, 9, 1),
    "Boron Compounds": (3, 9, 2),
    "Photovoltaic Cells": (3, 9, 3),
    "Elementary": (3, 10, 1),
    "Mixed Acids": (3, 10, 2),
    "Squaric Acid": (3, 10, 3),
    "Misproportioned": (3, 11, 1),
    "Narkotikum": (3, 11, 2),
    "Vereinheitlichung": (3, 11, 3),
    "Haber-Bosch": (3, 12, 1),
    "Mustard Oil": (3, 12, 2),
    "Nano Electric Motor": (3, 12, 3),
    "Count": (4, 1, 1),
    "Sharing Is Caring": (4, 1, 2),
    "Reassembly": (4, 1, 3),
    "Cyanogen": (4, 2, 1),
    "Chloromethylsilane": (4, 2, 2),
    "Glyceraldehyde": (4, 2, 3),
    "Ethandiamin": (4, 3, 1),
    "Radikal": (4, 3, 2),
    "Kreisalkanol": (4, 3, 3),
    "Inorganic Pigments": (4, 4, 1),
    "Miller-Urey": (4, 4, 2),
    "Getting Pumped": (4, 4, 3),
    "Lewisite": (4, 5, 1),
    "Novichok": (4, 5, 2),
    "Ribulose": (4, 5, 3),
    "Knockout Drops": (4, 6, 1),
    "Strong Acids": (4, 6, 2),
    # Vitamin B3 4-6-3 stored with the same-named 2-1-3
    "1,2,3-Triphenol": (4, 7, 1),
    "1,3-Dimetoxibencene": (4, 7, 2),
    "Think in Spirals": (4, 7, 3),
    "Yellowcake": (4, 8, 1),
    "Thiourea": (4, 8, 2),
    "Downgrade": (4, 8, 3),
    "Wood Alcohol": (4, 9, 1),
    "Allyl Alcohol": (4, 9, 2),
    "Propargyl Alcohol": (4, 9, 3),
    "Condensation": (4, 10, 1),
    "Silane": (4, 10, 2),
    "Phosphine": (4, 10, 3),
    "Nuclear Medicine": (4, 11, 1),
    "Oxygen Supply": (4, 11, 2),
    "Red Cross": (4, 11, 3),
    "Fluoromethanes": (4, 12, 1),
    "Exercise": (4, 12, 2),
    "Nanoboxes": (4, 12, 3),
    "PAX Challenge 1": (5, 1, 1),
    "PAX Challenge 2": (5, 1, 2),
    "PAX Challenge 3": (5, 1, 3),
    "Fill in the Blank": (5, 2, 1),
    "Break-up": (5, 2, 2),
    "Average Out": (5, 2, 3),
    "Fake-out": (5, 3, 1),
    # Breakdown 5-3-2 stored with the same-named 2-1-2
    "Master of Disguise": (5, 3, 3),
    "Thermoplastic": (5, 4, 1),
    "Contaminated": (5, 4, 2),
    "Running Low": (5, 4, 3),
    "Not a Planet": (5, 5, 1),
    "Back to Basics": (5, 5, 2),
    "Not Helping": (5, 5, 3),
    "Two-fer": (5, 6, 1),
    "Oxygen Synthesis": (5, 6, 2),
    "Stupor": (5, 6, 3),
    "Oxygen Synthesis for Kids": (5, 7, 1),
    "+1": (5, 7, 2),
    "Nuclear Sorting": (5, 7, 3),
    "Fun with Oxides": (5, 8, 1),
    "Overflow": (5, 8, 2),
    "Conversion": (5, 8, 3),
    "Benzene Machine": (5, 9, 1),
    "Speedster": (5, 9, 2),
    "Carbon Splatter": (5, 9, 3),
    "Eth": (5, 10, 1),
    "Large Scale": (5, 10, 2),
    "Revenge": (5, 10, 3),
    "Excess": (5, 11, 1),
    "Carbon Compounds": (5, 11, 2),
    "Magnesium Bicarbonate": (5, 11, 3),
    "Impostor": (5, 12, 1),
    "Master Plan": (5, 12, 2),
    "Rags to Riches": (5, 12, 3),
    "Plutonium Separation": (6, 1, 1),
    "You're Doing It Wrong": (6, 1, 2),
    "Synthetic Elerium": (6, 1, 3),
    "Deadly Soft Drinks": (6, 2, 1),
    "Deadly Fluorinated Water": (6, 2, 2),
    "Deadly Microwaves": (6, 2, 3),
    "Carbon Snakes": (6, 3, 1),
    "Catalyst": (6, 3, 2),
    "Catalyst II": (6, 3, 3),
    "Unbonding with no Bonders": (6, 4, 1),
    "Breeder Reactor": (6, 4, 2),
    "Nightmare Factory": (6, 4, 3),
    "Fructose Factory": (7, 1, 1),
    "Misfortune Modifier": (7, 1, 2),
    "Particle Accelerator": (7, 1, 3),
    "Sun Simulator": (7, 2, 1),
    "100": (7, 2, 2),
    "Hypothetical Synthesis": (7, 2, 3),
    "Halogen Sorting": (7, 3, 1),
    "Metallica": (7, 3, 2),
    "Homogenizer": (7, 3, 3),
    "Dessication Station": (7, 4, 1),
    "Vinegar Distillation": (7, 4, 2),
    "A Glass of Water": (7, 4, 3),
    "Pertetroxide Synthesis EX": (7, 5, 1),
    "Fantastic Metals": (7, 5, 2),
    "Reppe Chemistry": (7, 5, 3),
    "Better Than Graphene": (7, 6, 1),
    "Magnets": (7, 6, 2),
    "Precious Oxygen": (7, 6, 3),
    "Dewer Benzene": (8, 1, 1),
    "Natural Chemo": (8, 1, 2),
    "The Chem in SpaceChem": (8, 1, 3),
    "Airborne Aldehyde": (8, 2, 1),
    "Natural Gas": (8, 2, 2),
    "Symmetry": (8, 2, 3),
    "Fenton Industries 001": (8, 3, 1),
    "Oxygen Candle": (8, 3, 2),
    "Lies": (8, 3, 3),
    "Liquid Glass": (8, 4, 1),
    "PVC V": (8, 4, 2),
    "Memories": (8, 4, 3),
    "Tumbler": (8, 5, 1),
    "Molecular Key Carving": (8, 5, 2),
    "Sensitive Explosives I": (8, 5, 3),
    "Waste Gas": (8, 6, 1),
    "Ethane Scrubbing": (8, 6, 2),
    "Melanophlogite Clathrates": (8, 6, 3),
    "Largest Prime": (8, 7, 1),
    "Three": (8, 7, 2),
    "Θne": (8, 7, 3),
    "A Small Push": (8, 8, 1),
    "Pushed Together": (8, 8, 2),
    "Repair Tungsten": (8, 8, 3),
    "Shared Space I": (8, 9, 1),
    "Shared Space II": (8, 9, 2),
    "Taking Turns": (8, 9, 3),
    "How Ionic": (8, 10, 1),
    "Two by Two": (8, 10, 2),
    "The Gold Standard": (8, 10, 3),
    "2 of Hearts": (8, 11, 1),
    "Miracle Cure": (8, 11, 2),
    "Oxygen Snake": (8, 11, 3),
    "That's a Relief": (8, 12, 1),
    "Headaches": (8, 12, 2),
    "Under the Counter": (8, 12, 3),
    "A New Beginning": (8, 13, 1),
    "Discombobulate": (8, 13, 2),
    "Magnum Opus": (8, 13, 3),
    "Organic Fusion Chemistry": (8, 14, 1),
    "The Soul of Iron": (8, 14, 2),
    "Serbalcide": (8, 14, 3),
    "Precious Tears": (8, 15, 1),
    "Desperate Measures": (8, 15, 2),
    "Hydrocarbon Stitch": (8, 15, 3),
    "Prime Time": (9, 1, 1),
    "Water not WAtEr": (9, 1, 2),
    "Carbon Products": (9, 1, 3),
    "Martian Respiration": (9, 2, 1),
    "Blockheads": (9, 2, 2),
    "Greed": (9, 2, 3),
    "Comet Chemistry": (9, 3, 1),
    "Ferrous Wheel": (9, 3, 2),
    "Barbituric Acid": (9, 3, 3),
    "Really Easy": (9, 4, 1),
    "Modern Alchemy": (9, 4, 2),
    "Gem Factory": (9, 4, 3),
    "Unlikely": (9, 5, 1),
    "Chalcogens": (9, 5, 2),
    "Chlorine and Ammonia": (9, 5, 3),
    "Combustion": (9, 6, 1),
    "Low Power Polymers": (9, 6, 2),
    "Photosynthesis": (9, 6, 3),
    "Break Up": (9, 7, 1),
    "Chemotherapy": (9, 7, 2),
    "Stuck Together": (9, 7, 3),
    "Antimony Mining": (9, 8, 1),
    "What a Waste": (9, 8, 2),
    "AC without AGW": (9, 8, 3),
    "Strong Dimerization": (9, 9, 1),
    "Philosopher's Cleanup": (9, 9, 2),
    "Upscale Downscale": (9, 9, 3),
    "Molting": (9, 10, 1),
    "Unpacking": (9, 10, 2),
    "Unpleasant Dreams": (9, 10, 3),
    "Electroplating": (9, 11, 1),
    "Doping": (9, 11, 2),
    "Mass of Osmium": (9, 11, 3),
    "Spaghetti Hoops": (9, 12, 1),
    "Handle With Care": (9, 12, 2),
    "The Greatest Honor": (9, 12, 3),
}
