"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildKinesisStream = void 0;
// Imports
const kinesis = require("@aws-cdk/aws-kinesis");
const kinesis_streams_defaults_1 = require("./kinesis-streams-defaults");
const utils_1 = require("./utils");
function buildKinesisStream(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the stream properties
    let kinesisStreamProps;
    if (props.kinesisStreamProps) {
        // If property overrides have been provided, incorporate them and deploy
        kinesisStreamProps = utils_1.overrideProps(kinesis_streams_defaults_1.DefaultStreamProps, props.kinesisStreamProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        kinesisStreamProps = kinesis_streams_defaults_1.DefaultStreamProps;
    }
    // Create the stream and return
    return new kinesis.Stream(scope, 'KinesisStream', kinesisStreamProps);
}
exports.buildKinesisStream = buildKinesisStream;
//# sourceMappingURL=data:application/json;base64,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