# mypy-boto3-machinelearning

[![PyPI - mypy-boto3-machinelearning](https://img.shields.io/pypi/v/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MachineLearning 1.12.42](https://boto3.amazonaws.com/v1/documentation/api/1.12.42/reference/services/machinelearning.html#MachineLearning) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.7](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-machinelearning](#mypy-boto3-machinelearning)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `MachineLearning` service.

```bash
python -m pip install boto3-stubs[machinelearning]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import machinelearning
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_machinelearning as machinelearning

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("machinelearning")
client: machinelearning.MachineLearningClient = boto3.client("machinelearning")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: machinelearning.MachineLearningClient = session.client("machinelearning")


# Waiters need type annotation on creation
batch_prediction_available_waiter: machinelearning.BatchPredictionAvailableWaiter = client.get_waiter("batch_prediction_available")
data_source_available_waiter: machinelearning.DataSourceAvailableWaiter = client.get_waiter("data_source_available")
evaluation_available_waiter: machinelearning.EvaluationAvailableWaiter = client.get_waiter("evaluation_available")
ml_model_available_waiter: machinelearning.MLModelAvailableWaiter = client.get_waiter("ml_model_available")

# Paginators need type annotation on creation
describe_batch_predictions_paginator: machinelearning.DescribeBatchPredictionsPaginator = client.get_paginator("describe_batch_predictions")
describe_data_sources_paginator: machinelearning.DescribeDataSourcesPaginator = client.get_paginator("describe_data_sources")
describe_evaluations_paginator: machinelearning.DescribeEvaluationsPaginator = client.get_paginator("describe_evaluations")
describe_ml_models_paginator: machinelearning.DescribeMLModelsPaginator = client.get_paginator("describe_ml_models")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.