/* Copyright 2020 Zhao HG

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. */
#include "unicode_data.h"

namespace unicode {

const BidirectionalCategory AL = BidirectionalCategory::AL;
const BidirectionalCategory AN = BidirectionalCategory::AN;
const BidirectionalCategory B = BidirectionalCategory::B;
const BidirectionalCategory BN = BidirectionalCategory::BN;
const BidirectionalCategory CS = BidirectionalCategory::CS;
const BidirectionalCategory EN = BidirectionalCategory::EN;
const BidirectionalCategory ES = BidirectionalCategory::ES;
const BidirectionalCategory ET = BidirectionalCategory::ET;
const BidirectionalCategory FSI = BidirectionalCategory::FSI;
const BidirectionalCategory L = BidirectionalCategory::L;
const BidirectionalCategory LRE = BidirectionalCategory::LRE;
const BidirectionalCategory LRI = BidirectionalCategory::LRI;
const BidirectionalCategory LRO = BidirectionalCategory::LRO;
const BidirectionalCategory NSM = BidirectionalCategory::NSM;
const BidirectionalCategory ON = BidirectionalCategory::ON;
const BidirectionalCategory PDF = BidirectionalCategory::PDF;
const BidirectionalCategory PDI = BidirectionalCategory::PDI;
const BidirectionalCategory R = BidirectionalCategory::R;
const BidirectionalCategory RLE = BidirectionalCategory::RLE;
const BidirectionalCategory RLI = BidirectionalCategory::RLI;
const BidirectionalCategory RLO = BidirectionalCategory::RLO;
const BidirectionalCategory S = BidirectionalCategory::S;
const BidirectionalCategory WS = BidirectionalCategory::WS;

std::ostream& operator<<(std::ostream& os, BidirectionalCategory c) {
    switch (c) {
    case AL: os << "AL"; break;
    case AN: os << "AN"; break;
    case B: os << "B"; break;
    case BN: os << "BN"; break;
    case CS: os << "CS"; break;
    case EN: os << "EN"; break;
    case ES: os << "ES"; break;
    case ET: os << "ET"; break;
    case FSI: os << "FSI"; break;
    case L: os << "L"; break;
    case LRE: os << "LRE"; break;
    case LRI: os << "LRI"; break;
    case LRO: os << "LRO"; break;
    case NSM: os << "NSM"; break;
    case ON: os << "ON"; break;
    case PDF: os << "PDF"; break;
    case PDI: os << "PDI"; break;
    case R: os << "R"; break;
    case RLE: os << "RLE"; break;
    case RLI: os << "RLI"; break;
    case RLO: os << "RLO"; break;
    case S: os << "S"; break;
    case WS: os << "WS"; break;
    }
    return os;
}


const BidirectionalCategory BIDIRECTIONAL_CATEGORY[] = {
    BN, BN, BN, BN, BN, BN, BN, BN, BN, S,
    B, S, WS, B, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, B, B,
    B, S, WS, ON, ON, ET, ET, ET, ON, ON,
    ON, ON, ON, ES, CS, ES, CS, CS, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, CS, ON,
    ON, ON, ON, ON, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, ON, ON, ON, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, ON, BN, BN, BN,
    BN, BN, BN, B, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    CS, ON, ET, ET, ET, ET, ON, ON, ON, ON,
    L, ON, ON, BN, ON, ON, ET, ET, EN, EN,
    ON, L, ON, ON, ON, EN, L, ON, ON, ON,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, ON, L,
    L, L, L, L, L, L, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    L, L, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, L, L, L, L,
    L, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    L, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    L, L, L, L, ON, ON, L, L, L, L,
    L, L, ON, L, ON, ON, L, ON, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, ON, ON, ET,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, R, NSM, R, NSM, NSM,
    R, NSM, NSM, R, NSM, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, AN, AN,
    AN, AN, AN, AN, ON, ON, AL, ET, ET, AL,
    CS, AL, ON, ON, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, AN, AN, AN, AN, AN, AN, AN,
    AN, AN, AN, ET, AN, AN, AL, AL, AL, NSM,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, NSM, NSM, NSM, NSM, NSM, NSM, NSM, AN, ON,
    NSM, NSM, NSM, NSM, NSM, NSM, AL, AL, NSM, NSM,
    ON, NSM, NSM, NSM, NSM, AL, AL, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, NSM,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, AL, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    R, R, ON, ON, ON, ON, R, NSM, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, NSM, NSM, NSM, NSM, R, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, R, NSM, NSM, NSM,
    R, NSM, NSM, NSM, NSM, NSM, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, NSM, NSM, NSM, R,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, AN, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, L, NSM, L, L, L, L,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L,
    L, L, NSM, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, L, L, L, L, NSM, NSM, NSM, NSM,
    L, L, L, L, NSM, L, L, L, L, L,
    L, L, NSM, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, ET, ET, L, L,
    L, L, L, L, L, ET, L, L, NSM, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, L, L, L, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, L, L, L, NSM, L, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, L, L, L, L, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, L, L, L, NSM, L, L, L, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, ET, L, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    L, L, NSM, L, NSM, NSM, NSM, NSM, L, L,
    L, L, NSM, NSM, NSM, L, L, L, L, L,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, L, L, L, L, L, L, L, L, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ON, ON, ON, ON, ON,
    ON, ET, ON, NSM, L, L, L, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, NSM, L, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, L, L, L, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, ON, ON, ON, ON,
    L, L, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, L, L, L, L, L, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, L,
    L, L, L, NSM, NSM, NSM, NSM, L, L, L,
    L, L, L, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, NSM, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, L, L, L, NSM, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, L, L,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, ET, L, L,
    L, L, L, L, L, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, L, L, L, L, L, NSM, NSM,
    NSM, NSM, NSM, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, L, NSM, L, NSM, ON, ON, ON, ON,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    L, NSM, NSM, NSM, NSM, NSM, L, NSM, NSM, L,
    L, L, L, L, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, L, L, L, L, L, L, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, NSM, L, NSM,
    NSM, NSM, NSM, NSM, NSM, L, NSM, NSM, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, L,
    L, L, L, NSM, NSM, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, NSM, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    L, L, NSM, NSM, L, L, L, L, L, L,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, ON,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, WS,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, ON, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, NSM, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    L, L, L, L, L, L, L, L, NSM, L,
    L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, L, L, L, L, L, L, L, ET,
    L, NSM, L, L, L, L, L, L, L, L,
    L, L, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, NSM, NSM, NSM, BN, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, NSM, L, L, L, L, NSM, NSM, L,
    L, L, L, L, NSM, L, L, L, L, L,
    L, NSM, NSM, NSM, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, L, L, NSM, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, NSM, L, L, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L, L, L, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, L, NSM, NSM, NSM, NSM, NSM,
    L, NSM, L, L, L, L, L, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L, L, L, L,
    L, L, NSM, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    L, L, NSM, NSM, L, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, L, NSM, NSM, L, L,
    L, NSM, L, NSM, NSM, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, L, L, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, NSM,
    L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, L, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, L, L, L, L, NSM, L, L, L,
    L, L, L, NSM, L, L, L, NSM, NSM, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ON, L, ON, ON, ON,
    L, L, L, L, L, L, L, L, L, L,
    ON, ON, ON, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, ON,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, ON, ON, WS, WS, WS, WS, WS, WS,
    WS, WS, WS, WS, WS, BN, BN, BN, L, R,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, WS, B, LRE, RLE, PDF, LRO,
    RLO, CS, ET, ET, ET, ET, ET, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, CS, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, WS,
    BN, BN, BN, BN, BN, LRI, RLI, FSI, PDI, BN,
    BN, BN, BN, BN, BN, EN, L, EN, EN, EN,
    EN, EN, EN, ES, ES, ON, ON, ON, L, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, ES,
    ES, ON, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ET, ET, ET,
    ET, ET, ET, ET, ET, ET, ET, ET, ET, ET,
    ET, ET, ET, ET, ET, ET, ET, ET, ET, ET,
    ET, ET, ET, ET, ET, ET, ET, ET, ET, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, ON, ON, L, ON, ON, ON, ON, L,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, ON, L, ON, ON, ON, L, L, L,
    L, L, ON, ON, ON, ON, ON, ON, L, ON,
    L, ON, L, ON, L, L, L, L, ET, L,
    L, L, L, L, L, L, L, L, L, L,
    ON, ON, L, L, L, L, ON, ON, ON, ON,
    ON, L, L, L, L, L, ON, ON, ON, ON,
    L, L, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ES, ET, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, L,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, L, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, ON, ON, ON, ON, ON, L, L,
    L, L, NSM, NSM, NSM, L, L, ON, ON, ON,
    ON, ON, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, WS, ON,
    ON, ON, ON, L, L, L, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, L, L, L, L, L, L, L, L, L,
    NSM, NSM, NSM, NSM, L, L, ON, L, L, L,
    L, L, ON, ON, L, L, L, L, L, ON,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, NSM, NSM,
    ON, ON, L, L, L, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, ON, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, ON, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, L,
    L, L, L, L, L, L, L, L, L, L,
    L, ON, ON, ON, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, ON, ON, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, ON, L,
    L, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, NSM, NSM, ON, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, ON, ON, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, L, L, L, L, L, L, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, L, L, L, NSM, L, L,
    L, L, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, NSM, NSM,
    L, ON, ON, ON, ON, NSM, L, L, L, L,
    L, L, L, L, ET, ET, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, ON, ON,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, L, L, NSM, NSM, NSM, NSM, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, NSM, NSM, NSM, NSM, L,
    L, NSM, NSM, L, L, NSM, NSM, L, L, L,
    NSM, L, L, L, L, L, L, L, L, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, L, NSM, NSM, NSM,
    L, L, NSM, NSM, L, L, L, L, L, NSM,
    NSM, L, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, L, L, NSM, L, L, L, L, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, R, NSM, R, R,
    R, R, R, R, R, R, R, R, ES, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, ON,
    ON, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, ON, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, CS, ON, CS,
    ON, CS, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ET, ON, ON, ES, ES, ON, ON, ON, ON,
    ET, ET, ON, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, BN, ON, ON, ET, ET, ET, ON,
    ON, ON, ON, ON, ES, CS, ES, CS, CS, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, CS,
    ON, ON, ON, ON, ON, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, ON, ON, ON, ON, ON, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, ET, ET, ON, ON, ON,
    ET, ET, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, L,
    L, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, NSM, NSM, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, ON, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, NSM,
    NSM, NSM, NSM, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, NSM, NSM, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    ON, ON, ON, ON, ON, ON, ON, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    NSM, NSM, NSM, NSM, AN, AN, AN, AN, AN, AN,
    AN, AN, AN, AN, AN, AN, AN, AN, AN, AN,
    AN, AN, AN, AN, AN, AN, AN, AN, AN, AN,
    AN, AN, AN, AN, AN, AN, AN, AN, AN, AN,
    AN, AN, AN, AN, AN, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, NSM, NSM, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, L, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, L, L, L, L,
    L, L, L, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, NSM, NSM, NSM, L,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, NSM, NSM, NSM, NSM,
    L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, L, L, L, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, NSM, NSM, L, L, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, NSM, NSM,
    NSM, L, L, NSM, L, NSM, NSM, L, L, L,
    L, L, L, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    L, L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, L, L, L, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, NSM, NSM, NSM, L, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, NSM, NSM, NSM, NSM,
    NSM, L, NSM, L, L, L, L, NSM, NSM, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    L, L, L, L, NSM, NSM, L, NSM, NSM, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L, NSM,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, L, NSM, L, L, NSM, NSM,
    NSM, NSM, NSM, NSM, L, NSM, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, NSM, NSM, NSM, L, L, NSM,
    NSM, NSM, NSM, L, NSM, NSM, NSM, NSM, NSM, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, NSM, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, L, NSM, L, L, L, L, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, NSM, NSM, NSM, NSM, L, L, L,
    L, NSM, L, L, L, L, L, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, NSM, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, NSM, NSM, NSM, NSM, L,
    L, L, L, L, L, L, L, NSM, L, NSM,
    NSM, NSM, NSM, NSM, NSM, L, L, NSM, NSM, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, NSM, NSM,
    L, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, L, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, L, L, NSM, L, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, ON, ON,
    ON, ON, ON, ON, ON, ON, ET, ET, ET, ET,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, NSM, NSM, NSM,
    NSM, NSM, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, NSM, NSM, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, L, NSM, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, NSM,
    NSM, L, BN, BN, BN, BN, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, NSM, L, L, L, L,
    L, L, L, L, L, BN, BN, BN, BN, BN,
    BN, BN, BN, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    NSM, NSM, NSM, NSM, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, NSM,
    NSM, NSM, ON, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    ON, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, ON, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, ON, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, ON, L, L, L, L, L, L, L,
    L, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, L, L,
    L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, L, L, L, L, L, L, L, L,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, NSM, L, L, L, L,
    L, L, L, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, NSM, NSM, NSM, NSM,
    L, L, L, L, L, L, L, L, L, L,
    ET, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, NSM, NSM, NSM, NSM, NSM, NSM, NSM, R,
    R, R, R, R, R, R, R, R, R, R,
    R, R, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, AL, AL, AL, AL, AL, AL, AL, AL,
    AL, AL, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    EN, EN, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, ON, ON, ON, ON, ON, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, ON, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, ON, ON, ON, ON,
    ON, ON, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, ON, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, ON, ON, ON, ON, ON, ON, ON, ON,
    ON, ON, EN, EN, EN, EN, EN, EN, EN, EN,
    EN, EN, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, L, L, L, L,
    L, L, L, L, L, L, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, BN, BN, BN, BN, BN, BN, BN,
    BN, BN, BN, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM, NSM,
    NSM, NSM, NSM, L, L, L, L
};

}  // namespace unicode
