"""New initial schema

Revision ID: d9e6283fc947
Revises:
Create Date: 2023-02-01 16:03:16.138102

"""
import sqlalchemy as sa
import sqlalchemy_utils
import sqlmodel
from alembic import op


# revision identifiers, used by Alembic.
revision = "d9e6283fc947"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "project",
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "project_dir", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("read_only", sa.Boolean(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "state",
        sa.Column("data", sa.JSON(), nullable=True),
        sa.Column("timestamp", sa.DateTime(timezone=True), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "task",
        sa.Column("default_args", sa.JSON(), nullable=True),
        sa.Column("meta", sa.JSON(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "command", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "source", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "input_type", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "output_type", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "user_oauth",
        sa.Column(
            "id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False
        ),
        sa.Column("email", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "hashed_password",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=False,
        ),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("is_superuser", sa.Boolean(), nullable=False),
        sa.Column("is_verified", sa.Boolean(), nullable=False),
        sa.Column(
            "slurm_user", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_user_oauth_email"), "user_oauth", ["email"], unique=True
    )
    op.create_table(
        "dataset",
        sa.Column("meta", sa.JSON(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("type", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("read_only", sa.Boolean(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "linkuserproject",
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_oauth.id"],
        ),
        sa.PrimaryKeyConstraint("project_id", "user_id"),
    )
    op.create_table(
        "oauthaccount",
        sa.Column("id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column("user_id", sqlmodel.sql.sqltypes.GUID(), nullable=False),
        sa.Column(
            "oauth_name", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "access_token", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("expires_at", sa.Integer(), nullable=True),
        sa.Column(
            "refresh_token", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "account_id", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column(
            "account_email", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_oauth.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_oauthaccount_account_id"),
        "oauthaccount",
        ["account_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_oauthaccount_oauth_name"),
        "oauthaccount",
        ["oauth_name"],
        unique=False,
    )
    op.create_table(
        "workflow",
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "applyworkflow",
        sa.Column(
            "start_timestamp", sa.DateTime(timezone=True), nullable=True
        ),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("input_dataset_id", sa.Integer(), nullable=False),
        sa.Column("output_dataset_id", sa.Integer(), nullable=False),
        sa.Column("workflow_id", sa.Integer(), nullable=False),
        sa.Column("overwrite_input", sa.Boolean(), nullable=False),
        sa.Column(
            "worker_init", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "working_dir", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "working_dir_user",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=True,
        ),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "status", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("log", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.ForeignKeyConstraint(
            ["input_dataset_id"],
            ["dataset.id"],
        ),
        sa.ForeignKeyConstraint(
            ["output_dataset_id"],
            ["dataset.id"],
        ),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflow.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "resource",
        sa.Column("path", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "glob_pattern", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["dataset.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "workflowtask",
        sa.Column("meta", sa.JSON(), nullable=True),
        sa.Column("args", sa.JSON(), nullable=True),
        sa.Column("workflow_id", sa.Integer(), nullable=True),
        sa.Column("task_id", sa.Integer(), nullable=True),
        sa.Column("order", sa.Integer(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["task.id"],
        ),
        sa.ForeignKeyConstraint(
            ["workflow_id"],
            ["workflow.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("workflowtask")
    op.drop_table("resource")
    op.drop_table("applyworkflow")
    op.drop_table("workflow")
    op.drop_index(
        op.f("ix_oauthaccount_oauth_name"), table_name="oauthaccount"
    )
    op.drop_index(
        op.f("ix_oauthaccount_account_id"), table_name="oauthaccount"
    )
    op.drop_table("oauthaccount")
    op.drop_table("linkuserproject")
    op.drop_table("dataset")
    op.drop_index(op.f("ix_user_oauth_email"), table_name="user_oauth")
    op.drop_table("user_oauth")
    op.drop_table("task")
    op.drop_table("state")
    op.drop_table("project")
    # ### end Alembic commands ###
