/*
 * Decompiled with CFR 0.152.
 */
package com.pagesetup;

import com.pagesetup.PageSetupFormatter;
import java.io.File;
import java.net.URLDecoder;
import org.json.JSONObject;

public final class App {
    private App() {
    }

    public static void main(String[] args) {
        try {
            System.out.println("Hello World! new");
            System.out.println(args[2]);
            String decoded = URLDecoder.decode(args[2].replace("+", "%2B"), "UTF-8").replace("%2B", "+");
            System.out.println(decoded);
            JSONObject obj = new JSONObject(decoded);
            File excelFile = new File(args[0]);
            System.out.println(excelFile.getAbsolutePath());
            System.out.println(excelFile.canRead());
            PageSetupFormatter pageSetupFormatter = new PageSetupFormatter(excelFile);
            App.processJsonObjs(obj, pageSetupFormatter);
            pageSetupFormatter.writeToFile(args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processJsonObjs(JSONObject object, PageSetupFormatter pageSetupFormatter) {
        String[] keys;
        String[] stringArray = keys = JSONObject.getNames(object);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            JSONObject sheetObj = object.getJSONObject(key);
            App.processJsonObj(sheetObj, pageSetupFormatter, key);
            ++n2;
        }
    }

    public static void processJsonObj(JSONObject object, PageSetupFormatter pageSetupFormatter, String sheetName) {
        String[] keys;
        String[] stringArray = keys = JSONObject.getNames(object);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            App.processCommand(key, pageSetupFormatter, object, sheetName);
            ++n2;
        }
    }

    public static void processCommand(String key, PageSetupFormatter pageSetupFormatter, JSONObject object, String sheetName) {
        System.out.println("Processing Command :" + key);
        switch (key) {
            case "setFitColumnsToWidth": {
                Boolean setFitColumnsWidth = (Boolean)App.getJSONvalue(object, key);
                if (!setFitColumnsWidth.booleanValue()) break;
                pageSetupFormatter.setFitColumnsToWidth(sheetName);
                break;
            }
            case "setFitToPage": {
                Boolean setFitToPage = (Boolean)App.getJSONvalue(object, key);
                if (!setFitToPage.booleanValue()) break;
                pageSetupFormatter.setFitToPage(sheetName);
                break;
            }
            case "setRepeatingRange": {
                String repeatingRange = (String)App.getJSONvalue(object, key);
                if (repeatingRange == null) break;
                pageSetupFormatter.setRepeatingRange(sheetName, repeatingRange);
                break;
            }
            case "setLeftHeaderForSheet": {
                String leftHeaderForSheet = (String)App.getJSONvalue(object, key);
                if (leftHeaderForSheet == null) break;
                pageSetupFormatter.setLeftHeaderForSheet(pageSetupFormatter.getSheet(sheetName), leftHeaderForSheet);
                break;
            }
            case "setCenterHeaderForSheet": {
                String centerHeaderForSheet = (String)App.getJSONvalue(object, key);
                if (centerHeaderForSheet == null) break;
                pageSetupFormatter.setCenterHeaderForSheet(pageSetupFormatter.getSheet(sheetName), centerHeaderForSheet);
                break;
            }
            case "setRightHeaderForSheet": {
                String rightHeaderForSheet = (String)App.getJSONvalue(object, key);
                if (rightHeaderForSheet == null) break;
                pageSetupFormatter.setRightHeaderForSheet(pageSetupFormatter.getSheet(sheetName), rightHeaderForSheet);
                break;
            }
            case "setLeftFooterForSheet": {
                String leftFooterForSheet = (String)App.getJSONvalue(object, key);
                if (leftFooterForSheet == null) break;
                pageSetupFormatter.setLeftFooterForSheet(pageSetupFormatter.getSheet(sheetName), leftFooterForSheet);
                break;
            }
            case "setCenterFooterForSheet": {
                String centerFooterForSheet = (String)App.getJSONvalue(object, key);
                if (centerFooterForSheet == null) break;
                pageSetupFormatter.setCenterFooterForSheet(pageSetupFormatter.getSheet(sheetName), centerFooterForSheet);
                break;
            }
            case "setRightFooterForSheet": {
                String rightFooterForSheet = (String)App.getJSONvalue(object, key);
                if (rightFooterForSheet == null) break;
                pageSetupFormatter.setRightFooterForSheet(pageSetupFormatter.getSheet(sheetName), rightFooterForSheet);
                break;
            }
            default: {
                System.out.println("No Action Found For Key:" + key);
            }
        }
    }

    public static Object getJSONvalue(JSONObject obj, String key) {
        Object result;
        try {
            result = obj.get(key);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }
}

