import cdk = require('@aws-cdk/core');
/**
 * Properties for defining a `AWS::Events::EventBusPolicy`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html
 */
export interface CfnEventBusPolicyProps {
    /**
     * `AWS::Events::EventBusPolicy.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-action
     */
    readonly action: string;
    /**
     * `AWS::Events::EventBusPolicy.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-principal
     */
    readonly principal: string;
    /**
     * `AWS::Events::EventBusPolicy.StatementId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-statementid
     */
    readonly statementId: string;
    /**
     * `AWS::Events::EventBusPolicy.Condition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-condition
     */
    readonly condition?: CfnEventBusPolicy.ConditionProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Events::EventBusPolicy`
 *
 * @cloudformationResource AWS::Events::EventBusPolicy
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html
 */
export declare class CfnEventBusPolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Events::EventBusPolicy";
    /**
     * `AWS::Events::EventBusPolicy.Action`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-action
     */
    action: string;
    /**
     * `AWS::Events::EventBusPolicy.Principal`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-principal
     */
    principal: string;
    /**
     * `AWS::Events::EventBusPolicy.StatementId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-statementid
     */
    statementId: string;
    /**
     * `AWS::Events::EventBusPolicy.Condition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-eventbuspolicy.html#cfn-events-eventbuspolicy-condition
     */
    condition: CfnEventBusPolicy.ConditionProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Events::EventBusPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventBusPolicyProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEventBusPolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html
     */
    interface ConditionProperty {
        /**
         * `CfnEventBusPolicy.ConditionProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html#cfn-events-eventbuspolicy-condition-key
         */
        readonly key?: string;
        /**
         * `CfnEventBusPolicy.ConditionProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html#cfn-events-eventbuspolicy-condition-type
         */
        readonly type?: string;
        /**
         * `CfnEventBusPolicy.ConditionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-eventbuspolicy-condition.html#cfn-events-eventbuspolicy-condition-value
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::Events::Rule`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 */
export interface CfnRuleProps {
    /**
     * `AWS::Events::Rule.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-description
     */
    readonly description?: string;
    /**
     * `AWS::Events::Rule.EventPattern`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventpattern
     */
    readonly eventPattern?: any | cdk.IResolvable;
    /**
     * `AWS::Events::Rule.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-name
     */
    readonly name?: string;
    /**
     * `AWS::Events::Rule.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::Events::Rule.ScheduleExpression`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-scheduleexpression
     */
    readonly scheduleExpression?: string;
    /**
     * `AWS::Events::Rule.State`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-state
     */
    readonly state?: string;
    /**
     * `AWS::Events::Rule.Targets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets
     */
    readonly targets?: Array<CfnRule.TargetProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Events::Rule`
 *
 * @cloudformationResource AWS::Events::Rule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html
 */
export declare class CfnRule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Events::Rule";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Events::Rule.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-description
     */
    description: string | undefined;
    /**
     * `AWS::Events::Rule.EventPattern`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventpattern
     */
    eventPattern: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Events::Rule.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-name
     */
    name: string | undefined;
    /**
     * `AWS::Events::Rule.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::Events::Rule.ScheduleExpression`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-scheduleexpression
     */
    scheduleExpression: string | undefined;
    /**
     * `AWS::Events::Rule.State`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-state
     */
    state: string | undefined;
    /**
     * `AWS::Events::Rule.Targets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets
     */
    targets: Array<CfnRule.TargetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Events::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRuleProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html
     */
    interface EcsParametersProperty {
        /**
         * `CfnRule.EcsParametersProperty.TaskCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount
         */
        readonly taskCount?: number;
        /**
         * `CfnRule.EcsParametersProperty.TaskDefinitionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn
         */
        readonly taskDefinitionArn: string;
    }
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html
     */
    interface InputTransformerProperty {
        /**
         * `CfnRule.InputTransformerProperty.InputPathsMap`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap
         */
        readonly inputPathsMap?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnRule.InputTransformerProperty.InputTemplate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate
         */
        readonly inputTemplate: string;
    }
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html
     */
    interface KinesisParametersProperty {
        /**
         * `CfnRule.KinesisParametersProperty.PartitionKeyPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath
         */
        readonly partitionKeyPath: string;
    }
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html
     */
    interface RunCommandParametersProperty {
        /**
         * `CfnRule.RunCommandParametersProperty.RunCommandTargets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets
         */
        readonly runCommandTargets: Array<CfnRule.RunCommandTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html
     */
    interface RunCommandTargetProperty {
        /**
         * `CfnRule.RunCommandTargetProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key
         */
        readonly key: string;
        /**
         * `CfnRule.RunCommandTargetProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values
         */
        readonly values: string[];
    }
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html
     */
    interface SqsParametersProperty {
        /**
         * `CfnRule.SqsParametersProperty.MessageGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid
         */
        readonly messageGroupId: string;
    }
}
export declare namespace CfnRule {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html
     */
    interface TargetProperty {
        /**
         * `CfnRule.TargetProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn
         */
        readonly arn: string;
        /**
         * `CfnRule.TargetProperty.EcsParameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters
         */
        readonly ecsParameters?: CfnRule.EcsParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id
         */
        readonly id: string;
        /**
         * `CfnRule.TargetProperty.Input`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input
         */
        readonly input?: string;
        /**
         * `CfnRule.TargetProperty.InputPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath
         */
        readonly inputPath?: string;
        /**
         * `CfnRule.TargetProperty.InputTransformer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer
         */
        readonly inputTransformer?: CfnRule.InputTransformerProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.KinesisParameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters
         */
        readonly kinesisParameters?: CfnRule.KinesisParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnRule.TargetProperty.RunCommandParameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters
         */
        readonly runCommandParameters?: CfnRule.RunCommandParametersProperty | cdk.IResolvable;
        /**
         * `CfnRule.TargetProperty.SqsParameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters
         */
        readonly sqsParameters?: CfnRule.SqsParametersProperty | cdk.IResolvable;
    }
}
