import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheOriginConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#description NetworkServicesEdgeCacheOrigin#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The Origin resource to try when the current origin cannot be reached.
     *
     * After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
     *
     * The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
     * A reference to a Topic resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#failover_origin NetworkServicesEdgeCacheOrigin#failover_origin}
     *
     * @stability stable
     */
    readonly failoverOrigin?: string;
    /**
     * Set of label tags associated with the EdgeCache resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#labels NetworkServicesEdgeCacheOrigin#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The maximum number of attempts to cache fill from this origin.
     *
     * Another attempt is made when a cache fill fails with one of the retryConditions.
     *
     * Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
     * retryConditions and failoverOrigin to control its own cache fill failures.
     *
     * The total number of allowed attempts to cache fill across this and failover origins is limited to four.
     * The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
     *
     * The last valid response from an origin will be returned to the client.
     * If no origin returns a valid response, an HTTP 503 will be returned to the client.
     *
     * Defaults to 1. Must be a value greater than 0 and less than 4.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#max_attempts NetworkServicesEdgeCacheOrigin#max_attempts}
     *
     * @stability stable
     */
    readonly maxAttempts?: number;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
     * and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#name NetworkServicesEdgeCacheOrigin#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
     *
     * This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com IPv4:35.218.1.1 IPv6:[2607:f8b0:4012:809::200e] Cloud Storage: gs://bucketname
     *
     * When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.
     * If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#origin_address NetworkServicesEdgeCacheOrigin#origin_address}
     *
     * @stability stable
     */
    readonly originAddress: string;
    /**
     * The port to connect to the origin on.
     *
     * Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#port NetworkServicesEdgeCacheOrigin#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#project NetworkServicesEdgeCacheOrigin#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The protocol to use to connect to the configured origin.
     *
     * Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
     *
     * When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server. Possible values: ["HTTP2", "HTTPS", "HTTP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#protocol NetworkServicesEdgeCacheOrigin#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Specifies one or more retry conditions for the configured origin.
     *
     * If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
     * the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
     *
     * The default retryCondition is "CONNECT_FAILURE".
     *
     * retryConditions apply to this origin, and not subsequent failoverOrigin(s),
     * which may specify their own retryConditions and maxAttempts.
     *
     * Valid values are:
     *
     * - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
     * - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
     * - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
     * - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet. Possible values: ["CONNECT_FAILURE", "HTTP_5XX", "GATEWAY_ERROR", "RETRIABLE_4XX", "NOT_FOUND"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#retry_conditions NetworkServicesEdgeCacheOrigin#retry_conditions}
     *
     * @stability stable
     */
    readonly retryConditions?: string[];
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#timeout NetworkServicesEdgeCacheOrigin#timeout}
     *
     * @stability stable
     */
    readonly timeout?: NetworkServicesEdgeCacheOriginTimeout;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#timeouts NetworkServicesEdgeCacheOrigin#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkServicesEdgeCacheOriginTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheOriginTimeout {
    /**
     * The maximum duration to wait for the origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
     *
     * Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#connect_timeout NetworkServicesEdgeCacheOrigin#connect_timeout}
     *
     * @stability stable
     */
    readonly connectTimeout?: string;
    /**
     * The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client.
     *
     * A HTTP 503 will be returned if the timeout is reached before a response is returned.
     *
     * Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#max_attempts_timeout NetworkServicesEdgeCacheOrigin#max_attempts_timeout}
     *
     * @stability stable
     */
    readonly maxAttemptsTimeout?: string;
    /**
     * The maximum duration to wait for data to arrive when reading from the HTTP connection/stream.
     *
     * Defaults to 5 seconds. The timeout must be a value between 1s and 30s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#response_timeout NetworkServicesEdgeCacheOrigin#response_timeout}
     *
     * @stability stable
     */
    readonly responseTimeout?: string;
}
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheOriginTimeoutOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _connectTimeout?;
    /**
     * @stability stable
     */
    get connectTimeout(): string | undefined;
    /**
     * @stability stable
     */
    set connectTimeout(value: string | undefined);
    /**
     * @stability stable
     */
    resetConnectTimeout(): void;
    /**
     * @stability stable
     */
    get connectTimeoutInput(): string | undefined;
    private _maxAttemptsTimeout?;
    /**
     * @stability stable
     */
    get maxAttemptsTimeout(): string | undefined;
    /**
     * @stability stable
     */
    set maxAttemptsTimeout(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaxAttemptsTimeout(): void;
    /**
     * @stability stable
     */
    get maxAttemptsTimeoutInput(): string | undefined;
    private _responseTimeout?;
    /**
     * @stability stable
     */
    get responseTimeout(): string | undefined;
    /**
     * @stability stable
     */
    set responseTimeout(value: string | undefined);
    /**
     * @stability stable
     */
    resetResponseTimeout(): void;
    /**
     * @stability stable
     */
    get responseTimeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheOriginTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#create NetworkServicesEdgeCacheOrigin#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#delete NetworkServicesEdgeCacheOrigin#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html#update NetworkServicesEdgeCacheOrigin#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html google_network_services_edge_cache_origin}.
 *
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheOrigin extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin.html google_network_services_edge_cache_origin} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheOriginConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _failoverOrigin?;
    /**
     * @stability stable
     */
    get failoverOrigin(): string | undefined;
    /**
     * @stability stable
     */
    set failoverOrigin(value: string | undefined);
    /**
     * @stability stable
     */
    resetFailoverOrigin(): void;
    /**
     * @stability stable
     */
    get failoverOriginInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maxAttempts?;
    /**
     * @stability stable
     */
    get maxAttempts(): number | undefined;
    /**
     * @stability stable
     */
    set maxAttempts(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxAttempts(): void;
    /**
     * @stability stable
     */
    get maxAttemptsInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _originAddress?;
    /**
     * @stability stable
     */
    get originAddress(): string;
    /**
     * @stability stable
     */
    set originAddress(value: string);
    /**
     * @stability stable
     */
    get originAddressInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string | undefined;
    /**
     * @stability stable
     */
    set protocol(value: string | undefined);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _retryConditions?;
    /**
     * @stability stable
     */
    get retryConditions(): string[] | undefined;
    /**
     * @stability stable
     */
    set retryConditions(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRetryConditions(): void;
    /**
     * @stability stable
     */
    get retryConditionsInput(): string[] | undefined;
    private _timeout?;
    private __timeoutOutput;
    /**
     * @stability stable
     */
    get timeout(): NetworkServicesEdgeCacheOriginTimeoutOutputReference;
    /**
     * @stability stable
     */
    putTimeout(value: NetworkServicesEdgeCacheOriginTimeout | undefined): void;
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): NetworkServicesEdgeCacheOriginTimeout | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NetworkServicesEdgeCacheOriginTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkServicesEdgeCacheOriginTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkServicesEdgeCacheOriginTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
