import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationIamCustomRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description for the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#description OrganizationIamCustomRole#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The numeric ID of the organization in which you want to create a custom role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#org_id OrganizationIamCustomRole#org_id}
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * The names of the permissions this role grants when bound in an IAM policy.
     *
     * At least one permission must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#permissions OrganizationIamCustomRole#permissions}
     *
     * @stability stable
     */
    readonly permissions: string[];
    /**
     * The role id to use for this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#role_id OrganizationIamCustomRole#role_id}
     *
     * @stability stable
     */
    readonly roleId: string;
    /**
     * The current launch stage of the role. Defaults to GA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#stage OrganizationIamCustomRole#stage}
     *
     * @stability stable
     */
    readonly stage?: string;
    /**
     * A human-readable title for the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html#title OrganizationIamCustomRole#title}
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html google_organization_iam_custom_role}.
 *
 * @stability stable
 */
export declare class OrganizationIamCustomRole extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_custom_role.html google_organization_iam_custom_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrganizationIamCustomRoleConfig);
    /**
     * @stability stable
     */
    get deleted(): any;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _orgId?;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): string[];
    /**
     * @stability stable
     */
    set permissions(value: string[]);
    /**
     * @stability stable
     */
    get permissionsInput(): string[] | undefined;
    private _roleId?;
    /**
     * @stability stable
     */
    get roleId(): string;
    /**
     * @stability stable
     */
    set roleId(value: string);
    /**
     * @stability stable
     */
    get roleIdInput(): string | undefined;
    private _stage?;
    /**
     * @stability stable
     */
    get stage(): string | undefined;
    /**
     * @stability stable
     */
    set stage(value: string | undefined);
    /**
     * @stability stable
     */
    resetStage(): void;
    /**
     * @stability stable
     */
    get stageInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
