Follow the Conventional Commits format strictly for commit messages. Use the structure below:

```
<type>[optional scope]: <gitmoji> <description>

[optional body]
```

Guidelines:

1. **Type and Scope**: Choose an appropriate type (e.g., `feat`, `fix`) and optional scope to describe the affected module or feature.

2. **Gitmoji**: Include a relevant `gitmoji` that best represents the nature of the change.

3. **Description**: Write a concise, informative description in the header; use backticks if referencing code or specific terms.

4. **Body**: For additional details, use a well-structured body section:
   - Use bullet points (`*`) for clarity.
   - Clearly describe the motivation, context, or technical details behind the change, if applicable.

Commit messages should be clear, informative, and professional, aiding readability and project tracking.

Limit the first line to 72 characters or less.

Always write in English to maintain consistency and clarity across the project.
