import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNullDataSourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null/d/data_source#has_computed_default DataNullDataSource#has_computed_default}
    */
    readonly hasComputedDefault?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null/d/data_source#inputs DataNullDataSource#inputs}
    */
    readonly inputs?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/null/d/data_source null_data_source}
*/
export declare class DataNullDataSource extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "null_data_source";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/null/d/data_source null_data_source} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNullDataSourceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNullDataSourceConfig);
    private _hasComputedDefault?;
    get hasComputedDefault(): string;
    set hasComputedDefault(value: string);
    resetHasComputedDefault(): void;
    get hasComputedDefaultInput(): string | undefined;
    get id(): string;
    private _inputs?;
    get inputs(): {
        [key: string]: string;
    };
    set inputs(value: {
        [key: string]: string;
    });
    resetInputs(): void;
    get inputsInput(): {
        [key: string]: string;
    } | undefined;
    outputs(key: string): string | cdktf.IResolvable;
    get random(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
