# to4326
to4326 convert bounds of satellite data such as GeoTIFF to Polygon of EPSG:4326.  
Depends: pyproj

## Example

```Python
from to4326 import transform

upper_left = [382200.000, 2512500.000]
lower_left = [382200.000, 2279400.000]
upper_right = [610500.000, 2512500.000]
lower_right = [610500.000, 2279400.000]
src_crs = 32645

transform.geojson_from_corner_coordinates(upper_left, lower_left, upper_right, lower_right, src_crs)
```
**result**
```JSON
{
  "type":"Feature",
  "bbox":[
    85.85296718933647,
    20.610041795245515,
    88.07596179098907,
    22.719775713801845
   ],
  "properties": {},
  "geometry":{
    "type":"Polygon",
    "coordinates": [
      [
        [
           85.85296718933647,
           22.71566587084141
        ],
        [
           85.85471144948144,
           22.505128271679137
        ],
        [
           85.85643508166952,
           22.29458504609756
        ],
        [
           85.85813822451726,
           22.08403623614523
        ],
        [
           85.8598210145163,
           21.87348188415423
        ],
        [
           85.86148358606195,
           21.662922032738383
        ],
        [
           85.86312607148135,
           21.452356724791283
        ],
        [
           85.86474860106108,
           21.24178600348436
        ],
        [
           85.86635130307411,
           21.031209912264952
        ],
        [
           85.86793430380634,
           20.820628494854294
        ],
        [
           85.8694977275825,
           20.610041795245515
        ],
        [
           86.08856914891048,
           20.611335735650073
        ],
        [
           86.30765561712383,
           20.612352097028005
        ],
        [
           86.52675351639061,
           20.613090808785984
        ],
        [
           86.7458592298015,
           20.613551819609576
        ],
        [
           86.96496913971066,
           20.613735097472322
        ],
        [
           87.18407962807663,
           20.613640629641363
        ],
        [
           87.40318707680342,
           20.6132684226797
        ],
        [
           87.6222878680816,
           20.612618502445013
        ],
        [
           87.84137838472925,
           20.611690914085163
        ],
        [
           88.06045501053292,
           20.610485722030123
        ],
        [
           88.06192160852325,
           20.82107736606614
        ],
        [
           88.0634065712253,
           21.031663741215127
        ],
        [
           88.06491001527168,
           21.242244803670587
        ],
        [
           88.06643205913487,
           21.45282050989972
        ],
        [
           88.06797282315154,
           21.663390816645528
        ],
        [
           88.06953242954742,
           21.873955680928745
        ],
        [
           88.0711110024627,
           22.084515060049903
        ],
        [
           88.07270866797775,
           22.295068911591237
        ],
        [
           88.07432555413966,
           22.5056171934187
        ],
        [
           88.07596179098907,
           22.71615986368381
        ],
        [
           87.8536827240295,
           22.717500978966182
        ],
        [
           87.63138882771706,
           22.718533183697783
        ],
        [
           87.4090839625065,
           22.71925640487522
        ],
        [
           87.18677198995947,
           22.71967059134279
        ],
        [
           86.96445677235506,
           22.719775713801845
        ],
        [
           86.74214217229994,
           22.719571764815985
        ],
        [
           86.51983205233836,
           22.719058758812512
        ],
        [
           86.29753027456248,
           22.71823673207974
        ],
        [
           86.07524070022231,
           22.717105742760463
        ],
        [
           85.85296718933647,
           22.71566587084141
        ]
      ]
    ]
  }
}
```

## note
Linear ring enclosing the pole is transformed to polar sterographic projections once.  
`Source CRS -> polar sterographic projections (EPSG:3995, EPSG:3031) -> EPSG:4326`  

Not support linear ring enclosing both poles.  

Input polygon must be less than 360deg in width and less than 180deg in height, in EPSG:4326.