# fiducialary

`fiducialary` is a tool for generating fiducial marks for use in imaging systems. These artificial markers made using circular codes can be used in photogrammetry, volumetric capture and vision search.

This project also provides some pre-generated markers you can use without having to run the program to generate them.

![Alt text](markers/sample.png?raw=true "Circular code")


# Contributors
* Luke Miller

# Thanks

`fiducialary` made for 'Project 39', a creative art project supported by Creative Victoria. 


# Using existing markers

## Looking for markers to use?


The marker images generated by this program in the `markers` folder are free to use in any way, commercial or otherwise. 
I release these free fiducial markers into the public domain.
Download them direct:
https://gitlab.com/dodgyville/fiducialary/tree/master/markers

Note: The `fiducialary` program that generated them is licensed under the open source LGPLv3 and is not public domain.

Recommended: Print out one of the A4 pdf files and separate the markers for use.


## How to use markers
* Markers work best when surrounded by space - so don't bend, cut or write on markers.
* Try to have three or four markers in each image.
* Do not use duplicate markers, all markers should be unique.
* Some research indicates that the more of your pixels occupied by a marker the better
but real-world results suggest not to make them too large.


# Generating your own markers

## Install

`pip install fiducialary`


## Source

`git clone https://gitlab.com/dodgyville/fiducialary`


## Usage

### Generate a PDF of markers

From the command line, run:
```shell
fiducialary
```

it will output a PDF

### A single marker from inside python
```
from fiducialary import generate_marker 

marker = generate_marker()
marker.write_to_png(f"example.png")
```


### A batch of markers
```
from fiducialary import generate_markers 

markers = generate_markers()
save_markers_individually(markers)

```

### A 20-bit marker

```
marker = generate_marker(bits=20)
```

# Example marker
![Alt text](markers/sample.png?raw=true "Circular code")

 
# Known issues
* When generating multiple markers, duplicate patterns may occur but rotated compared to each other. So watch out for that.

# Roadmap
* Test for rotated duplicates
* Better documentation 

# Changelog
v1.1.0
* switch to pyproject and poetry
* install as command line tool available at `fiducialary`

v1.0.1
* fix packaging issue

v1.0.0
* initial release