# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fiducialary']

package_data = \
{'': ['*']}

install_requires = \
['pycairo>=1.21.0,<2.0.0', 'typer>=0.4.1,<0.5.0']

setup_kwargs = {
    'name': 'fiducialary',
    'version': '1.1.0',
    'description': 'Generate unique circular fiducial markers for use in vision systems such as photogrammetry.',
    'long_description': '# fiducialary\n\n`fiducialary` is a tool for generating fiducial marks for use in imaging systems. These artificial markers made using circular codes can be used in photogrammetry, volumetric capture and vision search.\n\nThis project also provides some pre-generated markers you can use without having to run the program to generate them.\n\n![Alt text](markers/sample.png?raw=true "Circular code")\n\n\n# Contributors\n* Luke Miller\n\n# Thanks\n\n`fiducialary` made for \'Project 39\', a creative art project supported by Creative Victoria. \n\n\n# Using existing markers\n\n## Looking for markers to use?\n\n\nThe marker images generated by this program in the `markers` folder are free to use in any way, commercial or otherwise. \nI release these free fiducial markers into the public domain.\nDownload them direct:\nhttps://gitlab.com/dodgyville/fiducialary/tree/master/markers\n\nNote: The `fiducialary` program that generated them is licensed under the open source LGPLv3 and is not public domain.\n\nRecommended: Print out one of the A4 pdf files and separate the markers for use.\n\n\n## How to use markers\n* Markers work best when surrounded by space - so don\'t bend, cut or write on markers.\n* Try to have three or four markers in each image.\n* Do not use duplicate markers, all markers should be unique.\n* Some research indicates that the more of your pixels occupied by a marker the better\nbut real-world results suggest not to make them too large.\n\n\n# Generating your own markers\n\n## Install\n\n`pip install fiducialary`\n\n\n## Source\n\n`git clone https://gitlab.com/dodgyville/fiducialary`\n\n\n## Usage\n\n### Generate a PDF of markers\n\nFrom the command line, run:\n```shell\nfiducialary\n```\n\nit will output a PDF\n\n### A single marker from inside python\n```\nfrom fiducialary import generate_marker \n\nmarker = generate_marker()\nmarker.write_to_png(f"example.png")\n```\n\n\n### A batch of markers\n```\nfrom fiducialary import generate_markers \n\nmarkers = generate_markers()\nsave_markers_individually(markers)\n\n```\n\n### A 20-bit marker\n\n```\nmarker = generate_marker(bits=20)\n```\n\n# Example marker\n![Alt text](markers/sample.png?raw=true "Circular code")\n\n \n# Known issues\n* When generating multiple markers, duplicate patterns may occur but rotated compared to each other. So watch out for that.\n\n# Roadmap\n* Test for rotated duplicates\n* Better documentation \n\n# Changelog\nv1.1.0\n* switch to pyproject and poetry\n* install as command line tool available at `fiducialary`\n\nv1.0.1\n* fix packaging issue\n\nv1.0.0\n* initial release',
    'author': 'Luke Miller',
    'author_email': 'dodgyville@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/dodgyville/fiducialary',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
