# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ["display_frames", "display_in_cols"]

# Internal Cell
import pandas as pd
from IPython.display import display_html
from typing import Union

# Cell
def display_frames(*dataframes):
    html = ""
    for df in dataframes:
        if type(df) is pd.Series:
            df = df.to_frame()
        html += df.to_html()
    display_html(html.replace("table", 'table style="display:inline"'), raw=True)


# Cell
def display_in_cols(df: Union[pd.DataFrame, pd.Series], n_disp_cols: int = 1):
    assert n_disp_cols > 0
    n_rows_each_col = df.shape[0] // n_disp_cols
    if n_disp_cols * n_rows_each_col < df.shape[0]:
        n_rows_each_col += 1
    disp_cols = [
        df.iloc[i * n_rows_each_col : (i + 1) * n_rows_each_col]
        for i in range(n_disp_cols)
    ]
    return display_frames(*disp_cols)
