# How to make a release

1. Change version number and doc dropdown options. E.g. [46104c8](https://github.com/mne-tools/mne-nirs/pull/295/commits/46104c8cc5f971b1cce772626869dd96993b2bb7)
    1. Change the version number from `0.X.0.dev0` to `0.X.0` in [mne-nirs/mne_nirs/_version.py](https://github.com/mne-tools/mne-nirs/blob/master/mne_nirs/_version.py#L1)
    2. Add new version to [mne-nirs/doc/conf.py](https://github.com/mne-tools/mne-nirs/blob/714dc6f75ebc561e7974ba7d3256fe0ae8d35174/doc/conf.py#L131) by changing the `html_context['versions_dropdown']` dict.
       Remove the stable tag from previous version and add this version as `'v0.X.0': 'v0.X.0 (stable)',`
    3. Modify `doc/changelog.rst` and rename the `-dev` from most recent changes
2. Push change and wait for PR checks to go green.
3. Merge PR and wait for checks to go green.
4. Ensure the documentation built correctly and all figures were generated by visiting https://mne.tools/mne-nirs/index.html
5. Clone main branch locally. `git clone git@github.com:mne-tools/mne-nirs.git`
6. Create release locally by
   1. `pip install twine wheel`
   2. `rm -rf dist`
   3. `python setup.py sdist bdist_wheel`
   4. `twine upload dist/*`
7. Create a release in GitHub interface which also creates a git tag
   1. Copy change log to release notes and remove names
8. Push to github a new `maint` branch as `git push upstream main:maint/0.X`
8. Bump version to dev naming and regenerate docs (e.g. [6393b6dfc6](https://github.com/mne-tools/mne-nirs/pull/321/commits/6393b6dfc6f4fb8c5068c2ec728dfecd41c11897)).
    1. Change the version number from `0.X.0` to `0.X+1.dev0` in [mne-nirs/mne_nirs/_version.py](https://github.com/mne-tools/mne-nirs/blob/master/mne_nirs/_version.py#L1)
    2. ~~Set docs to build all versions in [conf.py](https://github.com/mne-tools/mne-nirs/blob/714dc6f75ebc561e7974ba7d3256fe0ae8d35174/doc/conf.py#L57) by setting `smv_tag_whitelist = r'^v\d+\.\d+.\d+$'`~~
9. Commit which rebuild all docs
10. ~~Set docs to build current version only in [conf.py](https://github.com/mne-tools/mne-nirs/blob/714dc6f75ebc561e7974ba7d3256fe0ae8d35174/doc/conf.py#L57) by setting `smv_tag_whitelist = 'ignore all tags'`~~
11. ~~Commit~~

Done!
