"""
Experimental feature.
This module tries to allow custom binding data from the user to be inputted into
the RNPFind software (such as data recently obtained by experiment).

Custom data should be organized as a dict of dict
For example:
custom_data[RNA][custom_protein] = [(3,4), (7,11), ...]

which means RNA has binding sites from 3-4, 7-11, ... by custom-protein.
It's good to label custom_protein with a special name to allow separation from
other sites obtained by POSTAR, ATTRACT, or RBPDB. (Alternatively, perhaps the
metadata could be labelled for each binding site).

"""

custom_data = {"Neat1": {}, "Malat1": {}}

custom_data["Neat1"]["HNRNPK-custom"] = [
    (152, 167),
    (483, 499),
    (503, 525),
    (889, 929),
    (1063, 1129),
    (1228, 1272),
    (1404, 1452),
    (1505, 1599),
    (1674, 1731),
    (2632, 2635),
    (4619, 4674),
    (4697, 4733),
    (4757, 4841),
    (4908, 4981),
    (5004, 5024),
    (5984, 5997),
    (6520, 6526),
    (7046, 7091),
    (7137, 7273),
    (7379, 7532),
    (7587, 7678),
    (8218, 8228),
    (8241, 8300),
    (8479, 8510),
    (9464, 9479),
    (10028, 10132),
    (10302, 10329),
    (11065, 11147),
    (11357, 11425),
    (11912, 11990),
    (12486, 12576),
    (13039, 13114),
    (13199, 13231),
    (13499, 13537),
    (13590, 13636),
    (13699, 13780),
    (14119, 14200),
    (14939, 15013),
    (15036, 15062),
    (15197, 15347),
    (15424, 15446),
    (16168, 16246),
    (20270, 20431),
    (20452, 20512),
    (20775, 20826),
    (20855, 20921),
    (20958, 21011),
    (21032, 21123),
    (21157, 21183),
    (21406, 21434),
    (21634, 21663),
    (21679, 21692),
    (21908, 21946),
    (21997, 22031),
    (22144, 22197),
    (22265, 22346),
    (22415, 22474),
]

custom_data["Malat1"]["HNRNPK-custom"] = [
    (1503, 1523),
    (3113, 3222),
    (3283, 3325),
    (3407, 3434),
    (3502, 3570),
    (3645, 3679),
    (3716, 3759),
    (3842, 3918),
    (3940, 3994),
    (4011, 4039),
    (4172, 4229),
    (4276, 4321),
    (4436, 4477),
    (4575, 4595),
    (4696, 4729),
    (4907, 4952),
    (5011, 5082),
    (5147, 5175),
    (5211, 5242),
    (5324, 5371),
    (5525, 5559),
    (5766, 5777),
    (5941, 5991),
    (6088, 6101),
    (6106, 6126),
    (6232, 6294),
    (6335, 6381),
    (6382, 6429),
    (6463, 6480),
    (6583, 6684),
    (6876, 6940),
    (7034, 7113),
    (7178, 7250),
    (7312, 7350),
    (7424, 7431),
    (7441, 7519),
    (7531, 7660),
    (7786, 7888),
    (7897, 7912),
    (7948, 7996),
    (8014, 8084),
    (8144, 8250),
]

custom_data["Neat1"]["YBX1-custom"] = [
    (15, 16),
    (50, 51),
    (196, 198),
    (341, 342),
    (345, 346),
    (355, 356),
    (406, 407),
    (412, 413),
    (461, 463),
    (489, 491),
    (757, 758),
    (820, 821),
    (823, 825),
    (844, 845),
    (851, 853),
    (918, 919),
    (929, 930),
    (935, 936),
    (938, 939),
    (944, 947),
    (1012, 1013),
    (1161, 1162),
    (1229, 1230),
    (1291, 1292),
    (1326, 1327),
    (1375, 1376),
    (1381, 1382),
    (1395, 1396),
    (1410, 1411),
    (1419, 1420),
    (1460, 1461),
    (1567, 1568),
    (1615, 1618),
    (1684, 1685),
    (2053, 2054),
    (2097, 2098),
    (2439, 2440),
    (2537, 2538),
    (2555, 2556),
    (2557, 2559),
    (2592, 2593),
    (2625, 2626),
    (2658, 2659),
    (2669, 2670),
    (2742, 2746),
    (3220, 3221),
    (4404, 4405),
    (5156, 5157),
    (5562, 5563),
    (5686, 5688),
    (5715, 5716),
    (7741, 7742),
    (13186, 13187),
    (13375, 13376),
    (13380, 13381),
    (13382, 13383),
    (13428, 13429),
    (13444, 13445),
    (13530, 13531),
    (13910, 13911),
    (14049, 14050),
    (14111, 14112),
    (15413, 15415),
    (19065, 19067),
    (19800, 19801),
    (21571, 21573),
]

custom_data["Malat1"]["YBX1-custom"] = [
    (1381, 1382),
    (1383, 1384),
    (1493, 1495),
    (1505, 1506),
    (1606, 1607),
    (1649, 1650),
    (1943, 1944),
    (2040, 2041),
    (2729, 2730),
    (3219, 3220),
    (3530, 3531),
    (3772, 3773),
    (3944, 3946),
    (4009, 4010),
    (4013, 4015),
    (4250, 4251),
    (4293, 4294),
    (4425, 4426),
    (4895, 4896),
    (4903, 4907),
    (4915, 4916),
    (4944, 4945),
    (5139, 5140),
    (5234, 5235),
    (5271, 5273),
    (5308, 5309),
    (5328, 5329),
    (5330, 5331),
    (5336, 5338),
    (5366, 5367),
    (5396, 5397),
    (5399, 5400),
    (5416, 5419),
    (5502, 5503),
    (5530, 5534),
    (5537, 5538),
    (5546, 5547),
    (5572, 5573),
    (5603, 5607),
    (5612, 5613),
    (5650, 5651),
    (5690, 5692),
    (5765, 5766),
    (7033, 7034),
    (7074, 7075),
    (7433, 7438),
    (7442, 7448),
    (7451, 7452),
    (7458, 7459),
    (7460, 7461),
    (7483, 7484),
    (7486, 7487),
    (7488, 7489),
    (7492, 7493),
    (7533, 7534),
    (7571, 7574),
    (7579, 7580),
    (7604, 7608),
    (7783, 7784),
    (7841, 7843),
    (8152, 8154),
    (8173, 8174),
    (8182, 8183),
]
