import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::ApplicationAutoScaling::ScalableTarget`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 */
export interface CfnScalableTargetProps {
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     */
    readonly maxCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     */
    readonly minCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
     */
    readonly resourceId: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
     */
    readonly scalableDimension: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
     */
    readonly serviceNamespace: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     */
    readonly scheduledActions?: Array<CfnScalableTarget.ScheduledActionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalableTarget`
 *
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalableTarget
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 */
export declare class CfnScalableTarget extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::ApplicationAutoScaling::ScalableTarget";
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     */
    maxCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     */
    minCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
     */
    resourceId: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
     */
    roleArn: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
     */
    scalableDimension: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
     */
    serviceNamespace: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     */
    scheduledActions: Array<CfnScalableTarget.ScheduledActionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApplicationAutoScaling::ScalableTarget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalableTargetProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnScalableTarget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html
     */
    interface ScalableTargetActionProperty {
        /**
         * `CfnScalableTarget.ScalableTargetActionProperty.MaxCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-maxcapacity
         */
        readonly maxCapacity?: number;
        /**
         * `CfnScalableTarget.ScalableTargetActionProperty.MinCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-mincapacity
         */
        readonly minCapacity?: number;
    }
}
export declare namespace CfnScalableTarget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html
     */
    interface ScheduledActionProperty {
        /**
         * `CfnScalableTarget.ScheduledActionProperty.EndTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-endtime
         */
        readonly endTime?: Date | cdk.IResolvable;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.ScalableTargetAction`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scalabletargetaction
         */
        readonly scalableTargetAction?: CfnScalableTarget.ScalableTargetActionProperty | cdk.IResolvable;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.Schedule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-schedule
         */
        readonly schedule: string;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.ScheduledActionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scheduledactionname
         */
        readonly scheduledActionName: string;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.StartTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-starttime
         */
        readonly startTime?: Date | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ApplicationAutoScaling::ScalingPolicy`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 */
export interface CfnScalingPolicyProps {
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
     */
    readonly policyName: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype
     */
    readonly policyType: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ResourceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid
     */
    readonly resourceId?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalableDimension`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension
     */
    readonly scalableDimension?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalingTargetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid
     */
    readonly scalingTargetId?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ServiceNamespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace
     */
    readonly serviceNamespace?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration
     */
    readonly stepScalingPolicyConfiguration?: CfnScalingPolicy.StepScalingPolicyConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration
     */
    readonly targetTrackingScalingPolicyConfiguration?: CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`
 *
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 */
export declare class CfnScalingPolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly cfnResourceTypeName = "AWS::ApplicationAutoScaling::ScalingPolicy";
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
     */
    policyName: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype
     */
    policyType: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ResourceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid
     */
    resourceId: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalableDimension`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension
     */
    scalableDimension: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalingTargetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid
     */
    scalingTargetId: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ServiceNamespace`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace
     */
    serviceNamespace: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration
     */
    stepScalingPolicyConfiguration: CfnScalingPolicy.StepScalingPolicyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration
     */
    targetTrackingScalingPolicyConfiguration: CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApplicationAutoScaling::ScalingPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPolicyProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html
     */
    interface CustomizedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-dimensions
         */
        readonly dimensions?: Array<CfnScalingPolicy.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-metricname
         */
        readonly metricName: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-namespace
         */
        readonly namespace: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Statistic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-statistic
         */
        readonly statistic: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-unit
         */
        readonly unit?: string;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-name
         */
        readonly name: string;
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-value
         */
        readonly value: string;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html
     */
    interface PredefinedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.PredefinedMetricType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-predefinedmetrictype
         */
        readonly predefinedMetricType: string;
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.ResourceLabel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-resourcelabel
         */
        readonly resourceLabel?: string;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html
     */
    interface StepAdjustmentProperty {
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalLowerBound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment-metricintervallowerbound
         */
        readonly metricIntervalLowerBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalUpperBound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment-metricintervalupperbound
         */
        readonly metricIntervalUpperBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.ScalingAdjustment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment-scalingadjustment
         */
        readonly scalingAdjustment: number;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html
     */
    interface StepScalingPolicyConfigurationProperty {
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.AdjustmentType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-adjustmenttype
         */
        readonly adjustmentType?: string;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.Cooldown`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-cooldown
         */
        readonly cooldown?: number;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.MetricAggregationType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-metricaggregationtype
         */
        readonly metricAggregationType?: string;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.MinAdjustmentMagnitude`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-minadjustmentmagnitude
         */
        readonly minAdjustmentMagnitude?: number;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.StepAdjustments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustments
         */
        readonly stepAdjustments?: Array<CfnScalingPolicy.StepAdjustmentProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html
     */
    interface TargetTrackingScalingPolicyConfigurationProperty {
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.CustomizedMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-customizedmetricspecification
         */
        readonly customizedMetricSpecification?: CfnScalingPolicy.CustomizedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.DisableScaleIn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-disablescalein
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.PredefinedMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-predefinedmetricspecification
         */
        readonly predefinedMetricSpecification?: CfnScalingPolicy.PredefinedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.ScaleInCooldown`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown
         */
        readonly scaleInCooldown?: number;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.ScaleOutCooldown`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown
         */
        readonly scaleOutCooldown?: number;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.TargetValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue
         */
        readonly targetValue: number;
    }
}
