"use strict";
const assert_1 = require("@aws-cdk/assert");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const cdk = require("@aws-cdk/cdk");
const appscaling = require("../lib");
const util_1 = require("./util");
module.exports = {
    'test setup target tracking on predefined metric'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const target = util_1.createScalableTarget(stack);
        // WHEN
        target.scaleToTrackMetric('Tracking', {
            predefinedMetric: appscaling.PredefinedMetric.EC2SpotFleetRequestAverageCPUUtilization,
            targetValue: 30,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApplicationAutoScaling::ScalingPolicy', {
            PolicyType: "TargetTrackingScaling",
            TargetTrackingScalingPolicyConfiguration: {
                PredefinedMetricSpecification: { PredefinedMetricType: "EC2SpotFleetRequestAverageCPUUtilization" },
                TargetValue: 30
            }
        }));
        test.done();
    },
    'test setup target tracking on custom metric'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const target = util_1.createScalableTarget(stack);
        // WHEN
        target.scaleToTrackMetric('Tracking', {
            customMetric: new cloudwatch.Metric({ namespace: 'Test', metricName: 'Metric' }),
            targetValue: 30,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ApplicationAutoScaling::ScalingPolicy', {
            PolicyType: "TargetTrackingScaling",
            TargetTrackingScalingPolicyConfiguration: {
                CustomizedMetricSpecification: {
                    MetricName: "Metric",
                    Namespace: "Test",
                    Statistic: "Average"
                },
                TargetValue: 30
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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