"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const scalingcommon = require("@aws-cdk/aws-autoscaling-common");
const fc = require("fast-check");
const appscaling = require("../lib");
const lib_1 = require("../lib");
function createScalableTarget(scope) {
    return new appscaling.ScalableTarget(scope, 'Target', {
        serviceNamespace: lib_1.ServiceNamespace.DynamoDb,
        scalableDimension: 'test:TestCount',
        resourceId: 'test:this/test',
        minCapacity: 1,
        maxCapacity: 20,
    });
}
exports.createScalableTarget = createScalableTarget;
class ArbitraryInputIntervals extends fc.Arbitrary {
    generate(mrng) {
        const ret = scalingcommon.generateArbitraryIntervals(mrng);
        return new fc.Shrinkable(ret.intervals);
    }
}
exports.ArbitraryInputIntervals = ArbitraryInputIntervals;
function arbitrary_input_intervals() {
    return new ArbitraryInputIntervals();
}
exports.arbitrary_input_intervals = arbitrary_input_intervals;
//# sourceMappingURL=data:application/json;base64,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