# mypy-boto3-dms

[![PyPI - mypy-boto3-dms](https://img.shields.io/pypi/v/mypy-boto3-dms.svg?color=blue)](https://pypi.org/project/mypy-boto3-dms)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dms.svg?color=blue)](https://pypi.org/project/mypy-boto3-dms)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DatabaseMigrationService 1.14.0](https://boto3.amazonaws.com/v1/documentation/api/1.14.0/reference/services/dms.html#DatabaseMigrationService) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DatabaseMigrationService` service.

```bash
python -m pip install boto3-stubs[dms]
```

## How to use

### Client annotations

`DatabaseMigrationServiceClient` provides annotations for `boto3.client("dms")`.

```python
import boto3

from mypy_boto3_dms import DatabaseMigrationServiceClient

client: DatabaseMigrationServiceClient = boto3.client("dms")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DatabaseMigrationServiceClient = session.client("dms")
```

### Paginators annotations

`mypy_boto3_dms.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_dms import DatabaseMigrationServiceClient
from mypy_boto3_dms.paginator import (
    DescribeCertificatesPaginator,
    DescribeConnectionsPaginator,
    DescribeEndpointTypesPaginator,
    DescribeEndpointsPaginator,
    DescribeEventSubscriptionsPaginator,
    DescribeEventsPaginator,
    DescribeOrderableReplicationInstancesPaginator,
    DescribeReplicationInstancesPaginator,
    DescribeReplicationSubnetGroupsPaginator,
    DescribeReplicationTaskAssessmentResultsPaginator,
    DescribeReplicationTasksPaginator,
    DescribeSchemasPaginator,
    DescribeTableStatisticsPaginator,
)

client: DatabaseMigrationServiceClient = boto3.client("dms")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_certificates_paginator: DescribeCertificatesPaginator = client.get_paginator("describe_certificates")
describe_connections_paginator: DescribeConnectionsPaginator = client.get_paginator("describe_connections")
describe_endpoint_types_paginator: DescribeEndpointTypesPaginator = client.get_paginator("describe_endpoint_types")
describe_endpoints_paginator: DescribeEndpointsPaginator = client.get_paginator("describe_endpoints")
describe_event_subscriptions_paginator: DescribeEventSubscriptionsPaginator = client.get_paginator("describe_event_subscriptions")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_orderable_replication_instances_paginator: DescribeOrderableReplicationInstancesPaginator = client.get_paginator("describe_orderable_replication_instances")
describe_replication_instances_paginator: DescribeReplicationInstancesPaginator = client.get_paginator("describe_replication_instances")
describe_replication_subnet_groups_paginator: DescribeReplicationSubnetGroupsPaginator = client.get_paginator("describe_replication_subnet_groups")
describe_replication_task_assessment_results_paginator: DescribeReplicationTaskAssessmentResultsPaginator = client.get_paginator("describe_replication_task_assessment_results")
describe_replication_tasks_paginator: DescribeReplicationTasksPaginator = client.get_paginator("describe_replication_tasks")
describe_schemas_paginator: DescribeSchemasPaginator = client.get_paginator("describe_schemas")
describe_table_statistics_paginator: DescribeTableStatisticsPaginator = client.get_paginator("describe_table_statistics")
```


### Waiters annotations

`mypy_boto3_dms.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_dms import DatabaseMigrationServiceClient
from mypy_boto3_dms.waiter import (
    EndpointDeletedWaiter,
    ReplicationInstanceAvailableWaiter,
    ReplicationInstanceDeletedWaiter,
    ReplicationTaskDeletedWaiter,
    ReplicationTaskReadyWaiter,
    ReplicationTaskRunningWaiter,
    ReplicationTaskStoppedWaiter,
    TestConnectionSucceedsWaiter,
)

client: DatabaseMigrationServiceClient = boto3.client("dms")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
endpoint_deleted_waiter: EndpointDeletedWaiter = client.get_waiter("endpoint_deleted")
replication_instance_available_waiter: ReplicationInstanceAvailableWaiter = client.get_waiter("replication_instance_available")
replication_instance_deleted_waiter: ReplicationInstanceDeletedWaiter = client.get_waiter("replication_instance_deleted")
replication_task_deleted_waiter: ReplicationTaskDeletedWaiter = client.get_waiter("replication_task_deleted")
replication_task_ready_waiter: ReplicationTaskReadyWaiter = client.get_waiter("replication_task_ready")
replication_task_running_waiter: ReplicationTaskRunningWaiter = client.get_waiter("replication_task_running")
replication_task_stopped_waiter: ReplicationTaskStoppedWaiter = client.get_waiter("replication_task_stopped")
test_connection_succeeds_waiter: TestConnectionSucceedsWaiter = client.get_waiter("test_connection_succeeds")
```





### Typed dictionations

`mypy_boto3_dms.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_dms.type_defs import AccountQuotaTypeDef, ...

def get_structure() -> AccountQuotaTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_dms` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("dms")

session_client = boto3.Session().client("dms")
```