"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cloudfront = require("@aws-cdk/aws-cloudfront");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const origins = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'cloudfront-origin-group');
const bucket = new s3.Bucket(stack, 'Bucket', {
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const originGroup = new origins.OriginGroup({
    primaryOrigin: new origins.S3Origin(bucket),
    fallbackOrigin: new origins.HttpOrigin('www.example.com'),
});
new cloudfront.Distribution(stack, 'Distribution', {
    defaultBehavior: { origin: originGroup },
    additionalBehaviors: {
        '/api': {
            origin: originGroup,
        },
    },
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcub3JpZ2luLWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcub3JpZ2luLWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsc0RBQXNEO0FBQ3RELHNDQUFzQztBQUN0QyxxQ0FBcUM7QUFDckMsa0NBQWtDO0FBRWxDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUseUJBQXlCLENBQUMsQ0FBQztBQUU1RCxNQUFNLE1BQU0sR0FBRyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRTtJQUM1QyxhQUFhLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxPQUFPO0NBQ3pDLENBQUMsQ0FBQztBQUVILE1BQU0sV0FBVyxHQUFHLElBQUksT0FBTyxDQUFDLFdBQVcsQ0FBQztJQUMxQyxhQUFhLEVBQUUsSUFBSSxPQUFPLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQztJQUMzQyxjQUFjLEVBQUUsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFDO0NBQzFELENBQUMsQ0FBQztBQUVILElBQUksVUFBVSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO0lBQ2pELGVBQWUsRUFBRSxFQUFFLE1BQU0sRUFBRSxXQUFXLEVBQUU7SUFDeEMsbUJBQW1CLEVBQUU7UUFDbkIsTUFBTSxFQUFFO1lBQ04sTUFBTSxFQUFFLFdBQVc7U0FDcEI7S0FDRjtDQUNGLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNsb3VkZnJvbnQgZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIG9yaWdpbnMgZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdjbG91ZGZyb250LW9yaWdpbi1ncm91cCcpO1xuXG5jb25zdCBidWNrZXQgPSBuZXcgczMuQnVja2V0KHN0YWNrLCAnQnVja2V0Jywge1xuICByZW1vdmFsUG9saWN5OiBjZGsuUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxufSk7XG5cbmNvbnN0IG9yaWdpbkdyb3VwID0gbmV3IG9yaWdpbnMuT3JpZ2luR3JvdXAoe1xuICBwcmltYXJ5T3JpZ2luOiBuZXcgb3JpZ2lucy5TM09yaWdpbihidWNrZXQpLFxuICBmYWxsYmFja09yaWdpbjogbmV3IG9yaWdpbnMuSHR0cE9yaWdpbignd3d3LmV4YW1wbGUuY29tJyksXG59KTtcblxubmV3IGNsb3VkZnJvbnQuRGlzdHJpYnV0aW9uKHN0YWNrLCAnRGlzdHJpYnV0aW9uJywge1xuICBkZWZhdWx0QmVoYXZpb3I6IHsgb3JpZ2luOiBvcmlnaW5Hcm91cCB9LFxuICBhZGRpdGlvbmFsQmVoYXZpb3JzOiB7XG4gICAgJy9hcGknOiB7XG4gICAgICBvcmlnaW46IG9yaWdpbkdyb3VwLFxuICAgIH0sXG4gIH0sXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=