"""
This package contains several modules related to cost functions.

CostFunctions map circuit parameters, represented as a vector of real numbers,
to a real cost value. They are either generated by CostFunctionGenerators or
constructed normally. CostFunctions are minimized by minimizers, which change
the parameters such that the cost value is best minimized. Minimization can be
used on its own with `circuit.minimize` or as a circuit instantiation method
with `circuit.instantiate`.
"""
from __future__ import annotations

from bqskit.ir.opt.cost.function import CostFunction
from bqskit.ir.opt.cost.functions import HilbertSchmidtCost
from bqskit.ir.opt.cost.functions import HilbertSchmidtCostGenerator
from bqskit.ir.opt.cost.functions import HilbertSchmidtResiduals
from bqskit.ir.opt.cost.functions import HilbertSchmidtResidualsGenerator
from bqskit.ir.opt.cost.generator import CostFunctionGenerator

__all__ = [
    'CostFunction',
    'CostFunctionGenerator',
    'HilbertSchmidtCost',
    'HilbertSchmidtCostGenerator',
    'HilbertSchmidtResiduals',
    'HilbertSchmidtResidualsGenerator',
]
