# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['rstcheck', 'tests', 'tests.integration_tests']

package_data = \
{'': ['*']}

modules = \
['AUTHORS']
install_requires = \
['docutils>=0.7,<0.19',
 'pydantic>=1.2,<2.0',
 'typer[all]>=0.3.2,<0.5',
 'types-docutils>=0.18,<0.19']

extras_require = \
{':python_version < "3.8"': ['importlib-metadata>=1.6,<5.0',
                             'typing-extensions>=3.7.4,<5.0'],
 'sphinx': ['sphinx>=4.0,<5.0'],
 'testing': ['pytest>=6.0',
             'pytest-cov>=3.0',
             'coverage[toml]>=6.0',
             'coverage-conditional-plugin>=0.5',
             'pytest-randomly>=3.0',
             'pytest-mock>=3.7',
             'mock>=4.0'],
 'toml': ['tomli>=2.0,<3.0']}

entry_points = \
{'console_scripts': ['rstcheck = rstcheck.cli:main']}

setup_kwargs = {
    'name': 'rstcheck',
    'version': '6.0.0a1',
    'description': 'Checks syntax of reStructuredText and code blocks nested within it',
    'long_description': '========\nrstcheck\n========\n\n.. image:: https://github.com/myint/rstcheck/workflows/Test%20code/badge.svg?branch=master\n    :target: https://github.com/myint/rstcheck/actions/workflows/test.yaml\n    :alt: Test status\n\n.. image:: https://github.com/myint/rstcheck/workflows/QA/badge.svg?branch=master\n    :target: https://github.com/myint/rstcheck/actions/workflows/qa.yaml\n    :alt: QA status\n\nChecks syntax of reStructuredText and code blocks nested within it.\n\n\n***Documentation will be updated soon.***\n\n\n.. contents::\n\n\nInstallation\n============\n\nFrom pip\n\n.. code:: shell\n\n    $ pip install rstcheck\n\nTo use pyproject.toml for configuration::\n\n    $ pip install rstcheck[toml]\n\nSupported languages in code blocks\n==================================\n\n- Bash\n- Doctest\n- C (C99)\n- C++ (C++11)\n- JSON\n- XML\n- Python\n- reStructuredText\n\n\nExamples\n========\n\nWith bad Python syntax:\n\n.. code:: rst\n\n    ====\n    Test\n    ====\n\n    .. code:: python\n\n        print(\n\n.. code:: text\n\n    $ rstcheck bad_python.rst\n    bad_python.rst:7: (ERROR/3) (python) unexpected EOF while parsing\n\nWith bad C++ syntax:\n\n.. code:: rst\n\n    ====\n    Test\n    ====\n\n    .. code:: cpp\n\n        int main()\n        {\n            return x;\n        }\n\n.. code:: text\n\n    $ rstcheck bad_cpp.rst\n    bad_cpp.rst:9: (ERROR/3) (cpp) error: \'x\' was not declared in this scope\n\nWith bad syntax in the reStructuredText document itself:\n\n.. code:: rst\n\n    ====\n    Test\n    ===\n\n.. code:: text\n\n    $ rstcheck bad_rst.rst\n    bad_rst.rst:1: (SEVERE/4) Title overline & underline mismatch.\n\n\nOptions\n=======\n\nIf ``sphinx`` and ``tomli`` are installed:\n\n.. code:: text\n\n    Usage: rstcheck [OPTIONS] FILES...\n\n    CLI of rstcheck.\n\n    Enabled features: [\'Sphinx\', \'Toml\']\n\n    Arguments:\n    FILES...  RST files to check. Can be files or directories if --recursive is\n                passed too.  [required]\n\n    Options:\n    --config PATH                Config file to load. Can be a INI or TOML file\n                                or directory. If a directory is passed it will\n                                be searched for .rstcheck.cfg | pyproject.toml\n                                | setup.cfg.\n    -r, --recursive              Recursively search passed directories for RST\n                                files to check.\n    --report-level LEVEL         The report level of the linting issues found.\n                                Valid levels are: INFO | WARNING | ERROR |\n                                SEVERE | NONE. Defauls to INFO. Can be set in\n                                config file.\n    --ignore-directives TEXT     Comma-separated-list of directives to add to\n                                the ignore list. Can be set in config file.\n    --ignore-roles TEXT          Comma-separated-list of roles to add to the\n                                ignore list. Can be set in config file.\n    --ignore-substitutions TEXT  Comma-separated-list of substitutions to add to\n                                the ignore list. Can be set in config file.\n    --ignore-languages TEXT      Comma-separated-list of languages for code-\n                                blocks to add to the ignore list. The code in\n                                ignored code-blocks will not be checked for\n                                errors. Can be set in config file.\n    --ignore-messages REGEX      A regular expression to match linting issue\n                                messages against to ignore. Can be set in\n                                config file.\n    --install-completion         Install completion for the current shell.\n    --show-completion            Show completion for the current shell, to copy\n                                it or customize the installation.\n    --help                       Show this message and exit.\n\n\nIgnore specific languages\n=========================\n\nYou can ignore checking of nested code blocks by language. Either use the\ncommand-line option ``--ignore-languages`` or put a comment in the document:\n\n.. code:: rst\n\n    .. rstcheck: ignore-languages=cpp,python,rst\n\n\nIgnore specific errors\n======================\n\nSince docutils doesn\'t categorize their error messages beyond the high-level\ncategories of: info, warning, error, and severe; we need filter them out at a\ntextual level. This is done by passing a Python regex. As example you can pass\na regex like this to ignore several errors\n\n.. code:: text\n\n    (Title underline too short.*|Duplicate implicit target.*\')\n\n\nConfiguration file\n==================\n\nYou can use the same arguments from the command line as options in the\nlocal configuration file of the project (just replace ``-`` for ``_``).\n``rstcheck`` looks for a file ``.rstcheck.cfg``, ``setup.cfg``, or\n``pyproject.toml`` in the directory or ancestor directories of the file it is\nchecking.\n\n``.rstcheck.cfg`` takes precedence over ``setup.cfg``.\n\nSettings in the config file are overwritten by CLI options.\n\nFor example, consider a project with the following directory structure\n\n.. code:: text\n\n    foo\n    ├── docs\n    │   └── bar.rst\n    ├── index.rst\n    └── .rstcheck.cfg\n\n``.rstcheck.cfg`` contains:\n\n.. code:: ini\n\n    [rstcheck]\n    ignore_directives=one,two,three\n    ignore_roles=src,RFC\n    ignore_messages=(Document or section may not begin with a transition\\.$)\n    report_level=warning\n\n``bar.rst`` contains:\n\n.. code:: rst\n\n    Bar\n    ===\n\n    :src:`hello_world.py`\n    :RFC:`793`\n\n    .. one::\n\n       Hello\n\n``rstcheck`` will make use of the ``.rstcheck.cfg``\n\n.. code:: shell\n\n    $ rstcheck foo/docs/bar.rst\n\n\nFor a Python project, you should put the configuration settings for\n``rstcheck`` inside the general ``setup.cfg`` `distutils configuration file`_,\nin the project root.\n\nFor a PEP-517/PEP-518 project, you should put the configuration settings for\n``rstcheck`` inside the ``pyproject.toml`` configuration file in the project\nroot.  These should be placed in a ``[tool.rstcheck]`` section.  Keep in mind\nbackslashes need to be escaped, so to ignore the message\n``"(Document or section may not begin with a transition\\.$)"`` you\'ll need to\nescape the backslash in ``pyproject.toml`` like this\n``"(Document or section may not begin with a transition\\\\.$)"``.  See the\n``pyproject.toml`` file in ``examples/with_configuration``.\n\nYou can override the location of the config file with the ``--config`` argument\n\n.. code:: shell\n\n    $ rstcheck --config $HOME/.rstcheck.ini foo/docs/bar.rst\n\nwill use the file ``.rstcheck.ini`` in your home directory. If the argument to\n``--config`` is a directory, ``rstcheck`` will search that directory and any\nany of its ancestors for a file ``.rstcheck.cfg`` or ``setup.cfg``\n\n.. code:: shell\n\n   $ rstcheck --config foo /tmp/bar.rst\n\nwould use the project configuration in ``./foo/.rstcheck.cfg`` to check the\nunrelated file ``/tmp/bar.rst``.\n\n.. _distutils configuration file: https://docs.python.org/3/distutils/configfile.html\n\n\nSphinx\n======\n\nTo enable Sphinx\n\n.. code:: shell\n\n    $ pip install rstcheck[sphinx]\n\n    # or\n\n    $ pip install sphinx\n\nWith version 4.0 ``rstcheck`` added Sphinx as an optional extra where the version\'s lower\nconstraint is >=4.0 because of Sphinx\'s open upper constraints on jinja2 and markupsafe,\nwhich result in import errors if not pinned below version 3 and 2 respectively. This happend\nin Sphinx version 4.0.\n\nYou can also add Sphinx by yourself but the installed Sphinx version must be at least 2.0.\n\nTo check that Sphinx support is enabled\n\n.. code:: shell\n\n    $ rstcheck -h | grep \'Sphinx is enabled\'\n\n\nUsage in Vim\n============\n\n\nUsing with Syntastic_:\n----------------------\n\n.. code:: vim\n\n    let g:syntastic_rst_checkers = [\'rstcheck\']\n\n\nUsing with ALE_:\n----------------\n\nJust install ``rstcheck`` and make sure is on your path.\n\n.. _Syntastic: https://github.com/scrooloose/syntastic\n.. _ALE: https://github.com/w0rp/ale\n\n\nUse as a module\n===============\n\n``rstcheck.check()`` yields a series of tuples. The first value of each tuple\nis the line number (not the line index). The second value is the error message.\n\n>>> import rstcheck\n>>> list(rstcheck.check(\'Example\\n===\'))\n[(2, \'(INFO/1) Possible title underline, too short for the title.\')]\n\nNote that this does not load any configuration as that would mutate the\n``docutils`` registries.\n\n\nUse as a pre-commit hook\n========================\n\nAdd this to your ``.pre-commit-config.yaml``\n\n.. code:: yaml\n\n    -   repo: https://github.com/myint/rstcheck\n        rev: \'\'  # Use the sha / tag you want to point at\n        hooks:\n        -   id: rstcheck\n\n\nUse with Mega-Linter:\n=====================\n\nJust install `Mega-Linter <https://nvuillam.github.io/mega-linter/>`__ in your repository,\n`rstcheck <https://nvuillam.github.io/mega-linter/descriptors/rst_rstcheck/>`__\nis part of the 70 linters activated out of the box.\n\n\nDevelopment\n===========\n\nThis project relies on `poetry`_ as its management tool for dependencies, building and venvs.\nYou do not need to have `poetry`_ installed globally, but it is recommended to.\n\nFor development venv creation run\n\n.. code:: shell\n\n    $ poetry install\n\n    # or without global `poetry`\n\n    $ python3 -m venv .venv\n    $ source .venv/bin/activate\n    $ pip install poetry\n\nWith global `poetry`_ you do not need to activate the venv. `poetry`_ will run\ncommands inside the venv if you call them like this\n\n.. code:: shell\n\n    $ poetry run COMMAND\n\n.. _poetry: https://python-poetry.org/\n\n\nTesting\n-------\n\nUnit tests are in ``tests/test_rstcheck.py``.\nSystem tests are in ``tests/test_as_cli_tool.py``.\n\nSystem tests are composed of example good/bad input. The test inputs are\ncontained in the ``testing/examples`` directory. For basic tests, adding a test should\njust be a matter of adding files to ``examples/good`` or ``examples/bad``.\n\nTo run all the tests you have three options\n\n.. code:: shell\n\n    # With global `poetry` or with active development venv:\n    $ poetry run tox\n\n    # With active development venv:\n    $ tox\n\n    # Without `poetry` and development venv:\n    $ python3 -m venv .venv\n    $ source .venv/bin/activate\n    $ pip install tox\n    $ tox\n\n\nKnown limitations / FAQ\n=======================\n\nThere are inherent limitations to what ``rstcheck`` can and cannot do. The reason for this is that\n``rstcheck`` itself does not parse the rst source but gives it to ``docutils`` and gets the errors\nback. Therefore rstcheck in the sense of rst source is more an error accumulation tool. The same\ngoes for the source code in supported code blocks.\n\n\nHistory\n=======\n\n\n(next version)\n--------------\n\n\n6.0.0a1 (2022-05-13)\n--------------------\n\n- Fix inability to ignore ``code``, ``code-block`` and ``sourcecode`` directives (#79)\n- Fix ``code-block`` options recognition (#62)\n- Add section with ``Known limitations / FAQ`` to the README (#97)\n- Accumulate all errors in rst source instead of only one (#83)\n- Fix Malformed tables because of substitutions (#82)\n- Fix: remove ``include`` directive from ignore list when sphinx is active (#70)\n- Allow errors in code blocks to be ignored via ignore_messages (#100)\n\n\n.. _beaking_changes_v6a1:\n\nBREAKING CHANGES\n~~~~~~~~~~~~~~~~\n\n- Full restructuring of the code base (#100)\n- Rewrite of CLI with ``typer`` (#100)\n- Renamed config ``report`` to ``report_level`` (#100)\n- Renamed config ``ignore_language`` to ``ignore_languages`` (#100)\n- Renamed CLI option ``--ignore-language`` to ``--ignore-languages`` (#100)\n- Drop CLI option ``--ignore`` as alias to ``--ignore-languages`` (#100)\n- Drop CLI option ``--debug`` (#100)\n- Drop CLI option ``--version``; may be readded later (#100)\n- Don\'t support multiline strings in INI files (#100)\n- Allow a string or list of strings for ``ignore_messages`` in TOML config files (#100)\n- Prohibit numbers as report level (#100)\n- Non-existing files are skipped; ``rstcheck non-existing-file.rst`` exits 0; may be changed later (#100)\n- Drop support for sphinx < 2.0\n- Drop default values for directves and roles for sphinx (#65)\n- CLI options now take precedence over config file options (#96)\n\n\n5.0.0 (2022-04-17)\n------------------\n\n- Add examples/ to sdist\n- Add ``Development`` section to README and update ``Testing`` section\n- Add ``Mega-Linter`` section to README\n- Add ``BREAKING CHANGES`` sections to changelog\n\n\n.. _beaking_changes_v5:\n\nBREAKING CHANGES\n~~~~~~~~~~~~~~~~\n\n- Rewrite test.bash script in pytest test cases adn run them on linux in CI\n- Rewrite old test suite in pytest and AAA style\n\n\n4.1.0 (2022-04-16)\n------------------\n\n- Fix shebangs and scripts to use ``python3`` instead of ``python`` (#78)\n- Improve the gcc checker functions by removing restrictions and\n  using environment variable flags (#88)\n- Fix pool size on windows by setting max to 61 (#86)\n- Update test.bash script and makefile with new file location\n\n\n4.0.0 (2022-04-15)\n------------------\n\n- Add inline type annotations\n- Add ``sphinx`` as extra\n- Update build process and set up ``poetry``\n- Add ``pre-commit`` and ``tox`` for automated testing, linting and formatting\n- Move from travis to github actions\n- Activate dependabot\n\n\n.. _beaking_changes_v4:\n\nBREAKING CHANGES\n~~~~~~~~~~~~~~~~\n\n- Drop support for python versions prior 3.7\n\n\n3.5.0 (2022-04-14)\n------------------\n\n- Deprecate python versions prior 3.7\n\n\n3.4.0 (2022-04-12)\n------------------\n\n- Add ``--config`` option to change the location of the config file.\n- Add ``pre-commit`` hooks config.\n\n\n3.3.1 (2018-10-09)\n------------------\n\n- Make compatible with Sphinx >= 1.8.\n\n\n3.3 (2018-03-17)\n----------------\n\n- Parse more options from configuration file (thanks to Santos Gallegos).\n- Allow ignoring specific (info/warning/error) messages via\n  ``--ignore-messages`` (thanks to Santos Gallegos).\n\n\n3.2 (2018-02-17)\n----------------\n\n- Check for invalid Markdown-style links (thanks to biscuitsnake).\n- Allow configuration to be stored in ``setup.cfg`` (thanks to Maël Pedretti).\n- Add ``--recursive`` option to recursively drill down directories to check for\n  all ``*.rst`` files.\n\n\n3.1 (2017-03-08)\n----------------\n\n- Add support for checking XML code blocks (thanks to Sameer Singh).\n\n\n3.0.1 (2017-03-01)\n------------------\n\n- Support UTF-8 byte order marks (BOM). Previously, ``docutils`` would\n  interpret the BOM as a visible character, which would lead to false positives\n  about underlines being too short.\n\n\n3.0 (2016-12-19)\n----------------\n\n- Optionally support Sphinx 1.5. Sphinx support will be enabled if Sphinx is\n  installed.\n\n\n2.0 (2015-07-27)\n----------------\n\n- Support loading settings from configuration files.\n\n\n1.0 (2015-03-14)\n----------------\n\n- Add Sphinx support.\n\n\n0.1 (2013-12-02)\n----------------\n\n- Initial version.\n\n\n.. rstcheck: ignore-languages=cpp,python,rst\n',
    'author': 'Steven Myint',
    'author_email': 'git@stevenmyint.com',
    'maintainer': 'Christian Riedel',
    'maintainer_email': 'cielquan@protonmail.com',
    'url': 'https://github.com/myint/rstcheck',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
