# mypy-boto3-robomaker

[![PyPI - mypy-boto3-robomaker](https://img.shields.io/pypi/v/mypy-boto3-robomaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-robomaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-robomaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-robomaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.RoboMaker 1.14.55](https://boto3.amazonaws.com/v1/documentation/api/1.14.55/reference/services/robomaker.html#RoboMaker) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-robomaker](#mypy-boto3-robomaker)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `RoboMaker` service.

```bash
python -m pip install boto3-stubs[robomaker]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[robomaker]` in your environment: `python -m pip install 'boto3-stubs[robomaker]'`

Both type checking and auto-complete should work for `RoboMaker` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[robomaker]` in your environment: `python -m pip install 'boto3-stubs[robomaker]'`

Both type checking and auto-complete should work for `RoboMaker` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[robomaker]` in your environment: `python -m pip install 'boto3-stubs[robomaker]'`
- Run `mypy` as usual

Type checking should work for `RoboMaker` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[robomaker]` in your environment: `python -m pip install 'boto3-stubs[robomaker]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `RoboMaker` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`RoboMakerClient` provides annotations for `boto3.client("robomaker")`.

```python
import boto3

from mypy_boto3_robomaker import RoboMakerClient

client: RoboMakerClient = boto3.client("robomaker")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RoboMakerClient = session.client("robomaker")
```

### Paginators annotations

`mypy_boto3_robomaker.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_robomaker import RoboMakerClient
from mypy_boto3_robomaker.paginator import (
    ListDeploymentJobsPaginator,
    ListFleetsPaginator,
    ListRobotApplicationsPaginator,
    ListRobotsPaginator,
    ListSimulationApplicationsPaginator,
    ListSimulationJobBatchesPaginator,
    ListSimulationJobsPaginator,
    ListWorldExportJobsPaginator,
    ListWorldGenerationJobsPaginator,
    ListWorldsPaginator,
    ListWorldTemplatesPaginator,
)

client: RoboMakerClient = boto3.client("robomaker")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_deployment_jobs_paginator: ListDeploymentJobsPaginator = client.get_paginator("list_deployment_jobs")
list_fleets_paginator: ListFleetsPaginator = client.get_paginator("list_fleets")
list_robot_applications_paginator: ListRobotApplicationsPaginator = client.get_paginator("list_robot_applications")
list_robots_paginator: ListRobotsPaginator = client.get_paginator("list_robots")
list_simulation_applications_paginator: ListSimulationApplicationsPaginator = client.get_paginator("list_simulation_applications")
list_simulation_job_batches_paginator: ListSimulationJobBatchesPaginator = client.get_paginator("list_simulation_job_batches")
list_simulation_jobs_paginator: ListSimulationJobsPaginator = client.get_paginator("list_simulation_jobs")
list_world_export_jobs_paginator: ListWorldExportJobsPaginator = client.get_paginator("list_world_export_jobs")
list_world_generation_jobs_paginator: ListWorldGenerationJobsPaginator = client.get_paginator("list_world_generation_jobs")
list_world_templates_paginator: ListWorldTemplatesPaginator = client.get_paginator("list_world_templates")
list_worlds_paginator: ListWorldsPaginator = client.get_paginator("list_worlds")
```







### Typed dictionations

`mypy_boto3_robomaker.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_robomaker.type_defs import (
    BatchDeleteWorldsResponseTypeDef,
    BatchDescribeSimulationJobResponseTypeDef,
    BatchPolicyTypeDef,
    ComputeResponseTypeDef,
    ComputeTypeDef,
    CreateDeploymentJobResponseTypeDef,
    CreateFleetResponseTypeDef,
    CreateRobotApplicationResponseTypeDef,
    CreateRobotApplicationVersionResponseTypeDef,
    CreateRobotResponseTypeDef,
    CreateSimulationApplicationResponseTypeDef,
    CreateSimulationApplicationVersionResponseTypeDef,
    CreateSimulationJobResponseTypeDef,
    CreateWorldExportJobResponseTypeDef,
    CreateWorldGenerationJobResponseTypeDef,
    CreateWorldTemplateResponseTypeDef,
    DataSourceConfigTypeDef,
    DataSourceTypeDef,
    DeploymentApplicationConfigTypeDef,
    DeploymentConfigTypeDef,
    DeploymentJobTypeDef,
    DeploymentLaunchConfigTypeDef,
    DeregisterRobotResponseTypeDef,
    DescribeDeploymentJobResponseTypeDef,
    DescribeFleetResponseTypeDef,
    DescribeRobotApplicationResponseTypeDef,
    DescribeRobotResponseTypeDef,
    DescribeSimulationApplicationResponseTypeDef,
    DescribeSimulationJobBatchResponseTypeDef,
    DescribeSimulationJobResponseTypeDef,
    DescribeWorldExportJobResponseTypeDef,
    DescribeWorldGenerationJobResponseTypeDef,
    DescribeWorldResponseTypeDef,
    DescribeWorldTemplateResponseTypeDef,
    FailedCreateSimulationJobRequestTypeDef,
    FailureSummaryTypeDef,
    FilterTypeDef,
    FinishedWorldsSummaryTypeDef,
    FleetTypeDef,
    GetWorldTemplateBodyResponseTypeDef,
    LaunchConfigTypeDef,
    ListDeploymentJobsResponseTypeDef,
    ListFleetsResponseTypeDef,
    ListRobotApplicationsResponseTypeDef,
    ListRobotsResponseTypeDef,
    ListSimulationApplicationsResponseTypeDef,
    ListSimulationJobBatchesResponseTypeDef,
    ListSimulationJobsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWorldExportJobsResponseTypeDef,
    ListWorldGenerationJobsResponseTypeDef,
    ListWorldsResponseTypeDef,
    ListWorldTemplatesResponseTypeDef,
    LoggingConfigTypeDef,
    NetworkInterfaceTypeDef,
    OutputLocationTypeDef,
    PaginatorConfigTypeDef,
    PortForwardingConfigTypeDef,
    PortMappingTypeDef,
    ProgressDetailTypeDef,
    RegisterRobotResponseTypeDef,
    RenderingEngineTypeDef,
    RobotApplicationConfigTypeDef,
    RobotApplicationSummaryTypeDef,
    RobotDeploymentTypeDef,
    RobotSoftwareSuiteTypeDef,
    RobotTypeDef,
    S3KeyOutputTypeDef,
    S3ObjectTypeDef,
    SimulationApplicationConfigTypeDef,
    SimulationApplicationSummaryTypeDef,
    SimulationJobBatchSummaryTypeDef,
    SimulationJobRequestTypeDef,
    SimulationJobSummaryTypeDef,
    SimulationJobTypeDef,
    SimulationSoftwareSuiteTypeDef,
    SourceConfigTypeDef,
    SourceTypeDef,
    StartSimulationJobBatchResponseTypeDef,
    SyncDeploymentJobResponseTypeDef,
    TemplateLocationTypeDef,
    TemplateSummaryTypeDef,
    UpdateRobotApplicationResponseTypeDef,
    UpdateSimulationApplicationResponseTypeDef,
    UpdateWorldTemplateResponseTypeDef,
    VPCConfigResponseTypeDef,
    VPCConfigTypeDef,
    WorldConfigTypeDef,
    WorldCountTypeDef,
    WorldExportJobSummaryTypeDef,
    WorldFailureTypeDef,
    WorldGenerationJobSummaryTypeDef,
    WorldSummaryTypeDef,
)

def get_structure() -> BatchPolicyTypeDef:
    return {
      ...
    }
```
