import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnFilter`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html
 */
export interface CfnFilterProps {
    /**
     * `AWS::InspectorV2::Filter.FilterAction`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filteraction
     */
    readonly filterAction: string;
    /**
     * `AWS::InspectorV2::Filter.FilterCriteria`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filtercriteria
     */
    readonly filterCriteria: CfnFilter.FilterCriteriaProperty | cdk.IResolvable;
    /**
     * `AWS::InspectorV2::Filter.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-name
     */
    readonly name: string;
    /**
     * `AWS::InspectorV2::Filter.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::InspectorV2::Filter`
 *
 *
 *
 * @cloudformationResource AWS::InspectorV2::Filter
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html
 */
export declare class CfnFilter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::InspectorV2::Filter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFilter;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::InspectorV2::Filter.FilterAction`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filteraction
     */
    filterAction: string;
    /**
     * `AWS::InspectorV2::Filter.FilterCriteria`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-filtercriteria
     */
    filterCriteria: CfnFilter.FilterCriteriaProperty | cdk.IResolvable;
    /**
     * `AWS::InspectorV2::Filter.Name`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-name
     */
    name: string;
    /**
     * `AWS::InspectorV2::Filter.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html#cfn-inspectorv2-filter-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::InspectorV2::Filter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFilterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html
     */
    interface DateFilterProperty {
        /**
         * `CfnFilter.DateFilterProperty.EndInclusive`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html#cfn-inspectorv2-filter-datefilter-endinclusive
         */
        readonly endInclusive?: number;
        /**
         * `CfnFilter.DateFilterProperty.StartInclusive`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html#cfn-inspectorv2-filter-datefilter-startinclusive
         */
        readonly startInclusive?: number;
    }
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html
     */
    interface FilterCriteriaProperty {
        /**
         * `CfnFilter.FilterCriteriaProperty.AwsAccountId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-awsaccountid
         */
        readonly awsAccountId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.ComponentId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-componentid
         */
        readonly componentId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.ComponentType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-componenttype
         */
        readonly componentType?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.Ec2InstanceImageId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instanceimageid
         */
        readonly ec2InstanceImageId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.Ec2InstanceSubnetId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instancesubnetid
         */
        readonly ec2InstanceSubnetId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.Ec2InstanceVpcId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ec2instancevpcid
         */
        readonly ec2InstanceVpcId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.EcrImageArchitecture`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagearchitecture
         */
        readonly ecrImageArchitecture?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.EcrImageHash`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagehash
         */
        readonly ecrImageHash?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.EcrImagePushedAt`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagepushedat
         */
        readonly ecrImagePushedAt?: Array<CfnFilter.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.EcrImageRegistry`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimageregistry
         */
        readonly ecrImageRegistry?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.EcrImageRepositoryName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagerepositoryname
         */
        readonly ecrImageRepositoryName?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.EcrImageTags`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-ecrimagetags
         */
        readonly ecrImageTags?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.FindingArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingarn
         */
        readonly findingArn?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.FindingStatus`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingstatus
         */
        readonly findingStatus?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.FindingType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-findingtype
         */
        readonly findingType?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.FirstObservedAt`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-firstobservedat
         */
        readonly firstObservedAt?: Array<CfnFilter.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.InspectorScore`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-inspectorscore
         */
        readonly inspectorScore?: Array<CfnFilter.NumberFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.LastObservedAt`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-lastobservedat
         */
        readonly lastObservedAt?: Array<CfnFilter.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.NetworkProtocol`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-networkprotocol
         */
        readonly networkProtocol?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.PortRange`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-portrange
         */
        readonly portRange?: Array<CfnFilter.PortRangeFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.RelatedVulnerabilities`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-relatedvulnerabilities
         */
        readonly relatedVulnerabilities?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.ResourceId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourceid
         */
        readonly resourceId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.ResourceTags`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourcetags
         */
        readonly resourceTags?: Array<CfnFilter.MapFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.ResourceType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-resourcetype
         */
        readonly resourceType?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.Severity`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-severity
         */
        readonly severity?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.Title`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-title
         */
        readonly title?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.UpdatedAt`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-updatedat
         */
        readonly updatedAt?: Array<CfnFilter.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.VendorSeverity`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vendorseverity
         */
        readonly vendorSeverity?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.VulnerabilityId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerabilityid
         */
        readonly vulnerabilityId?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.VulnerabilitySource`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerabilitysource
         */
        readonly vulnerabilitySource?: Array<CfnFilter.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFilter.FilterCriteriaProperty.VulnerablePackages`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html#cfn-inspectorv2-filter-filtercriteria-vulnerablepackages
         */
        readonly vulnerablePackages?: Array<CfnFilter.PackageFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html
     */
    interface MapFilterProperty {
        /**
         * `CfnFilter.MapFilterProperty.Comparison`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-comparison
         */
        readonly comparison: string;
        /**
         * `CfnFilter.MapFilterProperty.Key`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-key
         */
        readonly key?: string;
        /**
         * `CfnFilter.MapFilterProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html#cfn-inspectorv2-filter-mapfilter-value
         */
        readonly value?: string;
    }
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html
     */
    interface NumberFilterProperty {
        /**
         * `CfnFilter.NumberFilterProperty.LowerInclusive`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html#cfn-inspectorv2-filter-numberfilter-lowerinclusive
         */
        readonly lowerInclusive?: number;
        /**
         * `CfnFilter.NumberFilterProperty.UpperInclusive`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html#cfn-inspectorv2-filter-numberfilter-upperinclusive
         */
        readonly upperInclusive?: number;
    }
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html
     */
    interface PackageFilterProperty {
        /**
         * `CfnFilter.PackageFilterProperty.Architecture`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-architecture
         */
        readonly architecture?: CfnFilter.StringFilterProperty | cdk.IResolvable;
        /**
         * `CfnFilter.PackageFilterProperty.Epoch`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-epoch
         */
        readonly epoch?: CfnFilter.NumberFilterProperty | cdk.IResolvable;
        /**
         * `CfnFilter.PackageFilterProperty.Name`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-name
         */
        readonly name?: CfnFilter.StringFilterProperty | cdk.IResolvable;
        /**
         * `CfnFilter.PackageFilterProperty.Release`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-release
         */
        readonly release?: CfnFilter.StringFilterProperty | cdk.IResolvable;
        /**
         * `CfnFilter.PackageFilterProperty.SourceLayerHash`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-sourcelayerhash
         */
        readonly sourceLayerHash?: CfnFilter.StringFilterProperty | cdk.IResolvable;
        /**
         * `CfnFilter.PackageFilterProperty.Version`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html#cfn-inspectorv2-filter-packagefilter-version
         */
        readonly version?: CfnFilter.StringFilterProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html
     */
    interface PortRangeFilterProperty {
        /**
         * `CfnFilter.PortRangeFilterProperty.BeginInclusive`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html#cfn-inspectorv2-filter-portrangefilter-begininclusive
         */
        readonly beginInclusive?: number;
        /**
         * `CfnFilter.PortRangeFilterProperty.EndInclusive`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html#cfn-inspectorv2-filter-portrangefilter-endinclusive
         */
        readonly endInclusive?: number;
    }
}
export declare namespace CfnFilter {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html
     */
    interface StringFilterProperty {
        /**
         * `CfnFilter.StringFilterProperty.Comparison`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html#cfn-inspectorv2-filter-stringfilter-comparison
         */
        readonly comparison: string;
        /**
         * `CfnFilter.StringFilterProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html#cfn-inspectorv2-filter-stringfilter-value
         */
        readonly value: string;
    }
}
