# AUTOGENERATED! DO NOT EDIT! File to edit: 02_pandas.ipynb (unless otherwise specified).

__all__ = ['set_plt_defaults', 'remove_ticks']

# Cell
import matplotlib.pyplot as plt

# Cell
def set_plt_defaults(figsize=(10, 10), spines_off=['top','right']):
    plt.rcParams['figure.figsize'] = figsize
    for s in spines_off:
        plt.rcParams[f'axes.spines.{s}'] = False


# Cell
def remove_ticks(ax, xticks_off=True, yticks_off=True, spines=['top','bottom','left','right']):
    if xticks_off:
        ax.set_xticklabels([])
        ax.set_xticks([])
    if yticks_off:
        ax.set_yticklabels([])
        ax.set_yticks([])
    for s in spines:
        ax.spines[s].set_visible(False)

# Cell
import pandas as pd
import pandas_flavor
import typing as T