"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalTable = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
/**
 * (deprecated) This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[], then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends cdk.Construct {
    /**
     * @deprecated
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        cdk.Annotations.of(this).addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * (deprecated) Obtain tables deployed in other each region.
     *
     * @deprecated
     */
    get regionalTables() {
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
//# sourceMappingURL=data:application/json;base64,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