import unittest
from dhivehi_nlp import corpus


class test_corpus(unittest.TestCase):
    def test_news(self):
        self.assertEqual(
            corpus.news(),
            """މާލެއިން މީހަކު ގެއްލިގެން ހޯދަން ފަށައިފިއެވެ.ގެއްލިގެން ހޯދަމުންދަނީ ބ. މާޅޮސް، ކީސްފިލާ، ޢަބްދުﷲ މުޢާޒު (30 އަހަރު) އެވެ.ފުލުހުން ބުނީ މިިދިޔަ އަންގާރަ ދުވަހުގެ މެންދުރު އޭނާ ދިރިއުޅެމުން ދިޔަ ގެއިން ނުކުތް ގޮތަށް އެއްްވެސް ހަބަރެއް ނުވެގެން އޭނާގެ އާއިލާއިން މިއަދު މެންދުރު 03:45 ކަންހާއިރު ފުލުހުންނަށް ރިޕޯޓްކުރި ކަމަށެވެ.ޢަބްދުﷲ މުޢާޒު އެންމެ ފަހުން ފެނުނު އިރު ލައިގެން ހުރީ ކަޅު ތިކިތަކެއް ޖަހާފައިހުރި ނޫކުލައިގެން ޓީޝާޓަކާއި ގަދަ މުށިކުލައިގެ ފަޓުލޫނެެއްކަމަށް ފުލުހުން ބުންޏެވެ.މިހާތަނަށް ކުރި މަސައްކަތުން އޭނާ ފެނިފައިނުވާކަމަށްވެސް ފުލުހުން ބުންޏެވެ."ވީމާ، އަބްދުﷲ މުޢާޒާބެހޭ އެއްވެސް މަޢުލޫމާތެއް ލިބިވަޑައިގެންފައިވާ ފަރާތެއްވާނަމަ ލަސްނުކުރައްވައި އެމަޢުލޫމާތެއް ފުލުހުންގެ ހޮޓްލައިން ނަންބަރު 3322111 އަށް ނުވަތަ ޖެނެރަލް އިންވެސްޓިގޭޝަން ޑިޕާޓްމަންޓުގެ ނަންބަރު 9631696 އަށް ގުޅުއްވައި ހިއްސާކޮށްދެއްވުން އެދެމެވެ." ފުލުހުންގެ ވެބްސައިޓްގައި އާންމުކުރި ލިއުމުގައި ބުނެފައިވެއެވެ. މިމަހު ކުރީކޮޅުވެސް އަންހެނަކު ގެއްލިގެން އާއިލާއިން ފުލުހުންގެ އެހީއަށް އެދުނެވެ. ޝިރުމީނާ އަބޫބަކުރު ނަމަކަށް ކިޔާ އެ އަންހެން މީހާ ރަހީނުކުރުމަށްފަހު އޭނާގެ އަތުން 25،000 ރުފިޔާ އަތުލިއެވެ. އެ މައްސަލައިގައި މިހާރު ވަނީ ދެ މީހަު ހައްޔަރުވެސްކޮށްފައެވެ.""",
        )

    def test_tweet(self):
        self.assertEqual(
            corpus.tweet(),
            """ކޮޓަރިތެރޭ ހުރި އަލަމާރި އެއް ތަނުން އަނެއް ކަނަށް ބަދަލުކޮށްފަ ހަބަރަށް ފޮނުވަބަލަ ތަރައްގީ އޭ މެގަ ޕްރޮޖެކްޓޭ ކިޔާފަ""",
        )


if __name__ == "__main__":
    unittest.main()
