# Generated by Django 3.2.9 on 2021-11-16 18:14

from django.db import migrations, models
import django.db.models.deletion


def migrate_mesh3dmeta_to_mesh3d(apps, schema_editor):
    Mesh3DMeta = apps.get_model('rgd_3d', 'Mesh3DMeta')  # noqa
    for meta in Mesh3DMeta.objects.all():
        meta.source.name = meta.name
        meta.source.description = meta.description
        meta.source.vtp_data = meta.vtp_data
        meta.source.save(
            update_fields=[
                'name',
                'description',
                'vtp_data',
            ]
        )


class Migration(migrations.Migration):

    dependencies = [
        ('rgd', '0005_auto_20211105_1715'),
        ('rgd_3d', '0003_auto_20211116_1726'),
    ]

    operations = [
        migrations.AddField(
            model_name='mesh3d',
            name='description',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='mesh3d',
            name='name',
            field=models.CharField(blank=True, max_length=1000),
        ),
        migrations.AddField(
            model_name='mesh3d',
            name='vtp_data',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name='+',
                to='rgd.checksumfile',
            ),
        ),
        migrations.RunPython(migrate_mesh3dmeta_to_mesh3d),
        migrations.DeleteModel(
            name='Mesh3DMeta',
        ),
    ]
