from dataclasses import dataclass

import optuna
from pnpxai.explainers.base import Explainer
from pnpxai.explainers.utils.postprocess import PostProcessor


@dataclass
class OptimizationOutput:
    """
    A dataclass used to store the results of an optimization process, including the chosen 
    explainer, postprocessor, and the Optuna study object that was used during the optimization.

    Attributes:
        explainer (Explainer):
            The explainer object selected during the optimization process. This object is 
            responsible for generating explanations or attributions for a model.
        postprocessor (PostProcessor):
            The postprocessor object selected during the optimization process. This object 
            is used to process the attributions generated by the explainer, often involving 
            normalization or other transformations.
        study (optuna.study.Study):
            The Optuna study object that was used to conduct the optimization. This object 
            contains information about the optimization trials and results.
    """
    
    explainer: Explainer
    postprocessor: PostProcessor
    study: optuna.study.Study
