# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPolicyDocumentResult',
    'AwaitableGetPolicyDocumentResult',
    'get_policy_document',
]

@pulumi.output_type
class GetPolicyDocumentResult:
    """
    A collection of values returned by getPolicyDocument.
    """
    def __init__(__self__, hcl=None, id=None, rules=None):
        if hcl and not isinstance(hcl, str):
            raise TypeError("Expected argument 'hcl' to be a str")
        pulumi.set(__self__, "hcl", hcl)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def hcl(self) -> str:
        """
        The above arguments serialized as a standard Vault HCL policy document.
        """
        return pulumi.get(self, "hcl")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetPolicyDocumentRuleResult']:
        return pulumi.get(self, "rules")


class AwaitableGetPolicyDocumentResult(GetPolicyDocumentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyDocumentResult(
            hcl=self.hcl,
            id=self.id,
            rules=self.rules)


def get_policy_document(rules: Optional[Sequence[pulumi.InputType['GetPolicyDocumentRuleArgs']]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyDocumentResult:
    """
    This is a data source which can be used to construct a HCL representation of an Vault policy document, for use with resources which expect policy documents, such as the `Policy` resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    example_policy_document = vault.get_policy_document(rules=[vault.GetPolicyDocumentRuleArgs(
        capabilities=[
            "create",
            "read",
            "update",
            "delete",
            "list",
        ],
        description="allow all on secrets",
        path="secret/*",
    )])
    example_policy = vault.Policy("examplePolicy", policy=example_policy_document.hcl)
    ```
    """
    __args__ = dict()
    __args__['rules'] = rules
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('vault:index/getPolicyDocument:getPolicyDocument', __args__, opts=opts, typ=GetPolicyDocumentResult).value

    return AwaitableGetPolicyDocumentResult(
        hcl=__ret__.hcl,
        id=__ret__.id,
        rules=__ret__.rules)
