# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendCrlConfigArgs', 'SecretBackendCrlConfig']

@pulumi.input_type
class SecretBackendCrlConfigArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendCrlConfig resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        pulumi.set(__self__, "backend", backend)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)


@pulumi.input_type
class _SecretBackendCrlConfigState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendCrlConfig resources.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)


class SecretBackendCrlConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows setting the duration for which the generated CRL should be marked valid. If the CRL is disabled, it will return a signed but zero-length CRL for any request. If enabled, it will re-build the CRL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400,
            path="%s",
            type="pki")
        crl_config = vault.pki_secret.SecretBackendCrlConfig("crlConfig",
            backend=pki.path,
            disable=False,
            expiry="72h")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendCrlConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting the duration for which the generated CRL should be marked valid. If the CRL is disabled, it will return a signed but zero-length CRL for any request. If enabled, it will re-build the CRL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        pki = vault.Mount("pki",
            default_lease_ttl_seconds=3600,
            max_lease_ttl_seconds=86400,
            path="%s",
            type="pki")
        crl_config = vault.pki_secret.SecretBackendCrlConfig("crlConfig",
            backend=pki.path,
            disable=False,
            expiry="72h")
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendCrlConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendCrlConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 disable: Optional[pulumi.Input[bool]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendCrlConfigArgs.__new__(SecretBackendCrlConfigArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["disable"] = disable
            __props__.__dict__["expiry"] = expiry
        super(SecretBackendCrlConfig, __self__).__init__(
            'vault:pkiSecret/secretBackendCrlConfig:SecretBackendCrlConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            disable: Optional[pulumi.Input[bool]] = None,
            expiry: Optional[pulumi.Input[str]] = None) -> 'SecretBackendCrlConfig':
        """
        Get an existing SecretBackendCrlConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        :param pulumi.Input[bool] disable: Disables or enables CRL building.
        :param pulumi.Input[str] expiry: Specifies the time until expiration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendCrlConfigState.__new__(_SecretBackendCrlConfigState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["disable"] = disable
        __props__.__dict__["expiry"] = expiry
        return SecretBackendCrlConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path the PKI secret backend is mounted at, with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def disable(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables or enables CRL building.
        """
        return pulumi.get(self, "disable")

    @property
    @pulumi.getter
    def expiry(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the time until expiration.
        """
        return pulumi.get(self, "expiry")

