from openpyxl.chartsheet.chartsheet import Chartsheet
from openpyxl.styles.named_styles import NamedStyle
from openpyxl.workbook.defined_name import DefinedName
from openpyxl.worksheet._read_only import ReadOnlyWorksheet
from openpyxl.worksheet._write_only import WriteOnlyWorksheet
from openpyxl.worksheet.worksheet import Worksheet
from typing import (
    List,
    Optional,
    Union,
)

class Workbook:
    def __contains__(self, key: str) -> bool: ...
    def __delitem__(self, key: str) -> None: ...
    def __getitem__(
        self, key: str
    ) -> Union[Chartsheet, Worksheet, ReadOnlyWorksheet]: ...
    def __init__(self, write_only: bool = ..., iso_dates: bool = ...) -> None: ...
    def _add_sheet(
        self,
        sheet: Union[Chartsheet, str, WriteOnlyWorksheet, Worksheet],
        index: None = ...,
    ) -> None: ...
    def _duplicate_name(self, name: str) -> Optional[bool]: ...
    def _setup_styles(self) -> None: ...
    def add_named_range(self, named_range: DefinedName) -> None: ...
    def add_named_style(self, style: NamedStyle) -> None: ...
    @property
    def chartsheets(self) -> List[Chartsheet]: ...
    def close(self) -> None: ...
    def copy_worksheet(
        self, from_worksheet: Union[WriteOnlyWorksheet, Worksheet]
    ) -> Worksheet: ...
    def create_chartsheet(self, title: None = ..., index: None = ...) -> Chartsheet: ...
    def create_named_range(
        self,
        name: str,
        worksheet: Optional[Worksheet] = ...,
        value: Optional[str] = ...,
        scope: Optional[int] = ...,
    ) -> None: ...
    def create_sheet(
        self, title: Optional[Union[str, int]] = ..., index: None = ...
    ) -> Union[WriteOnlyWorksheet, Worksheet]: ...
    @property
    def data_only(self) -> bool: ...
    @property
    def excel_base_date(self) -> float: ...
    def get_named_ranges(self) -> List[DefinedName]: ...
    def index(self, worksheet: Worksheet) -> int: ...
    @property
    def mime_type(self) -> str: ...
    def move_sheet(self, sheet: str, offset: int = ...) -> None: ...
    @property
    def named_styles(self) -> List[str]: ...
    @property
    def read_only(self) -> bool: ...
    def remove(self, worksheet: Union[Chartsheet, Worksheet]) -> None: ...
    def save(self, filename: str) -> None: ...
    @property
    def sheetnames(self) -> List[str]: ...
    @property
    def worksheets(self) -> Union[List[Worksheet], List[ReadOnlyWorksheet]]: ...
    @property
    def write_only(self) -> bool: ...
