## -*- coding: utf-8 -*-
## (C) 2019 Muthiah Annamalai,
## This module is part of solthiruthi project under open-tamil umbrella.
## This code maybe used/distributed under MIT LICENSE.

# Tamil99 Keyboard adjacency matrix - aka - confusion matrix
# for keystroke error modeling

confusion_matrix = {
'ஆ' : ['ஈ','இ','அ'], 
'ஈ' : ['ஊ','உ','இ','அ','ஆ'], 
'ஊ' : ['ஏ','உ','உ','இ','ஈ'], 
'ஏ' : ['ள','எ','ஐ','உ','ஊ'], 
'ள' : ['ற','க','எ','ஐ','ஏ'], 
'ற' : ['ன','ப','க','எ','ள'], 
'ன' : ['ட','ம','ப','க','ற'], 
'ட' : ['ண','த','ம','ப','ன'], 
'ண' : ['ச','ந','த','ம','ட'], 
'ச' : ['ஞ','ய','ந','த','ண'], 
'ஞ' : ['ய','ந','ச'], 
'அ' : ['ஆ','இ','ஔ'], 
'இ' : ['ஊ','உ','ஔ','அ','ஆ','ஈ'], 
'உ' : ['ஏ','ஐ','ஓ','ஔ','இ','ஈ','ஊ'], 
'ஐ' : ['ள','எ','ஒ','ஓ','உ','ஊ'], 
'எ' : ['ற','க','வ','ஒ','ஐ','ஏ','ள'], 
'க' : ['ன','ப','ங','வ','எ','ள','ற'], 
'ப' : ['ட','ம','ல','ங','க','ற','ன'], 
'ம' : ['ண','த','ர','ல','ப','ன','ட'], 
'த' : ['ச','ந','ழ','ர','ம','ட','ண'], 
'ந' : ['ஞ','ய','ழ','த','ண','ச'], 
'ய' : ['ந','ச','ஞ'], 
'ஔ' : ['உ','ஓ','இ'], 
'ஓ' : ['உ','ஐ','ஒ','ஔ'], 
'ஒ' : ['எ','வ','ஓ','ஐ'], 
'வ' : ['க','ங','ஒ','எ'], 
'ங' : ['ப','ல','வ','க'], 
'ல' : ['ம','ர','ங','ப','்'], 
'ர' : ['த','ழ','ல','ம','்'], 
'ழ' : ['ந','ர','த','்'], 
}

inv_confusion_matrix = {
'ஆ' : ['ஈ','அ','இ'], 
'ஈ' : ['உ','ஊ','இ','ஆ'], 
'ஊ' : ['உ','ஈ','ஏ','இ','ஐ'], 
'ஏ' : ['உ','ள','ஊ','எ'], 
'ள' : ['ற','ஐ','க','ஏ','எ'], 
'ற' : ['ன','ள','ப','க','எ'], 
'ன' : ['ற','ப','க','ட','ம'], 
'ட' : ['ன','ண','ப','த','ம'], 
'ண' : ['ந','ச','த','ட','ம'], 
'ச' : ['ந','ண','த','ய','ஞ'], 
'ஞ' : ['ந','ச','ய'], 
'அ' : ['ஈ','இ','ஆ'], 
'இ' : ['அ','ஆ','உ','ஈ','ஊ','ஔ'], 
'உ' : ['இ','ஈ','ஊ','ஏ','ஐ','ஓ','ஔ'], 
'ஐ' : ['உ','ள','ஏ','எ','ஓ','ஒ'], 
'எ' : ['ஏ','ற','ஐ','ள','ஒ','க','வ'], 
'க' : ['ன','ப','எ','ற','ள','வ','ங'], 
'ப' : ['ன','ம','ற','ல','க','ங','ட'], 
'ம' : ['ண','த','ன','ப','ர','ல','ட'], 
'த' : ['ண','ந','ம','ர','ழ','ச','ட'], 
'ந' : ['ண','த','ய','ழ','ச','ஞ'], 
'ய' : ['ந','ச','ஞ'], 
'ஔ' : ['உ','ஓ','அ','இ'], 
'ஓ' : ['உ','ஐ','ஒ','ஔ'], 
'ஒ' : ['ஐ','ஓ','வ','எ'], 
'வ' : ['ங','ஒ','க','எ'], 
'ங' : ['வ','ப','க','ல'], 
'ல' : ['ங','ர','ப','ம'], 
'ர' : ['ழ','ல','த','ம'], 
'ழ' : ['ந','த','ர'], 
}
