/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.conversion;

import org.cyclopsgroup.caff.conversion.BooleanField;
import org.cyclopsgroup.caff.conversion.Converter;
import org.cyclopsgroup.caff.conversion.ConverterFactory;

public class BooleanConverterFactory
implements ConverterFactory<Boolean> {
    @Override
    public Converter<Boolean> getConverterFor(Class<Boolean> valueType, Object hint) {
        return new BooleanConverter((BooleanField)hint);
    }

    private static class BooleanConverter
    implements Converter<Boolean> {
        private final BooleanField field;

        private BooleanConverter(BooleanField field) {
            this.field = field;
        }

        @Override
        public Boolean fromCharacters(CharSequence text) {
            return text.toString().equals(this.field.yes());
        }

        @Override
        public CharSequence toCharacters(Boolean value) {
            return value != false ? this.field.yes() : this.field.no();
        }
    }
}

