/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.format;

public enum AlignPolicy {
    LEFT{

        @Override
        CharSequence trim(CharSequence input, char empty) {
            int lengthToKeep;
            for (lengthToKeep = input.length(); lengthToKeep > 0 && input.charAt(lengthToKeep - 1) == empty; --lengthToKeep) {
            }
            return input.subSequence(0, lengthToKeep);
        }

        @Override
        void fill(CharSequence src, char[] dest, int start, int length, char empty) {
            for (int i = 0; i < length; ++i) {
                char c = i < src.length() ? src.charAt(i) : empty;
                dest[start + i] = c;
            }
        }
    }
    ,
    RIGHT{

        @Override
        CharSequence trim(CharSequence input, char empty) {
            int start;
            for (start = 0; start < input.length() && input.charAt(start) == empty; ++start) {
            }
            return input.subSequence(start, input.length());
        }

        @Override
        void fill(CharSequence src, char[] dest, int start, int length, char empty) {
            for (int i = 0; i < length; ++i) {
                char c = i < src.length() ? src.charAt(src.length() - i - 1) : empty;
                dest[start + length - i - 1] = c;
            }
        }
    };


    abstract CharSequence trim(CharSequence var1, char var2);

    abstract void fill(CharSequence var1, char[] var2, int var3, int var4, char var5);
}

