/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.format;

import java.io.IOException;
import java.nio.CharBuffer;
import org.cyclopsgroup.caff.CharIterator;

public abstract class CSVParser {
    private static final int BUFFER_SIZE = 100;

    public final void parse(CharIterator in) throws IOException {
        ParsingContext context = new ParsingContext();
        block20: while (in.hasNext()) {
            char ch = in.next();
            switch (context.state) {
                case START: {
                    switch (ch) {
                        case ' ': {
                            continue block20;
                        }
                        case ',': {
                            context.notifyField();
                            continue block20;
                        }
                        case '\"': {
                            context.move(ParsingState.QUOTING);
                            continue block20;
                        }
                    }
                    context.move(ParsingState.WORD);
                    context.append(ch);
                    continue block20;
                }
                case WORD: {
                    switch (ch) {
                        case ',': {
                            context.notifyField();
                            context.move(ParsingState.START);
                            continue block20;
                        }
                    }
                    context.append(ch);
                    continue block20;
                }
                case QUOTING: {
                    switch (ch) {
                        case '\"': {
                            context.move(ParsingState.ESCAPING);
                            continue block20;
                        }
                    }
                    context.append(ch);
                    continue block20;
                }
                case ESCAPING: {
                    switch (ch) {
                        case ',': {
                            context.notifyField();
                            context.move(ParsingState.START);
                            continue block20;
                        }
                    }
                    context.append(ch);
                    context.move(ParsingState.QUOTING);
                    continue block20;
                }
            }
            throw new AssertionError((Object)("Nonsense state " + (Object)((Object)context.state)));
        }
        if (context.buffer.position() > 0) {
            context.notifyField();
        }
    }

    protected abstract void handleField(int var1, CharSequence var2) throws IOException;

    private static enum ParsingState {
        ESCAPING,
        QUOTING,
        START,
        WORD;

    }

    private class ParsingContext {
        private final CharBuffer buffer = CharBuffer.allocate(100);
        private int position = 0;
        private ParsingState state = ParsingState.START;

        private ParsingContext() {
        }

        private void notifyField() throws IOException {
            this.buffer.flip();
            CSVParser.this.handleField(this.position, this.buffer);
            this.buffer.clear();
            ++this.position;
        }

        private void move(ParsingState newState) {
            this.state = newState;
        }

        private void append(char ch) {
            this.buffer.append(ch);
        }
    }
}

