/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.token;

import org.cyclopsgroup.caff.token.TokenEvent;
import org.cyclopsgroup.caff.token.TokenEventHandler;
import org.cyclopsgroup.caff.token.ValueTokenizer;

public class QuotedValueTokenizer
implements ValueTokenizer {
    private final char delimiter;
    private final char quotation;

    public QuotedValueTokenizer() {
        this(' ', '\"');
    }

    public QuotedValueTokenizer(char delimiter, char quotation) {
        this.delimiter = delimiter;
        this.quotation = quotation;
    }

    @Override
    public void parse(CharSequence input, TokenEventHandler handler) {
        ParsingState state = ParsingState.READY;
        StringBuilder buf = null;
        int wordStart = 0;
        block6: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (state) {
                case READY: {
                    assert (buf == null);
                    if (c == this.delimiter) continue block6;
                    if (c == this.quotation) {
                        state = ParsingState.QUOTED;
                        wordStart = i;
                        buf = new StringBuilder();
                        continue block6;
                    }
                    state = ParsingState.WORD_STARTED;
                    wordStart = i;
                    buf = new StringBuilder();
                    buf.append(c);
                    continue block6;
                }
                case WORD_STARTED: {
                    assert (buf != null);
                    if (c == this.delimiter) {
                        state = ParsingState.READY;
                        handler.handleEvent(new TokenEvent(buf.toString(), wordStart, i, true));
                        buf = null;
                        continue block6;
                    }
                    buf.append(c);
                    continue block6;
                }
                case QUOTED: {
                    assert (buf != null);
                    if (c == this.quotation) {
                        state = ParsingState.ESCAPED_OR_QUOTE_END;
                        continue block6;
                    }
                    buf.append(c);
                    continue block6;
                }
                case ESCAPED_OR_QUOTE_END: {
                    assert (buf != null);
                    if (c == this.delimiter) {
                        state = ParsingState.READY;
                        handler.handleEvent(new TokenEvent(buf.toString(), wordStart, i, true, true));
                        buf = null;
                        continue block6;
                    }
                    buf.append(c);
                    state = ParsingState.QUOTED;
                }
            }
        }
        if (buf != null) {
            handler.handleEvent(new TokenEvent(buf.toString(), wordStart, input.length(), false, state == ParsingState.QUOTED));
        }
    }

    @Override
    public String escape(String output) {
        int d = output.indexOf(this.delimiter);
        int q = output.indexOf(this.quotation);
        if (d == -1 && q == -1) {
            return output;
        }
        StringBuffer sb = new StringBuffer().append(this.quotation);
        int i = 0;
        int j = 0;
        while (i < output.length()) {
            j = output.indexOf(this.quotation, i);
            if (j == -1) {
                sb.append(output.substring(i));
                break;
            }
            sb.append(output.substring(i, j)).append(this.quotation).append(output.charAt(j));
            i = ++j;
        }
        sb.append(this.quotation);
        return sb.toString();
    }

    private static enum ParsingState {
        ESCAPED_OR_QUOTE_END,
        QUOTED,
        READY,
        WORD_STARTED;

    }
}

