/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.example;

import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.List;
import org.cyclopsgroup.caff.conversion.DateField;
import org.cyclopsgroup.jcli.ArgumentProcessor;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.MultiValue;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jcli.example.UserControlAction;

@Cli(name="user", description="Comamnd line tool that manages user accounts")
public class UserControl {
    private UserControlAction action = UserControlAction.DISPLAY;
    private Date creationDate;
    private int intValue;
    private List<String> userNames;

    @Option(name="a", longName="action", description="Action to perform")
    public final UserControlAction getAction() {
        return this.action;
    }

    @DateField(format="yyyyMMdd")
    @Option(name="d", longName="date", description="Start date")
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Option(name="l", longName="level", description="A meaningless integer value")
    public final int getIntValue() {
        return this.intValue;
    }

    @MultiValue
    @Argument(description="User account name")
    public final List<String> getUserNames() {
        return this.userNames;
    }

    public final void setAction(UserControlAction action) {
        this.action = action;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public final void setIntValue(int intValue) {
        this.intValue = intValue;
    }

    public final void setUserNames(List<String> userNames) {
        this.userNames = userNames;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).addValue(this.userNames).addValue(this.intValue).addValue(this.creationDate).toString();
    }

    public static void main(String[] args) {
        UserControl control = new UserControl();
        ArgumentProcessor.forType(UserControl.class).process(args, control);
        System.out.println(control);
    }
}

