/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclopsgroup.jcli.impl.AnnotationParsingContext;
import org.cyclopsgroup.jcli.impl.MultiValueReference;
import org.cyclopsgroup.jcli.impl.Reference;
import org.cyclopsgroup.jcli.impl.SingleValueReference;
import org.cyclopsgroup.jcli.spi.CommandLine;
import org.cyclopsgroup.jcli.spi.CommandLineParser;

class DefaultBeanProcessor {
    DefaultBeanProcessor() {
    }

    static <T> void process(AnnotationParsingContext<T> context, List<String> arguments, T bean, CommandLineParser parser) {
        MultiValueReference ref;
        CommandLine cli = parser.parse(arguments, context);
        HashMap<String, ArrayList<String>> multiValues = new HashMap<String, ArrayList<String>>();
        for (CommandLine.OptionValue optionValue : cli.getOptionValues()) {
            ref = context.lookupReference(optionValue.name, !optionValue.shortName);
            if (ref == null) {
                throw new AssertionError((Object)("Option " + optionValue.name + " doesn't exist"));
            }
            if (ref instanceof SingleValueReference) {
                ((SingleValueReference)((Object)ref)).setValue(bean, optionValue.value);
                continue;
            }
            String optionName = optionValue.shortName ? optionValue.name : context.optionWithLongName(optionValue.name).getName();
            ArrayList<String> values = (ArrayList<String>)multiValues.get(optionName);
            if (values == null) {
                values = new ArrayList<String>();
                multiValues.put(optionName, values);
            }
            values.add(optionValue.value);
        }
        for (Map.Entry entry : multiValues.entrySet()) {
            ref = (MultiValueReference)context.lookupReference((String)entry.getKey(), false);
            ref.setValues(bean, (List)entry.getValue());
        }
        Reference<T> ref2 = context.lookupReference("----arguments----", false);
        if (ref2 == null) {
            return;
        }
        if (ref2 instanceof MultiValueReference) {
            ((MultiValueReference)ref2).setValues(bean, cli.getArguments());
        } else {
            String string = cli.getArguments().isEmpty() ? null : cli.getArguments().get(0);
            ((SingleValueReference)ref2).setValue(bean, string);
        }
    }
}

