/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.JMException;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.caff.token.EscapingValueTokenizer;
import org.cyclopsgroup.caff.token.TokenEvent;
import org.cyclopsgroup.caff.token.TokenEventHandler;
import org.cyclopsgroup.caff.token.ValueTokenizer;
import org.cyclopsgroup.jcli.ArgumentProcessor;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.CommandFactory;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cc.HelpCommand;
import org.cyclopsgroup.jmxterm.cc.JPMFactory;
import org.cyclopsgroup.jmxterm.cc.PredefinedCommandFactory;
import org.cyclopsgroup.jmxterm.cc.SessionImpl;
import org.cyclopsgroup.jmxterm.io.CommandInput;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.RuntimeIOException;
import org.cyclopsgroup.jmxterm.io.VerboseLevel;

public class CommandCenter {
    private static final String COMMAND_DELIMITER = "&&";
    static final String ESCAPE_CHAR_REGEX = "(?<!\\\\)#";
    final ValueTokenizer argTokenizer = new EscapingValueTokenizer();
    final CommandFactory commandFactory;
    private final Lock lock = new ReentrantLock();
    private final JavaProcessManager processManager;
    final Session session;

    public CommandCenter(CommandOutput output, CommandInput input) throws IOException {
        this(output, input, new PredefinedCommandFactory());
    }

    public CommandCenter(CommandOutput output, CommandInput input, CommandFactory commandFactory) throws IOException {
        Validate.notNull(output, "Output can't be NULL", new Object[0]);
        Validate.notNull(commandFactory, "Command factory can't be NULL", new Object[0]);
        this.processManager = new JPMFactory().getProcessManager();
        this.session = new SessionImpl(output, input, this.processManager);
        this.commandFactory = commandFactory;
    }

    public void close() {
        this.session.close();
    }

    public void connect(JMXServiceURL url, Map<String, Object> env) throws IOException {
        Validate.notNull(url, "URL can't be NULL", new Object[0]);
        this.session.connect(url, env);
    }

    private void doExecute(String command) throws JMException {
        if ((command = StringUtils.trimToNull(command)) == null) {
            return;
        }
        if (command.startsWith("#")) {
            return;
        }
        if ((command = command.split(ESCAPE_CHAR_REGEX)[0].replace("\\#", "#")).indexOf(COMMAND_DELIMITER) != -1) {
            String[] commands;
            for (String c : commands = StringUtils.split(command, COMMAND_DELIMITER)) {
                this.execute(c);
            }
            return;
        }
        final ArrayList args = new ArrayList();
        this.argTokenizer.parse(command, new TokenEventHandler(){

            @Override
            public void handleEvent(TokenEvent event) {
                args.add(event.getToken());
            }
        });
        String commandName = (String)args.remove(0);
        String[] commandArgs = args.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        try {
            this.doExecute(commandName, commandArgs, command);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Runtime IO exception: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(String commandName, String[] commandArgs, String originalCommand) throws JMException, IOException {
        Command cmd = this.commandFactory.createCommand(commandName);
        if (cmd instanceof HelpCommand) {
            ((HelpCommand)cmd).setCommandCenter(this);
        }
        ArgumentProcessor<?> ap = ArgumentProcessor.forType(cmd.getClass());
        ap.process(commandArgs, cmd);
        if (cmd.isHelp()) {
            ap.printHelp(new PrintWriter(System.out, true));
            return;
        }
        cmd.setSession(this.session);
        this.lock.lock();
        try {
            cmd.execute();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean execute(String command) {
        try {
            this.doExecute(command);
            return true;
        }
        catch (JMException e) {
            this.session.output.printError(e);
            return false;
        }
        catch (RuntimeException e) {
            this.session.output.printError(e);
            return false;
        }
    }

    public Set<String> getCommandNames() {
        return this.commandFactory.getCommandTypes().keySet();
    }

    public Class<? extends Command> getCommandType(String name) {
        return this.commandFactory.getCommandTypes().get(name);
    }

    public final JavaProcessManager getProcessManager() {
        return this.processManager;
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void setVerboseLevel(VerboseLevel verboseLevel) {
        this.session.setVerboseLevel(verboseLevel);
    }
}

