/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jcli.jline.CliCompletor;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.cc.CommandCenter;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleCompletor
implements Completer {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleCompletor.class);
    private final CommandCenter commandCenter;
    private final List<Candidate> commandNames;

    public ConsoleCompletor(CommandCenter commandCenter) {
        Validate.notNull(commandCenter, "Command center can't be NULL", new Object[0]);
        this.commandCenter = commandCenter;
        ArrayList<String> commandNames = new ArrayList<String>(commandCenter.getCommandNames());
        Collections.sort(commandNames);
        this.commandNames = new ArrayList<Candidate>(commandNames.size());
        for (String commandName : commandNames) {
            this.commandNames.add(new Candidate(commandName));
        }
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        block5: {
            try {
                String buffer = line.line();
                if (StringUtils.isEmpty(buffer) || buffer.indexOf(32) == -1) {
                    this.completeCommandName(buffer, candidates);
                }
                int separatorPos = buffer.indexOf(32);
                String commandName = buffer.substring(0, separatorPos);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Command name is [" + commandName + "]");
                }
                String commandArguments = buffer.substring(separatorPos + 1);
                commandArguments.replaceFirst("^\\s*", "");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Analyzing commmand arguments [" + commandArguments + "]");
                }
                Command cmd = this.commandCenter.commandFactory.createCommand(commandName);
                cmd.setSession(this.commandCenter.session);
                CliCompletor commandCompletor = new CliCompletor(cmd, this.commandCenter.argTokenizer);
                int position = line.cursor();
                commandCompletor.complete(reader, new ArgumentCompleter.ArgumentLine(commandArguments, position - separatorPos), candidates);
            }
            catch (RuntimeException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Couldn't complete input", e);
            }
        }
    }

    private void completeCommandName(String buf, List<Candidate> candidates) {
        if (buf == null) {
            candidates.addAll(this.commandNames);
        } else if (buf.indexOf(32) == -1) {
            ArrayList<Candidate> matchedNames = new ArrayList<Candidate>();
            for (Candidate commandName : this.commandNames) {
                if (!commandName.value().startsWith(buf)) continue;
                matchedNames.add(commandName);
            }
            candidates.addAll(matchedNames);
        } else {
            throw new IllegalStateException("Invalid state");
        }
    }
}

