import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleActiveFolderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_active_folder#display_name DataGoogleActiveFolder#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_active_folder#id DataGoogleActiveFolder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_active_folder#parent DataGoogleActiveFolder#parent}
    */
    readonly parent: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_active_folder google_active_folder}
*/
export declare class DataGoogleActiveFolder extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_active_folder";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_active_folder google_active_folder} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleActiveFolderConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleActiveFolderConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
