import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeGlobalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_global_address#id DataGoogleComputeGlobalAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_global_address#name DataGoogleComputeGlobalAddress#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_global_address#project DataGoogleComputeGlobalAddress#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_global_address google_compute_global_address}
*/
export declare class DataGoogleComputeGlobalAddress extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_global_address";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_global_address google_compute_global_address} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeGlobalAddressConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeGlobalAddressConfig);
    get address(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
