import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeHaVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_ha_vpn_gateway#id DataGoogleComputeHaVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_ha_vpn_gateway#name DataGoogleComputeHaVpnGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_ha_vpn_gateway#project DataGoogleComputeHaVpnGateway#project}
    */
    readonly project?: string;
    /**
    * The region this gateway should sit in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_ha_vpn_gateway#region DataGoogleComputeHaVpnGateway#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeHaVpnGatewayVpnInterfaces {
}
export declare function dataGoogleComputeHaVpnGatewayVpnInterfacesToTerraform(struct?: DataGoogleComputeHaVpnGatewayVpnInterfaces): any;
export declare class DataGoogleComputeHaVpnGatewayVpnInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHaVpnGatewayVpnInterfaces | undefined;
    set internalValue(value: DataGoogleComputeHaVpnGatewayVpnInterfaces | undefined);
    get id(): number;
    get interconnectAttachment(): string;
    get ipAddress(): string;
}
export declare class DataGoogleComputeHaVpnGatewayVpnInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHaVpnGatewayVpnInterfacesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_ha_vpn_gateway google_compute_ha_vpn_gateway}
*/
export declare class DataGoogleComputeHaVpnGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_ha_vpn_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_ha_vpn_gateway google_compute_ha_vpn_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeHaVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeHaVpnGatewayConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get network(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _vpnInterfaces;
    get vpnInterfaces(): DataGoogleComputeHaVpnGatewayVpnInterfacesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
