import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_health_check#id DataGoogleComputeHealthCheck#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_health_check#name DataGoogleComputeHealthCheck#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_health_check#project DataGoogleComputeHealthCheck#project}
    */
    readonly project?: string;
}
export interface DataGoogleComputeHealthCheckGrpcHealthCheck {
}
export declare function dataGoogleComputeHealthCheckGrpcHealthCheckToTerraform(struct?: DataGoogleComputeHealthCheckGrpcHealthCheck): any;
export declare class DataGoogleComputeHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckGrpcHealthCheck | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckGrpcHealthCheck | undefined);
    get grpcServiceName(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
}
export declare class DataGoogleComputeHealthCheckGrpcHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckGrpcHealthCheckOutputReference;
}
export interface DataGoogleComputeHealthCheckHttp2HealthCheck {
}
export declare function dataGoogleComputeHealthCheckHttp2HealthCheckToTerraform(struct?: DataGoogleComputeHealthCheckHttp2HealthCheck): any;
export declare class DataGoogleComputeHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckHttp2HealthCheck | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckHttp2HealthCheck | undefined);
    get host(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get requestPath(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckHttp2HealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckHttp2HealthCheckOutputReference;
}
export interface DataGoogleComputeHealthCheckHttpHealthCheck {
}
export declare function dataGoogleComputeHealthCheckHttpHealthCheckToTerraform(struct?: DataGoogleComputeHealthCheckHttpHealthCheck): any;
export declare class DataGoogleComputeHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckHttpHealthCheck | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckHttpHealthCheck | undefined);
    get host(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get requestPath(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckHttpHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckHttpHealthCheckOutputReference;
}
export interface DataGoogleComputeHealthCheckHttpsHealthCheck {
}
export declare function dataGoogleComputeHealthCheckHttpsHealthCheckToTerraform(struct?: DataGoogleComputeHealthCheckHttpsHealthCheck): any;
export declare class DataGoogleComputeHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckHttpsHealthCheck | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckHttpsHealthCheck | undefined);
    get host(): string;
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get requestPath(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckHttpsHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckHttpsHealthCheckOutputReference;
}
export interface DataGoogleComputeHealthCheckLogConfig {
}
export declare function dataGoogleComputeHealthCheckLogConfigToTerraform(struct?: DataGoogleComputeHealthCheckLogConfig): any;
export declare class DataGoogleComputeHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckLogConfig | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckLogConfig | undefined);
    get enable(): cdktf.IResolvable;
}
export declare class DataGoogleComputeHealthCheckLogConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckLogConfigOutputReference;
}
export interface DataGoogleComputeHealthCheckSslHealthCheck {
}
export declare function dataGoogleComputeHealthCheckSslHealthCheckToTerraform(struct?: DataGoogleComputeHealthCheckSslHealthCheck): any;
export declare class DataGoogleComputeHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckSslHealthCheck | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckSslHealthCheck | undefined);
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get request(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckSslHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckSslHealthCheckOutputReference;
}
export interface DataGoogleComputeHealthCheckTcpHealthCheck {
}
export declare function dataGoogleComputeHealthCheckTcpHealthCheckToTerraform(struct?: DataGoogleComputeHealthCheckTcpHealthCheck): any;
export declare class DataGoogleComputeHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeHealthCheckTcpHealthCheck | undefined;
    set internalValue(value: DataGoogleComputeHealthCheckTcpHealthCheck | undefined);
    get port(): number;
    get portName(): string;
    get portSpecification(): string;
    get proxyHeader(): string;
    get request(): string;
    get response(): string;
}
export declare class DataGoogleComputeHealthCheckTcpHealthCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeHealthCheckTcpHealthCheckOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_health_check google_compute_health_check}
*/
export declare class DataGoogleComputeHealthCheck extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_health_check";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_health_check google_compute_health_check} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeHealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeHealthCheckConfig);
    get checkIntervalSec(): number;
    get creationTimestamp(): string;
    get description(): string;
    private _grpcHealthCheck;
    get grpcHealthCheck(): DataGoogleComputeHealthCheckGrpcHealthCheckList;
    get healthyThreshold(): number;
    private _http2HealthCheck;
    get http2HealthCheck(): DataGoogleComputeHealthCheckHttp2HealthCheckList;
    private _httpHealthCheck;
    get httpHealthCheck(): DataGoogleComputeHealthCheckHttpHealthCheckList;
    private _httpsHealthCheck;
    get httpsHealthCheck(): DataGoogleComputeHealthCheckHttpsHealthCheckList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logConfig;
    get logConfig(): DataGoogleComputeHealthCheckLogConfigList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _sslHealthCheck;
    get sslHealthCheck(): DataGoogleComputeHealthCheckSslHealthCheckList;
    private _tcpHealthCheck;
    get tcpHealthCheck(): DataGoogleComputeHealthCheckTcpHealthCheckList;
    get timeoutSec(): number;
    get type(): string;
    get unhealthyThreshold(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
