import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group#id DataGoogleComputeNetworkEndpointGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource; provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group#name DataGoogleComputeNetworkEndpointGroup#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group#project DataGoogleComputeNetworkEndpointGroup#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group#self_link DataGoogleComputeNetworkEndpointGroup#self_link}
    */
    readonly selfLink?: string;
    /**
    * Zone where the network endpoint group is located.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group#zone DataGoogleComputeNetworkEndpointGroup#zone}
    */
    readonly zone?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group google_compute_network_endpoint_group}
*/
export declare class DataGoogleComputeNetworkEndpointGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_network_endpoint_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_compute_network_endpoint_group google_compute_network_endpoint_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeNetworkEndpointGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeNetworkEndpointGroupConfig);
    get defaultPort(): number;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get network(): string;
    get networkEndpointType(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selfLink?;
    get selfLink(): string;
    set selfLink(value: string);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    get size(): number;
    get subnetwork(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
