import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerEngineVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_container_engine_versions#id DataGoogleContainerEngineVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_container_engine_versions#location DataGoogleContainerEngineVersions#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_container_engine_versions#project DataGoogleContainerEngineVersions#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_container_engine_versions#version_prefix DataGoogleContainerEngineVersions#version_prefix}
    */
    readonly versionPrefix?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_container_engine_versions google_container_engine_versions}
*/
export declare class DataGoogleContainerEngineVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_engine_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_container_engine_versions google_container_engine_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerEngineVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleContainerEngineVersionsConfig);
    get defaultClusterVersion(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get latestMasterVersion(): string;
    get latestNodeVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _releaseChannelDefaultVersion;
    get releaseChannelDefaultVersion(): cdktf.StringMap;
    get validMasterVersions(): string[];
    get validNodeVersions(): string[];
    private _versionPrefix?;
    get versionPrefix(): string;
    set versionPrefix(value: string);
    resetVersionPrefix(): void;
    get versionPrefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
