import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleDnsKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_dns_keys#id DataGoogleDnsKeys#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_dns_keys#managed_zone DataGoogleDnsKeys#managed_zone}
    */
    readonly managedZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_dns_keys#project DataGoogleDnsKeys#project}
    */
    readonly project?: string;
}
export interface DataGoogleDnsKeysKeySigningKeysDigests {
}
export declare function dataGoogleDnsKeysKeySigningKeysDigestsToTerraform(struct?: DataGoogleDnsKeysKeySigningKeysDigests): any;
export declare class DataGoogleDnsKeysKeySigningKeysDigestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysKeySigningKeysDigests | undefined;
    set internalValue(value: DataGoogleDnsKeysKeySigningKeysDigests | undefined);
    get digest(): string;
    get type(): string;
}
export declare class DataGoogleDnsKeysKeySigningKeysDigestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysKeySigningKeysDigestsOutputReference;
}
export interface DataGoogleDnsKeysKeySigningKeys {
}
export declare function dataGoogleDnsKeysKeySigningKeysToTerraform(struct?: DataGoogleDnsKeysKeySigningKeys): any;
export declare class DataGoogleDnsKeysKeySigningKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysKeySigningKeys | undefined;
    set internalValue(value: DataGoogleDnsKeysKeySigningKeys | undefined);
    get algorithm(): string;
    get creationTime(): string;
    get description(): string;
    private _digests;
    get digests(): DataGoogleDnsKeysKeySigningKeysDigestsList;
    get dsRecord(): string;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get keyLength(): number;
    get keyTag(): number;
    get publicKey(): string;
}
export declare class DataGoogleDnsKeysKeySigningKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysKeySigningKeysOutputReference;
}
export interface DataGoogleDnsKeysZoneSigningKeysDigests {
}
export declare function dataGoogleDnsKeysZoneSigningKeysDigestsToTerraform(struct?: DataGoogleDnsKeysZoneSigningKeysDigests): any;
export declare class DataGoogleDnsKeysZoneSigningKeysDigestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysZoneSigningKeysDigests | undefined;
    set internalValue(value: DataGoogleDnsKeysZoneSigningKeysDigests | undefined);
    get digest(): string;
    get type(): string;
}
export declare class DataGoogleDnsKeysZoneSigningKeysDigestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysZoneSigningKeysDigestsOutputReference;
}
export interface DataGoogleDnsKeysZoneSigningKeys {
}
export declare function dataGoogleDnsKeysZoneSigningKeysToTerraform(struct?: DataGoogleDnsKeysZoneSigningKeys): any;
export declare class DataGoogleDnsKeysZoneSigningKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysZoneSigningKeys | undefined;
    set internalValue(value: DataGoogleDnsKeysZoneSigningKeys | undefined);
    get algorithm(): string;
    get creationTime(): string;
    get description(): string;
    private _digests;
    get digests(): DataGoogleDnsKeysZoneSigningKeysDigestsList;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get keyLength(): number;
    get keyTag(): number;
    get publicKey(): string;
}
export declare class DataGoogleDnsKeysZoneSigningKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysZoneSigningKeysOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_dns_keys google_dns_keys}
*/
export declare class DataGoogleDnsKeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_dns_keys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_dns_keys google_dns_keys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleDnsKeysConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleDnsKeysConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keySigningKeys;
    get keySigningKeys(): DataGoogleDnsKeysKeySigningKeysList;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zoneSigningKeys;
    get zoneSigningKeys(): DataGoogleDnsKeysZoneSigningKeysList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
